/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.request.handler;

import java.awt.Container;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.TStorm.gui.RemoveMissing;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.fabric.details.DetailsClient;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoBackend;
import org.eclipse.aperi.gui.topo.widget.ITopoFrontend;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequestImpl;
import org.eclipse.aperi.server.guireq.topology.request.handler.ThreadPool;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerAutoRefreshTimer;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerCache;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerException;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerGuiSendRequest;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerRequestNode;

public abstract class ViewerRequestDispatcher
implements ITopoBackend {
    private ITopoFrontend topoViewer = null;
    protected ThreadPool pool = new ThreadPool(2, 4);
    private Hashtable pendingRefresh = new Hashtable();
    private ViewerRequestNode pendingRequests;
    ViewerAutoRefreshTimer timer;
    private ControllerApp controllerApp = null;
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object object) {
            GraphEntity graphEntity = (GraphEntity)object;
            String string = (String)graphEntity.getEntityID().getID();
            return string;
        }

        public String extractDefaultElementManager(Object object) {
            String string = null;
            if (object instanceof GraphSubsystem) {
                GraphSubsystem graphSubsystem = (GraphSubsystem)object;
                string = graphSubsystem.getDefaultElementManager();
            } else if (object instanceof GraphSwitch) {
                GraphSwitch graphSwitch = (GraphSwitch)object;
                string = graphSwitch.getDefaultElementManager();
            } else if (object instanceof GraphTapeLibrary) {
                GraphTapeLibrary graphTapeLibrary = (GraphTapeLibrary)object;
                string = graphTapeLibrary.getDefaultElementManager();
            }
            return string;
        }

        public String extractDisplayName(Object object) {
            GraphEntity graphEntity = (GraphEntity)object;
            String string = graphEntity.getDisplayName();
            return string;
        }
    };

    public void close() {
        if (this.pool != null) {
            this.pool.shutdown();
            this.pool = null;
        }
        this.pendingRefresh.clear();
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer = null;
        }
    }

    public void print(Container container) {
        this.topoViewer.print();
    }

    public void setTimer(ViewerAutoRefreshTimer viewerAutoRefreshTimer) {
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(2);
                viewerRequestImpl.getRefreshRate();
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
        this.timer = viewerAutoRefreshTimer;
    }

    public ITopoFrontend getITopoFrontend() {
        return this.topoViewer;
    }

    public ViewerAutoRefreshTimer getTimer() {
        return this.timer;
    }

    public synchronized ViewerRequestNode addToPending(ViewerGuiSendRequest viewerGuiSendRequest) {
        ViewerRequestNode viewerRequestNode = new ViewerRequestNode();
        viewerRequestNode.requestor = viewerGuiSendRequest;
        viewerRequestNode.next = this.pendingRequests;
        this.pendingRequests = viewerRequestNode;
        this.setBusyState(true);
        return viewerRequestNode;
    }

    public synchronized boolean removeNode(ViewerRequestNode viewerRequestNode) {
        boolean bl;
        Object object;
        if (this.pendingRefresh == null) {
            return false;
        }
        if (viewerRequestNode != null && viewerRequestNode.request != null && viewerRequestNode.request.requestData instanceof ViewerRequest) {
            object = (ViewerRequest)viewerRequestNode.request.requestData;
            this.pendingRefresh.remove(object);
        }
        object = null;
        ViewerRequestNode viewerRequestNode2 = this.pendingRequests;
        while (viewerRequestNode2 != null && viewerRequestNode2 != viewerRequestNode) {
            object = viewerRequestNode2;
            viewerRequestNode2 = viewerRequestNode2.next;
        }
        if (viewerRequestNode2 == null) {
            bl = false;
        } else {
            if (object != null) {
                ((ViewerRequestNode)object).next = viewerRequestNode2.next;
            } else {
                this.pendingRequests = viewerRequestNode2.next;
            }
            bl = true;
        }
        this.setBusyState(this.pendingRequests != null);
        return bl;
    }

    public synchronized void cancelAll() {
        this.pendingRefresh.clear();
        ViewerRequestNode viewerRequestNode = this.pendingRequests;
        while (viewerRequestNode != null) {
            viewerRequestNode.requestor.cancel();
            viewerRequestNode = viewerRequestNode.next;
        }
        this.pendingRequests = null;
        this.setBusyState(false);
        if (this.topoViewer != null) {
            this.topoViewer.cancelAllRefresh();
        }
    }

    public synchronized boolean nonePending() {
        return this.pendingRequests == null;
    }

    protected abstract void dispatchRequest(ViewerRequest var1) throws ViewerException;

    protected abstract void setBusyState(boolean var1);

    public void addListener(ITopoFrontend iTopoFrontend) {
        this.topoViewer = iTopoFrontend;
    }

    public void removeListener(ITopoFrontend iTopoFrontend) {
        this.topoViewer = null;
    }

    /*
     * Exception decompiling
     */
    public void handleResponse(short var1_1, Request var2_2, Response var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 518->522)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void finishRefresh(Request request) {
        ViewerRequest viewerRequest = (ViewerRequest)request.requestData;
        if (viewerRequest.getModelID() != null) {
            GraphModel.ID iD = viewerRequest.getModelID();
            this.topoViewer.finishRefreshView(iD);
        }
    }

    public void refreshView(final GraphModel.ID iD) {
        if (this.timer != null) {
            this.timer.startTimer();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestDispatcher.this.refreshView(iD, true);
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
    }

    public void refreshView(GraphModel.ID iD, boolean bl) {
        GraphModel graphModel;
        Serializable serializable;
        if (this.topoViewer == null) {
            return;
        }
        if (iD instanceof GraphModel.MultiEntityID && (serializable = ((GraphModel.MultiEntityID)iD).getSrcGroupEntity()) != null) {
            ((GraphEntity)serializable).setCollationKey(null);
        }
        serializable = new ViewerRequestImpl();
        serializable.addRequest(iD, null);
        try {
            this.topoViewer.startRefreshView(iD);
        }
        catch (Exception exception) {
            GraphDebug.trace("Refreshing modelId:" + iD);
            GraphDebug.exception(exception);
        }
        if (bl && (graphModel = ViewerCache.getFromCache(iD, true)) != null) {
            this.topoViewer.updateView(0, graphModel);
            return;
        }
        try {
            if (this.pendingRefresh.get(serializable) == null) {
                this.pendingRefresh.put(serializable, serializable);
                this.dispatchRequest((ViewerRequest)serializable);
            } else {
                GraphDebug.trace("Request in progress...");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector getOpenedViews() {
        return this.topoViewer.getOpenedViews();
    }

    public void refreshAllViews() {
        Vector vector;
        if (this.timer != null) {
            this.timer.resetTimer();
        }
        if ((vector = this.topoViewer.getOpenedViews()) == null || vector.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    GraphModel.ID iD = (GraphModel.ID)iterator.next();
                    ViewerRequestDispatcher.this.refreshView(iD, false);
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, false, true);
        }
    }

    public void closeView(GraphModel.ID iD) {
        ViewerCache.markAsClosed(iD);
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void launchElementManager(GraphEntity graphEntity) {
        ElementManagerManager.getInstance().getElementManager(graphEntity, this.getElementManagerHelper());
        ElementManagerManager.getInstance().launchElementManager(graphEntity, this.getElementManagerHelper());
    }

    public void setTimeout(int n) {
        if (this.timer != null) {
            this.timer.setTimeout(n);
        }
        try {
            ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
            viewerRequestImpl.setRequestType(1);
            viewerRequestImpl.setRefreshRate(n);
            this.dispatchRequest(viewerRequestImpl);
        }
        catch (ViewerException viewerException) {
            viewerException.printStackTrace();
        }
    }

    public void launchDetailsPanel(GraphEntity.ID iD) {
        String string = (String)iD.getID();
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        if ("switch:".equals(string2) || "hba:".equals(string2) || "host:".equals(string2) || "server:".equals(string2) || "fabric:".equals(string2) || "Port:".equalsIgnoreCase(string2) || "pe:".equals(string2) || "node:".equals(string2) || "other:".equals(string2)) {
            if ("other:".equals(string2)) {
                n = string3.indexOf(58);
                string2 = string3.substring(0, n + 1);
                string3 = string3.substring(n + 1);
            }
            if ("host:".equals(string2)) {
                string2 = "server:";
            }
            string2 = string2.toLowerCase();
            string2 = string2.substring(0, string2.length() - 1);
            DetailsClient.showDetails(string2, string3);
        } else if ("subsystem:".equals(string2)) {
            SubsystemDDI subsystemDDI = new SubsystemDDI(Integer.parseInt(string3));
            ((DataDisplayInfo)subsystemDDI).reDisplay();
        } else if ("tapelibrary:".equals(string2)) {
            LibraryDDI libraryDDI = new LibraryDDI(Integer.parseInt(string3));
            ((DataDisplayInfo)libraryDDI).reDisplay();
        }
    }

    public int getTimeout() {
        if (this.timer != null) {
            return this.timer.getTimeout();
        }
        return 0;
    }

    public void removeEntity(Vector vector) {
        Object object;
        RemoveMissing removeMissing = new RemoveMissing();
        Vector<String> vector2 = new Vector<String>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (GraphEntity)iterator.next();
            GraphEntity.ID iD = ((GraphEntity)object).getEntityID();
            String string = (String)iD.getID();
            if (string != null && string.startsWith("other:")) {
                string = string.substring(6);
            }
            if (string.startsWith("server:")) {
                string = "host:" + string.substring(7);
            }
            if (string.startsWith("port2port:")) {
                string = "port2port:" + string.substring(string.lastIndexOf(44) + 1);
            }
            string = string.toLowerCase();
            vector2.add(string);
        }
        object = new String[vector.size()];
        vector2.toArray((T[])object);
        removeMissing.remove((String[])object);
    }

    public void refreshPinnedList(GraphModel.ID iD) {
    }

    public void probeAll(final Vector vector) {
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(3);
                viewerRequestImpl.setRequestObject(vector);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, false, true);
        }
    }

    public void requestTopoSettings(ControllerApp controllerApp) {
        this.controllerApp = controllerApp;
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(4);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
    }

    public void persistTopoSettings(final TopoSetting topoSetting) {
        Runnable runnable = new Runnable(){

            public void run() {
                ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
                viewerRequestImpl.setRequestType(5);
                viewerRequestImpl.setTopoSettings(topoSetting);
                try {
                    ViewerRequestDispatcher.this.dispatchRequest(viewerRequestImpl);
                }
                catch (ViewerException viewerException) {
                    viewerException.printStackTrace();
                }
            }
        };
        if (this.pool != null) {
            this.pool.execute(runnable, true, true);
        }
    }
}

