/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.xmsg.WrappedLogger;

public class LoggerRegistry {
    private static WrappedLogger defaultLogger;
    private static Map<ClassLoader, WrappedLogger> byClassLoaderMap;

    static {
        byClassLoaderMap = new HashMap<ClassLoader, WrappedLogger>();
    }

    public static void setDefaultLogger(WrappedLogger wrappedLogger) {
        defaultLogger = wrappedLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogger(ClassLoader classLoader, WrappedLogger wrappedLogger) {
        Map<ClassLoader, WrappedLogger> map = byClassLoaderMap;
        synchronized (map) {
            byClassLoaderMap.put(classLoader, wrappedLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WrappedLogger getLogger(ClassLoader classLoader) {
        WrappedLogger wrappedLogger = null;
        if (classLoader != null) {
            Map<ClassLoader, WrappedLogger> map = byClassLoaderMap;
            synchronized (map) {
                wrappedLogger = byClassLoaderMap.get(classLoader);
            }
        }
        if (wrappedLogger == null) {
            wrappedLogger = defaultLogger;
        }
        return wrappedLogger;
    }
}

