/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.MessagingService;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.jms.Message;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.TopicHandler;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.interfaces.IMessagingService;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class MessagingService
implements IMessagingService,
IService,
ICliDispatcher {
    private static String className = null;
    static ILogger traceLogger = null;
    static ILogger msgLogger = null;
    private static final String TRACE_NAME = "aperi.logger.trace.MessagingService";
    private static final String MESSAGE_NAME = "aperi.logger.message.MessagingService";
    private static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.middleware.MessagingService.resources.MsgSvcMsgs";
    private Status status = new Status(5, 9);
    private Hashtable topics;
    private Vector listOfSubscribers = new Vector();
    private Vector listOfTopicHandlers = new Vector();

    static {
        try {
            msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
            msgLogger.setMessageFile(BUNDLENAME);
            traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MessagingService() {
        className = this.getClass().getName();
        String string = "MessagingService()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.topics = new Hashtable();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void subscribe(String string, String string2) {
        String string3 = "subscribe(String topic, String service)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        this.subscribe(string, null, string2);
        if (msgLogger != null && msgLogger.isLogging()) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string3, "MessagingService_subscribed", (Object)string2, (Object)string);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String string, String string2, String string3) {
        Object object;
        Object object2;
        String string4 = "subscribe(String topic, String url, String service)";
        String string5 = "";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "service " + string3 + "subscribing to topic: " + string);
        }
        if (string2 == null) {
            object2 = null;
            object2 = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            object = object2.getProperty("manager.port", "setup");
            int n = Integer.parseInt((String)object);
            string5 = "localhost:" + n + ":" + string3;
        } else {
            string5 = String.valueOf(string2) + ":" + string3;
        }
        if (!this.listOfSubscribers.contains(string5)) {
            this.listOfSubscribers.add(string5);
        }
        object2 = new Vector();
        object = this.topics;
        synchronized (object) {
            if (!this.topics.containsKey(string)) {
                TopicHandler topicHandler = new TopicHandler(string);
                this.listOfTopicHandlers.add(topicHandler);
                topicHandler.addSubscriber(string2, string3);
                ((Vector)object2).add(topicHandler);
                Enumeration enumeration = this.topics.keys();
                while (enumeration.hasMoreElements()) {
                    Vector vector;
                    String string6 = (String)enumeration.nextElement();
                    if (this.matches(string, string6)) {
                        vector = (Vector)this.topics.get(string6);
                        Enumeration enumeration2 = vector.elements();
                        while (enumeration2.hasMoreElements()) {
                            TopicHandler topicHandler2 = (TopicHandler)enumeration2.nextElement();
                            if (((Vector)object2).contains(topicHandler2)) continue;
                            ((Vector)object2).add(topicHandler2);
                        }
                        continue;
                    }
                    if (!this.isSuperClassOf(string, string6)) continue;
                    vector = (Vector)this.topics.get(string6);
                    if (!vector.contains(topicHandler)) {
                        vector.add(topicHandler);
                    }
                    this.topics.put(string6, vector);
                }
                this.topics.put(string, object2);
                new Thread((Runnable)topicHandler, "TopicHandler-" + string).start();
            } else {
                object2 = (Vector)this.topics.get(string);
                TopicHandler topicHandler = (TopicHandler)((Vector)object2).get(0);
                topicHandler.addSubscriber(string2, string3);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, this.toString());
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public void unsubscribe(String string, String string2) {
        String string3 = "unsubscribe(String topoic, String service)";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        this.unsubscribe(string, null, string2);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String string, String string2, String string3) {
        String string4 = "unsubscribe(String topic, String url, String service)";
        Vector vector = new Vector();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        Hashtable hashtable = this.topics;
        synchronized (hashtable) {
            vector = (Vector)this.topics.get(string);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TopicHandler topicHandler = (TopicHandler)enumeration.nextElement();
                topicHandler.removeSubscriber(string2, string3);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
    }

    public void publish(String string, Message message) {
        String string2 = "publish(String topic, Message message)";
        Vector vector = new Vector();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "topic = " + string);
        }
        if ((vector = this.getTopicHandlers(string)) != null) {
            int n = 0;
            while (n < vector.size()) {
                block10: {
                    try {
                        TopicHandler topicHandler = (TopicHandler)vector.get(n);
                        if (topicHandler != null) {
                            if (traceLogger != null && traceLogger.isLogging()) {
                                String string3 = topicHandler.getTopic();
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Adding message to TopicHandler = " + string3);
                                Hashtable hashtable = topicHandler.getSubscribers();
                                Enumeration enumeration = hashtable.keys();
                                while (enumeration.hasMoreElements()) {
                                    String string4 = (String)enumeration.nextElement();
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "TopicHandler subscriber= " + string4);
                                }
                            }
                            topicHandler.addMessage(message);
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block10;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
                    }
                }
                ++n;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "MessagingService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("MessagingService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("MessagingService_Description");
    }

    public boolean startup() {
        String string = "startup()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        this.status.setRunStatus(8);
        if (msgLogger != null && msgLogger.isLogging()) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string, "MessagingService_started");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public boolean shutdown() {
        String string = "shutdown()";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        int n = 0;
        while (n < this.listOfTopicHandlers.size()) {
            TopicHandler topicHandler = (TopicHandler)this.listOfTopicHandlers.get(n);
            topicHandler.stopThread();
            ++n;
        }
        this.status.setRunStatus(10);
        if (msgLogger != null && msgLogger.isLogging()) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, string, "MessagingService_shutdown");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public String getDescription() {
        return "Messaging Toolkit";
    }

    public Status getStatus() {
        return this.status;
    }

    public String dispatch(String string, String[] stringArray) {
        return CliDispatcher.dispatch((Object)this, (String)string, (String[])stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getTopicHandlers(String string) {
        Vector vector;
        String string2;
        block9: {
            Object object;
            block8: {
                string2 = "getTopicHandlers(String topic)";
                vector = new Vector();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
                }
                object = this.topics;
                synchronized (object) {
                    vector = (Vector)this.topics.get(String.valueOf(string) + "*");
                }
                if (vector == null) break block8;
                if (traceLogger == null || !traceLogger.isLogging()) break block9;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Size of v vector = " + vector.size());
                break block9;
            }
            object = string;
            while (!((String)object).equals("java.lang.Object")) {
                Vector vector2;
                int n = ((String)object).lastIndexOf("/");
                String string3 = string.substring(0, n);
                object = string3;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "nextTopicToLookFor = " + string3);
                }
                if ((vector2 = (Vector)this.topics.get(String.valueOf(object) + "*")) == null) continue;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Found nextTopicToLookFor");
                }
                vector = vector2;
                break;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return vector;
    }

    private boolean matches(String string, String string2) {
        String string3 = "matches(String str, String pattern)";
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "topic = " + string + ", pattern = " + string2);
        }
        bl = string2.endsWith("*") ? string.startsWith(string2.substring(0, string2.length() - 1)) : string.equals(string2);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return bl;
    }

    private boolean isSuperClassOf(String string, String string2) {
        String string3 = "isSuperClassOf(String str, String pattern)";
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string3, "topic = " + string + ", pattern = " + string2);
        }
        if (string.endsWith("*")) {
            bl = string2.startsWith(string.substring(0, string.length() - 1));
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return bl;
    }

    public String toString() {
        String string = "There are " + this.topics.size() + " topics in the topics Hashtable.\n";
        Enumeration enumeration = this.topics.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)this.topics.get(string2);
            string = String.valueOf(string) + "Topic " + string2 + " has " + vector.size() + " topic handlers.\n";
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                TopicHandler topicHandler = (TopicHandler)enumeration2.nextElement();
                string = String.valueOf(string) + "\tTopicHandler: " + topicHandler + "\n";
                Hashtable hashtable = topicHandler.getSubscribers();
                Enumeration enumeration3 = hashtable.keys();
                while (enumeration3.hasMoreElements()) {
                    String string3 = (String)enumeration3.nextElement();
                    string = String.valueOf(string) + "\t\tSubscriber: " + string3 + "\n";
                }
            }
        }
        return string;
    }

    public boolean isAlive() {
        String string = "isAlive()";
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (this.status.getRunStatus() == 8) {
            bl = true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean isSubscriber(String string, String string2) {
        String string3 = "isSubscriber(String url, String service)";
        String string4 = "";
        boolean bl = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        if (string == null) {
            IConfigService iConfigService = null;
            iConfigService = (IConfigService)Activator._serviceHelper.bindLocal("ConfigService");
            String string5 = iConfigService.getProperty("manager.port", "setup");
            int n = Integer.parseInt(string5);
            string4 = "localhost:" + n + ":" + string2;
        } else {
            string4 = String.valueOf(string) + ":" + string2;
        }
        if (this.listOfSubscribers.contains(string4)) {
            bl = true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return bl;
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }
}

