/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.JoinCondition;
import org.eclipse.birt.data.engine.api.querydefn.JointDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.internal.adapter.DataAdapterUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;

public class JointDataSetAdapter
extends JointDataSetDesign {
    public JointDataSetAdapter(JointDataSetHandle handle) throws BirtException {
        super(handle.getQualifiedName());
        Iterator it = handle.joinConditionsIterator();
        JoinConditionHandle jc = null;
        while (it.hasNext()) {
            jc = (JoinConditionHandle)it.next();
            this.addJoinCondition(new JoinCondition((IScriptExpression)new ScriptExpression(jc.getLeftExpression()), (IScriptExpression)new ScriptExpression(jc.getRightExpression()), JointDataSetAdapter.adaptJoinOperator(jc.getOperator())));
        }
        if (jc != null) {
            this.setLeftDataSetDesignName(jc.getLeftDataSet());
            this.setRightDataSetDesignName(jc.getRightDataSet());
            this.setJoinType(JointDataSetAdapter.adaptJoinType(jc.getJoinType()));
        }
        DataAdapterUtil.adaptBaseDataSet((DataSetHandle)handle, (BaseDataSetDesign)this);
    }

    public static int adaptJoinType(String joinType) {
        if (joinType.equals("inner")) {
            return 0;
        }
        if (joinType.equals("left-out")) {
            return 1;
        }
        if (joinType.equals("right-out")) {
            return 2;
        }
        return -1;
    }

    public static int adaptJoinOperator(String operator) {
        if (operator.equals("eq")) {
            return 1;
        }
        return -1;
    }
}

