/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.util.Map;
import org.eclipse.aperi.AbstractDiscoverProcess;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMTransportException;

public abstract class DiscoverProcess
extends AbstractDiscoverProcess {
    public DiscoverProcess(String string, boolean bl, String[] stringArray, String[] stringArray2) {
        super(string, bl, stringArray, stringArray2);
    }

    protected IDiscoverRouterService getDiscoverRouterService() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IDiscoverRouterService)DiscoveryActivator._serviceHelper.bindLocalOSGiService(clazz.getName());
    }

    public void checkException(Throwable throwable, LogTraceHelper logTraceHelper, Map map) {
        if (throwable != null) {
            if (throwable instanceof CIMException) {
                if (throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                    logTraceHelper.traceError("CIMOM timout Failure", throwable);
                    logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
                } else if (throwable instanceof CIMTransportException) {
                    logTraceHelper.traceError("CIMOM Connection Failure", throwable);
                    logTraceHelper.logMsg("HWN021537E", new Object[]{((String[])map.get("CIMOM"))[0], throwable.getMessage()});
                } else {
                    logTraceHelper.traceError("CIMOM Exception", throwable);
                    logTraceHelper.logMsg("HWN021529E", new Object[]{((String[])map.get("CIMOM"))[0]});
                }
            } else if (throwable instanceof DiskManagerTimeoutException) {
                logTraceHelper.traceError("CIMOM timout Failure", throwable);
                logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
            } else {
                Throwable throwable2;
                Throwable throwable3 = throwable2 = throwable.getCause();
                while (throwable3 != null && !(throwable3 instanceof CIMException)) {
                    throwable3 = throwable3.getCause();
                }
                if (throwable3 != null) {
                    throwable2 = throwable3;
                }
                if (throwable2 != null) {
                    if (throwable2 instanceof CIMException) {
                        if (throwable.getMessage().indexOf("ERR_TIME_OUT") > 0) {
                            logTraceHelper.traceError("CIMOM timout Failure", throwable2);
                            logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
                        } else if (throwable.getMessage().indexOf("EXT_ERR_UNABLE_TO_CONNECT") > 0) {
                            logTraceHelper.traceError("CIMOM connection Failure", throwable2);
                            logTraceHelper.logMsg("HWN021537E", new Object[]{((String[])map.get("CIMOM"))[0], throwable2.getMessage()});
                        } else if (throwable2 instanceof CIMTransportException) {
                            logTraceHelper.traceError("CIMOM Connection Failure", throwable2);
                            logTraceHelper.logMsg("HWN021537E", new Object[]{((String[])map.get("CIMOM"))[0], throwable2.getMessage()});
                        } else {
                            logTraceHelper.traceError("CIMOM Exception", throwable2);
                            logTraceHelper.logMsg("HWN021529E", new Object[]{((String[])map.get("CIMOM"))[0]});
                        }
                    } else if (throwable2 instanceof DiskManagerTimeoutException) {
                        logTraceHelper.traceError("CIMOM timout Failure", throwable2);
                        logTraceHelper.logMsg("HWN021650E", new Object[]{((String[])map.get("CIMOM"))[0]});
                    } else {
                        logTraceHelper.traceError("Unexpected error ", throwable2);
                        logTraceHelper.logMsg("HWN021503E", null);
                    }
                } else {
                    logTraceHelper.traceError("Unexpected error ", throwable);
                    logTraceHelper.logMsg("HWN021503E", null);
                }
            }
        }
    }

    public static class RegistrationData
    extends AbstractDiscoverProcess.AbstractRegistrationData {
        private String mSmisVersion;
        private String mProfile;
        private String mVendor;
        private String mModel;
        private String mInstrumentationVersion;

        public RegistrationData(String string, String string2, String string3, String string4, String string5, String string6) {
            if (string == null || string.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mName = string;
            this.mSmisVersion = string2;
            this.mProfile = string3;
            this.mVendor = string4;
            this.mModel = string5;
            this.mInstrumentationVersion = string6;
        }

        public String getInstrumentationVersion() {
            return this.mInstrumentationVersion;
        }

        public String getModel() {
            return this.mModel;
        }

        public String getProfile() {
            return this.mProfile;
        }

        public String getSmisVersion() {
            return this.mSmisVersion;
        }

        public String getVendor() {
            return this.mVendor;
        }

        public boolean equals(Object object) {
            if (object instanceof RegistrationData) {
                RegistrationData registrationData = (RegistrationData)((Object)object);
                return this.mName.equals(registrationData.mName) && this.mSmisVersion.equals(registrationData.mSmisVersion) && this.mProfile.equals(registrationData.mProfile) && this.mVendor.equals(registrationData.mVendor) && this.mModel.equals(registrationData.mModel) && this.mInstrumentationVersion.equals(registrationData.mInstrumentationVersion);
            }
            return false;
        }
    }
}

