/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.internal.computations.Matrix;
import org.eclipse.birt.chart.internal.computations.Polygon;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.util.ChartUtil;

public class Object3D {
    private Vector[] va;
    private Vector[] viewVa;
    private Vector center;
    private Vector normal;
    private double xMax;
    private double xMin;
    private double yMax;
    private double yMin;
    private double zMax;
    private double zMin;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object3D(int points) {
        this.va = new Vector[points];
    }

    public Object3D(Location3D la) {
        this(new Location3D[]{la});
    }

    public Object3D(Location3D[] loa) {
        this.va = new Vector[loa.length];
        for (int i = 0; i < this.va.length; ++i) {
            this.va[i] = new Vector(loa[i]);
            loa[i].linkToVector(this.va[i]);
        }
    }

    public Object3D(Object3D original) {
        if (original == null) {
            return;
        }
        this.va = new Vector[original.va.length];
        for (int i = 0; i < original.va.length; ++i) {
            this.va[i] = new Vector(original.va[i]);
        }
        this.center = original.center;
        this.normal = original.normal;
        this.zMax = original.zMax;
        this.zMin = original.zMin;
        this.yMax = original.yMax;
        this.yMin = original.yMin;
        this.xMax = original.xMax;
        this.xMin = original.xMin;
    }

    public Location3D[] getLocation3D() {
        Location3D[] loa3d = new Location3D[this.va.length];
        for (int i = 0; i < this.va.length; ++i) {
            loa3d[i] = Location3DImpl.create(this.va[i].get(0), this.va[i].get(1), this.va[i].get(2));
        }
        return loa3d;
    }

    public Vector getNormal() {
        if (this.normal == null) {
            if (this.va == null || this.va.length < 3) {
                return null;
            }
            Vector v1 = new Vector(this.va[1]);
            v1.sub(this.va[0]);
            Vector v2 = new Vector(this.va[2]);
            v2.sub(this.va[0]);
            this.normal = v1.crossProduct(v2);
        }
        return this.normal;
    }

    public Vector getCenter() {
        if (this.center == null) {
            if (this.va == null || this.va.length == 0) {
                return null;
            }
            double m = this.va.length;
            this.center = new Vector();
            int i = 0;
            while ((double)i < m) {
                this.center.add(this.va[i]);
                ++i;
            }
            this.center.scale(1.0 / m);
        }
        return this.center;
    }

    public void reset() {
        this.center = null;
        this.normal = null;
        this.va = null;
        this.viewVa = null;
        this.zMax = 0.0;
        this.zMin = 0.0;
        this.yMax = 0.0;
        this.yMin = 0.0;
        this.xMax = 0.0;
        this.xMin = 0.0;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public void transform(Matrix m) {
        for (int i = 0; i < this.va.length; ++i) {
            this.va[i].multiply(m);
        }
        if (this.center != null) {
            // empty if block
        }
        if (this.normal != null) {
            // empty if block
        }
    }

    private void computeExtremums() {
        this.xMin = Double.MAX_VALUE;
        this.xMax = -1.7976931348623157E308;
        this.yMin = Double.MAX_VALUE;
        this.yMax = -1.7976931348623157E308;
        this.zMin = Double.MAX_VALUE;
        this.zMax = -1.7976931348623157E308;
        for (int i = 0; i < this.va.length; ++i) {
            this.xMin = Math.min(this.xMin, this.va[i].get(0));
            this.xMax = Math.max(this.xMax, this.va[i].get(0));
            this.yMin = Math.min(this.yMin, this.va[i].get(1));
            this.yMax = Math.max(this.yMax, this.va[i].get(1));
            this.zMin = Math.min(this.zMin, this.va[i].get(2));
            this.zMax = Math.max(this.zMax, this.va[i].get(2));
        }
    }

    public void clip(Engine3D engine) {
        ArrayList<Vector> lst = new ArrayList<Vector>();
        switch (this.va.length) {
            case 0: {
                break;
            }
            case 1: {
                Vector start = new Vector(this.va[0]);
                Vector end = new Vector(this.va[0]);
                byte retval = engine.checkClipping(start, end);
                if (retval == 4) break;
                lst.add(start);
                break;
            }
            case 2: {
                Vector start = new Vector(this.va[0]);
                Vector end = new Vector(this.va[1]);
                byte retval = engine.checkClipping(start, end);
                if (retval == 4) break;
                lst.add(start);
                lst.add(end);
                break;
            }
            default: {
                boolean endClipped = false;
                for (int i = 0; i < this.va.length; ++i) {
                    Vector start = null;
                    Vector end = null;
                    if (i == this.va.length - 1) {
                        start = new Vector(this.va[i]);
                        end = new Vector(this.va[0]);
                    } else {
                        start = new Vector(this.va[i]);
                        end = new Vector(this.va[i + 1]);
                    }
                    byte retval = engine.checkClipping(start, end);
                    if (retval == 4) continue;
                    if (i == 0 || (retval & 2) != 0 || endClipped) {
                        lst.add(start);
                    }
                    endClipped = false;
                    if ((retval & 1) != 0) {
                        endClipped = true;
                    }
                    if (i == this.va.length - 1 && !endClipped) continue;
                    lst.add(end);
                }
            }
        }
        this.va = lst.toArray(new Vector[lst.size()]);
    }

    public void prepareZSort() {
        this.computeExtremums();
        this.getNormal();
        this.getCenter();
        this.viewVa = new Vector[this.va.length];
        for (int i = 0; i < this.va.length; ++i) {
            this.viewVa[i] = new Vector(this.va[i]);
        }
    }

    public void perspective(double distance) {
        for (int i = 0; i < this.va.length; ++i) {
            this.va[i].perspective(distance);
        }
        if (this.center != null) {
            // empty if block
        }
    }

    public Vector[] getVectors() {
        return this.va;
    }

    public Vector[] getViewerVectors() {
        return this.viewVa;
    }

    public Location[] getPoints2D(double xOffset, double yOffset) {
        Location[] locations = new Location[this.va.length];
        for (int i = 0; i < this.va.length; ++i) {
            locations[i] = LocationImpl.create(this.va[i].get(0) + xOffset, this.va[i].get(1) + yOffset);
        }
        return locations;
    }

    private Vector getLineNormalToPlane(Vector p1, Vector p2, Object3D plane) {
        Vector dv = new Vector(p1);
        dv.sub(p2);
        int status = 0;
        if (dv.get(0) == 0.0) {
            status |= 1;
        }
        if (dv.get(1) == 0.0) {
            status |= 2;
        }
        if (dv.get(2) == 0.0) {
            status |= 4;
        }
        Vector pn = plane.getNormal();
        double delta = -plane.getViewerVectors()[0].scalarProduct(pn);
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        return null;
    }

    protected boolean testAside(Object3D obj, boolean outside, Engine3D engine) {
        Vector viewDirection;
        if (this.viewVa.length == 0 || obj.getViewerVectors().length == 0) {
            return true;
        }
        if (this.viewVa.length < 3 && obj.getViewerVectors().length < 3) {
            return true;
        }
        Vector normal = null;
        Vector ov = this.viewVa[0];
        Vector[] tva = obj.getViewerVectors();
        normal = this.viewVa.length < 3 ? new Vector(obj.getNormal()) : new Vector(this.getNormal());
        if (normal.scalarProduct(viewDirection = new Vector(0.0, 0.0, 1.0)) <= 0.0) {
            normal.inverse();
        }
        double d = -normal.scalarProduct(ov);
        for (int i = 0; i < tva.length; ++i) {
            double p = tva[i].scalarProduct(normal) + d;
            if (!(outside ? ChartUtil.mathLT(p, 0.0) : ChartUtil.mathGT(p, 0.0))) continue;
            return false;
        }
        return true;
    }

    protected boolean testIntersect(Object3D near, Engine3D engine) {
        Vector v;
        Vector[] va1 = this.getViewerVectors();
        Vector[] va2 = near.getViewerVectors();
        Polygon p1 = new Polygon();
        for (int i = 0; i < va1.length; ++i) {
            v = engine.perspective(va1[i]);
            v = engine.view2Canvas(v);
            p1.add(v.get(0), v.get(1));
        }
        Polygon p2 = new Polygon();
        for (int i = 0; i < va2.length; ++i) {
            v = engine.perspective(va2[i]);
            v = engine.view2Canvas(v);
            p2.add(v.get(0), v.get(1));
        }
        return p1.intersects(p2);
    }

    protected boolean testXOverlap(Object3D near) {
        return this.getXMax() >= near.getXMax() && this.getXMin() < near.getXMax() || this.getXMax() < near.getXMax() && this.getXMax() > near.getXMin();
    }

    protected boolean testYOverlap(Object3D near) {
        return this.getYMax() >= near.getYMax() && this.getYMin() < near.getYMax() || this.getYMax() < near.getYMax() && this.getYMax() > near.getYMin();
    }

    public boolean testSwap(Object3D near, Engine3D engine) {
        Object3D far = this;
        boolean swap = false;
        if (far.testXOverlap(near) && far.testYOverlap(near) && !near.testAside(far, true, engine) && !far.testAside(near, false, engine) && far.testIntersect(near, engine)) {
            swap = true;
        }
        return swap;
    }

    public boolean testZOverlap(Object3D near) {
        return this.getZMax() >= near.getZMax() && this.getZMin() < near.getZMax() || this.getZMax() < near.getZMax() && this.getZMax() > near.getZMin();
    }

    static {
        $assertionsDisabled = !Object3D.class.desiredAssertionStatus();
    }
}

