/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.Point;

public class Rectangle {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public double x;
    public double y;
    public double width;
    public double height;

    public Rectangle() {
    }

    public Rectangle(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public void setRect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void setRect(Rectangle r) {
        this.x = r.getX();
        this.y = r.getY();
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    public int outcode(double x, double y) {
        int out = 0;
        if (this.width <= 0.0) {
            out |= 5;
        } else if (x < this.x) {
            out |= 1;
        } else if (x > this.x + this.width) {
            out |= 4;
        }
        if (this.height <= 0.0) {
            out |= 0xA;
        } else if (y < this.y) {
            out |= 2;
        } else if (y > this.y + this.height) {
            out |= 8;
        }
        return out;
    }

    public Rectangle getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle createIntersection(Rectangle r) {
        Rectangle dest = new Rectangle();
        Rectangle.intersect(this, r, dest);
        return dest;
    }

    private static void intersect(Rectangle rectangle, Rectangle r, Rectangle dest) {
    }

    public Rectangle createUnion(Rectangle r) {
        Rectangle dest = new Rectangle();
        Rectangle.union(this, r, dest);
        return dest;
    }

    private static void union(Rectangle rectangle, Rectangle r, Rectangle dest) {
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
    }

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth();
    }

    public double getMaxY() {
        return this.getY() + this.getHeight();
    }

    public boolean contains(Point lo) {
        double w = this.getWidth();
        double h = this.getHeight();
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        double x = this.getMinX();
        double y = this.getMinY();
        if (lo.getX() < x || lo.getY() < y) {
            return false;
        }
        return ((w += x) < x || w > lo.getX()) && ((h += y) < y || h > lo.getY());
    }
}

