/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.datafeed.GroupKey;
import org.eclipse.birt.chart.internal.datafeed.ResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.ResultSetWrapper;
import org.eclipse.birt.chart.internal.datafeed.UserDataSetProcessor;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.StockDataSet;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataProcessor {
    private final RunTimeContext rtc;
    private final IActionEvaluator iae;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/trace");

    public DataProcessor(RunTimeContext rtc, IActionEvaluator iae) {
        this.rtc = rtc;
        this.iae = iae;
    }

    public static List getRowExpressions(Chart cm, IActionEvaluator iae) throws ChartException {
        if (cm instanceof ChartWithAxes) {
            return DataProcessor.getRowExpressions((ChartWithAxes)cm, iae);
        }
        if (cm instanceof ChartWithoutAxes) {
            return DataProcessor.getRowExpressions((ChartWithoutAxes)cm, iae);
        }
        return null;
    }

    private static List getRowExpressions(ChartWithoutAxes cwoa, IActionEvaluator iae) throws ChartException {
        Series seBase;
        EList elBaseSeries;
        ArrayList<String> alExpressions = new ArrayList<String>(4);
        EList elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.CannotDecipher", Messages.getResourceBundle());
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Query qBaseSeriesDefinition = sd.getQuery();
        String sExpression = qBaseSeriesDefinition.getDefinition();
        if (sExpression != null && sExpression.trim().length() > 0) {
            logger.log(2, Messages.getString("dataprocessor.log.baseSeriesDefn3", sExpression, ULocale.getDefault()));
        }
        if ((elBaseSeries = (seBase = sd.getDesignTimeSeries()).getDataDefinition()).size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.FoundDefnAssociatedWithX", new Object[]{String.valueOf(elBaseSeries.size())}, null);
        }
        Query qBaseSeries = (Query)elBaseSeries.get(0);
        sExpression = qBaseSeries.getDefinition();
        if (sExpression == null || sExpression.trim().length() <= 0 || alExpressions.contains(sExpression)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefinitionUnspecified", Messages.getResourceBundle());
        }
        alExpressions.add(sExpression);
        elSD = sd.getSeriesDefinitions();
        int iCount = 0;
        for (int k = 0; k < elSD.size(); ++k) {
            Series seOrthogonal;
            EList elOrthogonalSeries;
            sd = (SeriesDefinition)elSD.get(k);
            Query qOrthogonalSeriesDefinition = sd.getQuery();
            if (qOrthogonalSeriesDefinition == null) continue;
            sExpression = qOrthogonalSeriesDefinition.getDefinition();
            if (sExpression != null && sExpression.trim().length() > 0) {
                if (alExpressions.contains(sExpression)) {
                    int iRemovalIndex = alExpressions.indexOf(sExpression);
                    if (iRemovalIndex > iCount) {
                        alExpressions.remove(iRemovalIndex);
                        alExpressions.add(iCount++, sExpression);
                    }
                } else {
                    alExpressions.add(iCount++, sExpression);
                }
            }
            if ((elOrthogonalSeries = (seOrthogonal = sd.getDesignTimeSeries()).getDataDefinition()).isEmpty()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
            }
            boolean bAnyQueries = false;
            for (int i = 0; i < elOrthogonalSeries.size(); ++i) {
                Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                if (qOrthogonalSeries == null || (sExpression = qOrthogonalSeries.getDefinition()) == null || sExpression.trim().length() <= 0) continue;
                bAnyQueries = true;
                if (alExpressions.contains(sExpression)) continue;
                alExpressions.add(sExpression);
            }
            if (!bAnyQueries) {
                throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.AtLeastOneDefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
            }
            String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonal, iae);
            if (triggerExprs == null) continue;
            for (int t = 0; t < triggerExprs.length; ++t) {
                String tgexp = triggerExprs[t];
                if (alExpressions.contains(tgexp)) continue;
                alExpressions.add(tgexp);
            }
        }
        return alExpressions;
    }

    private static List getRowExpressions(ChartWithAxes cwa, IActionEvaluator iae) throws ChartException {
        Series seBase;
        EList elBaseSeries;
        ArrayList<String> alExpressions = new ArrayList<String>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "dataprocessor.exception.CannotDecipher2", Messages.getResourceBundle());
        }
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        Query qBaseSeriesDefinition = sd.getQuery();
        String sExpression = qBaseSeriesDefinition.getDefinition();
        if (sExpression != null && sExpression.trim().length() > 0) {
            logger.log(2, Messages.getString("dataprocessor.log.XSeriesDefn", sExpression, ULocale.getDefault()));
        }
        if ((elBaseSeries = (seBase = sd.getDesignTimeSeries()).getDataDefinition()).size() != 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.FoundMoreThanOneDefnAssociateX", new Object[]{String.valueOf(elBaseSeries.size())}, Messages.getResourceBundle());
        }
        Query qBaseSeries = (Query)elBaseSeries.get(0);
        sExpression = qBaseSeries.getDefinition();
        if (sExpression == null || sExpression.trim().length() <= 0 || alExpressions.contains(sExpression)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.definitionsAssociatedWithX", Messages.getResourceBundle());
        }
        alExpressions.add(sExpression);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int iCount = 0;
        for (int j = 0; j < axaOrthogonal.length; ++j) {
            elSD = axaOrthogonal[j].getSeriesDefinitions();
            for (int k = 0; k < elSD.size(); ++k) {
                Series seOrthogonal;
                EList elOrthogonalSeries;
                sd = (SeriesDefinition)elSD.get(k);
                Query qOrthogonalSeriesDefinition = sd.getQuery();
                if (qOrthogonalSeriesDefinition == null) continue;
                sExpression = qOrthogonalSeriesDefinition.getDefinition();
                if (sExpression != null && sExpression.trim().length() > 0) {
                    if (alExpressions.contains(sExpression)) {
                        int iRemovalIndex = alExpressions.indexOf(sExpression);
                        if (iRemovalIndex > iCount) {
                            alExpressions.remove(iRemovalIndex);
                            alExpressions.add(iCount++, sExpression);
                        }
                    } else {
                        alExpressions.add(iCount++, sExpression);
                    }
                }
                if ((elOrthogonalSeries = (seOrthogonal = sd.getDesignTimeSeries()).getDataDefinition()).isEmpty()) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.DefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
                }
                boolean bAnyQueries = false;
                for (int i = 0; i < elOrthogonalSeries.size(); ++i) {
                    Query qOrthogonalSeries = (Query)elOrthogonalSeries.get(i);
                    if (qOrthogonalSeries == null || (sExpression = qOrthogonalSeries.getDefinition()) == null || sExpression.trim().length() <= 0) continue;
                    bAnyQueries = true;
                    if (alExpressions.contains(sExpression)) continue;
                    alExpressions.add(sExpression);
                }
                if (!bAnyQueries) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 19, "dataprocessor.exception.AtLeastOneDefnExpMustAssociateY", new Object[]{String.valueOf(iCount), seOrthogonal}, Messages.getResourceBundle());
                }
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonal, iae);
                if (triggerExprs == null) continue;
                for (int t = 0; t < triggerExprs.length; ++t) {
                    String tgexp = triggerExprs[t];
                    if (alExpressions.contains(tgexp)) continue;
                    alExpressions.add(tgexp);
                }
            }
        }
        return alExpressions;
    }

    private static String[] getSeriesTriggerExpressions(Series se, IActionEvaluator iae) {
        ArrayList<String> rt = new ArrayList<String>();
        if (se != null && iae != null) {
            Iterator itr = se.getTriggers().iterator();
            while (itr.hasNext()) {
                Trigger tg = (Trigger)itr.next();
                String[] expra = iae.getActionExpressions(tg.getAction(), StructureSource.createSeries(se));
                if (expra == null || expra.length <= 0) continue;
                for (int i = 0; i < expra.length; ++i) {
                    String expr = expra[i];
                    if (expr == null || expr.trim().length() <= 0 || rt.contains(expr)) continue;
                    rt.add(expr);
                }
            }
        }
        if (rt.size() > 0) {
            return rt.toArray(new String[rt.size()]);
        }
        return null;
    }

    private GroupKey[] findGroupKeys(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return this.findGroupKeys((ChartWithAxes)cm);
        }
        if (cm instanceof ChartWithoutAxes) {
            return this.findGroupKeys((ChartWithoutAxes)cm);
        }
        return null;
    }

    private GroupKey[] findGroupKeys(ChartWithoutAxes cwoa) {
        ArrayList<GroupKey> alKeys = new ArrayList<GroupKey>(4);
        EList elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sd = (SeriesDefinition)elSD.get(0);
        elSD = sd.getSeriesDefinitions();
        for (int i = 0; i < elSD.size(); ++i) {
            GroupKey sortKey;
            String sExpression;
            sd = (SeriesDefinition)elSD.get(i);
            Query qOrthogonalSeriesDefinition = sd.getQuery();
            if (qOrthogonalSeriesDefinition == null || (sExpression = qOrthogonalSeriesDefinition.getDefinition()) == null || sExpression.trim().length() <= 0 || alKeys.contains(sortKey = new GroupKey(sExpression, sd.isSetSorting() ? sd.getSorting() : null))) continue;
            alKeys.add(sortKey);
        }
        return alKeys.toArray(new GroupKey[alKeys.size()]);
    }

    private GroupKey[] findGroupKeys(ChartWithAxes cwa) {
        ArrayList<GroupKey> alKeys = new ArrayList<GroupKey>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        for (int i = 0; i < axaOrthogonal.length; ++i) {
            EList elSD = axaOrthogonal[i].getSeriesDefinitions();
            for (int j = 0; j < elSD.size(); ++j) {
                GroupKey sortKey;
                String sExpression;
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                Query qOrthogonalSeriesDefinition = sd.getQuery();
                if (qOrthogonalSeriesDefinition == null || (sExpression = qOrthogonalSeriesDefinition.getDefinition()) == null || sExpression.trim().length() <= 0 || alKeys.contains(sortKey = new GroupKey(sExpression, sd.isSetSorting() ? sd.getSorting() : null))) continue;
                alKeys.add(sortKey);
            }
        }
        return alKeys.toArray(new GroupKey[alKeys.size()]);
    }

    protected ResultSetWrapper mapToChartResultSet(IDataRowExpressionEvaluator idre, Chart cm) throws ChartException {
        LinkedHashMap<String, Integer> lhmLookup = new LinkedHashMap<String, Integer>();
        List co = DataProcessor.getRowExpressions(cm, this.iae);
        Iterator it = co.iterator();
        int i = 0;
        while (it.hasNext()) {
            String sxp = (String)it.next();
            lhmLookup.put(sxp, new Integer(i++));
        }
        int iColumnCount = i;
        ArrayList<Object[]> liResultSet = new ArrayList<Object[]>();
        boolean hasFirst = idre.first();
        if (hasFirst) {
            do {
                Object[] oaTuple = new Object[iColumnCount];
                it = co.iterator();
                int iColumnIndex = 0;
                while (it.hasNext()) {
                    oaTuple[iColumnIndex++] = idre.evaluate((String)it.next());
                }
                liResultSet.add(oaTuple);
            } while (idre.next());
        }
        GroupKey[] groupKeys = this.findGroupKeys(cm);
        for (i = 0; i < groupKeys.length; ++i) {
            groupKeys[i].setKeyIndex((Integer)lhmLookup.get(groupKeys[i].getKey()));
        }
        ResultSetWrapper rsw = new ResultSetWrapper(lhmLookup.keySet(), liResultSet, groupKeys);
        SeriesDefinition sdGrouping = null;
        String[] saOrthogonalDataDefinitions = null;
        if (cm instanceof ChartWithAxes) {
            ArrayList<String> alODD = new ArrayList<String>(8);
            ChartWithAxes cwa = (ChartWithAxes)cm;
            Axis[] axaBase = cwa.getBaseAxes();
            Axis[] axaOrthogonal = null;
            for (int j = 0; j < axaBase.length; ++j) {
                sdGrouping = (SeriesDefinition)axaBase[j].getSeriesDefinitions().get(0);
                axaOrthogonal = cwa.getOrthogonalAxes(axaBase[j], true);
                for (i = 0; i < axaOrthogonal.length; ++i) {
                    EList elSD = axaOrthogonal[i].getSeriesDefinitions();
                    for (int k = 0; k < elSD.size(); ++k) {
                        Series SE = ((SeriesDefinition)elSD.get(k)).getDesignTimeSeries();
                        if (SE == null) continue;
                        EList elDD = SE.getDataDefinition();
                        for (int n = 0; n < elDD.size(); ++n) {
                            String sExpression = ((Query)elDD.get(n)).getDefinition();
                            if (sExpression == null || sExpression.trim().length() <= 0 || alODD.contains(sExpression)) continue;
                            alODD.add(sExpression);
                        }
                    }
                }
            }
            saOrthogonalDataDefinitions = alODD.toArray(new String[alODD.size()]);
        } else if (cm instanceof ChartWithoutAxes) {
            ArrayList<String> alODD = new ArrayList<String>(8);
            ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
            sdGrouping = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            EList elSD = sdGrouping.getSeriesDefinitions();
            for (int k = 0; k < elSD.size(); ++k) {
                Series SE = ((SeriesDefinition)elSD.get(k)).getDesignTimeSeries();
                if (SE == null) continue;
                EList elDD = SE.getDataDefinition();
                for (int n = 0; n < elDD.size(); ++n) {
                    String sExpression = ((Query)elDD.get(n)).getDefinition();
                    if (sExpression == null || sExpression.trim().length() <= 0 || alODD.contains(sExpression)) continue;
                    alODD.add(sExpression);
                }
            }
            saOrthogonalDataDefinitions = alODD.toArray(new String[alODD.size()]);
        }
        if (rsw.getRowCount() > 0) {
            rsw.applyBaseSeriesSortingAndGrouping(sdGrouping, saOrthogonalDataDefinitions);
        }
        return rsw;
    }

    public void generateRuntimeSeries(IDataRowExpressionEvaluator idre, Chart cm) throws ChartException {
        ResultSetWrapper rsw = this.mapToChartResultSet(idre, cm);
        cm.clearSections(3);
        if (cm instanceof ChartWithAxes) {
            this.generateRuntimeSeries((ChartWithAxes)cm, rsw);
        } else if (cm instanceof ChartWithoutAxes) {
            this.generateRuntimeSeries((ChartWithoutAxes)cm, rsw);
        }
    }

    private void generateRuntimeSeries(ChartWithoutAxes cwoa, ResultSetWrapper rsw) throws ChartException {
        String sExpression;
        Query qy;
        List columns;
        int iGroupCount = rsw.getGroupCount();
        EList elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition sdBase = (SeriesDefinition)elSD.get(0);
        SortOption baseSorting = sdBase.isSetSorting() ? sdBase.getSorting() : null;
        Series seBaseDesignSeries = sdBase.getDesignTimeSeries();
        Series seBaseRuntimeSeries = (Series)EcoreUtil.copy((EObject)seBaseDesignSeries);
        sdBase.getSeries().add((Object)seBaseRuntimeSeries);
        int iOrthogonalSeriesDefinitionCount = 0;
        int iBaseColumnIndex = 0;
        EList dda = sdBase.getDesignTimeSeries().getDataDefinition();
        if (dda.size() > 0 && (iBaseColumnIndex = (columns = DataProcessor.getRowExpressions(cwoa, this.iae)).indexOf(((Query)dda.get(0)).getDefinition())) == -1) {
            iBaseColumnIndex = 0;
        }
        elSD = sdBase.getSeriesDefinitions();
        for (int j = 0; j < elSD.size(); ++j) {
            SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
            qy = sd.getQuery();
            if (qy == null || (sExpression = qy.getDefinition()) == null || sExpression.length() == 0) continue;
            ++iOrthogonalSeriesDefinitionCount;
        }
        if (iOrthogonalSeriesDefinitionCount < 1) {
            this.fillSeriesDataSet(cwoa, seBaseRuntimeSeries, rsw.getSubset(iBaseColumnIndex));
            elSD = sdBase.getSeriesDefinitions();
            for (int j = 0; j < elSD.size(); ++j) {
                SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(j);
                Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                Series seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                this.fillSeriesDataSet(cwoa, seOrthogonalRuntimeSeries, rsw.getSubset(seOrthogonalDesignSeries.getDataDefinition()), triggerExprs, rsw.getSubset(triggerExprs));
                seOrthogonalRuntimeSeries.setSeriesIdentifier(seOrthogonalDesignSeries.getSeriesIdentifier());
                sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
            }
        } else {
            Series seOrthogonalRuntimeSeries;
            SeriesDefinition sdOrthogonal;
            Object[] oa = rsw.getMergedGroupingBaseValues(iBaseColumnIndex, baseSorting);
            List baseValues = (List)oa[0];
            List idxList = (List)oa[1];
            int maxCount = baseValues.size();
            Object[] baseData = this.populateSeriesDataSet(seBaseRuntimeSeries, new ResultSetDataSet(baseValues, rsw.getColumnDataType(iBaseColumnIndex)));
            ArrayList<Object[]> orthogonalDataList = new ArrayList<Object[]>();
            elSD = sdBase.getSeriesDefinitions();
            for (int j = 0; j < elSD.size(); ++j) {
                sdOrthogonal = (SeriesDefinition)elSD.get(j);
                Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                for (int k = 0; k < iGroupCount; ++k) {
                    seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                    Object[] odata = this.populateSeriesDataSet(seOrthogonalRuntimeSeries, rsw.getSubset(k, seOrthogonalDesignSeries.getDataDefinition()), rsw.getSubset(k, triggerExprs));
                    odata[3] = new Integer(rsw.getGroupRowCount(k));
                    odata[4] = new Integer(k);
                    odata[5] = triggerExprs;
                    orthogonalDataList.add(odata);
                }
            }
            Object[] orthogonalData = orthogonalDataList.toArray();
            for (int i = 0; i < orthogonalData.length; ++i) {
                DataSet ds = (DataSet)((Object[])orthogonalData[i])[0];
                DataSet[] userDs = (DataSet[])((Object[])orthogonalData[i])[6];
                int groupIndex = (Integer)((Object[])orthogonalData[i])[4];
                ds = this.adjustDataSet(ds, maxCount, (List)idxList.get(groupIndex), userDs);
                ((Object[])orthogonalData[i])[3] = ds;
            }
            this.fillSeriesDataSet((IDataSetProcessor)baseData[1], seBaseRuntimeSeries, (DataSet)baseData[0]);
            int odx = 0;
            elSD = sdBase.getSeriesDefinitions();
            for (int j = 0; j < elSD.size(); ++j) {
                sdOrthogonal = (SeriesDefinition)elSD.get(j);
                for (int k = 0; k < iGroupCount; ++k) {
                    Object[] odata = (Object[])orthogonalData[odx];
                    seOrthogonalRuntimeSeries = (Series)odata[2];
                    this.fillSeriesDataSet((IDataSetProcessor)odata[1], seOrthogonalRuntimeSeries, (DataSet)odata[0], (String[])odata[5], (DataSet[])odata[6]);
                    qy = sdOrthogonal.getQuery();
                    String string = sExpression = qy == null ? "" : qy.getDefinition();
                    if (sExpression == null) {
                        sExpression = "";
                    }
                    seOrthogonalRuntimeSeries.setSeriesIdentifier(rsw.getGroupKey(k, sExpression));
                    sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                    ++odx;
                }
            }
        }
    }

    private void generateRuntimeSeries(ChartWithAxes cwa, ResultSetWrapper rsw) throws ChartException {
        String sExpression;
        Query qy;
        List columns;
        int iGroupCount = rsw.getGroupCount();
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        SeriesDefinition sdBase = (SeriesDefinition)elSD.get(0);
        SortOption baseSorting = sdBase.isSetSorting() ? sdBase.getSorting() : null;
        Series seBaseDesignSeries = sdBase.getDesignTimeSeries();
        Series seBaseRuntimeSeries = (Series)EcoreUtil.copy((EObject)seBaseDesignSeries);
        sdBase.getSeries().add((Object)seBaseRuntimeSeries);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int iOrthogonalSeriesDefinitionCount = 0;
        int iBaseColumnIndex = 0;
        EList dda = sdBase.getDesignTimeSeries().getDataDefinition();
        if (dda.size() > 0 && (iBaseColumnIndex = (columns = DataProcessor.getRowExpressions(cwa, this.iae)).indexOf(((Query)dda.get(0)).getDefinition())) == -1) {
            iBaseColumnIndex = 0;
        }
        for (int i = 0; i < axaOrthogonal.length; ++i) {
            elSD = axaOrthogonal[i].getSeriesDefinitions();
            for (int j = 0; j < elSD.size(); ++j) {
                SeriesDefinition sd = (SeriesDefinition)elSD.get(j);
                qy = sd.getQuery();
                if (qy == null || (sExpression = qy.getDefinition()) == null || sExpression.length() == 0) continue;
                ++iOrthogonalSeriesDefinitionCount;
            }
        }
        if (iOrthogonalSeriesDefinitionCount < 1) {
            this.fillSeriesDataSet(cwa, seBaseRuntimeSeries, rsw.getSubset(iBaseColumnIndex));
            for (int i = 0; i < axaOrthogonal.length; ++i) {
                elSD = axaOrthogonal[i].getSeriesDefinitions();
                for (int j = 0; j < elSD.size(); ++j) {
                    SeriesDefinition sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                    Series seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                    this.fillSeriesDataSet(cwa, seOrthogonalRuntimeSeries, rsw.getSubset(seOrthogonalDesignSeries.getDataDefinition()), triggerExprs, rsw.getSubset(triggerExprs));
                    seOrthogonalRuntimeSeries.setSeriesIdentifier(seOrthogonalDesignSeries.getSeriesIdentifier());
                    sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                }
            }
        } else {
            Series seOrthogonalRuntimeSeries;
            SeriesDefinition sdOrthogonal;
            Object[] oa = rsw.getMergedGroupingBaseValues(iBaseColumnIndex, baseSorting);
            List baseValues = (List)oa[0];
            List idxList = (List)oa[1];
            int maxCount = baseValues.size();
            Object[] baseData = this.populateSeriesDataSet(seBaseRuntimeSeries, new ResultSetDataSet(baseValues, rsw.getColumnDataType(iBaseColumnIndex)));
            ArrayList<Object[]> orthogonalDataList = new ArrayList<Object[]>();
            for (int i = 0; i < axaOrthogonal.length; ++i) {
                elSD = axaOrthogonal[i].getSeriesDefinitions();
                for (int j = 0; j < elSD.size(); ++j) {
                    sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    Series seOrthogonalDesignSeries = sdOrthogonal.getDesignTimeSeries();
                    String[] triggerExprs = DataProcessor.getSeriesTriggerExpressions(seOrthogonalDesignSeries, this.iae);
                    for (int k = 0; k < iGroupCount; ++k) {
                        seOrthogonalRuntimeSeries = (Series)EcoreUtil.copy((EObject)seOrthogonalDesignSeries);
                        Object[] odata = this.populateSeriesDataSet(seOrthogonalRuntimeSeries, rsw.getSubset(k, seOrthogonalDesignSeries.getDataDefinition()), rsw.getSubset(k, triggerExprs));
                        odata[3] = new Integer(rsw.getGroupRowCount(k));
                        odata[4] = new Integer(k);
                        odata[5] = triggerExprs;
                        orthogonalDataList.add(odata);
                    }
                }
            }
            Object[] orthogonalData = orthogonalDataList.toArray();
            for (int i = 0; i < orthogonalData.length; ++i) {
                DataSet ds = (DataSet)((Object[])orthogonalData[i])[0];
                DataSet[] userDs = (DataSet[])((Object[])orthogonalData[i])[6];
                int groupIndex = (Integer)((Object[])orthogonalData[i])[4];
                ds = this.adjustDataSet(ds, maxCount, (List)idxList.get(groupIndex), userDs);
                ((Object[])orthogonalData[i])[3] = ds;
            }
            this.fillSeriesDataSet((IDataSetProcessor)baseData[1], seBaseRuntimeSeries, (DataSet)baseData[0]);
            int odx = 0;
            for (int i = 0; i < axaOrthogonal.length; ++i) {
                elSD = axaOrthogonal[i].getSeriesDefinitions();
                for (int j = 0; j < elSD.size(); ++j) {
                    sdOrthogonal = (SeriesDefinition)elSD.get(j);
                    for (int k = 0; k < iGroupCount; ++k) {
                        Object[] odata = (Object[])orthogonalData[odx];
                        seOrthogonalRuntimeSeries = (Series)odata[2];
                        this.fillSeriesDataSet((IDataSetProcessor)odata[1], seOrthogonalRuntimeSeries, (DataSet)odata[0], (String[])odata[5], (DataSet[])odata[6]);
                        qy = sdOrthogonal.getQuery();
                        String string = sExpression = qy == null ? "" : qy.getDefinition();
                        if (sExpression == null) {
                            sExpression = "";
                        }
                        seOrthogonalRuntimeSeries.setSeriesIdentifier(rsw.getGroupKey(k, sExpression));
                        sdOrthogonal.getSeries().add((Object)seOrthogonalRuntimeSeries);
                        ++odx;
                    }
                }
            }
        }
    }

    private DataSet adjustDataSet(DataSet ds, int maxcount, List indexMap, DataSet[] userDs) {
        ds = this.adjustEachDataSet(ds, indexMap);
        if (userDs != null && userDs.length > 0) {
            for (int i = 0; i < userDs.length; ++i) {
                DataSet usds;
                userDs[i] = usds = this.adjustEachDataSet(userDs[i], indexMap);
            }
        }
        return ds;
    }

    private DataSet adjustEachDataSet(DataSet ds, List indexMap) {
        int[] indexArray = new int[indexMap.size()];
        for (int i = 0; i < indexArray.length; ++i) {
            indexArray[i] = (Integer)indexMap.get(i);
        }
        Object oContent = ds.getValues();
        if (ds instanceof NumberDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                for (i = 0; i < objBuffer.length; ++i) {
                    co.add(objBuffer[i]);
                }
            } else if (oContent instanceof double[]) {
                double[] da = (double[])oContent;
                double[] doubleBuffer = new double[indexArray.length];
                Arrays.fill(doubleBuffer, Double.NaN);
                for (int i = 0; i < da.length; ++i) {
                    int idx = indexArray[i];
                    if (idx == -1) continue;
                    doubleBuffer[idx] = da[i];
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof Double[]) {
                Double[] dda = (Double[])oContent;
                Double[] doubleBuffer = new Double[indexArray.length];
                for (int i = 0; i < dda.length; ++i) {
                    int idx = indexArray[i];
                    if (idx == -1) continue;
                    doubleBuffer[idx] = dda[i];
                }
                ds.setValues(doubleBuffer);
            } else if (oContent instanceof Number) {
                double[] da = new double[]{((Number)oContent).doubleValue()};
                double[] doubleBuffer = new double[indexArray.length];
                Arrays.fill(doubleBuffer, Double.NaN);
                int idx = indexArray[0];
                if (idx != -1) {
                    doubleBuffer[idx] = da[0];
                }
                ds.setValues(doubleBuffer);
            }
        } else if (ds instanceof DateTimeDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                for (i = 0; i < objBuffer.length; ++i) {
                    co.add(objBuffer[i]);
                }
            } else if (oContent instanceof long[]) {
                long[] la = (long[])oContent;
                double[] longBuffer = new double[indexArray.length];
                Arrays.fill(longBuffer, Double.NaN);
                for (int i = 0; i < la.length; ++i) {
                    int idx = indexArray[i];
                    if (idx == -1) continue;
                    longBuffer[idx] = la[i];
                }
                ds.setValues(longBuffer);
            } else if (oContent instanceof Calendar[]) {
                Calendar[] ca = (Calendar[])oContent;
                Calendar[] calendarBuffer = new Calendar[indexArray.length];
                for (int i = 0; i < ca.length; ++i) {
                    int idx = indexArray[i];
                    if (idx == -1) continue;
                    calendarBuffer[idx] = ca[i];
                }
                ds.setValues(calendarBuffer);
            }
        } else if (ds instanceof TextDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                for (i = 0; i < objBuffer.length; ++i) {
                    co.add(objBuffer[i]);
                }
            } else if (oContent instanceof String[]) {
                String[] sa = (String[])oContent;
                String[] stringBuffer = new String[indexArray.length];
                for (int i = 0; i < sa.length; ++i) {
                    int idx = indexArray[i];
                    if (idx == -1) continue;
                    stringBuffer[idx] = sa[i];
                }
                ds.setValues(stringBuffer);
            }
        } else if (ds instanceof StockDataSet) {
            if (oContent instanceof Collection) {
                Collection co = (Collection)oContent;
                Object[] objBuffer = new Object[indexArray.length];
                int i = 0;
                Iterator itr = co.iterator();
                while (itr.hasNext()) {
                    int idx;
                    Object o = itr.next();
                    if ((idx = indexArray[i++]) == -1) continue;
                    objBuffer[idx] = o;
                }
                co.clear();
                for (i = 0; i < objBuffer.length; ++i) {
                    co.add(objBuffer[i]);
                }
            } else if (oContent instanceof Object[]) {
                Object[] oa = (Object[])oContent;
                Object[] objectBuffer = new Object[indexArray.length];
                for (int i = 0; i < oa.length; ++i) {
                    int idx = indexArray[i];
                    if (idx == -1) continue;
                    objectBuffer[idx] = oa[i];
                }
                ds.setValues(objectBuffer);
            }
        }
        return ds;
    }

    private Object[] populateSeriesDataSet(Series seRuntime, IResultSetDataSet rsds) throws ChartException {
        return this.populateSeriesDataSet(seRuntime, rsds, null);
    }

    private Object[] populateSeriesDataSet(Series seRuntime, IResultSetDataSet rsds, IResultSetDataSet userRsds) throws ChartException {
        IDataSetProcessor idsp = null;
        try {
            idsp = PluginSettings.instance().getDataSetProcessor(seRuntime.getClass());
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)((Object)pex));
        }
        DataSet ds = null;
        ds = idsp.populate(rsds, null);
        DataSet[] usds = null;
        if (userRsds != null) {
            UserDataSetProcessor tdsp = new UserDataSetProcessor();
            usds = tdsp.populate(userRsds);
        }
        return new Object[]{ds, idsp, seRuntime, null, null, null, usds};
    }

    private void fillSeriesDataSet(IDataSetProcessor idsp, Series seRuntime, DataSet ds) throws ChartException {
        this.fillSeriesDataSet(idsp, seRuntime, ds, null, null);
    }

    private void fillSeriesDataSet(IDataSetProcessor idsp, Series seRuntime, DataSet ds, String[] userKeys, DataSet[] userDs) throws ChartException {
        ScriptHandler sh = this.rtc.getScriptHandler();
        ScriptHandler.callFunction(sh, "beforeDataSetFilled", seRuntime, idsp, this.rtc.getScriptContext());
        seRuntime.setDataSet(ds);
        if (userDs != null && userKeys != null) {
            for (int i = 0; i < Math.min(userDs.length, userKeys.length); ++i) {
                seRuntime.setDataSet(userKeys[i], userDs[i]);
            }
        }
        ScriptHandler.callFunction(sh, "afterDataSetFilled", seRuntime, ds, this.rtc.getScriptContext());
    }

    private void fillSeriesDataSet(Chart cm, Series seRuntime, IResultSetDataSet rsds) throws ChartException {
        this.fillSeriesDataSet(cm, seRuntime, rsds, null, null);
    }

    private void fillSeriesDataSet(Chart cm, Series seRuntime, IResultSetDataSet rsds, String[] userKeys, IResultSetDataSet userRsds) throws ChartException {
        ScriptHandler sh = this.rtc.getScriptHandler();
        IDataSetProcessor idsp = null;
        try {
            idsp = PluginSettings.instance().getDataSetProcessor(seRuntime.getClass());
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)((Object)pex));
        }
        ScriptHandler.callFunction(sh, "beforeDataSetFilled", seRuntime, idsp, this.rtc.getScriptContext());
        DataSet ds = null;
        ds = idsp.populate(rsds, null);
        seRuntime.setDataSet(ds);
        if (userRsds != null && userKeys != null) {
            UserDataSetProcessor tdsp = new UserDataSetProcessor();
            DataSet[] usds = tdsp.populate(userRsds);
            for (int i = 0; i < Math.min(usds.length, userKeys.length); ++i) {
                seRuntime.setDataSet(userKeys[i], usds[i]);
            }
        }
        ScriptHandler.callFunction(sh, "afterDataSetFilled", seRuntime, ds, this.rtc.getScriptContext());
    }
}

