/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;

public final class DeferredCache {
    private final IDeviceRenderer idr;
    private final ArrayList alPlanes = new ArrayList(16);
    private final ArrayList alLines = new ArrayList(16);
    private final ArrayList alMarkers = new ArrayList(16);
    private final ArrayList alLabels = new ArrayList(16);
    private List al3D = new ArrayList(16);
    private final boolean bTransposed;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/factory");

    public DeferredCache(IDeviceRenderer idr, Chart c) {
        this.idr = idr;
        this.bTransposed = c instanceof ChartWithAxes && ((ChartWithAxes)c).isTransposed();
    }

    public final void addPlane(PrimitiveRenderEvent pre, int iInstruction) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            } else {
                this.alPlanes.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void addModel(WrappedInstruction wi) {
        this.alPlanes.add(wi);
    }

    public final void addLine(LineRenderEvent lre) {
        if (lre instanceof I3DRenderEvent) {
            if (lre.getLineAttributes() != null && lre.getLineAttributes().isSetVisible() && lre.getLineAttributes().isVisible()) {
                this.al3D.add(lre.copy());
            }
        } else {
            this.alLines.add(lre.copy());
        }
    }

    public final void addLabel(TextRenderEvent tre) {
        if (tre instanceof I3DRenderEvent) {
            this.al3D.add(tre.copy());
        } else {
            this.alLabels.add(tre.copy());
        }
    }

    public final void addMarker(PrimitiveRenderEvent pre, int iInstruction) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            } else {
                this.alMarkers.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void flush() throws ChartException {
        WrappedInstruction wi;
        int i;
        Collections.sort(this.alPlanes);
        block15: for (i = 0; i < this.alPlanes.size(); ++i) {
            wi = (WrappedInstruction)this.alPlanes.get(i);
            if (wi.isModel()) {
                ArrayList al = wi.getModel();
                for (int j = 0; j < al.size(); ++j) {
                    PrimitiveRenderEvent pre = (PrimitiveRenderEvent)al.get(j);
                    pre.fill(this.idr);
                    pre.draw(this.idr);
                }
                continue;
            }
            wi.getEvent().iObjIndex = i + 1;
            switch (wi.getInstruction()) {
                case 3: {
                    wi.getEvent().fill(this.idr);
                    wi.getEvent().draw(this.idr);
                    continue block15;
                }
                case 2: {
                    wi.getEvent().fill(this.idr);
                    continue block15;
                }
                case 1: {
                    wi.getEvent().draw(this.idr);
                }
            }
        }
        this.alPlanes.clear();
        for (i = 0; i < this.alLines.size(); ++i) {
            LineRenderEvent lre = (LineRenderEvent)this.alLines.get(i);
            lre.draw(this.idr);
        }
        this.alLines.clear();
        block18: for (i = 0; i < this.alMarkers.size(); ++i) {
            wi = (WrappedInstruction)this.alMarkers.get(i);
            switch (wi.getInstruction()) {
                case 3: {
                    wi.getEvent().fill(this.idr);
                    wi.getEvent().draw(this.idr);
                    continue block18;
                }
                case 2: {
                    wi.getEvent().fill(this.idr);
                    continue block18;
                }
                case 1: {
                    wi.getEvent().draw(this.idr);
                }
            }
        }
        this.alMarkers.clear();
        for (i = 0; i < this.alLabels.size(); ++i) {
            TextRenderEvent tre = (TextRenderEvent)this.alLabels.get(i);
            tre.draw(this.idr);
        }
        this.alLabels.clear();
        for (i = 0; i < this.al3D.size(); ++i) {
            Object obj = this.al3D.get(i);
            if (obj instanceof WrappedInstruction) {
                wi = (WrappedInstruction)obj;
                if (wi.isModel()) {
                    ArrayList al = wi.getModel();
                    for (int j = 0; j < al.size(); ++j) {
                        PrimitiveRenderEvent pre = (PrimitiveRenderEvent)al.get(j);
                        pre.fill(this.idr);
                        pre.draw(this.idr);
                    }
                    continue;
                }
                wi.getEvent().iObjIndex = i + 1;
                switch (wi.getInstruction()) {
                    case 3: {
                        wi.getEvent().fill(this.idr);
                        wi.getEvent().draw(this.idr);
                        break;
                    }
                    case 2: {
                        wi.getEvent().fill(this.idr);
                        break;
                    }
                    case 1: {
                        wi.getEvent().draw(this.idr);
                    }
                }
                continue;
            }
            if (obj instanceof LineRenderEvent) {
                ((LineRenderEvent)obj).draw(this.idr);
                continue;
            }
            if (!(obj instanceof TextRenderEvent)) continue;
            ((TextRenderEvent)obj).draw(this.idr);
        }
        this.al3D.clear();
    }

    public void process3DEvent(Engine3D engine, double xOffset, double yOffset) {
        this.al3D = engine.processEvent(this.al3D, xOffset, yOffset);
    }

    public boolean isTransposed() {
        return this.bTransposed;
    }
}

