/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.Rectangle;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.computations.Polygon;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Needle;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.Dial;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class DialRenderer {
    private transient Insets insCA = null;
    private transient IDisplayServer xs = null;
    private transient Dial dial = null;
    private transient DialSeries ds = null;
    private transient DeferredCache dc = null;
    private DataPointHints dphValue;
    private SeriesRenderingHints srh;
    private double dRadius;
    private double dStartAngle;
    private double dStopAngle;
    private Scale sc;
    private double dValue;
    private AutoScale asc;
    private double dSafeSpacing = 10.0;
    private double dExtraSpacing = 0.0;
    private String[] sla;
    private Palette pa;
    private final double dScale;
    private boolean inverseScale = false;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");

    DialRenderer(ChartWithoutAxes dct, Dial dial, SeriesRenderingHints srh, Palette pa) throws ChartException {
        this.xs = dial.getXServer();
        this.dScale = dial.getDeviceScale();
        this.dial = dial;
        this.pa = pa;
        this.srh = srh;
        DataPointHints[] dpha = srh.getDataPoints();
        double[] da = srh.asPrimitiveDoubleValues();
        if (dpha == null || da == null || dpha.length < 1 || da.length < 1) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.datapoint.dial", Messages.getResourceBundle(dial.getRunTimeContext().getULocale()));
        }
        int validIndex = -1;
        for (int i = 0; i < dpha.length; ++i) {
            if (!(dpha[i].getOrthogonalValue() instanceof Number) || Double.isNaN(((Number)dpha[i].getOrthogonalValue()).doubleValue())) continue;
            validIndex = i;
            break;
        }
        if (validIndex == -1) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.datapoint.dial", Messages.getResourceBundle(dial.getRunTimeContext().getULocale()));
        }
        this.dValue = da[validIndex];
        this.dphValue = dpha[validIndex];
        this.ds = (DialSeries)dial.getSeries();
        this.insCA = InsetsImpl.create((double)2.0, (double)2.0, (double)2.0, (double)2.0).scaledInstance(this.dScale);
        this.dSafeSpacing *= this.dScale;
    }

    final double getValue() {
        return this.dValue;
    }

    final boolean isInverseScale() {
        return this.ds.getDial().isInverseScale();
    }

    final double getDialRadius() {
        if (this.ds.getDial().isSetRadius()) {
            return Math.max(this.ds.getDial().getRadius() * this.dScale, 0.0);
        }
        return 0.0;
    }

    final Scale getDialScale() {
        return this.ds.getDial().getScale();
    }

    final double getDialStartAngle() {
        return this.ds.getDial().isSetStartAngle() ? this.ds.getDial().getStartAngle() : 0.0;
    }

    final double getDialStopAngle() {
        return this.ds.getDial().isSetStopAngle() ? this.ds.getDial().getStopAngle() : 180.0;
    }

    final AutoScale getAutoScale(double startAngle, double stopAngle, Scale sc, Bounds bo) throws ChartException {
        boolean bFullDisc;
        Bounds boCA = BoundsImpl.copyInstance((Bounds)bo);
        boCA.adjust(this.insCA);
        double dFullRadius = Math.min(boCA.getWidth() / 2.0, boCA.getHeight() / 2.0);
        AutoScale isc = this.computeScale(this.ds.getDial().getLabel(), new DataSetIterator((Object)new double[]{startAngle, stopAngle}, 3), this.getValue(), startAngle, stopAngle, sc.getMin(), sc.getMax(), sc.getStep() == 0.0 ? null : new Double(sc.getStep()), this.ds.getDial().getFormatSpecifier(), this.dial.getRunTimeContext(), dFullRadius);
        double extraSpacing = this.getDialExtraSpacing(isc);
        boolean bl = bFullDisc = this.dStopAngle < 0.0 || this.dStopAngle > 180.0 || this.dStartAngle < 0.0 || this.dStartAngle > 180.0;
        if (extraSpacing > dFullRadius / 3.0) {
            extraSpacing = dFullRadius / 3.0;
            if (this.dSafeSpacing > dFullRadius / 10.0) {
                this.dSafeSpacing = dFullRadius / 10.0;
            }
        }
        if (this.dRadius > 0.0 && this.dRadius + extraSpacing + this.dSafeSpacing * 2.0 < dFullRadius) {
            dFullRadius = this.dRadius + extraSpacing + this.dSafeSpacing * 2.0;
        }
        Bounds fullBounds = BoundsImpl.create((double)(boCA.getLeft() + (boCA.getWidth() - 2.0 * dFullRadius) / 2.0), (double)(boCA.getTop() + (boCA.getHeight() - (double)(bFullDisc ? 2 : 1) * dFullRadius) / 2.0), (double)(2.0 * dFullRadius), (double)(2.0 * dFullRadius));
        Bounds dialBounds = BoundsImpl.create((double)(fullBounds.getLeft() + extraSpacing + this.dSafeSpacing), (double)(fullBounds.getTop() + extraSpacing + this.dSafeSpacing), (double)(fullBounds.getWidth() - 2.0 * (extraSpacing + this.dSafeSpacing)), (double)(fullBounds.getHeight() - 2.0 * (extraSpacing + this.dSafeSpacing)));
        return this.computeScale(this.ds.getDial().getLabel(), new DataSetIterator((Object)new double[]{startAngle, stopAngle}, 3), this.getValue(), startAngle, stopAngle, sc.getMin(), sc.getMax(), sc.getStep() == 0.0 ? null : new Double(sc.getStep()), this.ds.getDial().getFormatSpecifier(), this.dial.getRunTimeContext(), Math.min(dialBounds.getWidth() / 2.0, dialBounds.getHeight() / 2.0));
    }

    final double getDialExtraSpacing(AutoScale sc) throws ChartException {
        TickStyle ts;
        double ex = 0.0;
        if (this.ds.getDial().getMajorGrid().getTickAttributes().isVisible()) {
            ts = this.ds.getDial().getMajorGrid().getTickStyle();
            if (ts == TickStyle.ABOVE_LITERAL) {
                ex = Math.max(ex, 5.0);
            } else if (ts == TickStyle.ACROSS_LITERAL) {
                ex = Math.max(ex, 2.5);
            }
        }
        if (this.ds.getDial().getMinorGrid().getTickAttributes().isVisible()) {
            ts = this.ds.getDial().getMinorGrid().getTickStyle();
            if (ts == TickStyle.ABOVE_LITERAL) {
                ex = Math.max(ex, 5.0);
            } else if (ts == TickStyle.ACROSS_LITERAL) {
                ex = Math.max(ex, 2.5);
            }
        }
        if (this.ds.getDial().getLabel().isSetVisible() && this.ds.getDial().getLabel().isVisible()) {
            Size msz = this.computeLabelSize(sc, this.ds.getDial().getLabel());
            ex += Math.max(msz.getWidth(), msz.getHeight());
        }
        return ex;
    }

    final void updateRadius(double radius) {
        this.dRadius = radius;
    }

    final void updateStartAngle(double angle) {
        this.dStartAngle = angle;
    }

    final void updateStopAngle(double angle) {
        this.dStopAngle = angle;
    }

    final void updateInverseScale(boolean inverseScale) {
        this.inverseScale = inverseScale;
    }

    final void updateScale(Scale sc) {
        this.sc = sc;
    }

    final void updateAutoScale(AutoScale asc) {
        this.asc = asc;
    }

    final void updateExtraSpacing(double spacing) {
        this.dExtraSpacing = spacing;
    }

    public final void render(IDeviceRenderer idr, Bounds bo) throws ChartException {
        double needleAngle;
        int i;
        this.dc = this.dial.getDeferredCache();
        Bounds boCA = BoundsImpl.copyInstance((Bounds)bo);
        boCA.adjust(this.insCA);
        boolean bDialSuperimposed = this.dial.isDialSuperimposed();
        boolean bFirstSeries = this.dial.isFirstDial();
        org.eclipse.birt.chart.model.component.Dial dialComponent = this.ds.getDial();
        Needle needleComponent = this.ds.getNeedle();
        if (!bDialSuperimposed) {
            this.dRadius = this.getDialRadius();
            this.dStartAngle = this.getDialStartAngle();
            this.dStopAngle = this.getDialStopAngle();
            this.inverseScale = this.isInverseScale();
            this.sc = this.getDialScale();
            this.asc = this.getAutoScale(this.dStartAngle, this.dStopAngle, this.sc, bo);
            this.dExtraSpacing = this.getDialExtraSpacing(this.asc);
        }
        if (this.dial.isRightToLeft()) {
            this.inverseScale = !this.inverseScale;
        }
        boolean bFullDisc = this.dStopAngle < 0.0 || this.dStopAngle > 180.0 || this.dStartAngle < 0.0 || this.dStartAngle > 180.0;
        double dFullRadius = Math.min(boCA.getWidth() / 2.0, boCA.getHeight() / 2.0);
        if (this.dExtraSpacing > dFullRadius / 3.0) {
            this.dExtraSpacing = dFullRadius / 3.0;
            if (this.dSafeSpacing > dFullRadius / 10.0) {
                this.dSafeSpacing = dFullRadius / 10.0;
            }
        }
        if (this.dRadius > 0.0 && this.dRadius + this.dExtraSpacing + this.dSafeSpacing * 2.0 < dFullRadius) {
            dFullRadius = this.dRadius + this.dExtraSpacing + this.dSafeSpacing * 2.0;
        }
        ArcRenderEvent are = (ArcRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createUnknown((EObject)dialComponent), ArcRenderEvent.class);
        Bounds fullBounds = BoundsImpl.create((double)(boCA.getLeft() + (boCA.getWidth() - 2.0 * dFullRadius) / 2.0), (double)(boCA.getTop() + (boCA.getHeight() - (double)(bFullDisc ? 2 : 1) * dFullRadius) / 2.0), (double)(2.0 * dFullRadius), (double)(2.0 * dFullRadius));
        if (!bDialSuperimposed || bFirstSeries) {
            Fill dialFill = dialComponent.getFill();
            double safeAngle = Math.toDegrees(Math.abs(Math.asin(this.dSafeSpacing / dFullRadius)));
            are.setBounds(fullBounds);
            are.setStartAngle(bFullDisc ? 0.0 : -safeAngle);
            are.setAngleExtent(bFullDisc ? 360.0 : 180.0 + 2.0 * safeAngle);
            are.setOutline(dialComponent.getLineAttributes());
            are.setBackground(dialFill);
            are.setStyle(2);
            idr.fillArc(are);
            idr.drawArc(are);
        }
        Bounds dialBounds = BoundsImpl.create((double)(fullBounds.getLeft() + this.dExtraSpacing + this.dSafeSpacing), (double)(fullBounds.getTop() + this.dExtraSpacing + this.dSafeSpacing), (double)(fullBounds.getWidth() - 2.0 * (this.dExtraSpacing + this.dSafeSpacing)), (double)(fullBounds.getHeight() - 2.0 * (this.dExtraSpacing + this.dSafeSpacing)));
        if (!bDialSuperimposed || bFirstSeries) {
            double tsa = this.dStartAngle;
            double tpa = this.dStopAngle;
            if (tsa > tpa) {
                double temp = tsa;
                tsa = tpa;
                tpa = temp;
            }
            are.setBounds(dialBounds);
            are.setStartAngle(tsa);
            are.setAngleExtent(tpa - tsa);
            are.setOutline(dialComponent.getMajorGrid().getLineAttributes());
            are.setStyle(Math.abs(this.dStopAngle - this.dStartAngle) < 360.0 ? 3 : 1);
            this.dc.addPlane((PrimitiveRenderEvent)are, 1);
        }
        double xc = dialBounds.getLeft() + dialBounds.getWidth() / 2.0;
        double yc = dialBounds.getTop() + dialBounds.getHeight() / 2.0;
        double dDialRadius = dialBounds.getHeight() / 2.0;
        for (int i2 = 0; i2 < dialComponent.getDialRegions().size(); ++i2) {
            double tpa;
            double tsa;
            DialRegion dregion = (DialRegion)dialComponent.getDialRegions().get(i2);
            double drStartValue = ((NumberDataElement)dregion.getStartValue()).getValue();
            double drEndValue = ((NumberDataElement)dregion.getEndValue()).getValue();
            double ascMinValue = Double.parseDouble(this.asc.getMinimum().toString());
            double ascMaxValue = Double.parseDouble(this.asc.getMaximum().toString());
            if (Math.max(drStartValue, drEndValue) <= ascMinValue || Math.min(drStartValue, drEndValue) >= ascMaxValue || drStartValue == drEndValue) continue;
            double sAngle = AutoScale.getLocation((AutoScale)this.asc, (double)drStartValue);
            double eAngle = AutoScale.getLocation((AutoScale)this.asc, (double)drEndValue);
            if (sAngle < this.dStartAngle) {
                sAngle = this.dStartAngle;
            }
            if (sAngle > this.dStopAngle) {
                sAngle = this.dStopAngle;
            }
            if (eAngle < this.dStartAngle) {
                eAngle = this.dStartAngle;
            }
            if (eAngle > this.dStopAngle) {
                eAngle = this.dStopAngle;
            }
            if ((tsa = this.transformAngle(sAngle)) > (tpa = this.transformAngle(eAngle))) {
                double temp = tsa;
                tsa = tpa;
                tpa = temp;
            }
            are.setBounds(dialBounds);
            are.setStartAngle(tsa);
            are.setAngleExtent(tpa - tsa);
            are.setBackground(dregion.getFill());
            are.setOutline(dregion.getOutline());
            are.setStyle(3);
            are.setInnerRadius(dregion.isSetInnerRadius() ? Math.min(dregion.getInnerRadius() * this.dScale, dDialRadius) : 0.0);
            if (dregion.isSetOuterRadius()) {
                if (dregion.getOuterRadius() == -1.0) {
                    are.setOuterRadius(dDialRadius);
                } else {
                    are.setOuterRadius(Math.min(dregion.getOuterRadius() * this.dScale, dDialRadius));
                }
            } else {
                are.setOuterRadius(0.0);
            }
            idr.fillArc(are);
            idr.drawArc(are);
        }
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createUnknown((EObject)dialComponent), LineRenderEvent.class);
        double[] tickCoord = this.asc.getTickCordinates();
        if ((!bDialSuperimposed || bFirstSeries) && (dialComponent.getMajorGrid().getTickAttributes().isVisible() || dialComponent.getMinorGrid().getTickAttributes().isVisible())) {
            double[] minorCoord = this.asc.getMinorCoordinates(this.sc.getMinorGridsPerUnit());
            Location start = LocationImpl.create((double)0.0, (double)0.0);
            Location end = LocationImpl.create((double)0.0, (double)0.0);
            for (i = 0; i < this.asc.getTickCount(); ++i) {
                double mtd = tickCoord[i];
                mtd = this.transformAngle(mtd);
                double mtr = Math.toRadians(mtd);
                if (dialComponent.getMajorGrid().getTickAttributes().isVisible()) {
                    lre.setLineAttributes(dialComponent.getMajorGrid().getTickAttributes());
                    switch (dialComponent.getMajorGrid().getTickStyle().getValue()) {
                        case 2: {
                            start.set(xc + dDialRadius * Math.cos(mtr), yc - dDialRadius * Math.sin(mtr));
                            end.set(xc + (dDialRadius + 5.0) * Math.cos(mtr), yc - (dDialRadius + 5.0) * Math.sin(mtr));
                            break;
                        }
                        case 4: {
                            start.set(xc + (dDialRadius + 2.5) * Math.cos(mtr), yc - (dDialRadius + 2.5) * Math.sin(mtr));
                            end.set(xc + (dDialRadius - 2.5) * Math.cos(mtr), yc - (dDialRadius - 2.5) * Math.sin(mtr));
                            break;
                        }
                        case 3: {
                            start.set(xc + dDialRadius * Math.cos(mtr), yc - dDialRadius * Math.sin(mtr));
                            end.set(xc + (dDialRadius - 5.0) * Math.cos(mtr), yc - (dDialRadius - 5.0) * Math.sin(mtr));
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.invalid.tick.style.dial", Messages.getResourceBundle(this.dial.getRunTimeContext().getULocale()));
                        }
                    }
                    lre.setStart(start);
                    lre.setEnd(end);
                    this.dc.addLine(lre);
                }
                if (!dialComponent.getMinorGrid().getTickAttributes().isVisible() || i == this.asc.getTickCount() - 1) continue;
                lre.setLineAttributes(dialComponent.getMinorGrid().getTickAttributes());
                for (int j = 0; j < this.sc.getMinorGridsPerUnit() - 1; ++j) {
                    double minortd = minorCoord[j];
                    if (this.inverseScale && mtd + minortd >= this.transformAngle(tickCoord[i + 1]) || !this.inverseScale && mtd - minortd <= this.transformAngle(tickCoord[i + 1])) continue;
                    double minortr = Math.toRadians(this.inverseScale ? mtd + minortd : mtd - minortd);
                    switch (dialComponent.getMinorGrid().getTickStyle().getValue()) {
                        case 2: {
                            start.set(xc + dDialRadius * Math.cos(minortr), yc - dDialRadius * Math.sin(minortr));
                            end.set(xc + (dDialRadius + 5.0) * Math.cos(minortr), yc - (dDialRadius + 5.0) * Math.sin(minortr));
                            break;
                        }
                        case 4: {
                            start.set(xc + (dDialRadius + 2.5) * Math.cos(minortr), yc - (dDialRadius + 2.5) * Math.sin(minortr));
                            end.set(xc + (dDialRadius - 2.5) * Math.cos(minortr), yc - (dDialRadius - 2.5) * Math.sin(minortr));
                            break;
                        }
                        case 3: {
                            start.set(xc + dDialRadius * Math.cos(minortr), yc - dDialRadius * Math.sin(minortr));
                            end.set(xc + (dDialRadius - 5.0) * Math.cos(minortr), yc - (dDialRadius - 5.0) * Math.sin(minortr));
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.invalid.tick.style.dial", Messages.getResourceBundle(this.dial.getRunTimeContext().getULocale()));
                        }
                    }
                    lre.setStart(start);
                    lre.setEnd(end);
                    this.dc.addLine(lre);
                }
            }
        }
        if ((!bDialSuperimposed || bDialSuperimposed && bFirstSeries) && dialComponent.getLabel().isSetVisible() && dialComponent.getLabel().isVisible()) {
            TextRenderEvent tre = (TextRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createUnknown((EObject)dialComponent.getLabel()), TextRenderEvent.class);
            Label lbScale = LabelImpl.copyInstance((Label)dialComponent.getLabel());
            Location loc = LocationImpl.create((double)0.0, (double)0.0);
            tre.setLabel(lbScale);
            tre.setAction(2);
            tre.setLocation(loc);
            for (i = 0; i < tickCoord.length; ++i) {
                if (this.dStopAngle - this.dStartAngle == 360.0 && i == tickCoord.length - 1) continue;
                lbScale.getCaption().setValue(this.sla[i]);
                double tickAngle = this.dStartAngle + (tickCoord[i] - tickCoord[0]) / (tickCoord[tickCoord.length - 1] - tickCoord[0]) * (this.dStopAngle - this.dStartAngle);
                tickAngle = this.transformAngle(tickAngle);
                int quad = ChartUtil.getQuadrant((double)tickAngle);
                double tickRadians = Math.toRadians(tickAngle);
                double tx = xc + dDialRadius * Math.cos(tickRadians);
                double ty = yc - dDialRadius * Math.sin(tickRadians);
                switch (quad) {
                    case -1: {
                        loc.set(tx + this.dSafeSpacing / 2.0, ty);
                        tre.setTextPosition(2);
                        break;
                    }
                    case -2: {
                        loc.set(tx, ty - this.dSafeSpacing / 2.0);
                        tre.setTextPosition(3);
                        break;
                    }
                    case -3: {
                        loc.set(tx - this.dSafeSpacing / 2.0, ty);
                        tre.setTextPosition(1);
                        break;
                    }
                    case -4: {
                        loc.set(tx, ty + this.dSafeSpacing / 2.0);
                        tre.setTextPosition(4);
                        break;
                    }
                    case 1: {
                        loc.set(tx + this.dSafeSpacing / 2.0, ty - this.dSafeSpacing / 2.0);
                        tre.setTextPosition(2);
                        break;
                    }
                    case 2: {
                        loc.set(tx - this.dSafeSpacing / 2.0, ty - this.dSafeSpacing / 2.0);
                        tre.setTextPosition(1);
                        break;
                    }
                    case 3: {
                        loc.set(tx - this.dSafeSpacing / 2.0, ty + this.dSafeSpacing / 2.0);
                        tre.setTextPosition(1);
                        break;
                    }
                    case 4: {
                        loc.set(tx + this.dSafeSpacing / 2.0, ty + this.dSafeSpacing / 2.0);
                        tre.setTextPosition(2);
                    }
                }
                this.dc.addLabel(tre);
            }
        }
        if ((needleAngle = AutoScale.getLocation((AutoScale)this.asc, (double)this.dValue)) < this.dStartAngle || needleAngle > this.dStopAngle) {
            return;
        }
        needleAngle = this.transformAngle(needleAngle);
        boolean bCategoryStyle = ((ChartWithoutAxes)this.dial.getModel()).getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
        LineAttributes lia = LineAttributesImpl.copyInstance((LineAttributes)needleComponent.getLineAttributes());
        Fill fl = bCategoryStyle ? (Fill)EcoreUtil.copy((EObject)((Fill)this.pa.getEntries().get(0))) : (Fill)EcoreUtil.copy((EObject)((Fill)this.pa.getEntries().get(this.dial.getSeriesDefinition().getRunTimeSeries().indexOf(this.ds) % this.pa.getEntries().size())));
        this.dial.updateTranslucency(fl, (Series)this.ds);
        ScriptHandler sh = this.dial.getRunTimeContext().getScriptHandler();
        ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)this.dphValue, (Object)fl, (Object)this.dial.getRunTimeContext().getScriptContext());
        this.dial.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)this.dphValue);
        if (fl instanceof ColorDefinition) {
            lia.setColor((ColorDefinition)fl);
        } else if (fl instanceof Gradient) {
            lia.setColor(((Gradient)fl).getStartColor());
        }
        LineRenderEvent lreNeedle = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)this.ds), LineRenderEvent.class);
        lreNeedle.setLineAttributes(lia);
        lreNeedle.setStart(LocationImpl.create((double)(dialBounds.getLeft() + dialBounds.getWidth() / 2.0), (double)(dialBounds.getTop() + dialBounds.getHeight() / 2.0)));
        double xOffset = dDialRadius * Math.cos(Math.toRadians(needleAngle));
        double yOffset = dDialRadius * Math.sin(Math.toRadians(needleAngle));
        lreNeedle.setEnd(LocationImpl.create((double)(lreNeedle.getStart().getX() + xOffset), (double)(lre.getStart().getY() - yOffset)));
        this.dc.addLine(lreNeedle);
        this.renderNeedleDecorator(idr, needleComponent, lreNeedle.getStart(), lreNeedle.getEnd(), lreNeedle.getLineAttributes(), needleAngle, dialBounds.getWidth() / 2.0, this.dphValue);
        ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)this.dphValue, (Object)fl, (Object)this.dial.getRunTimeContext().getScriptContext());
        this.dial.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)this.dphValue);
    }

    private void renderNeedleDecorator(IDeviceRenderer idr, Needle ndl, Location startPoint, Location endPoint, LineAttributes lia, double angle, double dialRadius, DataPointHints dph) throws ChartException {
        double decSize = (double)(4 * ((lia.getThickness() + 5) / 5)) * this.dScale;
        if (decSize > dialRadius / 5.0) {
            decSize = Math.max(dialRadius / 5.0, 1.0);
        }
        switch (ndl.getDecorator().getValue()) {
            case 0: {
                EList elTriggers;
                PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)this.ds), PolygonRenderEvent.class);
                Location[] loa = new Location[]{LocationImpl.copyInstance((Location)endPoint), LocationImpl.create((double)(endPoint.getX() - 2.0 * decSize * Math.cos(Math.toRadians(angle - 30.0))), (double)(endPoint.getY() + 2.0 * decSize * Math.sin(Math.toRadians(angle - 30.0)))), LocationImpl.create((double)(endPoint.getX() - 2.0 * decSize * Math.sin(Math.toRadians(60.0 - angle))), (double)(endPoint.getY() + 2.0 * decSize * Math.cos(Math.toRadians(60.0 - angle))))};
                pre.setPoints(loa);
                pre.setBackground((Fill)lia.getColor());
                pre.setOutline(lia);
                this.dc.addPlane((PrimitiveRenderEvent)pre, 3);
                if (!this.dial.isInteractivityEnabled() || (elTriggers = this.ds.getTriggers()).isEmpty()) break;
                StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.ds, (DataPointHints)dph);
                InteractionEvent iev = (InteractionEvent)((EventObjectCache)idr).getEventObject((Object)iSource, InteractionEvent.class);
                for (int t = 0; t < elTriggers.size(); ++t) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                    this.dial.processTrigger(tg, iSource);
                    iev.addTrigger(tg);
                }
                iev.setHotSpot((PrimitiveRenderEvent)pre);
                idr.enableInteraction(iev);
                break;
            }
            case 1: {
                EList elTriggers;
                OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)this.ds), OvalRenderEvent.class);
                double radius = Math.sqrt(Math.pow(endPoint.getX() - startPoint.getX(), 2.0) + Math.pow(endPoint.getY() - startPoint.getY(), 2.0));
                double x = startPoint.getX() + (radius - decSize) * Math.cos(Math.toRadians(angle));
                double y = startPoint.getY() - (radius - decSize) * Math.sin(Math.toRadians(angle));
                Bounds bo = BoundsImpl.create((double)(x - decSize), (double)(y - decSize), (double)(2.0 * decSize), (double)(2.0 * decSize));
                ore.setBounds(bo);
                ore.setOutline(lia);
                ore.setBackground((Fill)lia.getColor());
                this.dc.addPlane((PrimitiveRenderEvent)ore, 3);
                if (!this.dial.isInteractivityEnabled() || (elTriggers = this.ds.getTriggers()).isEmpty()) break;
                StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.ds, (DataPointHints)dph);
                InteractionEvent iev = (InteractionEvent)((EventObjectCache)idr).getEventObject((Object)iSource, InteractionEvent.class);
                for (int t = 0; t < elTriggers.size(); ++t) {
                    Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                    this.dial.processTrigger(tg, iSource);
                    iev.addTrigger(tg);
                }
                iev.setHotSpot((PrimitiveRenderEvent)ore);
                idr.enableInteraction(iev);
                break;
            }
        }
    }

    private Size computeLabelSize(AutoScale sc, Label la) throws ChartException {
        if (!la.isSetVisible() || !la.isVisible()) {
            return SizeImpl.create((double)0.0, (double)0.0);
        }
        double x = 0.0;
        double y = 0.0;
        double dw = 0.0;
        double dh = 0.0;
        double[] da = sc.getTickCordinates();
        double dAxisValue = Methods.asDouble((Object)sc.getMinimum());
        double dAxisStep = Methods.asDouble((Object)sc.getStep());
        Object df = null;
        FormatSpecifier fs = sc.getFormatSpecifier();
        if (fs == null) {
            // empty if block
        }
        NumberDataElement nde = NumberDataElementImpl.create((double)0.0);
        this.sla = new String[da.length];
        for (int i = 0; i < da.length; ++i) {
            RotatedRectangle rr;
            String sText;
            nde.setValue(dAxisValue);
            try {
                sText = ValueFormatter.format((Object)nde, (FormatSpecifier)fs, (ULocale)this.dial.getRunTimeContext().getULocale(), df);
            }
            catch (ChartException dfex) {
                sText = IConstants.NULL_STRING;
            }
            x = da[i];
            la.getCaption().setValue(sText);
            try {
                rr = AutoScale.computePolygon((IDisplayServer)this.xs, (int)3, (Label)la, (double)x, (double)y);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)uiex);
            }
            Rectangle rt = rr.getBounds();
            dw = Math.max(rt.getWidth(), dw);
            dh = Math.max(rt.getHeight(), dh);
            dAxisValue = i == da.length - 2 ? Methods.asDouble((Object)sc.getMaximum()) : (dAxisValue += dAxisStep);
            this.sla[i] = sText;
        }
        return SizeImpl.create((double)dw, (double)dh);
    }

    private double transformAngle(double angle) {
        if (!this.inverseScale) {
            angle = this.dStopAngle + this.dStartAngle - angle;
        }
        return angle;
    }

    private double[] getMinMaxValue() throws ChartException {
        double min;
        double[] values = this.srh.asPrimitiveDoubleValues();
        if (values == null || values.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, "Empty dataset found", Messages.getResourceBundle());
        }
        double max = min = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            min = Math.min(min, values[i]);
            max = Math.max(max, values[i]);
        }
        return new double[]{min, max};
    }

    private AutoScale computeScale(Label lb, DataSetIterator dsi, double dValue, double dStart, double dEnd, DataElement oMinimum, DataElement oMaximum, Double oStep, FormatSpecifier fs, RunTimeContext rtc, double fullRadius) throws ChartException {
        boolean bFirstFit;
        AutoScale sc = null;
        AutoScale scCloned = null;
        double[] minMax = this.getMinMaxValue();
        double dMinValue = minMax[0];
        double dMaxValue = minMax[1];
        double dStep = Math.abs(dMaxValue - dMinValue) / 2.0;
        sc = new AutoScale(3, (Object)new Double(dMinValue), (Object)new Double(dMaxValue), (Object)new Double(dStep));
        sc.setData(dsi);
        sc.setDirection(1);
        sc.setFormatSpecifier(fs);
        sc.setRunTimeContext(rtc);
        if (oMinimum != null) {
            if (!(oMinimum instanceof NumberDataElement)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.minimum.scale.value", new Object[]{sc.getMinimum(), ""}, Messages.getResourceBundle(rtc.getULocale()));
            }
            sc.setMinimum((Object)new Double(((NumberDataElement)oMinimum).getValue()));
            sc.setMinimumFixed(true);
        } else if (!Double.isNaN(dMinValue)) {
            sc.setMinimum((Object)new Double(dMinValue));
            sc.setMinimumFixed(true);
        }
        if (oMaximum != null) {
            if (!(oMaximum instanceof NumberDataElement)) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.maximum.scale.value", new Object[]{sc.getMaximum(), ""}, Messages.getResourceBundle(rtc.getULocale()));
            }
            sc.setMaximum((Object)new Double(((NumberDataElement)oMaximum).getValue()));
            sc.setMaximumFixed(true);
        } else if (!Double.isNaN(dMaxValue)) {
            sc.setMaximum((Object)new Double(dMaxValue));
            sc.setMaximumFixed(true);
        }
        if (oStep != null) {
            sc.setStep((Object)oStep);
            sc.setStepFixed(true);
            if ((Double)sc.getStep() <= 0.0) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.invalid.step.value", new Object[]{oStep}, Messages.getResourceBundle(rtc.getULocale()));
            }
        }
        if (sc.isMaximumFixed() && sc.isMinimumFixed() && (Double)sc.getMinimum() > (Double)sc.getMaximum()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.min.largerthan.max", new Object[]{sc.getMinimum(), sc.getMaximum()}, Messages.getResourceBundle(rtc.getULocale()));
        }
        Double oMinValue = new Double(dMinValue);
        Double oMaxValue = new Double(dMaxValue);
        sc.updateAxisMinMax((Object)oMinValue, (Object)oMaxValue);
        sc.computeTicks(this.xs, lb, 3, 0, dStart, dEnd, false, null);
        dStart = sc.getStart();
        dEnd = sc.getEnd();
        boolean bFits = bFirstFit = this.checkFit(sc, this.xs, lb, 3, fullRadius);
        boolean bZoomSuccess = false;
        while (bFits == bFirstFit) {
            bZoomSuccess = true;
            scCloned = (AutoScale)sc.clone();
            if (sc.isStepFixed()) break;
            if (bFirstFit) {
                if (!bFits) break;
                bZoomSuccess = sc.zoomIn();
            } else {
                if (!bFits && sc.getTickCount() == 2) break;
                bZoomSuccess = sc.zoomOut();
            }
            if (!bZoomSuccess) break;
            sc.updateAxisMinMax((Object)oMinValue, (Object)oMaxValue);
            sc.computeTicks(this.xs, lb, 3, 0, dStart, dEnd, false, null);
            bFits = this.checkFit(sc, this.xs, lb, 3, fullRadius);
            if (bFits || sc.getTickCount() != 2) continue;
            sc = scCloned;
            break;
        }
        if (scCloned != null && bFirstFit && bZoomSuccess) {
            sc = scCloned;
        }
        sc.setData(dsi);
        return sc;
    }

    private boolean checkFit(AutoScale sc, IDisplayServer xs, Label la, int iLabelLocation, double fullRadius) throws ChartException {
        double dAngleInDegrees = la.getCaption().getFont().getRotation();
        double x = 0.0;
        double y = 0.0;
        int iPointToCheck = 0;
        if (iLabelLocation == 3 || iLabelLocation == 4) {
            iPointToCheck = sc.getDirection() == -1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 1 : 2) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 3 : 0);
        } else if (iLabelLocation == 1 || iLabelLocation == 2) {
            iPointToCheck = sc.getDirection() == 1 ? (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 0 : 1) : (dAngleInDegrees < 0.0 && dAngleInDegrees > -90.0 ? 2 : 3);
        }
        double[] angles = sc.getTickCordinates();
        RotatedRectangle rrPrev = null;
        RotatedRectangle rrPrev2 = null;
        if ((sc.getType() & 3) == 3) {
            double dAxisValue = Methods.asDouble((Object)sc.getMinimum());
            double dAxisStep = Methods.asDouble((Object)sc.getStep());
            DecimalFormat df = null;
            if (sc.getFormatSpecifier() == null) {
                df = new DecimalFormat(sc.getNumericPattern());
            }
            NumberDataElement nde = NumberDataElementImpl.create((double)0.0);
            double delta = Math.PI * fullRadius / 180.0;
            for (int i = 0; i < angles.length; ++i) {
                RotatedRectangle rr;
                String sText;
                double da = Math.abs(angles[i] - sc.getStart()) * delta;
                nde.setValue(dAxisValue);
                try {
                    sText = ValueFormatter.format((Object)nde, (FormatSpecifier)sc.getFormatSpecifier(), (ULocale)sc.getRunTimeContext().getULocale(), (Object)df);
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    sText = IConstants.NULL_STRING;
                }
                if (iLabelLocation == 3 || iLabelLocation == 4) {
                    x = da;
                } else if (iLabelLocation == 1 || iLabelLocation == 2) {
                    y = da;
                }
                la.getCaption().setValue(sText);
                try {
                    rr = Methods.computePolygon((IDisplayServer)xs, (int)iLabelLocation, (Label)la, (double)x, (double)y);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)uiex);
                }
                Point p = rr.getPoint(iPointToCheck);
                if (sc.isAxisLabelStaggered() && sc.isTickLabelStaggered(i)) {
                    if (rrPrev2 != null && (rrPrev2.contains(p) || rrPrev2.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects((Polygon)rr, (Polygon)rrPrev2))) {
                        return false;
                    }
                    rrPrev2 = rr;
                } else {
                    if (rrPrev != null && (rrPrev.contains(p) || rrPrev.getPoint(iPointToCheck).equals(p) || ChartUtil.intersects((Polygon)rr, (Polygon)rrPrev))) {
                        return false;
                    }
                    rrPrev = rr;
                }
                dAxisValue += dAxisStep;
            }
        }
        return true;
    }
}

