/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.birt.chart.internal.datafeed.GroupKey;
import org.eclipse.birt.chart.model.attribute.SortOption;

public class TupleComparator
implements Comparator {
    private GroupKey[] iaSortKeys;
    private Collator collator;

    TupleComparator(GroupKey[] keys) {
        this.iaSortKeys = keys;
        this.collator = Collator.getInstance();
    }

    public int compare(Object o1, Object o2) {
        Object[] oaTuple1 = (Object[])o1;
        Object[] oaTuple2 = (Object[])o2;
        int iResult = 0;
        for (int i = 0; i < this.iaSortKeys.length; ++i) {
            int keyIndex = this.iaSortKeys[i].getKeyIndex();
            Object oValue1 = oaTuple1[keyIndex];
            Object oValue2 = oaTuple2[keyIndex];
            SortOption direction = this.iaSortKeys[i].getDirection();
            if (direction == null) {
                iResult = 0;
            } else if (direction.getValue() == 0) {
                iResult = TupleComparator.compareObjects(oValue1, oValue2, this.collator);
            } else if (direction.getValue() == 1) {
                iResult = TupleComparator.compareObjects(oValue2, oValue1, this.collator);
            }
            if (iResult == 0) continue;
            return iResult;
        }
        return 0;
    }

    public static int compareObjects(Object a, Object b, Collator collator) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a instanceof String) {
            int iC = collator != null ? collator.compare(a.toString(), b.toString()) : a.toString().compareTo(b.toString());
            if (iC != 0) {
                iC = iC < 0 ? -1 : 1;
            }
            return iC;
        }
        if (a instanceof Number) {
            double d2;
            double d1 = ((Number)a).doubleValue();
            return d1 == (d2 = ((Number)b).doubleValue()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Date) {
            long d2;
            long d1 = ((Date)a).getTime();
            return d1 == (d2 = ((Date)b).getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Calendar) {
            long d2;
            long d1 = ((Calendar)a).getTime().getTime();
            return d1 == (d2 = ((Calendar)b).getTime().getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        return TupleComparator.compareObjects(a.toString(), b.toString(), collator);
    }
}

