/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.impl;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutFactory;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.impl.BlockImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class LabelBlockImpl
extends BlockImpl
implements LabelBlock {
    protected Label label = null;

    protected LabelBlockImpl() {
    }

    protected EClass eStaticClass() {
        return LayoutPackage.Literals.LABEL_BLOCK;
    }

    public Label getLabel() {
        return this.label;
    }

    public NotificationChain basicSetLabel(Label newLabel, NotificationChain msgs) {
        Label oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldLabel, (Object)newLabel);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setLabel(Label newLabel) {
        if (newLabel != this.label) {
            NotificationChain msgs = null;
            if (this.label != null) {
                msgs = ((InternalEObject)this.label).eInverseRemove((InternalEObject)this, -17, null, msgs);
            }
            if (newLabel != null) {
                msgs = ((InternalEObject)newLabel).eInverseAdd((InternalEObject)this, -17, null, msgs);
            }
            if ((msgs = this.basicSetLabel(newLabel, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newLabel, (Object)newLabel));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 16: {
                return this.basicSetLabel(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getLabel();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setLabel((Label)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setLabel(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.label != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public static Block create() {
        LabelBlock lb = LayoutFactory.eINSTANCE.createLabelBlock();
        ((LabelBlockImpl)lb).initialize();
        return lb;
    }

    protected void initialize() {
        super.initialize();
        this.setLabel(LabelImpl.create());
    }

    public final Size getPreferredSize(IDisplayServer xs, Chart cm, RunTimeContext rtc) throws ChartException {
        BoundingBox bb = null;
        String sPreviousValue = this.getLabel().getCaption().getValue();
        this.getLabel().getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
        try {
            bb = Methods.computeBox(xs, 3, this.getLabel(), 0.0, 0.0);
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, uiex);
        }
        finally {
            this.getLabel().getCaption().setValue(sPreviousValue);
        }
        Size sz = SizeImpl.create(bb.getWidth(), bb.getHeight());
        sz.scale(72.0 / (double)xs.getDpiResolution());
        Insets ins = this.getInsets();
        sz.setHeight(sz.getHeight() + ins.getTop() + ins.getBottom());
        sz.setWidth(sz.getWidth() + ins.getLeft() + ins.getRight());
        return sz;
    }
}

