/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;

public class ProbePerfTracker {
    public static int PROCESS_CIMSCANNER = 0;
    public static int CIMOM_ENUMERATOR = PROCESS_CIMSCANNER + 1;
    public static int CIMOM_ENUMERATOR_NAMES = CIMOM_ENUMERATOR + 1;
    public static int CIMOM_ASSOCIATORS = CIMOM_ENUMERATOR_NAMES + 1;
    public static int CIMOM_ASSOCIATORS_NAMES = CIMOM_ASSOCIATORS + 1;
    public static int CIMOM_REFERENCES = CIMOM_ASSOCIATORS_NAMES + 1;
    public static int CIMOM_REFERENCES_NAMES = CIMOM_REFERENCES + 1;
    public static int CIMOM_GETINSTANCE = CIMOM_REFERENCES_NAMES + 1;
    public static int DISKCIMPROCESSOR_HANDLE_ASSOCIATION = CIMOM_GETINSTANCE + 1;
    public static int DISKCIMPROCESSOR_HANDLE_ENTITY = DISKCIMPROCESSOR_HANDLE_ASSOCIATION + 1;
    public static int STEP_PERSIST_STORAGESETTING = DISKCIMPROCESSOR_HANDLE_ENTITY + 1;
    public static int MAPPER_PERSIST = STEP_PERSIST_STORAGESETTING + 1;
    public static int DBC_COMMIT = MAPPER_PERSIST + 1;
    public static int DBC_QUERY = DBC_COMMIT + 1;
    public static int PROCESSOR_END = DBC_QUERY + 1;
    public static int POST_PROCESSING = PROCESSOR_END + 1;
    public static int NUMBER_OF_ACTIONTYPES = POST_PROCESSING + 1;
    public static String NEWLINE = System.getProperty("line.separator");
    public static String[] sActionDesc = new String[NUMBER_OF_ACTIONTYPES];
    ProbeAction[] cProbeActions = new ProbeAction[NUMBER_OF_ACTIONTYPES];
    String cScannerId;
    long cProbeStart = 0L;

    static {
        ProbePerfTracker.sActionDesc[ProbePerfTracker.PROCESS_CIMSCANNER] = "process CIMScanner          ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ENUMERATOR] = "CIM call Enumerator         ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ENUMERATOR_NAMES] = "CIM call EnumeratorNames    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ASSOCIATORS] = "CIM call Associators        ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ASSOCIATORS_NAMES] = "CIM call AssociatorNames    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_REFERENCES] = "CIM call References         ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_REFERENCES_NAMES] = "CIM call ReferencesNames    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_GETINSTANCE] = "CIM call getInstance        ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ASSOCIATION] = "DiskCIMProc.handleAssoc.    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ENTITY] = "DiskCIMProc.handleEntity    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.STEP_PERSIST_STORAGESETTING] = "Step.PersistStorageSetting  ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.MAPPER_PERSIST] = "Mapper.persist              ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DBC_COMMIT] = "DBConnection.commit         ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DBC_QUERY] = "DB.executeQuery             ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.PROCESSOR_END] = "Processor.end               ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.POST_PROCESSING] = "Post Processing             ";
    }

    public ProbePerfTracker(String string) {
        this.cScannerId = string;
        this.cProbeStart = System.currentTimeMillis();
        int n = 0;
        while (n < this.cProbeActions.length) {
            this.cProbeActions[n] = new ProbeAction();
            ++n;
        }
    }

    public ProbeAction startAction(int n) {
        if (n >= 0 && n < NUMBER_OF_ACTIONTYPES) {
            ProbeAction probeAction = this.cProbeActions[n];
            probeAction.start();
            return probeAction;
        }
        return null;
    }

    public void finishedAction(int n) {
        if (n > 0 && n < NUMBER_OF_ACTIONTYPES) {
            ProbeAction probeAction = this.cProbeActions[n];
            probeAction.finished();
        }
    }

    public void probeFinished(LogTraceHelper logTraceHelper) {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        Date date2 = new Date(this.cProbeStart);
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Probe performance Tracker Report").append(NEWLINE);
        stringBuffer.append("====================================================================").append(NEWLINE);
        stringBuffer.append("Probe scanner id: ").append(this.cScannerId).append(NEWLINE);
        stringBuffer.append("Probe started:  ").append(date2.toString()).append(NEWLINE);
        stringBuffer.append("Probe finished: ").append(date.toString()).append(NEWLINE);
        stringBuffer.append("Probe duration: ").append(this.formatDuration(l - this.cProbeStart)).append(NEWLINE);
        stringBuffer.append("Monitored probe Actions:").append(NEWLINE);
        int n = 0;
        while (n < this.cProbeActions.length) {
            ProbeAction probeAction = this.cProbeActions[n];
            int n2 = probeAction.getCallCount();
            long l2 = probeAction.getDuration();
            long l3 = n2 > 0 ? l2 / (long)n2 : 0L;
            stringBuffer.append(sActionDesc[n]).append(": No. of calls: ").append(decimalFormat.format(n2));
            stringBuffer.append(", Total time: ").append(this.formatDuration(l2));
            stringBuffer.append(", Average time: ").append(this.formatDuration(l3)).append(NEWLINE);
            ++n;
        }
        stringBuffer.append("====================================================================").append(NEWLINE);
        logTraceHelper.traceAlways(stringBuffer.toString());
    }

    private StringBuffer formatDuration(long l) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("000");
        long l2 = l / 3600000L;
        long l3 = (l %= 3600000L) / 60000L;
        long l4 = (l %= 60000L) / 1000L;
        long l5 = l % 1000L;
        return new StringBuffer().append(decimalFormat.format(l2)).append(':').append(decimalFormat.format(l3)).append(':').append(decimalFormat.format(l4)).append('.').append(decimalFormat2.format(l5));
    }

    public class ProbeAction {
        long cDuration = 0L;
        long cStartTime = 0L;
        int cCallCounter = 0;

        protected void start() {
            this.cStartTime = System.currentTimeMillis();
        }

        protected void finished() {
            this.cDuration += System.currentTimeMillis() - this.cStartTime;
            ++this.cCallCounter;
        }

        protected long getDuration() {
            return this.cDuration;
        }

        protected int getCallCount() {
            return this.cCallCounter;
        }
    }
}

