/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ProgressLogger
implements IProgressLogger {
    protected ILogger cJobLogger;
    protected String cEntryMessage;
    protected String cCompleteMessage;
    protected String cProgressMessage;
    protected String cFailedMessage;
    protected int cInterval = 50;
    protected int cElementCount = 0;
    protected boolean cComplete = false;
    protected String cSystemName;
    private boolean cHierarchical = false;

    public ProgressLogger(ILogger iLogger, String string, String string2, String string3, String string4, String string5) {
        this.cJobLogger = iLogger;
        this.cSystemName = string != null ? string : "n/a";
        this.cEntryMessage = string2;
        this.cProgressMessage = string3;
        this.cCompleteMessage = string4;
        this.cFailedMessage = string5;
    }

    public int getInterval() {
        return this.cInterval;
    }

    public void setInterval(int n) {
        this.cInterval = n;
    }

    public void entry() {
        this.cElementCount = 0;
        this.cComplete = false;
        this.cJobLogger.message(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "entry", this.cEntryMessage, (Object)this.cSystemName);
    }

    public void elementDiscovered() {
        if (!this.cHierarchical) {
            this.advance();
        }
    }

    public void complete() {
        this.cComplete = true;
        this.cJobLogger.message(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "complete", this.cCompleteMessage, (Object)Integer.toString(this.cElementCount));
    }

    public void exit() {
        if (!this.cComplete) {
            this.cJobLogger.message(IRecordType.TYPE_ERROR, (Object)this.getClass().getName(), "exit", this.cFailedMessage, (Object)Integer.toString(this.cElementCount));
        }
    }

    public void enableHierarchicalMode() {
        this.cHierarchical = true;
    }

    public void disableHierarchicalMode() {
        this.cHierarchical = false;
    }

    public boolean isHierarchical() {
        return this.cHierarchical;
    }

    protected void advance() {
        if (++this.cElementCount % this.cInterval == 0) {
            this.cJobLogger.message(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "increment", this.cProgressMessage, (Object)Integer.toString(this.cElementCount));
        }
    }

    public static class InnerProgressLogger
    implements IProgressLogger {
        private ProgressLogger cLogger;

        public InnerProgressLogger(ProgressLogger progressLogger) {
            this.cLogger = progressLogger;
        }

        public void entry() {
        }

        public void elementDiscovered() {
            this.cLogger.advance();
        }

        public void complete() {
        }

        public void exit() {
        }
    }
}

