/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import org.eclipse.birt.data.engine.aggregation.TotalAve;
import org.eclipse.birt.data.engine.aggregation.TotalCount;
import org.eclipse.birt.data.engine.aggregation.TotalCountDistinct;
import org.eclipse.birt.data.engine.aggregation.TotalFirst;
import org.eclipse.birt.data.engine.aggregation.TotalIrr;
import org.eclipse.birt.data.engine.aggregation.TotalLast;
import org.eclipse.birt.data.engine.aggregation.TotalMax;
import org.eclipse.birt.data.engine.aggregation.TotalMedian;
import org.eclipse.birt.data.engine.aggregation.TotalMin;
import org.eclipse.birt.data.engine.aggregation.TotalMirr;
import org.eclipse.birt.data.engine.aggregation.TotalMode;
import org.eclipse.birt.data.engine.aggregation.TotalMovingAve;
import org.eclipse.birt.data.engine.aggregation.TotalNpv;
import org.eclipse.birt.data.engine.aggregation.TotalRunningCount;
import org.eclipse.birt.data.engine.aggregation.TotalRunningNpv;
import org.eclipse.birt.data.engine.aggregation.TotalRunningSum;
import org.eclipse.birt.data.engine.aggregation.TotalStdDev;
import org.eclipse.birt.data.engine.aggregation.TotalSum;
import org.eclipse.birt.data.engine.aggregation.TotalVariance;
import org.eclipse.birt.data.engine.aggregation.TotalWeightedAve;
import org.eclipse.birt.data.engine.aggregation.rank.TotalIsBottomN;
import org.eclipse.birt.data.engine.aggregation.rank.TotalIsBottomNPercent;
import org.eclipse.birt.data.engine.aggregation.rank.TotalIsTopN;
import org.eclipse.birt.data.engine.aggregation.rank.TotalIsTopNPercent;
import org.eclipse.birt.data.engine.aggregation.rank.TotalPercentRank;
import org.eclipse.birt.data.engine.aggregation.rank.TotalPercentSum;
import org.eclipse.birt.data.engine.aggregation.rank.TotalPercentile;
import org.eclipse.birt.data.engine.aggregation.rank.TotalQuartile;
import org.eclipse.birt.data.engine.aggregation.rank.TotalRank;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;

public class BuiltInAggregationFactory {
    public static final String TOTAL_COUNT_FUNC = "COUNT";
    public static final String TOTAL_SUM_FUNC = "SUM";
    public static final String TOTAL_MAX_FUNC = "MAX";
    public static final String TOTAL_MIN_FUNC = "MIN";
    public static final String TOTAL_AVE_FUNC = "AVE";
    public static final String TOTAL_WEIGHTEDAVE_FUNC = "WEIGHTEDAVE";
    public static final String TOTAL_MOVINGAVE_FUNC = "MOVINGAVE";
    public static final String TOTAL_MEDIAN_FUNC = "MEDIAN";
    public static final String TOTAL_MODE_FUNC = "MODE";
    public static final String TOTAL_STDDEV_FUNC = "STDDEV";
    public static final String TOTAL_VARIANCE_FUNC = "VARIANCE";
    public static final String TOTAL_FIRST_FUNC = "FIRST";
    public static final String TOTAL_LAST_FUNC = "LAST";
    public static final String TOTAL_RUNNINGSUM_FUNC = "RUNNINGSUM";
    public static final String TOTAL_IRR_FUNC = "IRR";
    public static final String TOTAL_MIRR_FUNC = "MIRR";
    public static final String TOTAL_NPV_FUNC = "NPV";
    public static final String TOTAL_RUNNINGNPV_FUNC = "RUNNINGNPV";
    public static final String TOTAL_COUNTDISTINCT_FUNC = "COUNTDISTINCT";
    public static final String TOTAL_RANK_FUNC = "RANK";
    public static final String TOTAL_TOP_N_FUNC = "ISTOPN";
    public static final String TOTAL_TOP_PERCENT_FUNC = "ISTOPNPERCENT";
    public static final String TOTAL_BOTTOM_N_FUNC = "ISBOTTOMN";
    public static final String TOTAL_BOTTOM_PERCENT_FUNC = "ISBOTTOMNPERCENT";
    public static final String TOTAL_PERCENT_RANK_FUNC = "PERCENTRANK";
    public static final String TOTAL_PERCENTILE_FUNC = "PERCENTILE";
    public static final String TOTAL_QUARTILE_FUNC = "QUARTILE";
    public static final String TOTAL_PERCENTSUM_FUNC = "PERCENTSUM";
    public static final String TOTAL_RUNNINGCOUNT_FUNC = "RUNNINGCOUNT";
    private static BuiltInAggregationFactory instance = null;
    private static IAggregation[] aggregations = new IAggregation[]{new TotalCount(), new TotalSum(), new TotalMax(), new TotalMin(), new TotalAve(), new TotalMovingAve(), new TotalWeightedAve(), new TotalMedian(), new TotalMode(), new TotalStdDev(), new TotalVariance(), new TotalFirst(), new TotalLast(), new TotalRunningSum(), new TotalIrr(), new TotalMirr(), new TotalNpv(), new TotalRunningNpv(), new TotalCountDistinct(), new TotalRank(), new TotalIsTopN(), new TotalIsTopNPercent(), new TotalIsBottomN(), new TotalIsBottomNPercent(), new TotalPercentRank(), new TotalPercentile(), new TotalQuartile(), new TotalPercentSum(), new TotalRunningCount()};
    private static String[] aggNames = new String[]{"COUNT", "SUM", "MAX", "MIN", "AVE", "WEIGHTEDAVE", "MOVINGAVE", "MEDIAN", "MODE", "STDDEV", "VARIANCE", "FIRST", "LAST", "RUNNINGSUM", "IRR", "MIRR", "NPV", "RUNNINGNPV", "COUNTDISTINCT", "RANK", "ISTOPN", "ISTOPNPERCENT", "ISBOTTOMN", "ISBOTTOMNPERCENT", "PERCENTRANK", "PERCENTILE", "QUARTILE", "PERCENTSUM", "RUNNINGCOUNT"};

    private BuiltInAggregationFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuiltInAggregationFactory getInstance() {
        if (instance == null) {
            Class clazz = BuiltInAggregationFactory.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new BuiltInAggregationFactory();
                }
            }
        }
        return instance;
    }

    public IAggregation getAggregation(String name) {
        for (int i = 0; i < aggregations.length; ++i) {
            if (aggregations[i].getName().compareToIgnoreCase(name) != 0) continue;
            return aggregations[i];
        }
        return null;
    }

    public String[] getAggregationNames() {
        return aggNames;
    }
}

