/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.RunningAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRunningNpv
implements IAggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$TotalRunningNpv;

    public String getName() {
        return "RUNNINGNPV";
    }

    public int getType() {
        return 1;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true, false};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends RunningAccumulator {
        private double npv = 0.0;
        private double rate = 0.0;
        private int count = 1;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() throws DataException {
            super.start();
            this.npv = 0.0;
            this.count = 1;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 0) {
                throw new AssertionError();
            }
            if (args[0] != null && args[1] != null) {
                try {
                    if (this.count == 1) {
                        this.rate = DataTypeUtil.toDouble((Object)args[1]);
                    }
                    this.npv += DataTypeUtil.toDouble((Object)args[0]) / Math.pow(1.0 + this.rate, this.count++);
                }
                catch (BirtException e) {
                    throw new DataException("data.engine.DataConversionError", e);
                }
            }
        }

        public Object getValue() {
            return this.count > 1 ? new Double(this.npv) : null;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$TotalRunningNpv == null ? (class$org$eclipse$birt$data$engine$aggregation$TotalRunningNpv = TotalRunningNpv.class$("org.eclipse.birt.data.engine.aggregation.TotalRunningNpv")) : class$org$eclipse$birt$data$engine$aggregation$TotalRunningNpv).desiredAssertionStatus();
        }
    }
}

