/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation.rank;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.aggregation.SummaryAccumulator;
import org.eclipse.birt.data.engine.aggregation.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.core.DataException;

abstract class PercentileAccumulator
extends SummaryAccumulator {
    private double pct;
    private List cachedValues;
    static final /* synthetic */ boolean $assertionsDisabled;

    PercentileAccumulator() {
    }

    public void start() {
        super.start();
        this.pct = -1.0;
        this.cachedValues = new ArrayList();
    }

    public void onRow(Object[] args) throws DataException {
        Double d;
        if (!$assertionsDisabled && args.length != 2) {
            throw new AssertionError();
        }
        if (args[0] != null && args[0] != null && (d = RankAggregationUtil.getNumericValue(args[0])) != null) {
            this.cachedValues.add(d);
        }
        if (this.pct == -1.0) {
            Double pctValue = RankAggregationUtil.getNumericValue(args[1]);
            this.pct = this.getPctValue(pctValue);
        }
    }

    protected abstract double getPctValue(Double var1) throws DataException;

    public Object getSummaryValue() throws DataException {
        Object[] sortedObjs = this.cachedValues.toArray();
        RankAggregationUtil.sortArray(sortedObjs);
        double n = this.pct * (double)(sortedObjs.length - 1) + 1.0;
        int k = (int)Math.floor(n);
        double fraction = n - (double)k;
        double value = (Double)sortedObjs[k - 1];
        double adjustment = 0.0;
        if (fraction != 0.0) {
            double nextValue = (Double)sortedObjs[k];
            adjustment = fraction * (nextValue - value);
        }
        return new Double(value + adjustment);
    }

    static {
        $assertionsDisabled = !PercentileAccumulator.class.desiredAssertionStatus();
    }
}

