/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation.rank;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.data.engine.aggregation.rank.DataComparisonException;
import org.eclipse.birt.data.engine.aggregation.rank.DummyObject;
import org.eclipse.birt.data.engine.aggregation.rank.NullObject;
import org.eclipse.birt.data.engine.aggregation.rank.ValueComparator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

final class RankAggregationUtil {
    private static DummyObject dummy = new DummyObject();
    private static NullObject nullObject = new NullObject();

    RankAggregationUtil() {
    }

    static int getNextTopIndex(List cachedValues) throws DataException {
        return RankAggregationUtil.getIndex(cachedValues, true);
    }

    static int getNextBottomIndex(List cachedValues) throws DataException {
        return RankAggregationUtil.getIndex(cachedValues, false);
    }

    private static int getIndex(List cachedValues, boolean top) throws DataException {
        int result = -1;
        for (int i = 0; i < cachedValues.size(); ++i) {
            if (cachedValues.get(i).getClass() == (class$org$eclipse$birt$data$engine$aggregation$rank$DummyObject == null ? RankAggregationUtil.class$("org.eclipse.birt.data.engine.aggregation.rank.DummyObject") : class$org$eclipse$birt$data$engine$aggregation$rank$DummyObject)) continue;
            if (result == -1) {
                result = i;
                continue;
            }
            if (!(top ? RankAggregationUtil.compareTop(cachedValues.get(result), cachedValues.get(i)) : RankAggregationUtil.compareBottom(cachedValues.get(result), cachedValues.get(i)))) continue;
            result = i;
        }
        cachedValues.set(result, dummy);
        return result;
    }

    private static boolean compareTop(Object value1, Object value2) throws DataException {
        if (value1.getClass() == DummyObject.class || value2.getClass() == DummyObject.class) {
            return false;
        }
        if (value1.getClass() == NullObject.class) {
            return true;
        }
        if (value2.getClass() == NullObject.class) {
            return false;
        }
        return Boolean.valueOf(ScriptEvalUtil.evalConditionalExpr(value1, 3, value2, null).toString());
    }

    private static boolean compareBottom(Object value1, Object value2) throws DataException {
        if (value1.getClass() == DummyObject.class || value2.getClass() == DummyObject.class) {
            return false;
        }
        if (value1.getClass() == NullObject.class) {
            return false;
        }
        if (value2.getClass() == NullObject.class) {
            return true;
        }
        return Boolean.valueOf(ScriptEvalUtil.evalConditionalExpr(value1, 6, value2, null).toString());
    }

    static Double getNumericValue(Object o) {
        try {
            if (o instanceof Date) {
                return new Double(((Date)o).getTime());
            }
            return new Double(o.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static NullObject getNullObject() {
        return nullObject;
    }

    static void sortArray(Object[] objs) throws DataException {
        try {
            Arrays.sort(objs, new ValueComparator());
        }
        catch (DataComparisonException e) {
            throw e.getWrappedException();
        }
    }
}

