/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ExprManagerUtil;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.mozilla.javascript.Context;

public class ExprManager {
    private List bindingExprs = new ArrayList();
    private Map autoBindingExprMap = new HashMap();
    private int entryLevel = 0;
    public static final int OVERALL_GROUP = 0;

    ExprManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBindingExpr(String groupKey, Map resultsExprMap, int groupLevel) {
        if (resultsExprMap == null) {
            return;
        }
        Context cx = Context.enter();
        try {
            CompiledExpression ce;
            if (groupKey != null && (ce = ExpressionCompilerUtil.compile(groupKey, cx)) instanceof ColumnReferenceExpression) {
                ColumnReferenceExpression cre = (ColumnReferenceExpression)ce;
                groupKey = cre.getColumnName();
            }
            this.bindingExprs.add(new GroupBindingColumn(groupKey, groupLevel, resultsExprMap));
        }
        finally {
            Context.exit();
        }
    }

    void addAutoBindingExpr(String name, IBaseExpression baseExpr) {
        this.autoBindingExprMap.put(name, baseExpr);
    }

    public IBaseExpression getExpr(String name) {
        IBaseExpression baseExpr = this.getBindingExpr(name);
        if (baseExpr == null) {
            baseExpr = this.getAutoBindingExpr(name);
        }
        return baseExpr;
    }

    IBaseExpression getBindingExpr(String name) {
        for (int i = 0; i < this.bindingExprs.size(); ++i) {
            IBaseExpression o;
            GroupBindingColumn gcb = (GroupBindingColumn)this.bindingExprs.get(i);
            if (this.entryLevel != 0 && gcb.getGroupLevel() > this.entryLevel || (o = gcb.getExpression(name)) == null) continue;
            return o;
        }
        return null;
    }

    IScriptExpression getAutoBindingExpr(String name) {
        return (IScriptExpression)this.autoBindingExprMap.get(name);
    }

    List getBindingExprs() {
        return this.bindingExprs;
    }

    Map getAutoBindingExprMap() {
        return this.autoBindingExprMap;
    }

    void setEntryGroupLevel(int i) {
        this.entryLevel = i;
    }

    public void validateColumnBinding() throws DataException {
        ExprManagerUtil.validateColumnBinding(this);
    }
}

