/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.GroupDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;

class PreparedQueryUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    PreparedQueryUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static IPreparedQuery newInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        void var4_4;
        PreparedDataSourceQuery preparedQuery;
        if (!$assertionsDisabled && dataEngine == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        if (queryDefn.getQueryResultsID() != null) {
            return PreparedQueryUtil.newIVInstance(dataEngine, queryDefn);
        }
        IBaseDataSetDesign dset = dataEngine.getDataSetDesign(queryDefn.getDataSetName());
        if (dset == null && queryDefn.getQueryResultsID() == null) {
            return new PreparedDummyQuery(dataEngine.getContext(), queryDefn, dataEngine.getSession().getSharedScope());
        }
        if (dset instanceof IScriptDataSetDesign) {
            preparedQuery = new PreparedScriptDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IOdaDataSetDesign) {
            preparedQuery = new PreparedOdaDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IJointDataSetDesign) {
            preparedQuery = new PreparedJointDataSourceQuery(dataEngine, queryDefn, dset, appContext);
        } else {
            throw new DataException("data.engine.UnsupportedDataSetType", dset.getName());
        }
        return var4_4;
    }

    private static IPreparedQuery newIVInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        if (PreparedQueryUtil.runQueryOnRS(dataEngine, queryDefn)) {
            return new PreparedIVQuery(dataEngine, queryDefn);
        }
        return new PreparedIVDataSourceQuery(dataEngine, queryDefn);
    }

    private static boolean runQueryOnRS(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        if (!queryDefn.usesDetails()) {
            queryDefn.getSorts().clear();
        }
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getContext(), queryResultInfo);
        boolean runningOnRS = GroupDefnUtil.isEqualGroups(queryDefn.getGroups(), rdLoad.loadGroupDefn(0, 0));
        if (!runningOnRS) {
            return false;
        }
        boolean bl = runningOnRS = !PreparedQueryUtil.hasTopBottomNInFilter(queryDefn.getFilters());
        if (!runningOnRS) {
            return false;
        }
        runningOnRS = PreparedQueryUtil.isCompatibleRSMap(rdLoad.loadQueryDefn(0, 0).getResultSetExpressions(), queryDefn.getResultSetExpressions());
        if (!runningOnRS) {
            return false;
        }
        runningOnRS = PreparedQueryUtil.isCompatibleSubQuery(rdLoad.loadQueryDefn(0, 0), queryDefn);
        if (!runningOnRS) {
            return false;
        }
        IBaseQueryDefinition qd = rdLoad.loadQueryDefn(0, 0);
        List filters = qd.getFilters();
        if (FilterDefnUtil.isConflictFilter(filters, queryDefn.getFilters())) {
            runningOnRS = false;
            FilterDefnUtil.getRealFilterList(rdLoad.loadOriginalQueryDefn(0, 0).getFilters(), queryDefn.getFilters());
        }
        if (!runningOnRS) {
            return false;
        }
        if (PreparedQueryUtil.hasSubquery(queryDefn)) {
            if (!QueryDefnUtil.isEqualSorts(queryDefn.getSorts(), qd.getSorts())) {
                runningOnRS = false;
            }
            Collection subqueries = queryDefn.getSubqueries();
            List gps = queryDefn.getGroups();
            if (gps != null && gps.size() > 0) {
                for (int i = 0; i < gps.size(); ++i) {
                    subqueries.addAll(((IGroupDefinition)gps.get(i)).getSubqueries());
                }
            }
            Iterator it = subqueries.iterator();
            while (it.hasNext()) {
                IBaseQueryDefinition query = (IBaseQueryDefinition)it.next();
                if (!query.usesDetails()) {
                    query.getSorts().clear();
                }
                if (query.getFilters() != null && query.getFilters().size() > 0) {
                    runningOnRS = false;
                    break;
                }
                List groups = query.getGroups();
                for (int i = 0; i < groups.size(); ++i) {
                    List groupFilters = ((IGroupDefinition)groups.get(i)).getFilters();
                    if (groupFilters == null || groupFilters.size() <= 0) continue;
                    runningOnRS = false;
                    break;
                }
                if (runningOnRS) continue;
                break;
            }
        }
        if (!runningOnRS) {
            return false;
        }
        if (queryDefn.getFilters() != null && queryDefn.getFilters().size() > 0 && !PreparedQueryUtil.isFiltersEquals(filters, queryDefn.getFilters())) {
            runningOnRS = queryDefn.getResultSetExpressions().values() == null || !PreparedQueryUtil.hasAggregationOnRowObjects(queryDefn.getResultSetExpressions().values().iterator());
        }
        return runningOnRS;
    }

    private static boolean isFiltersEquals(List oldFilter, List newFilter) {
        if (oldFilter.size() != newFilter.size()) {
            return false;
        }
        for (int i = 0; i < oldFilter.size(); ++i) {
            if (FilterDefnUtil.isEqualFilter((IFilterDefinition)oldFilter.get(i), (IFilterDefinition)newFilter.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasTopBottomNInFilter(List filters) {
        if (filters == null || filters.size() == 0) {
            return false;
        }
        for (int i = 0; i < filters.size(); ++i) {
            int type;
            IBaseExpression o = ((IFilterDefinition)filters.get(i)).getExpression();
            if (!(o instanceof IConditionalExpression) || (type = ((IConditionalExpression)o).getOperator()) != 14 && type != 15 && type != 16 && type != 17) continue;
            return true;
        }
        return false;
    }

    private static boolean isCompatibleRSMap(Map oldMap, Map newMap) {
        if (oldMap == null) {
            return newMap.size() == 0;
        }
        if (newMap == null) {
            return oldMap.size() == 0;
        }
        if (newMap.size() > oldMap.size()) {
            return false;
        }
        Iterator it = newMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object oldObj = oldMap.get(key);
            Object newObj = newMap.get(key);
            if (oldObj != null) {
                if (PreparedQueryUtil.isTwoExpressionEqual((IBaseExpression)newObj, (IBaseExpression)oldObj)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isTwoExpressionEqual(IBaseExpression obj1, IBaseExpression obj2) {
        if (obj1 == null || obj2 != null) {
            return false;
        }
        if (obj1 != null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1 instanceof IScriptExpression) {
            return PreparedQueryUtil.isTwoExpressionEqual((IScriptExpression)obj1, (IScriptExpression)obj2);
        }
        if (obj1 instanceof IConditionalExpression) {
            return PreparedQueryUtil.isTwoExpressionEqual((IConditionalExpression)obj1, (IConditionalExpression)obj2);
        }
        return false;
    }

    private static boolean isTwoExpressionEqual(IScriptExpression obj1, IScriptExpression obj2) {
        return PreparedQueryUtil.isTwoStringEqual(obj1.getText(), obj2.getText()) && PreparedQueryUtil.isTwoStringEqual(obj1.getGroupName(), obj2.getGroupName()) && PreparedQueryUtil.isTwoStringEqual(obj1.getText(), obj2.getText()) && obj1.getDataType() == obj2.getDataType();
    }

    private static boolean isTwoExpressionEqual(IConditionalExpression obj1, IConditionalExpression obj2) {
        if (obj1.getOperator() != obj2.getOperator()) {
            return false;
        }
        return PreparedQueryUtil.isTwoStringEqual(obj1.getGroupName(), obj2.getGroupName()) && PreparedQueryUtil.isTwoExpressionEqual(obj1.getExpression(), obj2.getExpression()) && PreparedQueryUtil.isTwoExpressionEqual(obj1.getOperand1(), obj2.getOperand1()) && PreparedQueryUtil.isTwoExpressionEqual(obj1.getOperand2(), obj2.getOperand2());
    }

    private static boolean isTwoStringEqual(String s1, String s2) {
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static boolean isCompatibleSubQuery(IBaseQueryDefinition oldDefn, IBaseQueryDefinition newDefn) {
        boolean isComp = QueryDefnUtil.isCompatibleSQs(oldDefn.getSubqueries(), newDefn.getSubqueries());
        if (!isComp) {
            return false;
        }
        Iterator oldIt = oldDefn.getGroups().iterator();
        Iterator newIt = newDefn.getGroups().iterator();
        while (newIt.hasNext()) {
            IGroupDefinition oldGroupDefn = (IGroupDefinition)oldIt.next();
            IGroupDefinition newGroupDefn = (IGroupDefinition)newIt.next();
            isComp = QueryDefnUtil.isCompatibleSQs(oldGroupDefn.getSubqueries(), newGroupDefn.getSubqueries());
            if (isComp) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAggregationOnRowObjects(Iterator it) {
        while (it.hasNext()) {
            Object o = it.next();
            if (!ExpressionCompilerUtil.hasAggregationInExpr((IBaseExpression)o)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSubquery(IQueryDefinition qd) {
        if (!$assertionsDisabled && qd == null) {
            throw new AssertionError();
        }
        if (qd.getSubqueries() != null && qd.getSubqueries().size() > 0) {
            return true;
        }
        if (qd.getGroups() != null) {
            for (int i = 0; i < qd.getGroups().size(); ++i) {
                IGroupDefinition gd = (IGroupDefinition)qd.getGroups().get(i);
                if (gd.getSubqueries() == null || gd.getSubqueries().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    static {
        $assertionsDisabled = !PreparedQueryUtil.class.desiredAssertionStatus();
    }
}

