/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDSaveUtil;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.StreamManager;
import org.eclipse.birt.data.engine.impl.document.VersionManager;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class RDSave
implements IRDSave {
    private DataEngineContext context;
    private OutputStream rowExprsOs;
    private OutputStream rowLenOs;
    private int rowCount;
    private IBaseQueryDefinition queryDefn;
    private Set exprNameSet;
    private RowSaveUtil rowSaveUtil;
    private StreamManager streamManager;
    private RDSaveUtil rdSaveUtil;

    RDSave(DataEngineContext context, IBaseQueryDefinition queryDefn, int rowCount, QueryResultInfo queryResultInfo) throws DataException {
        this.context = context;
        this.rowCount = rowCount;
        this.queryDefn = queryDefn;
        this.streamManager = new StreamManager(context, queryResultInfo);
        this.rdSaveUtil = new RDSaveUtil(this.context.getMode(), queryDefn, this.streamManager);
    }

    public void saveExprValue(int currIndex, Map valueMap) throws DataException {
        if (this.rowSaveUtil == null) {
            this.initSaveRowUtil();
        }
        this.rowSaveUtil.saveExprValue(currIndex, valueMap);
    }

    private void initSaveRowUtil() throws DataException {
        this.rowExprsOs = this.streamManager.getOutStream(31, 0, 2);
        this.rowLenOs = this.streamManager.getOutStream(33, 0, 2);
        this.rowSaveUtil = new RowSaveUtil(this.rowCount, this.rowExprsOs, this.rowLenOs, this.getExprNameSet());
    }

    public void saveFinish(int currIndex) throws DataException {
        if (this.rowSaveUtil == null) {
            this.initSaveRowUtil();
        }
        this.exprNameSet = this.rowSaveUtil.getExprNameSet();
        this.rowSaveUtil.saveFinish(currIndex);
        this.closeSaveRowUtil();
        this.saveForIV();
    }

    private void closeSaveRowUtil() throws DataException {
        try {
            this.rowExprsOs.close();
            this.rowLenOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private void saveForIV() throws DataException {
        if (this.exprNameSet.size() == 0) {
            this.exprNameSet = this.getExprNameSet();
        }
        this.rdSaveUtil.saveExprMetadata(this.exprNameSet);
    }

    public void saveResultIterator(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
        VersionManager.setVersion(this.context, 1);
        this.rdSaveUtil.saveResultIterator(odiResult, groupLevel, subQueryInfo);
    }

    private Set getExprNameSet() {
        HashSet set = new HashSet();
        Iterator it = this.queryDefn.getResultSetExpressions().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            set.add(entry.getKey());
        }
        return set;
    }

    public void saveStart() throws DataException {
        if (!this.streamManager.isSubquery()) {
            this.rdSaveUtil.saveQueryDefn();
        }
    }
}

