/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaData {
    private IResultSetMetaData m_metadata;
    private String m_driverName;
    private String m_dataSetType;
    private static final String sm_className = ResultSetMetaData.class.getName();
    private static final String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");

    ResultSetMetaData(IResultSetMetaData metadata, String driverName, String dataSetType) {
        String methodName = "ResultSetMetaData";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, "ResultSetMetaData", new Object[]{metadata, driverName, dataSetType});
        }
        this.m_metadata = metadata;
        this.m_driverName = driverName;
        this.m_dataSetType = dataSetType;
        sm_logger.exiting(sm_className, "ResultSetMetaData", this);
    }

    public int getColumnCount() throws DataException {
        String methodName = "getColumnCount";
        try {
            if (this.m_metadata == null) {
                return 0;
            }
            return this.m_metadata.getColumnCount();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getColumnCount", "Cannot get column count.", ex);
            throw new DataException("odaconsumer.CannotGetColumnCount", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getColumnCount", "Cannot get column count.", ex);
            throw new DataException("odaconsumer.CannotGetColumnCount", ex);
        }
    }

    public String getColumnName(int index) throws DataException {
        String methodName = "getColumnName";
        this.verifyHasRuntimeMetaData();
        try {
            return this.m_metadata.getColumnName(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getColumnName", "Cannot get column name.", ex);
            throw new DataException("odaconsumer.CannotGetColumnName", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "getColumnName", "Cannot get column name.", ex);
            return "";
        }
    }

    public String getColumnLabel(int index) throws DataException {
        String methodName = "getColumnLabel";
        this.verifyHasRuntimeMetaData();
        try {
            return this.m_metadata.getColumnLabel(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getColumnLabel", "Cannot get column label.", ex);
            throw new DataException("odaconsumer.CannotGetColumnLabel", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, "getColumnLabel", "Cannot get column label.", ex);
            return "";
        }
    }

    public int getColumnType(int index) throws DataException {
        int odaType;
        String methodName = "getColumnType";
        int nativeType = this.doGetNativeColumnType(index);
        int n = odaType = nativeType == 0 ? 0 : DataTypeUtil.toOdaType(nativeType, this.m_driverName, this.m_dataSetType);
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "getColumnType", "Column at index {0} has ODA data type {1}.", new Object[]{new Integer(index), new Integer(odaType)});
        }
        return odaType;
    }

    public String getColumnNativeTypeName(int index) throws DataException {
        String methodName = "getColumnNativeTypeName";
        this.verifyHasRuntimeMetaData();
        try {
            return this.m_metadata.getColumnTypeName(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getColumnNativeTypeName", "Cannot get column native type name.", ex);
            throw new DataException("odaconsumer.CannotGetColumnNativeDataTypeName", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, "getColumnNativeTypeName", "Cannot get column native type name.", ex);
            return "";
        }
    }

    private int doGetNativeColumnType(int index) throws DataException {
        String methodName = "doGetNativeColumnType";
        this.verifyHasRuntimeMetaData();
        try {
            return this.m_metadata.getColumnType(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "doGetNativeColumnType", "Cannot get column native type code.", ex);
            throw new DataException("odaconsumer.CannotGetColumnType", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "doGetNativeColumnType", "Cannot get column native type code.", ex);
            throw new DataException("odaconsumer.CannotGetColumnType", (Throwable)ex, new Object[]{new Integer(index)});
        }
    }

    Class getColumnTypeAsJavaClass(int index) throws DataException {
        int odaType = this.getColumnType(index);
        return DataTypeUtil.toTypeClass(odaType);
    }

    private void verifyHasRuntimeMetaData() throws DataException {
        if (this.m_metadata == null) {
            throw new DataException("odaconsumer.CannotGetResultSetMetaData");
        }
    }

    String getOdaDataSourceId() {
        return this.m_driverName;
    }

    String getDataSetType() {
        return this.m_dataSetType;
    }
}

