/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Database;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.ICallback;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.DestinationFactory;
import org.eclipse.aperi.sanmgmt.event.SANEventMessageHandler;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.event.data.SANEventExceptionHandler;
import org.eclipse.aperi.sanmgmt.event.data.SANEventUtil;
import org.eclipse.aperi.sanmgmt.event.data.SnmpAddress;
import org.eclipse.aperi.sanmgmt.event.interfaces.ISANEventServiceR2;
import org.eclipse.aperi.sanmgmt.event.interfaces.ISANSnmpControlR2;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryCreationFailedException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryInvalidException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.UnknownFactoryTypeException;

public class SANEventService
implements ISANEventServiceR2,
ISANSnmpControlR2,
IService,
Serializable,
ICallback,
MessageListener,
ICliDispatcher {
    private static final long serialVersionUID = 20001130L;
    static final String TRACE_NAME = "aperi.logger.trace.event";
    static final String TRACE_FACTORY_NAME = "aperi.logger.trace.eventFactory";
    static final String MESSAGE_NAME = "aperi.logger.message.event";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventService";
    static final String TEXT_BUNDLENAME = "org.eclipse.aperi.sanmgmt.event.resources.SANEventText";
    private ResourceBundle rb = null;
    protected transient ILogger msgLogger = null;
    protected transient ILogger traceLogger = null;
    protected transient ILogger traceFactoryLogger = null;
    static final String className;
    private static IConfigService dbParms;
    private static Factory factory;
    private static Message template;
    static String subscriberName;
    static TopicSubscriber subscriber;
    static TopicPublisher publisher;
    static SANEventMessageHandler messagePrinter;
    static SANEventExceptionHandler exceptionPrinter;
    private DestinationFactory destFactory = null;
    private static final String NEW_LINE = "\n";
    public static final String COMMA = ",";
    boolean aliveStatus = true;
    private Status status = new Status(5, 9);
    private String description = "Generic service for publishing SNMP traps and TEC events.";
    private static ArrayList entityTypes;
    private static ArrayList eventCategories;
    private static ArrayList eventSeverities;
    private static ArrayList eventTypes;
    private static ArrayList eventActions;
    static final String EVENT_SEVERITY = "EVENT_SEVERITY";
    static final String ENTITY_TYPE = "ENTITY_TYPE";
    static final String UNIQUE_ID = "UNIQUE_ID";
    static final String EVENT_TYPE = "EVENT_TYPE";
    static final String EVENT_CATEGORY = "EVENT_CATEGORY";
    static final String RULE_ID = "RULE_ID";
    static final String EVENT_ACTION = "EVENT_ACTION";
    static final String EVENT_SEVERITY_SHORT = "SEV";
    static final String ENTITY_TYPE_SHORT = "ENT";
    static final String UNIQUE_ID_SHORT = "UID";
    static final String EVENT_TYPE_SHORT = "EVENT_TYPE";
    static final String EVENT_CATEGORY_SHORT = "CAT";
    static final String RULE_ID_SHORT = "RULE";
    static final String EVENT_ACTION_SHORT = "ACT";
    static final String UNSPECIFIED = "unspecified";
    private static HashMap defaultRule1;
    private static HashMap defaultRule2;
    private static HashMap defaultRule3;
    private static HashMap defaultRule4;
    private static HashMap defaultRule5;
    private static HashMap defaultRule6;
    private static HashMap defaultRule7;
    private static HashMap defaultRule8;
    private static HashMap defaultRule9;
    private static HashMap defaultRule10;
    private static HashMap defaultRule11;
    private static HashMap defaultRule12;
    private static HashMap defaultRule13;
    private static HashMap defaultRule14;
    private static HashMap defaultRule15;
    private static HashMap defaultRule16;
    private static HashMap defaultRule17;
    private static HashMap defaultRule18;
    private static HashMap defaultRule19;
    private static HashMap defaultRule20;
    private static HashMap[] defaultFilterRules;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.SANEventService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        dbParms = null;
        factory = null;
        template = null;
        subscriberName = null;
        publisher = null;
        messagePrinter = null;
        exceptionPrinter = null;
        entityTypes = null;
        eventCategories = null;
        eventSeverities = null;
        eventTypes = null;
        eventActions = null;
        defaultRule1 = new HashMap();
        defaultRule1.put(EVENT_ACTION, "suppress");
        defaultRule1.put("EVENT_TYPE", "tec");
        defaultRule1.put(RULE_ID, "1");
        defaultRule1.put(ENTITY_TYPE, "HBA2Node");
        defaultRule2 = new HashMap();
        defaultRule2.put(EVENT_ACTION, "suppress");
        defaultRule2.put("EVENT_TYPE", "trap");
        defaultRule2.put(RULE_ID, "2");
        defaultRule2.put(ENTITY_TYPE, "HBA2Node");
        defaultRule3 = new HashMap();
        defaultRule3.put(EVENT_ACTION, "suppress");
        defaultRule3.put("EVENT_TYPE", "tec");
        defaultRule3.put(RULE_ID, "3");
        defaultRule3.put(ENTITY_TYPE, "PE2Node");
        defaultRule4 = new HashMap();
        defaultRule4.put(EVENT_ACTION, "suppress");
        defaultRule4.put("EVENT_TYPE", "trap");
        defaultRule4.put(RULE_ID, "4");
        defaultRule4.put(ENTITY_TYPE, "PE2Node");
        defaultRule5 = new HashMap();
        defaultRule5.put(EVENT_ACTION, "suppress");
        defaultRule5.put("EVENT_TYPE", "tec");
        defaultRule5.put(RULE_ID, "5");
        defaultRule5.put(ENTITY_TYPE, "PV2LUN");
        defaultRule6 = new HashMap();
        defaultRule6.put(EVENT_ACTION, "suppress");
        defaultRule6.put("EVENT_TYPE", "trap");
        defaultRule6.put(RULE_ID, "6");
        defaultRule6.put(ENTITY_TYPE, "PV2LUN");
        defaultRule7 = new HashMap();
        defaultRule7.put(EVENT_ACTION, "suppress");
        defaultRule7.put("EVENT_TYPE", "tec");
        defaultRule7.put(RULE_ID, "7");
        defaultRule7.put(EVENT_SEVERITY, "minor");
        defaultRule8 = new HashMap();
        defaultRule8.put(EVENT_ACTION, "suppress");
        defaultRule8.put("EVENT_TYPE", "trap");
        defaultRule8.put(RULE_ID, "8");
        defaultRule8.put(EVENT_SEVERITY, "minor");
        defaultRule9 = new HashMap();
        defaultRule9.put(EVENT_ACTION, "suppress");
        defaultRule9.put("EVENT_TYPE", "tec");
        defaultRule9.put(RULE_ID, "9");
        defaultRule9.put(ENTITY_TYPE, "OS2FS");
        defaultRule10 = new HashMap();
        defaultRule10.put(EVENT_ACTION, "suppress");
        defaultRule10.put("EVENT_TYPE", "trap");
        defaultRule10.put(RULE_ID, "10");
        defaultRule10.put(ENTITY_TYPE, "OS2FS");
        defaultRule11 = new HashMap();
        defaultRule11.put(EVENT_ACTION, "suppress");
        defaultRule11.put("EVENT_TYPE", "tec");
        defaultRule11.put(RULE_ID, "11");
        defaultRule11.put(ENTITY_TYPE, "OS2LV");
        defaultRule12 = new HashMap();
        defaultRule12.put(EVENT_ACTION, "suppress");
        defaultRule12.put("EVENT_TYPE", "trap");
        defaultRule12.put(RULE_ID, "12");
        defaultRule12.put(ENTITY_TYPE, "OS2LV");
        defaultRule13 = new HashMap();
        defaultRule13.put(EVENT_ACTION, "suppress");
        defaultRule13.put("EVENT_TYPE", "tec");
        defaultRule13.put(RULE_ID, "13");
        defaultRule13.put(ENTITY_TYPE, "OS2PV");
        defaultRule14 = new HashMap();
        defaultRule14.put(EVENT_ACTION, "suppress");
        defaultRule14.put("EVENT_TYPE", "trap");
        defaultRule14.put(RULE_ID, "14");
        defaultRule14.put(ENTITY_TYPE, "OS2PV");
        defaultRule15 = new HashMap();
        defaultRule15.put(EVENT_ACTION, "suppress");
        defaultRule15.put("EVENT_TYPE", "tec");
        defaultRule15.put(RULE_ID, "15");
        defaultRule15.put(ENTITY_TYPE, "OS2VG");
        defaultRule16 = new HashMap();
        defaultRule16.put(EVENT_ACTION, "suppress");
        defaultRule16.put("EVENT_TYPE", "trap");
        defaultRule16.put(RULE_ID, "16");
        defaultRule16.put(ENTITY_TYPE, "OS2VG");
        defaultRule17 = new HashMap();
        defaultRule17.put(EVENT_ACTION, "suppress");
        defaultRule17.put("EVENT_TYPE", "tec");
        defaultRule17.put(RULE_ID, "17");
        defaultRule17.put(ENTITY_TYPE, "Port");
        defaultRule18 = new HashMap();
        defaultRule18.put(EVENT_ACTION, "suppress");
        defaultRule18.put("EVENT_TYPE", "trap");
        defaultRule18.put(RULE_ID, "18");
        defaultRule18.put(ENTITY_TYPE, "Port");
        defaultRule19 = new HashMap();
        defaultRule19.put(EVENT_ACTION, "suppress");
        defaultRule19.put("EVENT_TYPE", "tec");
        defaultRule19.put(RULE_ID, "19");
        defaultRule19.put(ENTITY_TYPE, "Node");
        defaultRule20 = new HashMap();
        defaultRule20.put(EVENT_ACTION, "suppress");
        defaultRule20.put("EVENT_TYPE", "trap");
        defaultRule20.put(RULE_ID, "20");
        defaultRule20.put(ENTITY_TYPE, "Node");
        defaultFilterRules = new HashMap[]{defaultRule1, defaultRule2, defaultRule3, defaultRule4, defaultRule5, defaultRule6, defaultRule7, defaultRule8, defaultRule9, defaultRule10, defaultRule11, defaultRule12, defaultRule13, defaultRule14, defaultRule15, defaultRule16, defaultRule17, defaultRule18, defaultRule19, defaultRule20};
    }

    public static void initStaticVars() {
        dbParms = null;
        factory = null;
        template = null;
        subscriberName = null;
        subscriber = null;
        publisher = null;
        messagePrinter = null;
        exceptionPrinter = null;
        entityTypes = null;
        eventCategories = null;
        eventSeverities = null;
        eventTypes = null;
        eventActions = null;
    }

    public SANEventService() throws IOException, JMSException {
        this.traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "SANEventService");
        }
        this.msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (this.msgLogger != null) {
            this.msgLogger.setMessageFile(BUNDLENAME);
        }
        this.traceFactoryLogger = LogManagerFactory.getTraceLogger((String)TRACE_FACTORY_NAME);
        dbParms = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        this.destFactory = new DestinationFactory(this.msgLogger, this.traceLogger, dbParms);
        messagePrinter = new SANEventMessageHandler(this.destFactory);
        exceptionPrinter = new SANEventExceptionHandler();
        Locale locale = Locale.getDefault();
        this.rb = ResourceBundle.getBundle(TEXT_BUNDLENAME, locale);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "SANEventService");
        }
    }

    public boolean isAlive() {
        return this.aliveStatus;
    }

    public boolean deleteSnmpAddr(SnmpAddress snmpAddress) {
        return this.destFactory.deleteSnmpAddr(snmpAddress);
    }

    public void forwardEvent(SANEvent sANEvent, String string) throws JMSException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("PublisherID", string);
        this.forwardEvent(sANEvent, hashtable);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void forwardEvent(SANEvent sANEvent, Hashtable hashtable) throws JMSException {
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "forwardEvent", (Object)sANEvent);
        }
        try {
            try {
                if (factory == null) {
                    factory = FactoryFactory.createFactory((int)2, null);
                }
                if (template == null) {
                    template = factory.createMessage(null);
                }
                template.clearProperties();
                String string = null;
                String string2 = null;
                Enumeration enumeration = hashtable.keys();
                while (true) {
                    block17: {
                        if (enumeration.hasMoreElements()) break block17;
                        publisher = factory.createPublisher(sANEvent.getClass().getName(), template);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "forwardEvent", "Publisher = " + publisher);
                        }
                        ObjectMessage objectMessage = factory.createMessage((Serializable)sANEvent);
                        objectMessage.setJMSPriority(2);
                        publisher.publish((Message)objectMessage);
                        break;
                    }
                    string = (String)enumeration.nextElement();
                    string2 = (String)hashtable.get(string);
                    template.setStringProperty(string, string2);
                }
            }
            catch (JMSException jMSException) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "forwardEvent", "SANEventException_JMSException", (Object)jMSException);
                }
                if (this.traceLogger == null) throw jMSException;
                if (!this.traceLogger.isLogging()) throw jMSException;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "forwardEvent", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (publisher == null) throw throwable;
                publisher.close();
                throw throwable;
            }
            catch (JMSException jMSException) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "forwardEvent", "SANEventException_JMSException", (Object)jMSException);
                }
                if (this.traceLogger == null) throw jMSException;
                if (!this.traceLogger.isLogging()) throw jMSException;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "forwardEvent", (Throwable)jMSException);
                throw jMSException;
            }
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (JMSException jMSException) {
            if (this.msgLogger != null) {
                this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "forwardEvent", "SANEventException_JMSException", (Object)jMSException);
            }
            if (this.traceLogger == null) throw jMSException;
            if (!this.traceLogger.isLogging()) throw jMSException;
            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "forwardEvent", (Throwable)jMSException);
            throw jMSException;
        }
        if (publisher != null) {
            publisher.close();
        }
        if (this.traceLogger == null) return;
        if (!this.traceLogger.isLogging()) return;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "forwardEvent");
    }

    public ArrayList getAllSnmpAddr() {
        return this.destFactory.getAllSnmpAddr();
    }

    public boolean setSnmpAddr(SnmpAddress snmpAddress) {
        return this.destFactory.setSnmpAddr(snmpAddress);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return "SANEvent";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("MessagingService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("MessagingService_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shutdown() {
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "shutdown");
        }
        this.status.setRunStatus(11);
        this.destFactory.close();
        messagePrinter.close();
        try {
            try {
                subscriber.close();
                factory.close();
            }
            catch (Exception exception) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)exception);
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.status.setRunStatus(10);
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "shutdown");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.status.setRunStatus(10);
        if (this.traceLogger == null) return true;
        if (!this.traceLogger.isLogging()) return true;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "shutdown");
        return true;
    }

    public boolean startup() {
        block32: {
            block31: {
                block30: {
                    block29: {
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "startup");
                        }
                        this.status.setRunStatus(9);
                        this.destFactory.init();
                        try {
                            int n = dbParms.setProperty("SANDomainID", "user", SANEventUtil.getUniqueQualifier());
                            if (n != 0) {
                                if (this.msgLogger != null) {
                                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "startup", "SANEventMessage_DomainIDNotSaved", (Object)"user.properties");
                                }
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_WARN, (Object)className, "startup", "Unable to save the DomainID (SANDomainID) to the properties file: RC = " + n);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (this.msgLogger != null) {
                                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)exception);
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block29;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)exception);
                        }
                    }
                    if (factory == null) {
                        try {
                            factory = FactoryFactory.createFactory((int)2, null);
                        }
                        catch (FactoryCreationFailedException factoryCreationFailedException) {
                            if (this.msgLogger != null) {
                                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)factoryCreationFailedException);
                            }
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)factoryCreationFailedException);
                            }
                        }
                        catch (UnknownFactoryTypeException unknownFactoryTypeException) {
                            if (this.msgLogger != null) {
                                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)unknownFactoryTypeException);
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block30;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)unknownFactoryTypeException);
                        }
                    }
                }
                if (this.traceFactoryLogger != null && this.traceFactoryLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "startup", "Created Factory");
                }
                try {
                    factory.setExceptionListener((ExceptionListener)exceptionPrinter);
                }
                catch (FactoryInvalidException factoryInvalidException) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)factoryInvalidException);
                    }
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)factoryInvalidException);
                    }
                }
                catch (JMSException jMSException) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)jMSException);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block31;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)jMSException);
                }
            }
            subscriberName = SANEventUtil.getUniqueSubscriberId((String)className);
            SANEvent sANEvent = new SANEvent();
            try {
                subscriber = factory.createSubscriber(sANEvent.getClass().getName(), null, null, (MessageListener)this);
            }
            catch (FactoryInvalidException factoryInvalidException) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)factoryInvalidException);
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)factoryInvalidException);
                }
            }
            catch (JMSException jMSException) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)jMSException);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block32;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "startup", (Throwable)jMSException);
            }
        }
        this.status.setRunStatus(8);
        if (this.msgLogger != null) {
            this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "startup", "SANEventService_ready");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "startup");
        }
        return true;
    }

    private Factory getFactory() {
        return factory;
    }

    public void propCallback(String string, String string2, String string3) {
        this.destFactory.propCallback(string, string2, string3);
    }

    public void onMessage(Message message) {
        String string = "onMessage";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        if (messagePrinter != null) {
            messagePrinter.onMessage(message);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public String dispatch(String string, String[] stringArray) {
        String string2 = "dispatch";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string2);
        }
        String string3 = "";
        string3 = (string = string.toLowerCase()).equals("insertfilterrule") ? this.insertFilterRule(stringArray) : (string.equals("updatefilterrule") ? this.updateFilterRule(stringArray) : (string.equals("listfilterrules") ? this.listFilterRules(stringArray) : (string.equals("changefilterrulepriority") ? this.changeFilterRulePriority(stringArray) : (string.equals("setdefaultfilterrules") ? this.setDefaultFilterRules(stringArray) : (string.equals("deletefilterrule") ? this.deleteFilterRule(stringArray) : (string.equals("help") ? this.help(stringArray) : this.rb.getString("invalidCmd")))))));
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string);
        }
        if (string3.equals("invalid")) {
            return this.rb.getString("invalidCmd");
        }
        return string3;
    }

    private String insertFilterRule(String[] stringArray) {
        String string = "insertFilterRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string);
        }
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        String string5 = new String();
        HashMap hashMap = new HashMap(12);
        boolean bl = true;
        Database database = new Database("", "", "");
        DBConnection dBConnection = null;
        try {
            dBConnection = database.getConnection();
        }
        catch (SQLException sQLException) {
            string2 = "invalid";
            return string2;
        }
        int n = 0;
        while (n < stringArray.length) {
            string4 = (string3 = stringArray[n++].toUpperCase()).equals(UNIQUE_ID) ? stringArray[n++] : stringArray[n++].toLowerCase();
            if (string3.equalsIgnoreCase(RULE_ID) || string3.equalsIgnoreCase(RULE_ID_SHORT)) {
                string5 = string4;
            }
            if (bl = this.addCriteria(hashMap, string3, string4)) continue;
            string2 = "invalid";
            string2 = "invalid";
            return "invalid";
        }
        if (bl) {
            bl = this.isCommandValid(dBConnection, hashMap);
            if (!bl) {
                string2 = "invalid";
                return "invalid";
            }
            this.initializeValues(hashMap);
            try {
                if (this.isRuleInUse(string5, dBConnection)) {
                    this.incrementRuleIds(string5, dBConnection);
                }
                this.saveRule(hashMap, dBConnection);
                dBConnection.commit();
            }
            catch (SQLException sQLException) {
                if (this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
                }
                try {
                    dBConnection.commit();
                }
                catch (SQLException sQLException2) {}
                string2 = "invalid";
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string);
        }
        return string2;
    }

    private String updateFilterRule(String[] stringArray) {
        String string;
        String string2;
        block16: {
            string2 = "updateFilterRule";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string2);
            }
            string = new String();
            String string3 = new String();
            String string4 = new String();
            String string5 = new String();
            HashMap hashMap = new HashMap();
            boolean bl = true;
            Database database = new Database("", "", "");
            DBConnection dBConnection = null;
            try {
                dBConnection = database.getConnection();
            }
            catch (SQLException sQLException) {
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                    }
                    catch (SQLException sQLException2) {}
                }
                string = "invalid";
                return string;
            }
            int n = 0;
            while (n < stringArray.length) {
                string4 = (string3 = stringArray[n++].toUpperCase()).equals(UNIQUE_ID) ? stringArray[n++] : stringArray[n++].toLowerCase();
                if (string3.equalsIgnoreCase(RULE_ID) || string3.equalsIgnoreCase(RULE_ID_SHORT)) {
                    string5 = string4;
                }
                if (bl = this.addCriteria(hashMap, string3, string4)) continue;
                string = "invalid";
                string = "invalid";
                return "invalid";
            }
            if (bl) {
                bl = this.isCommandValid(dBConnection, hashMap);
                if (!bl) {
                    string = "invalid";
                    return "invalid";
                }
                this.initializeValues(hashMap);
                try {
                    if (this.isRuleInUse(string5, dBConnection)) {
                        this.updateRule(hashMap, dBConnection);
                        dBConnection.commit();
                        break block16;
                    }
                    dBConnection.commit();
                    string = "invalid";
                    return "invalid";
                }
                catch (SQLException sQLException) {
                    try {
                        dBConnection.commit();
                    }
                    catch (SQLException sQLException3) {}
                    string = "invalid";
                    return "invalid";
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string2);
        }
        return string;
    }

    private String changeFilterRulePriority(String[] stringArray) {
        String string = "changeFilterRulePriority";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string);
        }
        String string2 = new String("");
        if (stringArray.length != 2) {
            string2 = "invalid";
            return "invalid";
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string3.equals(string4)) {
            return string2;
        }
        Database database = new Database("", "", "");
        DBConnection dBConnection = null;
        try {
            dBConnection = database.getConnection();
            boolean bl = this.isRuleInUse(string3, dBConnection);
            if (bl) {
                if (this.isRuleInUse(string4, dBConnection)) {
                    int n;
                    int n2 = Integer.parseInt(string4);
                    if (n2 < (n = Integer.parseInt(string3))) {
                        string3 = Integer.toString(++n);
                    }
                    this.incrementRuleIds(string4, dBConnection);
                }
            } else {
                dBConnection.commit();
                string2 = "invalid";
                return "invalid";
            }
            this.updateRuleId(string3, string4, dBConnection);
            dBConnection.commit();
        }
        catch (SQLException sQLException) {
            try {
                dBConnection.commit();
            }
            catch (SQLException sQLException2) {}
            string2 = "invalid";
            return "invalid";
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string);
        }
        return string2;
    }

    private String deleteFilterRule(String[] stringArray) {
        String string;
        String string2;
        block8: {
            string2 = "deleteFilterRule";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string2);
            }
            string = new String("");
            String string3 = stringArray[0].toLowerCase();
            Database database = new Database("", "", "");
            DBConnection dBConnection = null;
            try {
                dBConnection = database.getConnection();
                if (this.isRuleInUse(string3, dBConnection)) {
                    this.deleteRule(string3, dBConnection);
                    dBConnection.commit();
                } else {
                    dBConnection.commit();
                    string = "invalid";
                }
            }
            catch (SQLException sQLException) {
                if (dBConnection == null) break block8;
                try {
                    dBConnection.commit();
                }
                catch (SQLException sQLException2) {}
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string2);
        }
        return string;
    }

    private String setDefaultFilterRules(String[] stringArray) {
        String string;
        block7: {
            string = "setDefaultFilterRules";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string);
            }
            Database database = new Database("", "", "");
            DBConnection dBConnection = null;
            try {
                dBConnection = database.getConnection();
                this.deleteAllFilterRules(dBConnection);
                int n = 0;
                while (n < defaultFilterRules.length) {
                    this.initializeValues(defaultFilterRules[n]);
                    this.saveRule(defaultFilterRules[n], dBConnection);
                    ++n;
                }
                dBConnection.commit();
            }
            catch (SQLException sQLException) {
                if (dBConnection == null) break block7;
                try {
                    dBConnection.commit();
                }
                catch (SQLException sQLException2) {}
            }
        }
        String string2 = new String("");
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string);
        }
        return string2;
    }

    private String listFilterRules(String[] stringArray) {
        String string;
        String string2;
        block13: {
            string2 = "listFilterRules";
            DBResultSet dBResultSet = null;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            int n = 0;
            String string8 = "";
            String string9 = "";
            string = "";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string2);
            }
            Database database = new Database("", "", "");
            DBConnection dBConnection = null;
            try {
                dBConnection = database.getConnection();
                dBResultSet = this.listRules(dBConnection);
                if (dBResultSet != null) {
                    while (dBResultSet.next()) {
                        string3 = dBResultSet.getString(EVENT_SEVERITY);
                        string4 = dBResultSet.getString(ENTITY_TYPE);
                        string5 = dBResultSet.getString(UNIQUE_ID);
                        string6 = dBResultSet.getString("EVENT_TYPE");
                        string7 = dBResultSet.getString(EVENT_CATEGORY);
                        n = dBResultSet.getInt(RULE_ID);
                        string8 = Integer.toString(n);
                        string9 = dBResultSet.getString(EVENT_ACTION);
                        string = String.valueOf(string) + NEW_LINE + "Rule_ID: " + string8;
                        if (string3 != null && !string3.equals(UNSPECIFIED)) {
                            string = String.valueOf(string) + NEW_LINE + "Event_Severity: " + string3;
                        }
                        if (string4 != null && !string4.equals(UNSPECIFIED)) {
                            string = String.valueOf(string) + NEW_LINE + "Entity_Type: " + string4;
                        }
                        if (string5 != null && !string5.equals(UNSPECIFIED)) {
                            string = String.valueOf(string) + NEW_LINE + "Unique_ID: " + string5;
                        }
                        if (string6 != null && !string6.equals(UNSPECIFIED)) {
                            string = String.valueOf(string) + NEW_LINE + "Event_Type: " + string6;
                        }
                        if (string7 != null && !string7.equals(UNSPECIFIED)) {
                            string = String.valueOf(string) + NEW_LINE + "Event_Category: " + string7;
                        }
                        if (string9 == null || string9.equals(UNSPECIFIED)) continue;
                        string = String.valueOf(string) + NEW_LINE + "Event_Action: " + string9 + NEW_LINE;
                    }
                }
                dBResultSet.close();
            }
            catch (SQLException sQLException) {
                if (dBConnection == null) break block13;
                try {
                    dBConnection.commit();
                }
                catch (SQLException sQLException2) {}
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string2);
        }
        return string;
    }

    private String help(String[] stringArray) {
        String string;
        String string2;
        block4: {
            string2 = "help";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string2);
            }
            string = new String();
            try {
                string = String.valueOf(this.rb.getString("header1")) + NEW_LINE + NEW_LINE + this.rb.getString("header2") + NEW_LINE + NEW_LINE + this.rb.getString("insert") + NEW_LINE + this.rb.getString("update") + NEW_LINE + this.rb.getString("changePri") + NEW_LINE + this.rb.getString("setDefault") + NEW_LINE + this.rb.getString("delete") + NEW_LINE + this.rb.getString("list") + NEW_LINE + this.rb.getString("help") + NEW_LINE + NEW_LINE + this.rb.getString("insertDesc") + this.rb.getString("parms") + this.rb.getString("validParms") + this.rb.getString("optParms") + NEW_LINE + NEW_LINE + this.rb.getString("updateDesc") + this.rb.getString("parms") + this.rb.getString("validParms") + this.rb.getString("optParms") + NEW_LINE + NEW_LINE + this.rb.getString("changePriDesc") + NEW_LINE + NEW_LINE + this.rb.getString("setDefaultDesc") + NEW_LINE + NEW_LINE + this.rb.getString("deleteDesc") + NEW_LINE + NEW_LINE + this.rb.getString("listDesc") + NEW_LINE + NEW_LINE + this.rb.getString("helpDesc");
            }
            catch (Exception exception) {
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "dispatch(help)", (Throwable)exception);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, className, (Object)string2);
        }
        return string;
    }

    private boolean addCriteria(HashMap hashMap, String string, String string2) {
        boolean bl = true;
        if (string.equalsIgnoreCase(EVENT_ACTION) || string.equalsIgnoreCase(RULE_ID) || string.equalsIgnoreCase(EVENT_CATEGORY) || string.equalsIgnoreCase(EVENT_SEVERITY) || string.equalsIgnoreCase(ENTITY_TYPE) || string.equalsIgnoreCase("EVENT_TYPE") || string.equalsIgnoreCase(UNIQUE_ID)) {
            bl = true;
        } else if (string.equalsIgnoreCase(EVENT_ACTION_SHORT)) {
            string = EVENT_ACTION;
        } else if (string.equalsIgnoreCase(RULE_ID_SHORT)) {
            string = RULE_ID;
        } else if (string.equalsIgnoreCase(EVENT_CATEGORY_SHORT)) {
            string = EVENT_CATEGORY;
        } else if (string.equalsIgnoreCase(EVENT_SEVERITY_SHORT)) {
            string = EVENT_SEVERITY;
        } else if (string.equalsIgnoreCase(ENTITY_TYPE_SHORT)) {
            string = ENTITY_TYPE;
        } else if (string.equalsIgnoreCase("EVENT_TYPE")) {
            string = "EVENT_TYPE";
        } else if (string.equalsIgnoreCase(UNIQUE_ID_SHORT)) {
            string = UNIQUE_ID;
        } else {
            bl = false;
        }
        if (bl) {
            hashMap.put(string, string2);
        }
        return bl;
    }

    private void initializeValues(HashMap hashMap) {
        String string = null;
        string = (String)hashMap.get(EVENT_SEVERITY);
        if (string == null) {
            string = UNSPECIFIED;
            hashMap.put(EVENT_SEVERITY, string);
        }
        if ((string = (String)hashMap.get(EVENT_CATEGORY)) == null) {
            string = UNSPECIFIED;
            hashMap.put(EVENT_CATEGORY, string);
        }
        if ((string = (String)hashMap.get("EVENT_TYPE")) == null) {
            string = UNSPECIFIED;
            hashMap.put("EVENT_TYPE", string);
        }
    }

    private boolean isCommandValid(DBConnection dBConnection, HashMap hashMap) {
        String string;
        boolean bl = true;
        if (hashMap.get(EVENT_ACTION) == null || hashMap.get(EVENT_ACTION).equals("") || hashMap.get("EVENT_TYPE") == null || hashMap.get("EVENT_TYPE").equals("") || hashMap.get(RULE_ID) == null || hashMap.get(RULE_ID).equals("")) {
            bl = false;
            return bl;
        }
        if (hashMap.get(UNIQUE_ID) != null && !hashMap.get(UNIQUE_ID).equals("") && (hashMap.get(ENTITY_TYPE) == null || hashMap.get(ENTITY_TYPE).equals(""))) {
            bl = false;
            return bl;
        }
        if (hashMap.get(ENTITY_TYPE) != null && !hashMap.get(ENTITY_TYPE).equals("")) {
            try {
                string = this.convertEntityTypeToProperCase(dBConnection, (String)hashMap.get(ENTITY_TYPE));
                hashMap.put(ENTITY_TYPE, string);
            }
            catch (Exception exception) {
                bl = false;
                return bl;
            }
        }
        if (hashMap.get(EVENT_CATEGORY) != null && !hashMap.get(EVENT_CATEGORY).equals("")) {
            try {
                string = this.convertEventCategoryToProperCase(dBConnection, (String)hashMap.get(EVENT_CATEGORY));
                hashMap.put(EVENT_CATEGORY, string);
            }
            catch (Exception exception) {
                bl = false;
                return bl;
            }
        }
        if (hashMap.get(EVENT_SEVERITY) != null && !hashMap.get(EVENT_SEVERITY).equals("")) {
            try {
                string = this.convertEventSeverityToProperCase(dBConnection, (String)hashMap.get(EVENT_SEVERITY));
                hashMap.put(EVENT_SEVERITY, string);
            }
            catch (Exception exception) {
                bl = false;
                return bl;
            }
        }
        if (hashMap.get(EVENT_ACTION) != null && !hashMap.get(EVENT_ACTION).equals("")) {
            try {
                string = this.convertEventActionToProperCase(dBConnection, (String)hashMap.get(EVENT_ACTION));
                hashMap.put(EVENT_ACTION, string);
            }
            catch (Exception exception) {
                bl = false;
                return bl;
            }
        }
        if (hashMap.get("EVENT_TYPE") != null && !hashMap.get("EVENT_TYPE").equals("")) {
            try {
                string = this.convertEventTypeToProperCase(dBConnection, (String)hashMap.get("EVENT_TYPE"));
                hashMap.put("EVENT_TYPE", string);
            }
            catch (Exception exception) {
                bl = false;
                return bl;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRuleInUse(String var1_1, DBConnection var2_2) throws SQLException {
        block13: {
            block12: {
                var3_3 = "isRuleInUse";
                var4_4 = null;
                var5_5 = false;
                try {
                    try {
                        var6_6 = new String("select ITSANM.SANM_EVENT_FILTER.RULE_ID as ruleId from ITSANM.SANM_EVENT_FILTER where RULE_ID = ?");
                        var7_8 = var2_2.prepareStatement(var6_6);
                        var7_8.setString(1, var1_1);
                        var4_4 = var7_8.executeQuery();
                        if (var4_4 == null) {
                            var10_9 = var5_5;
                            var8_10 = null;
                            break block12;
                        }
                        if (var4_4.next()) {
                            var5_5 = true;
                        }
                        var4_4.close();
                    }
                    catch (Exception var6_7) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var3_3, (Throwable)var6_7);
                        if (this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventService.className, var3_3, (Throwable)var6_7);
                        }
                        break block13;
                    }
                }
                catch (Throwable var9_16) {
                    var8_11 = null;
                    try {
                        if (var4_4 == null) throw var9_16;
                        var4_4.close();
                        throw var9_16;
                    }
                    catch (Exception var11_14) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var3_3, (Throwable)var11_14);
                        if (this.traceLogger.isLogging() == false) throw var9_16;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventService.className, var3_3, (Throwable)var11_14);
                    }
                    throw var9_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 139->152)] { 
lbl38:
            // 1 sources

            if (var4_4 == null) return var10_9;
            var4_4.close();
            return var10_9;
lbl41:
            // 1 sources

            catch (Exception var11_13) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var3_3, (Throwable)var11_13);
                if (this.traceLogger.isLogging() == false) return var10_9;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventService.className, var3_3, (Throwable)var11_13);
            }
            return var10_9;
        }
        var8_12 = null;
        try {}
        catch (Exception var11_15) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, var3_3, (Throwable)var11_15);
            if (this.traceLogger.isLogging() == false) return var5_5;
            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SANEventService.className, var3_3, (Throwable)var11_15);
            return var5_5;
        }
        if (var4_4 == null) return var5_5;
        var4_4.close();
        return var5_5;
    }

    private void saveRule(HashMap hashMap, DBConnection dBConnection) throws SQLException {
        String string = "saveRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "dispatch", (Object)"entered");
        }
        try {
            String string2 = new String("INSERT INTO ITSANM.SANM_EVENT_FILTER (EVENT_SEVERITY , ENTITY_TYPE, UNIQUE_ID, EVENT_TYPE, EVENT_ACTION, RULE_ID, EVENT_CATEGORY) VALUES ((select id from ITSANM.SANM_EVENT_SEVERITY WHERE NAME=?), (select id from ITSANM.SANM_DEV_KEYS WHERE NAME=?), (?),  (select id from ITSANM.SANM_EVENT_TYPE WHERE NAME=?), (select id from ITSANM.SANM_EVENT_ACTION WHERE NAME=?),  (?), (select id from ITSANM.SANM_EVENT_CATEGORY WHERE NAME=?))");
            DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
            int n = Integer.parseInt((String)hashMap.get(RULE_ID));
            dBPreparedStatement.setString(1, (String)hashMap.get(EVENT_SEVERITY));
            dBPreparedStatement.setString(2, (String)hashMap.get(ENTITY_TYPE));
            dBPreparedStatement.setString(3, (String)hashMap.get(UNIQUE_ID));
            dBPreparedStatement.setString(4, (String)hashMap.get("EVENT_TYPE"));
            dBPreparedStatement.setString(5, (String)hashMap.get(EVENT_ACTION));
            dBPreparedStatement.setInt(6, n);
            dBPreparedStatement.setString(7, (String)hashMap.get(EVENT_CATEGORY));
            dBPreparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)sQLException);
            if (this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
            }
            throw sQLException;
        }
    }

    private void updateRule(HashMap hashMap, DBConnection dBConnection) throws SQLException {
        String string = "updateRule";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, className, (Object)string);
        }
        try {
            String string2 = new String("UPDATE ITSANM.SANM_EVENT_FILTER SET EVENT_SEVERITY= (SELECT ID FROM ITSANM.SANM_EVENT_SEVERITY WHERE NAME=?), ENTITY_TYPE= (SELECT ID FROM ITSANM.SANM_DEV_KEYS WHERE NAME=?), UNIQUE_ID=?, EVENT_TYPE= (SELECT ID FROM ITSANM.SANM_EVENT_TYPE WHERE NAME=?), EVENT_CATEGORY= (SELECT ID FROM ITSANM.SANM_EVENT_CATEGORY WHERE NAME=?), EVENT_ACTION= (SELECT ID FROM ITSANM.SANM_EVENT_ACTION WHERE NAME=?) WHERE RULE_ID=?");
            DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
            int n = Integer.parseInt((String)hashMap.get(RULE_ID));
            dBPreparedStatement.setString(1, (String)hashMap.get(EVENT_SEVERITY));
            dBPreparedStatement.setString(2, (String)hashMap.get(ENTITY_TYPE));
            dBPreparedStatement.setString(3, (String)hashMap.get(UNIQUE_ID));
            dBPreparedStatement.setString(4, (String)hashMap.get("EVENT_TYPE"));
            dBPreparedStatement.setString(5, (String)hashMap.get(EVENT_CATEGORY));
            dBPreparedStatement.setString(6, (String)hashMap.get(EVENT_ACTION));
            dBPreparedStatement.setInt(7, n);
            dBPreparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)sQLException);
            if (this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)sQLException);
            }
            throw sQLException;
        }
    }

    private void incrementRuleIds(String string, DBConnection dBConnection) throws SQLException {
        block2: {
            String string2 = "incrementRuleIds";
            try {
                String string3 = new String("UPDATE ITSANM.SANM_EVENT_FILTER SET RULE_ID=RULE_ID+1 WHERE RULE_ID>=?");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string3);
                int n = Integer.parseInt(string);
                dBPreparedStatement.setInt(1, n);
                dBPreparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
        }
    }

    private void updateRuleId(String string, String string2, DBConnection dBConnection) throws SQLException {
        block2: {
            String string3 = "updateRuleId";
            try {
                String string4 = new String("UPDATE ITSANM.SANM_EVENT_FILTER SET RULE_ID=? WHERE RULE_ID=?");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string4);
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(string2);
                dBPreparedStatement.setInt(1, n2);
                dBPreparedStatement.setInt(2, n);
                dBPreparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string3, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string3, (Throwable)exception);
            }
        }
    }

    private void deleteRule(String string, DBConnection dBConnection) throws SQLException {
        block2: {
            String string2 = "deleteRule";
            try {
                String string3 = new String("DELETE FROM ITSANM.SANM_EVENT_FILTER WHERE RULE_ID=?");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string3);
                int n = Integer.parseInt(string);
                dBPreparedStatement.setInt(1, n);
                dBPreparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string2, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
            }
        }
    }

    private void deleteAllFilterRules(DBConnection dBConnection) throws SQLException {
        block2: {
            String string = "deleteAllFilterRules";
            try {
                String string2 = new String("DELETE FROM ITSANM.SANM_EVENT_FILTER");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBPreparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
    }

    private DBResultSet listRules(DBConnection dBConnection) throws SQLException {
        DBResultSet dBResultSet;
        block2: {
            String string = "listRules";
            dBResultSet = null;
            try {
                String string2 = new String(" SELECT   ITSANM.SANM_EVENT_FILTER.RULE_ID AS RULE_ID,   ITSANM.SANM_EVENT_SEVERITY.NAME AS EVENT_SEVERITY,   ITSANM.SANM_DEV_KEYS.NAME AS ENTITY_TYPE,   ITSANM.SANM_EVENT_FILTER.UNIQUE_ID AS UNIQUE_ID,   ITSANM.SANM_EVENT_TYPE.NAME AS EVENT_TYPE,   ITSANM.SANM_EVENT_CATEGORY.NAME AS EVENT_CATEGORY,   ITSANM.SANM_EVENT_ACTION.NAME AS EVENT_ACTION FROM    ITSANM.SANM_DEV_KEYS RIGHT OUTER JOIN ITSANM.SANM_EVENT_FILTER       ON ( ITSANM.SANM_DEV_KEYS.ID = ITSANM.SANM_EVENT_FILTER.ENTITY_TYPE )     LEFT OUTER JOIN ITSANM.SANM_EVENT_CATEGORY       ON ( ITSANM.SANM_EVENT_CATEGORY.ID = ITSANM.SANM_EVENT_FILTER.EVENT_CATEGORY )     LEFT OUTER JOIN ITSANM.SANM_EVENT_TYPE       ON ( ITSANM.SANM_EVENT_TYPE.ID = ITSANM.SANM_EVENT_FILTER.EVENT_TYPE )     LEFT OUTER JOIN ITSANM.SANM_EVENT_ACTION       ON ( ITSANM.SANM_EVENT_ACTION.ID = ITSANM.SANM_EVENT_FILTER.EVENT_ACTION )     LEFT OUTER JOIN ITSANM.SANM_EVENT_SEVERITY       ON ( ITSANM.SANM_EVENT_SEVERITY.ID = ITSANM.SANM_EVENT_FILTER.EVENT_SEVERITY )  ORDER BY     RULE_ID");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBResultSet = dBPreparedStatement.executeQuery();
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block2;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return dBResultSet;
    }

    private String convertEntityTypeToProperCase(DBConnection dBConnection, String string) throws Exception {
        String string2 = string.replace('_', ' ');
        ArrayList arrayList = this.getEntityTypes(dBConnection);
        if (!arrayList.isEmpty()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string2.equalsIgnoreCase((String)arrayList.get(n))) {
                    return (String)arrayList.get(n);
                }
                ++n;
            }
        }
        throw new Exception();
    }

    private ArrayList getEntityTypes(DBConnection dBConnection) {
        block4: {
            String string = "getIntityTypes";
            if (entityTypes != null) {
                return entityTypes;
            }
            entityTypes = new ArrayList();
            DBResultSet dBResultSet = null;
            try {
                String string2 = new String("SELECT ITSANM.SANM_DEV_KEYS.NAME  as name FROM ITSANM.SANM_DEV_KEYS");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBResultSet = dBPreparedStatement.executeQuery();
                int n = 0;
                while (dBResultSet.next()) {
                    entityTypes.add(n, dBResultSet.getString("name"));
                    ++n;
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return entityTypes;
    }

    private String convertEventCategoryToProperCase(DBConnection dBConnection, String string) throws Exception {
        ArrayList arrayList = this.getEventCategories(dBConnection);
        if (!arrayList.isEmpty()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equalsIgnoreCase((String)arrayList.get(n))) {
                    return (String)arrayList.get(n);
                }
                ++n;
            }
        }
        throw new Exception();
    }

    private ArrayList getEventCategories(DBConnection dBConnection) {
        block4: {
            String string = "getEventCategories";
            if (eventCategories != null) {
                return eventCategories;
            }
            eventCategories = new ArrayList();
            DBResultSet dBResultSet = null;
            try {
                String string2 = new String("SELECT ITSANM.SANM_EVENT_CATEGORY.NAME  as name FROM ITSANM.SANM_EVENT_CATEGORY");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBResultSet = dBPreparedStatement.executeQuery();
                int n = 0;
                while (dBResultSet.next()) {
                    eventCategories.add(n, dBResultSet.getString("name"));
                    ++n;
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return eventCategories;
    }

    private String convertEventSeverityToProperCase(DBConnection dBConnection, String string) throws Exception {
        ArrayList arrayList = this.getEventSeverities(dBConnection);
        if (!arrayList.isEmpty()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equalsIgnoreCase((String)arrayList.get(n))) {
                    return (String)arrayList.get(n);
                }
                ++n;
            }
        }
        throw new Exception();
    }

    private ArrayList getEventSeverities(DBConnection dBConnection) {
        block4: {
            String string = "getEventSeverities";
            if (eventSeverities != null) {
                return eventSeverities;
            }
            eventSeverities = new ArrayList();
            DBResultSet dBResultSet = null;
            try {
                String string2 = new String("SELECT ITSANM.SANM_EVENT_SEVERITY.NAME  as name FROM ITSANM.SANM_EVENT_SEVERITY");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBResultSet = dBPreparedStatement.executeQuery();
                int n = 0;
                while (dBResultSet.next()) {
                    eventSeverities.add(n, dBResultSet.getString("name"));
                    ++n;
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return eventSeverities;
    }

    private String convertEventActionToProperCase(DBConnection dBConnection, String string) throws Exception {
        ArrayList arrayList = this.getEventActions(dBConnection);
        if (!arrayList.isEmpty()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equalsIgnoreCase((String)arrayList.get(n))) {
                    return (String)arrayList.get(n);
                }
                ++n;
            }
        }
        throw new Exception();
    }

    private ArrayList getEventActions(DBConnection dBConnection) {
        block4: {
            String string = "getEventActions";
            if (eventActions != null) {
                return eventActions;
            }
            eventActions = new ArrayList();
            DBResultSet dBResultSet = null;
            try {
                String string2 = new String("SELECT ITSANM.SANM_EVENT_ACTION.NAME  as name FROM ITSANM.SANM_EVENT_ACTION");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBResultSet = dBPreparedStatement.executeQuery();
                int n = 0;
                while (dBResultSet.next()) {
                    eventActions.add(n, dBResultSet.getString("name"));
                    ++n;
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return eventActions;
    }

    private String convertEventTypeToProperCase(DBConnection dBConnection, String string) throws Exception {
        ArrayList arrayList = this.getEventTypes(dBConnection);
        if (!arrayList.isEmpty()) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equalsIgnoreCase((String)arrayList.get(n))) {
                    return (String)arrayList.get(n);
                }
                ++n;
            }
        }
        throw new Exception();
    }

    private ArrayList getEventTypes(DBConnection dBConnection) {
        block4: {
            String string = "getEventTypes";
            if (eventTypes != null) {
                return eventTypes;
            }
            eventTypes = new ArrayList();
            DBResultSet dBResultSet = null;
            try {
                String string2 = new String("SELECT ITSANM.SANM_EVENT_TYPE.NAME  as name FROM ITSANM.SANM_EVENT_TYPE");
                DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string2);
                dBResultSet = dBPreparedStatement.executeQuery();
                int n = 0;
                while (dBResultSet.next()) {
                    eventTypes.add(n, dBResultSet.getString("name"));
                    ++n;
                }
            }
            catch (Exception exception) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        return eventTypes;
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }
}

