/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.Nas.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.Nas.gui.admin.NasAddDialog;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.server.agentreq.ManNasReq;
import org.eclipse.aperi.TStorm.server.guireq.RespManNas;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TextUtil;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasManualPanel
extends JPanel
implements ActionListener,
GuiRequestor {
    static final String ADDNAS = MessageLog.getMessageNoID("NAG0101L");
    static final String DELETE = MessageLog.getMessageNoID("GUI0106L");
    static final String FILER = MessageLog.getMessageNoID("NAG0015L");
    static final String NETWORK_NAME = MessageLog.getMessageNoID("NAG0103L");
    static final String DOMAIN = MessageLog.getMessageNoID("NAG0110L");
    static final String COMPUTER = MessageLog.getMessageNoID("NAG0104L");
    static final String OS_TYPE = MessageLog.getMessageNoID("STG1108L");
    static final String NONE = MessageLog.getMessageNoID("NAG0032L");
    static final String[] colNames = new String[]{FILER, NETWORK_NAME, OS_TYPE, DOMAIN, COMPUTER};
    static final int FILER_COL = 0;
    static final int NETWORK_COL = 1;
    static final int OS_TYPE_COL = 2;
    static final int DOMAIN_COL = 3;
    static final int COMPUTER_COL = 4;
    private MegaTable table = new MegaTable();
    private RespManNas[] dataArray;
    private NameList[] selectedNas;
    private NameList[] windowsAgents;
    private NameList[] unixAgents;
    private NameList[] ldapNameList;
    private LdapTree[] ldapTrees;
    private JButton addNasButton;
    private JButton addNetButton;
    private JButton deleteButton;
    private JPanel nonePanel;
    private NasAddDialog addDialog;
    private boolean requestSubmitted;
    private boolean bAddNas;
    private DataDisplayInfo ddi;
    private TableMouseListener mouseListener;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public NasManualPanel(DataDisplayInfo dataDisplayInfo, Object[] objectArray) {
        this.ddi = dataDisplayInfo;
        this.setLayout(new BorderLayout());
        this.massageData(objectArray);
        this.mouseListener = new TableMouseListener();
        this.addNasButton = new JButton(ADDNAS);
        this.addNasButton.setEnabled(true);
        this.addNasButton.setActionCommand(ADDNAS);
        this.addNasButton.addActionListener(this);
        GuiUtil.setAccessible(this.addNasButton, this.addNasButton.getText(), this.addNasButton.getText());
        this.addNasButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_AGENTROW"));
        this.deleteButton = new JButton(DELETE);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setActionCommand(DELETE);
        this.deleteButton.addActionListener(this);
        GuiUtil.setAccessible(this.deleteButton, this.deleteButton.getText(), this.deleteButton.getText());
        JPanel jPanel = new JPanel();
        jPanel.add(this.addNasButton);
        jPanel.add(this.deleteButton);
        this.add((Component)jPanel, "North");
        if (this.dataArray == null || this.dataArray.length == 0) {
            this.nonePanel = new JPanel();
            this.nonePanel.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
            this.add((Component)this.nonePanel, "Center");
        } else {
            this.table.setBaseTableModel(new TableModel());
            this.table.setSelectionPolicy(0);
            this.table.setMouseListener(this.mouseListener);
            this.add((Component)this.table, "Center");
        }
    }

    private void massageData(Object[] objectArray) {
        this.dataArray = (RespManNas[])objectArray[0];
        this.ldapTrees = (LdapTree[])objectArray[1];
        NameList[] nameListArray = (NameList[])objectArray[2];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nameListArray.length) {
            if (Constants.isWindows((short)nameListArray[n3].nlID3)) {
                ++n2;
            } else {
                ++n;
            }
            ++n3;
        }
        NameList nameList = new NameList();
        nameList.nlName = NONE;
        nameList.nlID = -999;
        this.unixAgents = new NameList[n];
        this.windowsAgents = new NameList[n2];
        n = 0;
        n2 = 0;
        int n4 = 0;
        while (n4 < nameListArray.length) {
            if (Constants.isWindows((short)nameListArray[n4].nlID3)) {
                this.windowsAgents[n2++] = nameListArray[n4];
            } else {
                this.unixAgents[n++] = nameListArray[n4];
            }
            ++n4;
        }
        if (n2 == 0) {
            this.windowsAgents = new NameList[1];
            this.windowsAgents[0] = nameList;
        }
        if (n == 0) {
            this.unixAgents = new NameList[1];
            this.unixAgents[0] = nameList;
        }
        this.ldapNameList = new NameList[this.ldapTrees.length];
        n4 = 0;
        while (n4 < this.ldapTrees.length) {
            this.ldapNameList[n4] = new NameList();
            this.ldapNameList[n4].nlName = this.ldapTrees[n4].getTrueLtName();
            this.ldapNameList[n4].nlID = this.ldapTrees[n4].ltTreeID;
            this.ldapNameList[n4].nlID2 = this.ldapTrees[n4].ltComputerID;
            this.ldapNameList[n4].nlHostName = this.ldapTrees[n4].ltComputerName;
            ++n4;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addNasButton) {
            this.addNas();
        } else if (object == this.deleteButton) {
            this.delete();
        } else if (object == this.addDialog.getSaveButton()) {
            this.saveADD();
        } else if (object == this.addDialog.getCancelButton()) {
            this.addDialogClosed();
        } else if (object == this.addDialog.getWindowsRB() || object == this.addDialog.getUnixRB()) {
            this.filterAgents();
        }
    }

    private void addItems(NameList[] nameListArray) {
        int n = 0;
        while (n < nameListArray.length) {
            this.addDialog.getAgentBox().addItem(nameListArray[n]);
            ++n;
        }
    }

    private void filterAgents() {
        if (this.addDialog == null || this.addDialog.getSaveButton() == null) {
            return;
        }
        this.addDialog.getAgentBox().removeAllItems();
        this.addDialog.getUseridField().setText("");
        this.addDialog.getPasswordField().setText("");
        if (this.addDialog.getWindowsRB().isSelected()) {
            this.addItems(this.windowsAgents);
            this.addDialog.setUserPasswordEnabled(true);
        } else {
            this.addItems(this.unixAgents);
            this.addDialog.setUserPasswordEnabled(false);
        }
        this.addDialog.getSaveButton().setEnabled(true);
        this.addDialog.getAgentBox().repaint();
    }

    private void addNas() {
        this.bAddNas = true;
        this.initComponents();
        this.addDialog.setTitle(MessageLog.getMessageNoID("NAG0101L"));
        this.filterAgents();
        Help.setHelpID(this.addDialog.getRootPane(), "asco150");
        this.addDialog.display();
    }

    private void delete() {
        int[] nArray = this.table.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            RespManNas respManNas = this.dataArray[nArray[n]];
            this.deleteDialog(respManNas);
            ++n;
        }
    }

    private void deleteDialog(RespManNas respManNas) {
        String string = MessageLog.getMessageNoID("NAG0115L");
        String string2 = MessageLog.getMessageNoID("NAG0116L", respManNas.mnNetName);
        if (GuiUtil.getConfirmation(this.guiMain.getFrame(), string, string2, false)) {
            this.sendRequest(respManNas);
        }
    }

    private void initComponents() {
        this.addDialog = null;
        this.addDialog = new NasAddDialog(this.guiMain.getFrame(), true, this.windowsAgents, this.ldapNameList);
        this.addDialog.setTitle(MessageLog.getMessageNoID("NAG0101L"));
        this.addDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing() {
                NasManualPanel.this.addDialogClosed();
            }

            public void windowOpened() {
                NasManualPanel.this.requestFocus();
                NasManualPanel.this.addDialog.getNameField().requestFocus();
            }
        });
        this.addDialog.getWindowsRB().addActionListener(this);
        this.addDialog.getUnixRB().addActionListener(this);
        this.addDialog.getSaveButton().addActionListener(this);
        this.addDialog.getCancelButton().addActionListener(this);
        this.addDialog.getLdapBox().addActionListener(this);
    }

    private void addDialogClosed() {
        if (this.requestSubmitted) {
            this.guiMain.endRequestWait();
            this.addDialog.enableControls(true);
            this.filterAgents();
            this.requestSubmitted = false;
        }
        if (this.addDialog != null) {
            this.addDialog.dispose();
            this.addDialog = null;
        }
    }

    private void saveADD() {
        Object object;
        String string;
        String string2 = null;
        String string3 = null;
        NameList nameList = null;
        try {
            string = this.getRequiredField(this.addDialog.getNameField(), "NAG0108E");
            if (this.bAddNas && this.addDialog.getWindowsRB().isSelected()) {
                string2 = this.getRequiredField(this.addDialog.getUseridField(), "SAG3002E");
                object = this.addDialog.getPasswordField().getPassword();
                if (object == null || ((Object)object).length == 0) {
                    this.addDialog.getPasswordField().requestFocus();
                    throw new GeneralException("SAG3003E");
                }
                string3 = String.valueOf((char[])object);
            }
            nameList = (NameList)this.addDialog.getAgentBox().getSelectedItem();
            if (nameList.nlID3 < 0) {
                throw new GeneralException("NAG0109E");
            }
        }
        catch (GeneralException generalException) {
            String string4 = MessageLog.getMessageNoTS(generalException.getMessage());
            GuiUtil.displayErrorMessage(string4);
            return;
        }
        object = new ManNasReq();
        ((ManNasReq)object).mnNetworkName = string;
        ((ManNasReq)object).mnAddNas = this.bAddNas;
        if (this.bAddNas) {
            ((ManNasReq)object).mnUserid = string2;
            if (string3 != null) {
                ((ManNasReq)object).mnPassword = Encrypt.encrypt(string3);
            }
            ((ManNasReq)object).mnAgentID = nameList.nlID;
            ((ManNasReq)object).mnCommunityName = this.addDialog.getSnmpField().getText();
            ((ManNasReq)object).mnIsWindows = this.addDialog.getWindowsRB().isSelected();
            if (((ManNasReq)object).mnAgentID < 0) {
                String string5 = ((ManNasReq)object).mnIsWindows ? MessageLog.getMessageNoTS("NAG0118E") : MessageLog.getMessageNoTS("NAG0117E");
                GuiUtil.displayErrorMessage(string5);
                return;
            }
        } else {
            NameList nameList2 = (NameList)this.addDialog.getLdapBox().getSelectedItem();
            ((ManNasReq)object).mnTreeName = nameList2.nlName;
            ((ManNasReq)object).mnAgentID = nameList2.nlID2;
        }
        this.sendRequest((Serializable)object);
    }

    private String getRequiredField(JTextField jTextField, String string) throws GeneralException {
        String string2 = TextUtil.getTrimmedText(jTextField);
        if (TextUtil.isNull(string2)) {
            jTextField.requestFocus();
            throw new GeneralException(string);
        }
        return string2;
    }

    private void sendRequest(Serializable serializable) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.nas.NasGuiManEntryHndlr";
        request.requestData = serializable;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
        this.requestSubmitted = true;
        if (this.addDialog != null) {
            this.addDialog.enableControls(false);
        }
    }

    public void handleResponse(short s, Response response) {
        this.requestSubmitted = false;
        if (s <= 4) {
            Object[] objectArray = (Object[])response.responseData;
            this.refreshTable((RespManNas[])objectArray[0]);
            if (this.addDialog != null) {
                this.addDialog.enableControls(true);
                this.filterAgents();
                this.addDialog.dispose();
                this.addDialog = null;
            }
        } else if (this.addDialog != null) {
            this.addDialog.enableControls(true);
        }
    }

    private void refreshTable(RespManNas[] respManNasArray) {
        this.remove(this.table);
        if (this.nonePanel != null) {
            this.remove(this.nonePanel);
            this.nonePanel = null;
        }
        if (respManNasArray == null || respManNasArray.length == 0) {
            this.nonePanel = new JPanel();
            this.nonePanel.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
            this.add((Component)this.nonePanel, "Center");
        } else {
            this.dataArray = respManNasArray;
            this.table.setBaseTableModel(new TableModel());
            this.table.setMouseListener(this.mouseListener);
            this.add((Component)this.table, "Center");
        }
        this.invalidate();
    }

    private class TableModel
    extends BaseTableModel {
        public TableModel() {
            this.columnNames = colNames;
            this.rowCount = NasManualPanel.this.dataArray.length;
        }

        public Object getTableDataItem(int n, int n2) {
            String string = null;
            if (n2 == 0) {
                string = ((NasManualPanel)NasManualPanel.this).dataArray[n].mnFiler;
            } else if (n2 == 1) {
                string = ((NasManualPanel)NasManualPanel.this).dataArray[n].mnNetName;
            } else if (n2 == 3) {
                string = ((NasManualPanel)NasManualPanel.this).dataArray[n].mnDomain;
            } else if (n2 == 2) {
                string = MessageLog.getMessageNoID(Constants.OSTYPES[((NasManualPanel)NasManualPanel.this).dataArray[n].mnOsType]);
            } else if (n2 == 4) {
                string = ((NasManualPanel)NasManualPanel.this).dataArray[n].mnUnixComp;
            }
            return string;
        }
    }

    private class TableMouseListener
    extends TJCTableMouseAdapter {
        private TableMouseListener() {
        }

        public boolean select(int n, int n2) {
            boolean bl = ((NasManualPanel)NasManualPanel.this).guiMain.getUserPrefs().administrator;
            return bl;
        }

        public void selectionChanged(boolean bl) {
            NasManualPanel.this.deleteButton.setEnabled(bl);
        }
    }
}

