/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.San.gui.RankTreeNode;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class RankTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    private NameList parent;
    private int ctrlrID;
    private int computerID;

    public RankTreeLabel(NameList nameList, int n) {
        this.setUserObject(MessageLog.getMessageNoID("SAG0089L"));
        this.parent = nameList;
        this.ctrlrID = n;
        this.computerID = nameList.nlID;
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.rankList(request, this.computerID, this.ctrlrID);
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short s, Response response) {
        Rank rank = null;
        if (s <= 4) {
            rank = (Rank)Packer.unpack((Packable[])response.responseData);
        }
        while (rank != null) {
            this.addSorted(this.makeNode(rank));
            rank = rank.rankNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    protected RankTreeNode makeNode(Rank rank) {
        return new RankTreeNode(rank, this.parent);
    }

    public void addSorted(BaseTreeNode baseTreeNode) {
        String string = baseTreeNode.getUserObject().toString();
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            BaseTreeNode baseTreeNode2 = (BaseTreeNode)this.getChildAt(n2);
            if (string.compareTo(baseTreeNode2.getUserObject().toString()) < 0) break;
            ++n2;
        }
        BaseTree.MyTree.insertNodeInto(baseTreeNode, this, n2);
    }
}

