/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;

public class FabricDiscoveryOptions {
    private String defaultCommunityStr;
    private int scanTimeout;
    private String scanTimeoutStr;
    private String userNameStr;
    private String passwordStr;

    public FabricDiscoveryOptions(String string) {
        int n;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDiscoveryOptions.class.getName(), "FabricDiscoveryOptions", "options");
        }
        this.scanTimeout = 0;
        this.defaultCommunityStr = "";
        this.userNameStr = "";
        this.passwordStr = "";
        if (!Util.isEmpty(string) && (n = string.indexOf(44)) != -1) {
            this.defaultCommunityStr = string.substring(0, n);
            int n2 = string.indexOf(44, n + 1);
            if (n2 != -1) {
                this.scanTimeoutStr = string.substring(n + 1, n2);
                this.scanTimeout = Util.isEmpty(this.scanTimeoutStr) ? 0 : Integer.parseInt(this.scanTimeoutStr);
                int n3 = string.indexOf(44, n2 + 1);
                if (n3 != -1) {
                    this.userNameStr = string.substring(n2 + 1, n3);
                    this.passwordStr = string.substring(n3 + 1, string.length());
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDiscoveryOptions.class.getName(), "FabricDiscoveryOptions");
        }
    }

    public void setScanTimeout(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDiscoveryOptions.class.getName(), "setScanLimit", "limit");
        }
        this.scanTimeoutStr = string;
        this.scanTimeout = Util.isEmpty(string) ? 0 : Integer.parseInt(string);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDiscoveryOptions.class.getName(), "setScanTimeout");
        }
    }

    public int getScanTimeout() {
        return this.scanTimeout;
    }

    public String getScanTimeoutString() {
        return this.scanTimeoutStr;
    }

    public void setDefaultCommunity(String string) {
        this.defaultCommunityStr = string;
    }

    public String getDefaultCommunity() {
        return this.defaultCommunityStr;
    }

    public void setUserName(String string) {
        this.userNameStr = string;
    }

    public String getUserName() {
        return this.userNameStr;
    }

    public void setPassword(String string) {
        String string2 = "";
        String string3 = "";
        if (!Util.isEmpty(string)) {
            try {
                string2 = Encrypt.encrypt(string);
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDiscoveryOptions.class.getName(), "setPassword", exception);
                }
                this.passwordStr = string3;
            }
        }
        this.passwordStr = string2;
    }

    public void setPasswordStr(String string) {
        this.passwordStr = string;
    }

    public String getPasword() {
        String string = "";
        String string2 = "";
        if (!Util.isEmpty(this.passwordStr)) {
            try {
                string = Encrypt.decrypt(this.passwordStr);
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDiscoveryOptions.class.getName(), "getPassword", exception);
                }
                return string2;
            }
        }
        return string;
    }

    public String getOptionsString() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDiscoveryOptions.class.getName(), "getOptionsString", "");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.defaultCommunityStr) + ',');
        if (this.scanTimeout != 0) {
            stringBuffer.append(String.valueOf(this.scanTimeoutStr) + ',');
        } else {
            stringBuffer.append(',');
        }
        stringBuffer.append(String.valueOf(this.userNameStr) + ',');
        stringBuffer.append(this.passwordStr);
        String string = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDiscoveryOptions.class.getName(), "getOptionsString", string);
        }
        return string;
    }
}

