/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnmanagedRptAdjuster
extends CustomReportDataAdjuster {
    private static final String NAME = MessageLog.getMessageNoID("STG5006L");
    private static final String DOMAIN = MessageLog.getMessageNoID("STG1104L");
    private static final String IP_ADDR = MessageLog.getMessageNoID("STG1280L");
    private static final String OS_TYPE = MessageLog.getMessageNoID("STG1108L");
    private static final String DISCOVERED = MessageLog.getMessageNoID("STG3199L");
    private static final String MISSING = MessageLog.getMessageNoID("STG3192L");
    public String[] colNames = new String[]{NAME, DOMAIN, IP_ADDR, OS_TYPE, DISCOVERED, MISSING};
    private static final int NAME_COL = 0;
    private static final int DOMAIN_COL = 1;
    private static final int IP_ADDR_COL = 2;
    private static final int OS_TYPE_COL = 3;
    private static final int DISCOVERED_COL = 4;
    private static final int MISSING_COL = 5;
    private GuiReportReq grr;
    private FoundComputer[] data;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private boolean batch;
    private int rows;

    public UnmanagedRptAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 1;
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[4] = 1;
        this.rendererArray[5] = 5;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        Arrays.sort(this.data, 0, this.data.length, new ComputerSorter());
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.data = (FoundComputer[])objectArray;
        this.rows = this.data.length;
        this.mDate = new Date[this.rows];
        this.mInt = new MutableInteger[this.rows];
        int n = 0;
        while (n < this.rows) {
            this.mDate[n] = new Date();
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
        columnDescriptorArray[3].cdValidValue = ColumnDescriptor.OS_TYPES_PLUS_UNKNOWN;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getArray() {
        return this.data;
    }

    public Object getCellData(int n, int n2) {
        Object object = " ";
        switch (n2) {
            case 0: {
                object = this.data[n].fcName;
                break;
            }
            case 1: {
                object = this.data[n].fcDomain;
                break;
            }
            case 2: {
                object = this.data[n].fcIPAddress;
                break;
            }
            case 3: {
                if (this.data[n].fcOSType >= Constants.OSTYPES.length || this.data[n].fcOSType == 0) {
                    object = MessageLog.getMessageNoID("STG1020L");
                    break;
                }
                object = MessageLog.getMessageNoID(Constants.OSTYPES[this.data[n].fcOSType]);
                break;
            }
            case 4: {
                this.mDate[n].setTime(this.data[n].fcWhenDiscovered);
                object = this.mDate[n];
                break;
            }
            case 5: {
                this.mInt[n].value = this.data[n].fcTimesMissing;
                object = this.mInt[n];
            }
        }
        return object;
    }

    private class ComputerSorter
    implements Comparator {
        private ComputerSorter() {
        }

        public int compare(Object object, Object object2) {
            FoundComputer foundComputer = (FoundComputer)object;
            FoundComputer foundComputer2 = (FoundComputer)object2;
            return foundComputer.fcName.compareTo(foundComputer2.fcName);
        }
    }
}

