/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.gui.DateSelector;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.request.BasicSocketClient;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class HistoryChart
implements GuiRequestor,
ReportingObjectBuilder,
ActionListener {
    public static final int DEFAULT_MAX_LINES = 10;
    protected String title = "";
    protected String sourceName = "";
    protected String[] seriesL;
    protected double[] xvalues;
    protected double[] yvalues;
    protected long currentTimeStamp = System.currentTimeMillis();
    protected double holeValue = Double.MIN_VALUE;
    protected ReportingDDI ddi;
    private GuiReportReq grr;
    private Request request;
    private AperiCustomizableChart chart;
    private JPanel panel = new JPanel(new BorderLayout());
    private JLabel error = new JLabel(MessageLog.getMessageNoID("STG0020M"));
    private String[] seriesLAll;
    private double[][] xValuesAll;
    private double[][] yValuesAll;
    private JButton generate = new JButton(MessageLog.getMessageNoID("STG1285T"));
    private String[] types = new String[]{Util.getString("BY_SCAN"), MessageLog.getMessageNoID("STG1194T"), MessageLog.getMessageNoID("STG1195T")};
    private TComboBox ctype = new TComboBox(this.types);
    private JCheckBox limit = new JCheckBox();
    private JLabel fromL = new JLabel(MessageLog.getMessageNoID("STG1284T"));
    private DateSelector from = new DateSelector();
    private JLabel toL = new JLabel(MessageLog.getMessageNoID("STG4083L"));
    private DateSelector to = new DateSelector();
    private boolean batch = false;
    private GuiChartSettingsReq gcsr = null;

    protected abstract boolean processResponse(Object var1, GuiReportReq var2);

    public Component batch(Object object, GuiChartSettingsReq guiChartSettingsReq) {
        this.gcsr = guiChartSettingsReq;
        this.batch = true;
        return this.build(object);
    }

    public Component build(Object object) {
        Component component;
        this.grr = (GuiReportReq)object;
        if (this.batch) {
            component = this.buildBatchReportChart();
        } else {
            this.request = new GuiReportRequest(this.grr);
            GuiClient.doRequest(this, this.request);
            component = this.buildReportChartPanel();
        }
        return component;
    }

    private Component buildBatchReportChart() {
        this.request = new GuiReportRequest(this.grr);
        Response response = null;
        try {
            response = BasicSocketClient.sendRequest(this.request, Variables.server, Variables.port);
        }
        catch (Exception exception) {
            response = new Response(12, null);
            response.errorMessage = exception.getMessage();
        }
        if (response == null || response.status > 4) {
            return null;
        }
        if (!this.processResponse(response.responseData, this.grr)) {
            return null;
        }
        this.handleResponse((short)0, null);
        return this.chart;
    }

    private Component buildReportChartPanel() {
        GuiUtil.setAccessible(this.generate, this.generate.getText(), this.generate.getText());
        GuiUtil.setAccessible(this.limit, this.fromL.getText(), this.fromL.getText());
        this.panel.add((Component)this.buildControlPanel(), "North");
        if (this.grr.startTime > 0L) {
            this.fromL.setEnabled(true);
            this.toL.setEnabled(true);
            this.from.setEnabled(true);
            this.from.setDate(this.grr.startTime);
            this.to.setEnabled(true);
            this.to.setDate(this.grr.endTime);
            this.limit.setSelected(true);
        } else {
            this.fromL.setEnabled(false);
            this.from.setEnabled(false);
            this.toL.setEnabled(false);
            this.to.setEnabled(false);
        }
        this.generate.addActionListener(this);
        this.limit.addActionListener(this);
        this.panel.revalidate();
        return this.panel;
    }

    private JPanel buildControlPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.ctype, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.buildLimitDateRangePanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 22;
        jPanel.add((Component)this.generate, gridBagConstraints);
        jPanel.setBorder(GuiUtil.getBorder());
        return jPanel;
    }

    private JPanel buildLimitDateRangePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.insets.right = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.limit, gridBagConstraints);
        this.limit.setOpaque(false);
        jPanel.add((Component)this.fromL, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.from, gridBagConstraints);
        this.from.setOpaque(false);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.toL, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        jPanel.add((Component)this.to, gridBagConstraints);
        this.to.setOpaque(false);
        return jPanel;
    }

    public void handleResponse(short s, Response response) {
        if (!this.batch) {
            if (this.error != null) {
                this.panel.remove(this.error);
            }
            if (this.chart != null) {
                this.panel.remove(this.chart);
            }
            if (s > 4 || response.responseData == null) {
                this.panel.add((Component)this.error, "Center");
                return;
            }
        }
        if (!this.batch && !this.processResponse(response.responseData, this.grr)) {
            this.panel.add((Component)this.error, "Center");
            return;
        }
        this.fillOutArrays();
        ChartOptions chartOptions = new ChartOptions();
        chartOptions.chartType = 0;
        chartOptions.chartsPerView = 10;
        this.chart = new AperiCustomizableChart((int)this.grr.chartLabelType, 5, this.yValuesAll, this.xValuesAll, this.seriesLAll, chartOptions, this.grr);
        if (!this.batch) {
            this.panel.add((Component)this.chart, "Center");
        }
    }

    private void fillOutArrays() {
        HashMap<String, ArrayList<Double>> hashMap = new HashMap<String, ArrayList<Double>>();
        HashMap<String, ArrayList<Double>> hashMap2 = new HashMap<String, ArrayList<Double>>();
        int n = 0;
        while (n < this.seriesL.length) {
            ArrayList<Double> arrayList = (ArrayList<Double>)hashMap.get(this.seriesL[n]);
            ArrayList<Double> arrayList2 = (ArrayList<Double>)hashMap2.get(this.seriesL[n]);
            if (arrayList == null) {
                arrayList = new ArrayList<Double>();
                hashMap.put(this.seriesL[n], arrayList);
                arrayList2 = new ArrayList<Double>();
                hashMap2.put(this.seriesL[n], arrayList2);
            }
            arrayList.add(new Double(this.xvalues[n]));
            arrayList2.add(new Double(this.yvalues[n]));
            ++n;
        }
        this.seriesLAll = hashMap.keySet().toArray(new String[hashMap.size()]);
        this.xValuesAll = new double[hashMap.size()][];
        this.yValuesAll = new double[hashMap.size()][];
        n = 0;
        while (n < this.seriesLAll.length) {
            this.xValuesAll[n] = new double[((ArrayList)hashMap.get(this.seriesLAll[n])).size()];
            this.yValuesAll[n] = new double[((ArrayList)hashMap2.get(this.seriesLAll[n])).size()];
            int n2 = 0;
            while (n2 < this.xValuesAll[n].length) {
                this.xValuesAll[n][n2] = (Double)((ArrayList)hashMap.get(this.seriesLAll[n])).get(n2);
                this.yValuesAll[n][n2] = (Double)((ArrayList)hashMap2.get(this.seriesLAll[n])).get(n2);
                ++n2;
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.generate) {
            this.grr.histType = (byte)this.ctype.getSelectedIndex();
            if (this.limit.isSelected()) {
                this.grr.startTime = this.from.getStartOfDay();
                this.grr.endTime = this.to.getEndOfDay();
            } else {
                this.grr.startTime = 0L;
                this.grr.endTime = 0L;
            }
            GuiClient.doRequest(this, this.request);
        } else if (actionEvent.getSource() == this.limit) {
            this.fromL.setEnabled(this.limit.isSelected());
            this.from.setEnabled(this.limit.isSelected());
            this.toL.setEnabled(this.limit.isSelected());
            this.to.setEnabled(this.limit.isSelected());
        }
    }

    public void setXaxis(short s) {
        this.ctype.setSelectedIndex(s);
    }

    public Object[] getArrays() {
        Object[] objectArray = new Object[4];
        objectArray[1] = this.seriesL;
        objectArray[2] = this.xvalues;
        objectArray[3] = this.yvalues;
        return objectArray;
    }

    public void regenerate(short s) {
        this.grr.histType = (byte)s;
        GuiClient.doRequest(this, this.request);
    }

    public void setDDI(ReportingDDI reportingDDI) {
        this.ddi = reportingDDI;
    }
}

