/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.ProbeAlertEditor;
import org.eclipse.aperi.TStorm.gui.ProbeGroupSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AbstractAlertEditor;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    private static final int COMPUTERS_TAB = 0;
    private static final int SCHEDULE_TAB = 1;
    private static final int ALERT_TAB = 2;
    private CreateOrEditDDI DDI;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    protected JSgcScheduleCreateWhenData scheduleDefiner;
    protected ProbeGroupSelector selector;
    protected AbstractAlertEditor alertEditor;

    public ProbeCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.showEnabled = true;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GuiProbeHndlr";
    }

    public CreateHeader getData() {
        this.scheduleDefiner.getData();
        ProbePing probePing = (ProbePing)this.createHeaderPanel.getData();
        this.getSelectorData(probePing);
        probePing.pbAlert = this.alertEditor.getData();
        return probePing;
    }

    public void getSelectorData(ProbePing probePing) {
        NameList[] nameListArray = this.selector.getData();
        probePing.pbComputers = nameListArray[0];
        probePing.pbComputerGroups = nameListArray[1];
        probePing.pbDiskArrays = nameListArray[2];
        probePing.pbDiskArrayGroups = nameListArray[3];
        probePing.pbClusters = nameListArray[4];
        probePing.pbFabrics = nameListArray[5];
        probePing.pbFabricGroups = nameListArray[6];
        probePing.pbLibraries = nameListArray[7];
        probePing.pbLibrariesGroups = nameListArray[8];
        probePing.pbAllComputers = this.selector.allCompsSelected;
        probePing.pbAllDiskArrays = this.selector.allDisksSelected;
        probePing.pbAllFabrics = this.selector.allFabricsSelected;
        probePing.pbAllLibraries = this.selector.allLibrariesSelected;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        ProbePing probePing = (ProbePing)createHeader;
        if (probePing.isEmpty()) {
            String string = MessageLog.getMessageNoTS("STG4048E", null);
            this.DDI.exceptionTabIndex = 0;
            throw new GeneralException(string);
        }
        this.DDI.exceptionTabIndex = 1;
        this.scheduleDefiner.validate(probePing);
        this.DDI.exceptionTabIndex = 2;
        this.alertEditor.validateData();
    }

    protected void makeSelectorAndAlertEditor(ProbePing probePing) {
        this.selector = new ProbeGroupSelector(probePing.pbComputers, probePing.pbComputerGroups, probePing.pbClusters, probePing.pbDiskArrays, probePing.pbDiskArrayGroups, probePing.pbFabrics, probePing.pbFabricGroups, probePing.pbLibraries, probePing.pbLibrariesGroups, probePing.pbAllComputers, probePing.pbAllDiskArrays, probePing.pbAllFabrics, probePing.pbAllLibraries);
        this.alertEditor = probePing.pbAlert == null ? new ProbeAlertEditor() : new ProbeAlertEditor(probePing.pbAlert);
    }

    private void create(ProbePing probePing) {
        this.createHeaderPanel = new CreateHeaderPanel(probePing, this, this.DDI);
        this.scheduleDefiner = new JSgcScheduleCreateWhenData(this.DDI.nlInfo, this.DDI);
        JPanel jPanel = this.scheduleDefiner.build(probePing);
        this.makeSelectorAndAlertEditor(probePing);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String string = Util.getString("WHAT_TO_PROBE");
        this.tabs.addTab(string, this.getSelectorComponent());
        string = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(string, jPanel);
        string = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(string, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.DDI.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
        this.DDI.addObjectChangeListener(this, (short)0);
    }

    public Component getSelectorComponent() {
        return this.selector.getComponent();
    }

    public void replace(CreateHeader createHeader) {
        ProbePing probePing = (ProbePing)createHeader;
        this.createHeaderPanel.replace(probePing);
        this.scheduleDefiner.replace(probePing);
        this.selectorReplace(probePing);
    }

    public void selectorReplace(ProbePing probePing) {
        this.selector.replace(probePing.pbComputers, probePing.pbComputerGroups, probePing.pbClusters, probePing.pbDiskArrays, probePing.pbDiskArrayGroups, probePing.pbFabrics, probePing.pbFabricGroups, probePing.pbLibraries, probePing.pbLibrariesGroups, probePing.pbAllComputers, probePing.pbAllDiskArrays, probePing.pbAllFabrics, probePing.pbAllLibraries);
    }

    private void submitRetrieve(int n) {
        ProbePing probePing = new ProbePing(this.DDI.nlInfo);
        probePing.ID = n;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr", probePing);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        ProbePing probePing = new ProbePing(this.DDI.nlInfo);
        this.create(probePing);
        probePing.pbAlert = this.alertEditor.getData();
        this.DDI.oldCreateHeader = (CreateHeader)probePing.clone();
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        ProbePing probePing = (ProbePing)createHeader;
        this.create(probePing);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
        this.tabs.setSelectedIndex(n);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        ProbePing probePing = (ProbePing)response.responseData;
        this.create(probePing);
        this.DDI.oldCreateHeader = (CreateHeader)probePing.clone();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.DDI.tabIndex = this.tabs.getSelectedIndex();
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n == 100) {
            this.selector.invalidateGroups(nameList.nlInfo);
        } else if (n == 1) {
            this.selector.addGroup(nameList);
        }
    }

    public String getHelpID(int n) {
        switch (n) {
            case 0: {
                return "moprob5";
            }
            case 1: {
                return "moprob10";
            }
            case 2: {
                return "moprob15";
            }
        }
        return null;
    }
}

