/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.ReportingFSGroupSelector;
import org.eclipse.aperi.TStorm.gui.ReportingGroupResourceData;
import org.eclipse.aperi.TStorm.gui.ShowResource;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.FilterPanel;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingFSGroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
ActionListener {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private ReportingFSGroupSelector fsSelector;
    private Vector filterVec;
    private GridBagPanel filterPanel;
    private JButton selectResourcesButton;
    private JButton showAllButton;
    private boolean showAllRequest = false;

    public ReportingFSGroupCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition groupDefinition = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector treeSelector = (TreeSelector)this.fsSelector.getComponent();
        groupDefinition.members = treeSelector.getNameList();
        groupDefinition.maskList = null;
        if (!this.filterVec.isEmpty()) {
            int n;
            int n2 = this.filterVec.size();
            switch (this.DDI.nlInfo) {
                case 89: {
                    n = 95;
                    break;
                }
                case 90: {
                    n = 96;
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown Filter Type");
                }
            }
            NameList nameList = null;
            int n3 = 0;
            while (n3 < n2) {
                NameList nameList2 = new NameList();
                nameList2.nlName = this.filterVec.get(n3).toString();
                nameList2.nlInfo = (short)n;
                nameList2.nlNext = nameList;
                nameList = nameList2;
                ++n3;
            }
            groupDefinition.maskList = nameList;
        }
        return groupDefinition;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        GroupDefinition groupDefinition = (GroupDefinition)createHeader;
        if (groupDefinition.members == null && groupDefinition.maskList == null) {
            String string = MessageLog.getMessageNoTS("STG3156E", null);
            throw new GeneralException(string);
        }
    }

    private void create(GroupDefinition groupDefinition) {
        NameList[] nameListArray;
        this.createHeaderPanel = new CreateHeaderPanel(groupDefinition, this, this.DDI);
        (new NameList[1])[0] = groupDefinition.members;
        NameList nameList = groupDefinition.members;
        String[] stringArray = new String[5];
        stringArray[1] = "STG4029L";
        stringArray[4] = "STG4030L";
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList nameList4 = null;
        NameList nameList5 = null;
        NameList nameList6 = null;
        NameList nameList7 = null;
        switch (this.DDI.nlInfo) {
            case 90: {
                while (nameList != null) {
                    if (nameList.nlInfo == 2) {
                        nameList5 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, nameList.nlInfo);
                        nameList5.nlNext = nameList2;
                        nameList2 = nameList5;
                    } else if (nameList.nlInfo == 3) {
                        nameList6 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, nameList.nlInfo);
                        nameList6.nlNext = nameList3;
                        nameList3 = nameList6;
                    } else if (nameList.nlInfo == 90) {
                        nameList7 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlID2, nameList.nlInfo);
                        nameList7.nlNext = nameList4;
                        nameList4 = nameList7;
                    }
                    nameList = nameList.nlNext;
                }
                nameListArray = new NameList[5];
                nameListArray[2] = nameList2;
                nameListArray[3] = nameList3;
                nameListArray[4] = nameList4;
                this.fsSelector = new ReportingFSGroupSelector(nameListArray, this.DDI.ID, false, false);
            }
        }
        this.filterVec = new Vector();
        nameListArray = groupDefinition.maskList;
        while (nameListArray != null) {
            this.filterVec.add(nameListArray.nlName);
            nameListArray = nameListArray.nlNext;
        }
        GridBagPanel gridBagPanel = new GridBagPanel(new Insets(0, 0, 0, 0));
        this.filterPanel = new FilterPanel(this.filterVec, new Insets(0, 0, 0, 0), this.DDI.nlInfo);
        gridBagPanel.add((JComponent)this.filterPanel, 1, new Insets(0, 4, 0, 4));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)this.fsSelector.getComponent(), 25, 1);
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        this.selectResourcesButton = new JButton(Util.getString("LABEL_SELECT_RESOURCES"));
        this.selectResourcesButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SELECT_RESOURCES"));
        this.selectResourcesButton.addActionListener(this);
        this.showAllButton = new JButton(Util.getString("LABEL_SHOW_ALL_RESOURCES"));
        this.showAllButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SHOW_ALL_RESOURCES"));
        this.showAllButton.addActionListener(this);
        gridBagPanel2.add((JComponent)this.selectResourcesButton, 21, new Insets(0, 4, 0, 4));
        gridBagPanel2.add((JComponent)new JPanel(), 10, new Insets(0, 125, 0, 55));
        gridBagPanel2.add((JComponent)this.showAllButton, 22, new Insets(0, 4, 0, 4));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)gridBagPanel2, 21);
        this.createHeaderPanel.add(gridBagPanel);
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader createHeader) {
        this.createHeaderPanel.replace(createHeader);
        NameList nameList = new NameList();
        nameList.nlInfo = this.DDI.nlInfo;
        ChangeManager.signalChange(100, nameList);
        this.fsSelector.hideSavedID(createHeader.ID);
    }

    private void submitRetrieve(int n) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.userName = GuiUtil.getUserName();
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.ID = n;
        groupDefinition.groupType = this.DDI.nlInfo;
        groupDefinition.members = null;
        request.requestData = groupDefinition;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = this.DDI.nlInfo;
        this.create(groupDefinition);
        this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (!this.showAllRequest) {
            GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
            this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
            this.create(groupDefinition);
        } else {
            NameList nameList = (NameList)response.responseData;
            this.showAllRequest = false;
            this.showDialog(nameList);
        }
    }

    public String getHelpID(int n) {
        return "repgrp10";
    }

    private NameList newNameList(String string, int n, int n2, int n3) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlID2 = n2;
        nameList.nlInfo = (short)n3;
        return nameList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectResourcesButton) {
            FilterResultsViewer filterResultsViewer = new FilterResultsViewer(guiMain.getFrame(), FilterResultsViewer.PICK, this, 0, null, this.DDI.nlInfo, Util.getString("TITLE_SELECT_RESOURCES"));
            GuiUtil.centerDialog(filterResultsViewer);
            filterResultsViewer.displayDialog();
        } else {
            this.sendShowAllRequest();
        }
    }

    private NameList getNameList() {
        GroupDefinition groupDefinition = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector treeSelector = (TreeSelector)this.fsSelector.getComponent();
        groupDefinition.members = treeSelector.getNameList();
        if (!this.filterVec.isEmpty()) {
            int n = this.filterVec.size();
            int n2 = 0;
            switch (this.DDI.nlInfo) {
                case 90: {
                    n2 = 96;
                }
            }
            int n3 = 0;
            while (n3 < n) {
                NameList nameList = new NameList();
                nameList.nlName = this.filterVec.get(n3).toString();
                nameList.nlInfo = (short)n2;
                nameList.nlNext = groupDefinition.members;
                groupDefinition.members = nameList;
                ++n3;
            }
        }
        return groupDefinition.members;
    }

    private void sendShowAllRequest() {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 11;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        request.flags = (byte)4;
        guiListReq.qualifierObject = this.getNameList();
        if (guiListReq.qualifierObject != null) {
            this.showAllRequest = true;
            GuiClient.doRequest(this, request);
        } else {
            JOptionPane.showMessageDialog(guiMain.getFrame(), Util.getString("LABEL_ALL_RESOURCES_EMPTY"), "GUI1621I", 1);
        }
    }

    private void showDialog(NameList nameList) {
        Serializable serializable;
        if (nameList == null) {
            return;
        }
        Vector<ReportingGroupResourceData> vector = new Vector<ReportingGroupResourceData>();
        while (nameList != null) {
            serializable = GuiUtil.getComputer(nameList.nlID2);
            ReportingGroupResourceData reportingGroupResourceData = new ReportingGroupResourceData();
            reportingGroupResourceData.setComputerName(((GComputer)serializable).gcTSName);
            reportingGroupResourceData.setOsType(((GComputer)serializable).gcOsType);
            reportingGroupResourceData.setFsName(nameList.nlName);
            vector.addElement(reportingGroupResourceData);
            nameList = nameList.nlNext;
        }
        serializable = new Vector();
        ((Vector)serializable).add(Util.getString("STG1216T"));
        ((Vector)serializable).add(Util.getString("STG1102L"));
        new ShowResource(vector, (Vector)serializable, 3);
    }

    public void addSelectedResources(NameList[] nameListArray) {
        JTree jTree = this.fsSelector.getSourceTree();
        jTree.expandRow(2);
        jTree.clearSelection();
        TreeSelector treeSelector = this.fsSelector.getTreeSelector();
        while (!this.fsSelector.getResourcesAvailable()) {
            System.out.println("Waiting for computer resources");
        }
        jTree.getSelectionModel();
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)jTree.getModel().getRoot();
        TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)treeSelectorNode.getChildAt(2);
        int n = 0;
        while (n < nameListArray.length) {
            System.out.println("Selected resources are:  " + nameListArray[n].toString());
            int n2 = nameListArray[n].nlID2;
            int n3 = 0;
            while (n3 < treeSelectorNode2.getChildCount()) {
                TreeSelectorNode treeSelectorNode3 = (TreeSelectorNode)treeSelectorNode2.getChildAt(n3);
                int n4 = ((NameList)treeSelectorNode3.getUserObject()).nlID;
                if (n4 == n2) {
                    int n5 = 0;
                    while (n5 < treeSelectorNode3.getChildCount()) {
                        TreeSelectorNode treeSelectorNode4 = (TreeSelectorNode)treeSelectorNode3.getChildAt(n5);
                        if (((NameList)treeSelectorNode4.getUserObject()).nlID == nameListArray[n].nlID) {
                            TreePath treePath = new TreePath(treeSelectorNode4.getPath());
                            jTree.addSelectionPath(treePath);
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            ++n;
        }
        if (jTree.getSelectionPaths() != null) {
            treeSelector.processSelections(jTree, this.fsSelector.getSelectedTree());
        }
        treeSelector.disableAddButton();
        jTree.setSelectionRow(0);
        jTree.requestFocus();
    }
}

