/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.Script;
import org.eclipse.aperi.TStorm.gui.GroupSelector;
import org.eclipse.aperi.TStorm.gui.JobAlertEditor;
import org.eclipse.aperi.TStorm.gui.ScriptOptions;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScriptCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    private CreateOrEditDDI ddi;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private GroupSelector selector;
    private ScriptOptions scriptDefiner;
    private JSgcScheduleCreateWhenData scheduleDefiner;
    private JobAlertEditor alertEditor;
    private static final int COMPUTER_TAB = 0;
    private static final int SCRIPT_TAB = 1;
    private static final int SCHEDULE_TAB = 2;
    private static final int ALERT_TAB = 3;

    public ScriptCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.ddi = createOrEditDDI;
        this.ddi.showEnabled = true;
        this.ddi.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.ddi.subType = "org.eclipse.aperi.server.handler.gui.GuiScriptHndlr";
    }

    public void build(int n) {
        this.submitRetrieve(n);
    }

    public void build(CreateHeader createHeader) {
        this.create((Script)createHeader);
    }

    private void submitRetrieve(int n) {
        Script script = new Script(this.ddi.nlInfo);
        script.ID = n;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiScriptHndlr", script);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            Script script = (Script)response.responseData;
            if (script.ID > 0) {
                this.ddi.oldCreateHeader = (CreateHeader)script.clone();
            }
            Arrays.sort(script.nameArray);
            this.create(script);
            this.getData();
            this.ddi.oldCreateHeader = (CreateHeader)script.clone();
        }
    }

    private void create(Script script) {
        this.createHeaderPanel = new CreateHeaderPanel(script, this, this.ddi);
        this.selector = new GroupSelector(1, script.scrComputers, script.scrComputerGroups, script.scrAllComputers, true, true);
        this.scriptDefiner = new ScriptOptions(script);
        this.scheduleDefiner = new JSgcScheduleCreateWhenData(this.ddi.nlInfo, this.ddi);
        JPanel jPanel = this.scheduleDefiner.build(script);
        this.alertEditor = script.scrAlert == null ? new JobAlertEditor(19) : new JobAlertEditor(19, script.scrAlert);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String string = MessageLog.getMessageNoID("STG4041L");
        this.tabs.addTab(string, this.selector.getComponent());
        string = MessageLog.getMessageNoID("STG5222L");
        this.tabs.addTab(string, this.scriptDefiner);
        string = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(string, jPanel);
        string = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(string, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.ddi.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.ddi.panel = this.createHeaderPanel;
        this.ddi.show();
        this.createHeaderPanel.gettingFocus();
        this.ddi.addObjectChangeListener(this, (short)0);
    }

    public CreateHeader getData() {
        this.scheduleDefiner.getData();
        Script script = (Script)this.createHeaderPanel.getData();
        NameList[] nameListArray = this.selector.getData();
        script.scrComputers = nameListArray[0];
        script.scrComputerGroups = nameListArray[1];
        script.scrAllComputers = this.selector.allMembersSelected;
        this.scriptDefiner.getData(script);
        script.scrAlert = this.alertEditor.getData();
        return script;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        Script script = (Script)createHeader;
        if (script.isEmpty()) {
            String string = MessageLog.getMessageNoTS("STG4048E", null);
            this.ddi.exceptionTabIndex = 0;
            throw new GeneralException(string);
        }
        this.ddi.exceptionTabIndex = 1;
        this.scriptDefiner.validateData(script);
        this.ddi.exceptionTabIndex = 2;
        this.scheduleDefiner.validate(script);
        this.ddi.exceptionTabIndex = 3;
        this.alertEditor.validateData();
    }

    public void replace(CreateHeader createHeader) {
        Script script = (Script)createHeader;
        this.createHeaderPanel.replace(script);
        this.scheduleDefiner.replace(script);
        this.selector.replace(script.scrComputers, script.scrComputerGroups, script.scrAllComputers);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
        this.tabs.setSelectedIndex(n);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.ddi.tabIndex = this.tabs.getSelectedIndex();
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n == 100) {
            this.selector.invalidateGroups(nameList.nlInfo);
        } else if (n == 1) {
            this.selector.addGroup(nameList);
        }
    }

    public String getHelpID(int n) {
        switch (n) {
            case 0: {
                return "pmsacaos";
            }
            case 1: {
                return "pmsasos";
            }
            case 2: {
                return "pmsawos";
            }
            case 3: {
                return "pmsaaos";
            }
        }
        return null;
    }
}

