/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;

public class StringMultipleFreeForm
extends FreeForm {
    public StringMultipleFreeForm(ColumnFilter columnFilter) {
        super(columnFilter);
    }

    private static boolean hasSpaces(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (!bl && n2 < n) {
            char c = string.charAt(n2);
            if (Character.isWhitespace(c)) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl;
    }

    public static char quoteAt(String string, int n) {
        char c = '\u0000';
        if (string.length() > n) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '\"': 
                case '\'': {
                    c = c2;
                }
            }
        }
        return c;
    }

    private static boolean startsWithQuote(String string) {
        return StringMultipleFreeForm.quoteAt(string, 0) != '\u0000';
    }

    private static boolean needsQuoting(String string) {
        return StringMultipleFreeForm.hasSpaces(string) || StringMultipleFreeForm.startsWithQuote(string);
    }

    public static void appendQuoted(StringBuffer stringBuffer, String string) {
        int n = string.length();
        int n2 = 0;
        stringBuffer.append('\"');
        while (n2 < n) {
            boolean bl;
            int n3 = string.indexOf(34, n2);
            boolean bl2 = bl = n3 >= 0;
            n3 = bl ? ++n3 : n;
            stringBuffer.append(string.substring(n2, n3));
            if (bl) {
                stringBuffer.append('\"');
            }
            n2 = n3;
        }
        stringBuffer.append('\"');
    }

    public void refresh() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(200);
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        while (columnFilterValue != null) {
            if (bl) {
                stringBuffer.append(' ');
            } else {
                bl = true;
            }
            Object object = columnFilterValue.fvValue;
            if (!(object instanceof String)) {
                stringBuffer.append("***ERROR***");
            } else {
                String string = (String)object;
                if (StringMultipleFreeForm.needsQuoting(string)) {
                    StringMultipleFreeForm.appendQuoted(stringBuffer, string);
                } else {
                    stringBuffer.append(string);
                }
            }
            columnFilterValue = columnFilterValue.fvNext;
        }
        this.textField.setText(stringBuffer.toString());
    }

    public static void breezeBySpace(String string, MutableInteger mutableInteger) {
        int n = string.length();
        boolean bl = true;
        while (bl && mutableInteger.value < n) {
            char c = string.charAt(mutableInteger.value);
            if (Character.isWhitespace(c)) {
                ++mutableInteger.value;
                continue;
            }
            bl = false;
        }
    }

    public static void breezeByNonSpace(String string, MutableInteger mutableInteger) {
        int n = string.length();
        boolean bl = true;
        while (bl && mutableInteger.value < n) {
            char c = string.charAt(mutableInteger.value);
            if (Character.isWhitespace(c)) {
                bl = false;
                continue;
            }
            ++mutableInteger.value;
        }
    }

    private static String quotedSegment(String string, MutableInteger mutableInteger, char c) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        ++mutableInteger.value;
        while (bl && mutableInteger.value < n) {
            int n2 = string.indexOf(c, mutableInteger.value);
            if (n2 < 0) {
                stringBuffer.append(string.substring(mutableInteger.value));
                mutableInteger.value = n;
                continue;
            }
            char c2 = n2 == n - 1 ? (char)' ' : (char)string.charAt(n2 + 1);
            int n3 = 1;
            if (Character.isWhitespace(c2)) {
                bl = false;
            } else {
                ++n2;
                if (c2 != c) {
                    n3 = 0;
                }
            }
            stringBuffer.append(string.substring(mutableInteger.value, n2));
            mutableInteger.value = n2 + n3;
        }
        return stringBuffer.toString();
    }

    private static String spaceDelimitedSegment(String string, MutableInteger mutableInteger) {
        int n = mutableInteger.value;
        StringMultipleFreeForm.breezeByNonSpace(string, mutableInteger);
        return string.substring(n, mutableInteger.value);
    }

    public void getData() throws GeneralException {
        this.ensureNonEmpty();
        ColumnFilterValue columnFilterValue = null;
        this.filter.clfValueList = null;
        String string = this.textField.getText();
        int n = string.length();
        MutableInteger mutableInteger = new MutableInteger();
        while (mutableInteger.value < n) {
            char c = StringMultipleFreeForm.quoteAt(string, mutableInteger.value);
            String string2 = c != '\u0000' ? StringMultipleFreeForm.quotedSegment(string, mutableInteger, c) : StringMultipleFreeForm.spaceDelimitedSegment(string, mutableInteger);
            ColumnFilterValue columnFilterValue2 = new ColumnFilterValue(string2);
            if (columnFilterValue != null) {
                columnFilterValue.fvNext = columnFilterValue2;
            } else {
                this.filter.clfValueList = columnFilterValue2;
            }
            columnFilterValue = columnFilterValue2;
            StringMultipleFreeForm.breezeBySpace(string, mutableInteger);
        }
    }
}

