/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import com.ibm.log.Level;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.StreamResponse;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.QueueController;

public class JobEngine
implements Observer {
    private static JobEngine engine = null;
    public static String className = JobEngine.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.JobEngine";
    public static final String TRACE_NAME = "aperi.logger.trace.JobEngine";
    public static String MSG_FILE = "org.eclipse.aperi.resources.JobEngineTMS";
    private Map<String, ArrayList> jobList = Collections.synchronizedMap(new Hashtable());
    private Map<String, ArrayList<String>> cFinishedRequests = Collections.synchronizedMap(new HashMap());
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public Observer observer = null;

    static {
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public static JobEngine getInstance() {
        String string = "getInstance()";
        if (engine == null) {
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
            }
            engine = new JobEngine();
        }
        return engine;
    }

    public void addObserver(Observer observer) {
        this.observer = observer;
    }

    public ArrayList getJobs() {
        ArrayList arrayList = new ArrayList();
        Iterator<String> iterator = this.jobList.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.jobList.get(iterator.next()));
        }
        return arrayList;
    }

    public ArrayList getJobs(String string) {
        ArrayList arrayList = this.jobList.get(string);
        if (arrayList != null) {
            return arrayList;
        }
        return new ArrayList();
    }

    public void waitTilComplete(String string) {
        System.currentTimeMillis();
        while (this.getJobStatus(string) != 2) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getJobStatus(String string) {
        ArrayList arrayList = this.getJobs(string);
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n3 = ((JobInfo)iterator.next()).getStatus();
            if (n3 == 1) {
                return n3;
            }
            if (n3 == 0) {
                ++n;
                continue;
            }
            if (n3 != 2 && n3 != 4) continue;
            ++n2;
        }
        if (arrayList.size() == n2) {
            return 2;
        }
        if (arrayList.size() == 0) {
            return 0;
        }
        return 1;
    }

    private JobEngine() {
    }

    public void addJob(JobInfo jobInfo) {
        jobInfo.addObserver(this);
        ArrayList<JobInfo> arrayList = this.jobList.get(jobInfo.getDiscoverRequest());
        if (arrayList == null) {
            arrayList = new ArrayList<JobInfo>();
            this.jobList.put(jobInfo.getDiscoverRequest(), arrayList);
        }
        arrayList.add(jobInfo);
        QueueController.getInstance().addJob(jobInfo);
    }

    public void removeJobs(String string) {
        ArrayList arrayList = this.getJobs(string);
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                JobInfo jobInfo = (JobInfo)arrayList.get(n);
                jobInfo.deleteObserver(this);
                ++n;
            }
        }
        this.jobList.remove(string);
    }

    public void update(Observable observable, Object object) {
        String string;
        block16: {
            string = "update()";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
            }
            if (observable instanceof JobInfo) {
                JobInfo jobInfo = (JobInfo)observable;
                try {
                    block15: {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(Level.DEBUG_MAX, this, string, jobInfo.toString());
                        }
                        if (jobInfo.isSuccessful()) {
                            JobInfo jobInfo2;
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_INFO, className, string, "Successful Completion of Job");
                            }
                            if ((jobInfo2 = jobInfo.getNextJob()) != null) {
                                this.addJob(jobInfo2);
                            }
                        } else if (jobInfo.getResponse() instanceof StreamResponse) {
                            InputStream inputStream = (InputStream)jobInfo.getResponse().getData();
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                            try {
                                String string2;
                                StringBuffer stringBuffer = new StringBuffer();
                                while ((string2 = bufferedReader.readLine()) != null) {
                                    stringBuffer.append(String.valueOf(string2) + " ");
                                }
                                if (traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_ERROR, className, string, stringBuffer.toString());
                                }
                                jobInfo.getResponse().close();
                            }
                            catch (Exception exception) {
                                if (!traceLogger.isLogging()) break block15;
                                traceLogger.exception(IRecordType.TYPE_ERROR, className, string, exception);
                            }
                        }
                    }
                    this.jobStatusChange(jobInfo);
                }
                catch (Exception exception) {
                    if (!traceLogger.isLogging()) break block16;
                    traceLogger.exception(IRecordType.TYPE_ERROR, className, string, exception);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public void replaceJob(JobInfo jobInfo, JobInfo jobInfo2) {
        String string = "replaceJob()";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        jobInfo.getRequest().close();
        jobInfo.replaceWith(jobInfo2);
        this.jobStatusChange(jobInfo);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    public void jobStatusChange(JobInfo jobInfo) {
        block4: {
            String string = "jobStatusChange";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, string, "Notifying listener that " + jobInfo + " has changed status");
            }
            try {
                if (this.observer != null) {
                    this.observer.update(null, jobInfo);
                }
            }
            catch (Throwable throwable) {
                if (!traceLogger.isLogging()) break block4;
                traceLogger.text(IRecordType.TYPE_ERROR, className, string, "Error notifying observer of job change for " + jobInfo);
                traceLogger.exception(IRecordType.TYPE_ERROR, className, string, throwable);
            }
        }
    }

    public void addFinishedRequests(String string, String string2) {
        ArrayList<String> arrayList = this.cFinishedRequests.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.cFinishedRequests.put(string, arrayList);
        }
        arrayList.add(string2);
    }

    public void cleanupRequestInformation(String string) {
        ArrayList<String> arrayList = this.cFinishedRequests.remove(string);
        if (arrayList != null) {
            for (String string2 : arrayList) {
                JobEngine.getInstance().removeJobs(string2);
            }
            arrayList.remove(string);
        }
    }
}

