/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.database.objects.Port;

public class ParameterHelper {
    public static Long[] convertToLong(long[] lArray) {
        Long[] longArray = null;
        try {
            if (lArray != null) {
                longArray = new Long[lArray.length];
                int n = 0;
                while (n < lArray.length) {
                    longArray[n] = new Long(lArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {}
        return longArray;
    }

    public static int getPortFromServiceUrl(String string) {
        int n = -1;
        if (!ParameterHelper.isValidServiceUrl(string)) {
            return n;
        }
        int n2 = string.lastIndexOf(":");
        String string2 = string.substring(n2 + 1);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    public static String hashtableToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = null;
        Object var3_3 = null;
        if (hashtable != null && !hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                var3_3 = hashtable.get(string);
                stringBuffer.append(String.valueOf(string) + " :");
                if (var3_3 instanceof String[]) {
                    stringBuffer.append(ParameterHelper.stringArrayToString(var3_3));
                    stringBuffer.append(" ,");
                    continue;
                }
                if (var3_3 instanceof String) {
                    stringBuffer.append((String)var3_3);
                    stringBuffer.append(" ,");
                    continue;
                }
                if (var3_3 instanceof Boolean) {
                    stringBuffer.append((Object)var3_3);
                    stringBuffer.append(" ,");
                    continue;
                }
                stringBuffer.append("No supported object");
            }
        }
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        String string = "";
        try {
            if (nArray != null && nArray.length != 0) {
                int n = 0;
                while (n < nArray.length) {
                    string = String.valueOf(string) + nArray[n] + ", ";
                    ++n;
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public static String longArrayToString(long[] lArray) {
        String string = "";
        try {
            if (lArray != null && lArray.length != 0) {
                int n = 0;
                while (n < lArray.length) {
                    string = String.valueOf(string) + lArray[n] + ", ";
                    ++n;
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public static String stringArrayToString(String[] stringArray) {
        String string = "";
        try {
            if (stringArray != null && stringArray.length != 0) {
                int n = 0;
                while (n < stringArray.length) {
                    string = String.valueOf(string) + stringArray[n] + ", ";
                    ++n;
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public boolean isValidIP(String string) {
        char[] cArray = string.toCharArray();
        char c = '.';
        char c2 = '-';
        char c3 = '_';
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != c && cArray[n] != c2 && cArray[n] != c3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getIpFromServiceUrl(String string) {
        if (!ParameterHelper.isValidServiceUrl(string)) {
            return null;
        }
        int n = string.indexOf(":");
        int n2 = string.lastIndexOf(":");
        String string2 = string.substring(n + 3, n2 - 1);
        return string2;
    }

    public static boolean isValidServiceUrl(String string) {
        boolean bl = false;
        if (string.indexOf(":") != string.lastIndexOf(":") && string.startsWith("http") && string.indexOf("//") > 0 && string.lastIndexOf(":") == string.length() - 4) {
            bl = true;
        }
        return bl;
    }

    public static int[] convertTointArray(String string) {
        int[] nArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            nArray[n] = Integer.parseInt(string2);
            ++n;
        }
        return nArray;
    }

    public static String[] convertToStringArray(String string) {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final ConfigData readConfigData(DBConnection dBConnection, String string, LogTraceHelper logTraceHelper) {
        ConfigData configData = null;
        try {
            if (dBConnection != null && string != null) {
                configData = new ConfigData();
                configData.setAttribute(string);
                boolean bl = configData.retrieve(dBConnection);
                if (!bl) {
                    configData = null;
                }
            }
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceInfo("No retrieved parameter " + string + " from ConfigData ");
        }
        return configData;
    }

    public static boolean listContainsStringIgnoreCase(List list, String string) {
        if (list != null && string != null) {
            int n = 0;
            while (n < list.size()) {
                if (list.get(n).toString().equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static String getPortIgnoreCase(String string, DBConnection dBConnection) throws EntityNotFoundException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(ParameterHelper.class.getName(), "getPortIgnoreCase", new Object[]{string, dBConnection});
        String string2 = null;
        try {
            try {
                ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(Port.class, "NAME", logTraceHelper);
                String string3 = "SELECT " + columnInfo.getName() + " FROM " + columnInfo.getTableName() + " WHERE UPPER(" + columnInfo.getName() + ") = UPPER('" + string + "')";
                Statement statement = dBConnection.getConnection().createStatement();
                ResultSet resultSet = statement.executeQuery(string3);
                if (!resultSet.next()) {
                    resultSet.close();
                    throw new EntityNotFoundException(null, string);
                }
                string2 = (String)resultSet.getObject(columnInfo.getName());
                resultSet.close();
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Internal error: SQLException", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            try {
                dBConnection.commit();
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Internal error exception during commit", exception);
            }
            logTraceHelper.exit(string2);
            throw throwable;
        }
        try {
            dBConnection.commit();
        }
        catch (Exception exception) {
            logTraceHelper.traceError("Internal error exception during commit", exception);
        }
        logTraceHelper.exit(string2);
        return string2;
    }
}

