/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DoubleLineBorder;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.UilButtonPanelBean;

public class PrintPreviewPanel
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener {
    private PrintPreviewable printable;
    private int pageWidth;
    private int pageHeight;
    private int zoom = 25;
    private int scale = 100;
    private boolean isPortrait = true;
    private Dimension currentSize = null;
    private JComboBox zoomBox;
    private JComboBox scaleBox;
    private JRadioButton portraitButton;
    private JRadioButton landscapeButton;
    private JComboBox paperSize;
    private JButton printButton;
    private JButton closeButton;
    private JButton sizeToFitButton;
    private PrintPreviewLayout layout;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private JScrollPane scrollPane;
    private GridBagPanel toolBar;
    private boolean allowScaling = true;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public PrintPreviewPanel(PrintPreviewable printPreviewable, boolean bl) {
        this(printPreviewable, "", bl);
    }

    public PrintPreviewPanel(PrintPreviewable printPreviewable, String string, boolean bl) {
        super(string);
        this.setIconImage(this.guiMain.getFrame().getIconImage());
        this.printable = printPreviewable;
        this.allowScaling = bl;
        this.buildGUI();
    }

    private void buildGUI() {
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.addComponentListener(this);
        this.addWindowListener(this);
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
            this.remove(this.toolBar);
        }
        this.toolBar = new GridBagPanel(new Insets(3, 3, 3, 0));
        this.toolBar.setDefaultAnchor(21);
        UilButtonPanelBean uilButtonPanelBean = new UilButtonPanelBean();
        uilButtonPanelBean.setSpacerSize(5);
        uilButtonPanelBean.setIncrementWidth(1);
        this.printButton = new JButton(Util.getString("LABEL_PRINT_BUTTON"));
        this.printButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PRINT_BUTTON"));
        this.printButton.addActionListener(this);
        uilButtonPanelBean.add(this.printButton);
        this.toolBar.add(uilButtonPanelBean);
        this.addSeparator(this.toolBar);
        JLabel jLabel = new JLabel(Util.getString("LABEL_ZOOM_BOX"));
        String[] stringArray = new String[]{"10%", "25%", "50%", "75%", "100%"};
        this.zoomBox = new JComboBox<String>(stringArray);
        this.zoomBox.setEditable(true);
        this.zoomBox.setSelectedItem(String.valueOf(Integer.toString(this.zoom)) + "%");
        jLabel.setLabelFor(this.zoomBox);
        jLabel.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_ZOOM_BOX"));
        this.zoom = this.getInt(this.zoomBox.getSelectedItem().toString());
        this.zoomBox.addActionListener(this);
        this.zoomBox.setMaximumSize(this.zoomBox.getPreferredSize());
        Insets insets = new Insets(3, 3, 3, 0);
        Insets insets2 = new Insets(3, 0, 3, 5);
        this.toolBar.add((JComponent)jLabel, insets);
        this.toolBar.add((JComponent)this.zoomBox, insets2);
        this.addSeparator(this.toolBar);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.portraitButton = new JRadioButton(Util.getString("LABEL_PORTRAIT_BUTTON"));
        this.portraitButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PORTRAIT_BUTTON"));
        this.portraitButton.addActionListener(this);
        this.landscapeButton = new JRadioButton(Util.getString("LABEL_LANDSCAPE_BUTTON"));
        this.landscapeButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_LANDSCAPE_BUTTON"));
        this.landscapeButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.portraitButton);
        jPanel.add(this.landscapeButton);
        this.toolBar.add(jPanel);
        buttonGroup.add(this.portraitButton);
        buttonGroup.add(this.landscapeButton);
        this.portraitButton.setSelected(this.isPortrait);
        this.landscapeButton.setSelected(!this.isPortrait);
        this.addSeparator(this.toolBar);
        this.closeButton = new JButton(Util.getString("LABEL_CLOSE_BUTTON"));
        this.closeButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CLOSE_BUTTON"));
        this.closeButton.addActionListener(this);
        uilButtonPanelBean = new UilButtonPanelBean();
        uilButtonPanelBean.setSpacerSize(5);
        uilButtonPanelBean.setIncrementWidth(1);
        uilButtonPanelBean.add(this.closeButton);
        this.toolBar.add(uilButtonPanelBean);
        this.toolBar.createStretchBox();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.layout = new PrintPreviewLayout();
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = this.printerJob.defaultPage();
            this.pageFormat = this.printerJob.pageDialog(pageFormat);
            if (this.pageFormat == pageFormat) {
                this.cleanupResources();
                return;
            }
        }
        if (this.pageFormat.getOrientation() == 1) {
            this.portraitButton.setSelected(true);
            this.isPortrait = true;
        } else {
            this.landscapeButton.setSelected(true);
            this.isPortrait = false;
        }
        if (this.pageFormat.getHeight() <= 0.0 || this.pageFormat.getWidth() <= 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.pageHeight = (int)this.pageFormat.getHeight();
        this.pageWidth = (int)this.pageFormat.getWidth();
        int n = this.pageWidth * this.zoom / 100;
        int n2 = this.pageHeight * this.zoom / 100;
        int n3 = 0;
        try {
            while (true) {
                BufferedImage bufferedImage = new BufferedImage(this.pageWidth, this.pageHeight, 1);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.pageWidth, this.pageHeight);
                if (this.printable.print(graphics, this.pageFormat, n3) == 0) {
                    PrintPreviewPage printPreviewPage = new PrintPreviewPage(n, n2, bufferedImage);
                    this.layout.add(printPreviewPage);
                    ++n3;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            System.err.println("Unable to create Print Preview: " + printerException.toString());
        }
        this.scrollPane = new JScrollPane(this.layout);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.toolBar.setMinimumSize(this.toolBar.getPreferredSize());
        if (this.currentSize == null) {
            this.pack();
        } else {
            this.setSize(this.currentSize);
        }
        GuiUtil.centerDialog(this);
        this.getRootPane().setDefaultButton(this.printButton);
        this.invalidate();
        this.validate();
        this.setVisible(true);
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void addSeparator(GridBagPanel gridBagPanel) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new DoubleLineBorder(null, Color.black, 1));
        gridBagPanel.add((JComponent)jPanel, 3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.printButton) {
            this.printerJob.setPageable(this.printable);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (this.printerJob.printDialog()) {
                try {
                    this.printerJob.print();
                }
                catch (PrinterException printerException) {
                    System.err.println(printerException.getMessage());
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        } else if (object == this.closeButton) {
            this.cleanupResources();
        } else if (object == this.zoomBox) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.currentSize = this.getSize();
            Thread thread = new Thread(){

                public void run() {
                    PrintPreviewPanel.this.zoom = PrintPreviewPanel.this.getInt(PrintPreviewPanel.this.zoomBox.getSelectedItem().toString());
                    int n = PrintPreviewPanel.this.pageWidth * PrintPreviewPanel.this.zoom / 100;
                    int n2 = PrintPreviewPanel.this.pageHeight * PrintPreviewPanel.this.zoom / 100;
                    Component[] componentArray = PrintPreviewPanel.this.layout.getComponents();
                    int n3 = 0;
                    while (n3 < componentArray.length) {
                        if (componentArray[n3] instanceof PrintPreviewPage) {
                            PrintPreviewPage printPreviewPage = (PrintPreviewPage)componentArray[n3];
                            printPreviewPage.setScaledSize(n, n2);
                        }
                        ++n3;
                    }
                    PrintPreviewPanel.this.layout.doLayout();
                    PrintPreviewPanel.this.layout.getParent().getParent().validate();
                    PrintPreviewPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    PrintPreviewPanel.this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            thread.start();
        } else if (object == this.scaleBox) {
            this.currentSize = this.getSize();
            this.scale = this.getInt(this.scaleBox.getSelectedItem().toString());
            this.printable.setScale(this.scale);
            this.scaleBox.hidePopup();
            this.refreshGUI();
        } else if (object == this.sizeToFitButton) {
            this.currentSize = this.getSize();
            this.scale = this.printable.fitToPage(this.pageFormat);
            String string = String.valueOf(this.scale) + "%";
            this.scaleBox.addItem(string);
            this.scaleBox.setSelectedItem(string);
            this.refreshGUI();
        } else if (object == this.portraitButton) {
            if (this.isPortrait) {
                return;
            }
            this.currentSize = this.getSize();
            this.pageFormat.setOrientation(1);
            this.isPortrait = true;
            this.refreshGUI();
        } else if (object == this.landscapeButton) {
            if (!this.isPortrait) {
                return;
            }
            this.currentSize = this.getSize();
            this.pageFormat.setOrientation(0);
            this.isPortrait = false;
            this.refreshGUI();
        }
    }

    private void refreshGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.currentSize = this.getSize();
        this.setVisible(false);
        this.buildGUI();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    private int getInt(String string) {
        int n = 100;
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    private void cleanupResources() {
        this.printable.setScale(100);
        this.zoom = 25;
        this.scale = 100;
        this.printable.setBufferedImage(null);
        this.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cleanupResources();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = this.getPreferredSize().width;
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        if (n2 < n) {
            this.setSize(new Dimension(n, n3));
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    class PrintPreviewLayout
    extends JPanel {
        private int H_GAP = 16;
        private int V_GAP = 10;
        private int childHeight = 0;
        private int childWidth = 0;
        private Dimension preferredSize = null;

        PrintPreviewLayout() {
        }

        public Dimension getPreferredSize() {
            int n;
            int n2;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            this.childWidth = dimension.width;
            this.childHeight = dimension.height;
            int n4 = this.getParent().getSize().width;
            if (n4 == 0) {
                n4 = 640;
            }
            if ((n2 = n3 / (n = Math.max((n4 - this.H_GAP) / (this.childWidth + this.H_GAP), 1))) * n < n3) {
                ++n2;
            }
            int n5 = n * (this.childWidth + this.H_GAP) + this.H_GAP;
            int n6 = n2 * (this.childHeight + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            this.preferredSize = new Dimension(n5 + insets.left + insets.right, n6 + insets.top + insets.bottom);
            return this.preferredSize;
        }

        public Dimension getMaximumSize() {
            if (this.preferredSize != null) {
                return this.preferredSize;
            }
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.preferredSize != null) {
                return this.preferredSize;
            }
            return this.getPreferredSize();
        }

        public void doLayout() {
            int n;
            int n2;
            Insets insets = this.getInsets();
            int n3 = insets.left + this.H_GAP;
            int n4 = insets.top + this.V_GAP;
            int n5 = this.getComponentCount();
            if (n5 == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n6 = dimension.width;
            int n7 = dimension.height;
            int n8 = this.getParent().getSize().width;
            if (n8 == 0) {
                n8 = this.getParent().getPreferredSize().width;
            }
            if ((n2 = n5 / (n = Math.max((n8 - this.H_GAP) / (n6 + this.H_GAP), 1))) * n < n5) {
                ++n2;
            }
            int n9 = 0;
            int n10 = 0;
            while (n10 < n2) {
                int n11 = 0;
                while (n11 < n) {
                    if (n9 >= n5) {
                        return;
                    }
                    component = this.getComponent(n9++);
                    component.setBounds(n3, n4, n6, n7);
                    n3 += n6 + this.H_GAP;
                    ++n11;
                }
                n4 += n7 + this.V_GAP;
                n3 = insets.left + this.H_GAP;
                ++n10;
            }
        }
    }

    class PrintPreviewPage
    extends JPanel {
        private int width;
        private int height;
        private Image sourceImg;
        private Image scaledImg;

        public PrintPreviewPage(int n, int n2, Image image) {
            this.width = n;
            this.height = n2;
            this.sourceImg = image;
            this.scaledImg = this.sourceImg.getScaledInstance(this.width, this.height, 4);
            this.scaledImg.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.scaledImg = this.sourceImg.getScaledInstance(this.width, this.height, 4);
            this.scaledImg.flush();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.width + insets.left + insets.right, this.height + insets.top + insets.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.drawImage(this.scaledImg, 0, 0, this);
            this.paintBorder(graphics);
        }
    }
}

