/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.xmsg.MessageLog;

public class TCloseTabPane
extends JTabbedPane
implements TabCloseListener {
    public Vector keepOpenList;
    public Vector tabListenerList;
    private Mouser mouser;
    private TCloseTabPane tabPanel;
    private int mouseIndex = 0;

    public TCloseTabPane() {
        this.setupTabs();
    }

    public TCloseTabPane(int n) {
        super(n);
        this.setupTabs();
    }

    public TCloseTabPane(int n, int n2) {
        super(n, n2);
        this.setupTabs();
    }

    private void setupTabs() {
        this.setFont(BaseTree.boldFont);
        this.keepOpenList = new Vector();
        this.tabListenerList = new Vector();
        this.addMouser();
    }

    private void addToKeepOpenList(boolean bl) {
        int n = this.getTabCount();
        if (n == 1) {
            this.keepOpenList.add(new Boolean(true));
        } else if (n > 1) {
            if (!bl) {
                this.keepOpenList.add(new Boolean(true));
            } else {
                this.keepOpenList.add(new Boolean(false));
            }
        }
    }

    private void addMouser() {
        this.mouser = new Mouser(this);
        this.addMouseListener(this.mouser);
    }

    public void addTab(String string, Component component, String string2) {
        super.addTab(string, null, component, string2);
        this.addToKeepOpenList(true);
        this.tabListenerList.add(this);
    }

    public void addTab(String string, Component component, String string2, boolean bl) {
        super.addTab(string, null, component, string2);
        this.addToKeepOpenList(bl);
        this.tabListenerList.add(this);
    }

    public void addTab(String string, Component component, String string2, boolean bl, TabCloseListener tabCloseListener) {
        super.addTab(string, null, component, string2);
        this.addToKeepOpenList(bl);
        this.tabListenerList.add(tabCloseListener);
    }

    public void addTabCloseListener(TabCloseListener tabCloseListener, int n) {
        this.tabListenerList.set(n, tabCloseListener);
    }

    public boolean closeTab(int n) {
        this.removeTabAt(n);
        this.tabListenerList.remove(this.mouseIndex);
        this.keepOpenList.remove(this.mouseIndex);
        return false;
    }

    private class Mouser
    extends MouseAdapter
    implements ActionListener {
        TCloseTabPane tabPanel;

        public Mouser(TCloseTabPane tCloseTabPane2) {
            this.tabPanel = tCloseTabPane2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        private void checkPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Boolean bl;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TCloseTabPane.this.mouseIndex = TCloseTabPane.this.getUI().tabForCoordinate(this.tabPanel, n, n2);
                if (TCloseTabPane.this.mouseIndex > 0 && !(bl = (Boolean)TCloseTabPane.this.keepOpenList.elementAt(TCloseTabPane.this.mouseIndex)).booleanValue()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("GUI5008L"));
                    jMenuItem.setActionCommand("CloseTab");
                    jMenuItem.addActionListener(this);
                    jPopupMenu.show(this.tabPanel, n, n2);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabCloseListener tabCloseListener;
            boolean bl;
            if (actionEvent.getActionCommand() == "CloseTab" && (bl = (tabCloseListener = (TabCloseListener)TCloseTabPane.this.tabListenerList.get(TCloseTabPane.this.mouseIndex)) != null ? tabCloseListener.closeTab(TCloseTabPane.this.mouseIndex) : true)) {
                this.tabPanel.removeTabAt(TCloseTabPane.this.mouseIndex);
                TCloseTabPane.this.tabListenerList.remove(TCloseTabPane.this.mouseIndex);
                TCloseTabPane.this.keepOpenList.remove(TCloseTabPane.this.mouseIndex);
            }
        }
    }
}

