/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.LogViewerDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.InbandFabricAgentDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class InbandFabricAgentTreeNode
extends AgentTreeNode
implements GuiRequestor,
ActionListener {
    private String node_name;
    private int node_id;
    private int node_state;
    private JPopupMenu popup;
    private static String checkMenuItemString;
    private static String viewLogMenuItemString;
    private static String removeMenuItemString;
    private static String refreshMenuItemString;

    public InbandFabricAgentTreeNode(Object object, int n, byte by) {
        super(object, n, by);
        this.node_name = (String)object;
        this.node_id = n;
        this.node_state = by;
        this.setUserObject(object);
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        switch (this.node_state) {
            case 1: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateUpIcon());
                break;
            }
            case 0: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateDownIcon());
            }
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.popup = this.getPopupMenu();
        checkMenuItemString = FabricGuiUtil.getString("FabricInBand_Check");
        JMenuItem jMenuItem = new JMenuItem(checkMenuItemString);
        jMenuItem.setActionCommand(checkMenuItemString);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(true);
        this.popup.add(jMenuItem);
        viewLogMenuItemString = FabricGuiUtil.getString("FabricInBand_ViewLog");
        JMenuItem jMenuItem2 = new JMenuItem(viewLogMenuItemString);
        jMenuItem2.setActionCommand(viewLogMenuItemString);
        jMenuItem2.addActionListener(this);
        if (this.node_state == 1) {
            jMenuItem2.setEnabled(true);
            this.popup.add(jMenuItem2);
        }
        removeMenuItemString = MessageLog.getMessageNoID("ADG0262L");
        JMenuItem jMenuItem3 = new JMenuItem(removeMenuItemString);
        jMenuItem3.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        jMenuItem3.setActionCommand(removeMenuItemString);
        jMenuItem3.addActionListener(this);
        jMenuItem3.setEnabled(true);
        this.popup.add(jMenuItem3);
        refreshMenuItemString = MessageLog.getMessageNoID("ADG0003L");
        JMenuItem jMenuItem4 = new JMenuItem(refreshMenuItemString);
        jMenuItem4.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        jMenuItem4.setActionCommand(refreshMenuItemString);
        jMenuItem4.addActionListener(this);
        jMenuItem4.setEnabled(true);
        this.popup.add(jMenuItem4);
        super.showPopupMenu(this.popup, mouseEvent);
    }

    public void setNodeIconBasedOnStatusFromServer(int n) {
        this.node_state = n;
        BaseTree.MyTree.nodeChanged(this);
    }

    public void handleResponse(short s, Response response) {
        block10: {
            block9: {
                if (s != 0) break block9;
                InbandFabricAgentInfo inbandFabricAgentInfo = (InbandFabricAgentInfo)response.responseData;
                switch (inbandFabricAgentInfo.request_type) {
                    case 3: {
                        this.setNodeIconBasedOnStatusFromServer(inbandFabricAgentInfo.status);
                        if (inbandFabricAgentInfo.status == 1) {
                            String string = MessageLog.getMessageNoID("ADG0294M", this.node_name);
                            JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                            break;
                        }
                        String string = String.valueOf(this.node_name) + " " + FabricGuiUtil.getInbandFabricAgentStatusString(inbandFabricAgentInfo.status);
                        JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                        break;
                    }
                    case 2: {
                        BaseTree.MyTree.removeNodeFromParent(this);
                        if (this.ddi == null) break block10;
                        this.ddi.remove();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block10;
            }
            if (s == 12 && response.responseData != null) {
                InbandFabricAgentInfo inbandFabricAgentInfo = (InbandFabricAgentInfo)response.responseData;
                if (inbandFabricAgentInfo.request_type == 3 && inbandFabricAgentInfo.message_status == 2) {
                    BaseTree.MyTree.removeNodeFromParent(this);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(checkMenuItemString)) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
            request.requestData = inbandFabricAgentInfo;
            request.flags = (byte)4;
            inbandFabricAgentInfo.request_type = 3;
            inbandFabricAgentInfo.hostname = this.node_name;
            inbandFabricAgentInfo.hostId = this.node_id;
            GuiClient.doRequest(this, request);
        } else if (string.equals(removeMenuItemString)) {
            if (this.node_state == 0) {
                String string2 = Util.getString("CONFIRM_DELETE", this.node_name);
                String string3 = MessageLog.getMessageNoID("ADG0262L");
                int n = JOptionPane.showConfirmDialog(guiMain.getFrame(), string2, string3, 0, 2);
                if (n == 0) {
                    Request request = new Request();
                    request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                    request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
                    request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
                    request.userName = GuiUtil.getUserName();
                    InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
                    request.requestData = inbandFabricAgentInfo;
                    request.flags = (byte)4;
                    inbandFabricAgentInfo.request_type = 2;
                    inbandFabricAgentInfo.hostId = this.node_id;
                    GuiClient.doRequest(this, request);
                }
            } else {
                String[] stringArray = new String[]{this.node_name, FabricGuiUtil.getInbandFabricAgentStatusString(this.node_state), FabricGuiUtil.getInbandFabricAgentStatusString(0)};
                String string4 = Util.getString("FMSG_InBand_RemoveInvalidState", stringArray);
                String string5 = FabricGuiUtil.getString("FabricInBand_RemoveErrorTitle");
                JOptionPane.showMessageDialog(guiMain.getFrame(), string4, string5, 0);
            }
        } else if (string.equals(viewLogMenuItemString)) {
            new LogViewer(this.node_id, (BaseTreeNode)this, LogViewerDDI.AGENT_INBAND);
        } else if (string.equals(refreshMenuItemString)) {
            this.refresh();
        }
    }

    private void refresh() {
        if (this.ddi == null) {
            InbandFabricAgentDDI inbandFabricAgentDDI = new InbandFabricAgentDDI(this.node_name, this.node_id);
            this.ddi = inbandFabricAgentDDI;
            this.ddi.treeNode = this;
            this.ddi.setDescription(String.valueOf(MessageLog.getMessageNoID("ADG0201L")) + ":  " + this.getUserObject());
        }
        this.ddi.reDisplay();
        BaseTree.MyTree.nodeChanged(this);
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.refresh();
    }
}

