/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JLabel;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.IListTableModel;
import org.eclipse.aperi.gui.admin.agent.UtilsTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.config.service.ServiceConfigTab;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataAgentTableModel
extends BaseTableModel
implements IListTableModel {
    private Hashtable agentsHash;
    public final String[] COL_NAMES = new String[]{GuiUtil.getString("CONFIG_COMMON_TABLE_COL_AGENT"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_IP"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_STATE"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_MANUFACTURER"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_CPU"), GuiUtil.getString("CONFIG_COMMON_TABLE_COL_OS_TYPE")};
    public static final int DS_NAME = 0;
    public static final int DS_IP = 1;
    public static final int DS_STATE = 2;
    public static final int DS_MANUFACTURER = 3;
    public static final int DS_CPU = 4;
    public static final int DS_OS = 5;
    public ArrayList computers = null;
    public ArrayList agents = null;

    public DataAgentTableModel(ArrayList arrayList, ArrayList arrayList2) {
        this.computers = arrayList;
        this.agents = arrayList2;
        this.columnNames = this.COL_NAMES;
        this.rowCount = arrayList != null ? arrayList.size() : 0;
        this.agentsHash = new Hashtable();
        int n = 0;
        while (n < this.rowCount) {
            Integer n2 = new Integer(((NameList)this.agents.get((int)n)).nlID);
            this.agentsHash.put(n2, n);
            ++n;
        }
    }

    public DataAgentTableModel() {
        this(new ArrayList(), new ArrayList());
    }

    public Object getTableDataItem(int n, int n2) {
        try {
            GComputer gComputer = (GComputer)this.computers.get(n);
            NameList nameList = (NameList)this.agents.get(n);
            switch (n2) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(gComputer.gcTSName);
                }
                case 1: {
                    return GUIEntityUtil.getDisplayText(gComputer.gcIpAddress);
                }
                case 2: {
                    switch (nameList.nlState) {
                        case 2: {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_AGENT_STATUS_DEFECTED"), ServiceConfigTab.ICON_DEFECTED, 10);
                        }
                        case 1: {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_AGENT_STATUS_UP"), ServiceConfigTab.ICON_UP, 10);
                        }
                        case 0: {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_AGENT_STATUS_DOWN"), ServiceConfigTab.ICON_DOWN, 10);
                        }
                        case 3: {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_AGENT_STATUS_UPGRADE"), ServiceConfigTab.ICON_UPGRADE, 10);
                        }
                        case 4: {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_AGENT_STATUS_UNREACHABLE"), ServiceConfigTab.ICON_UNREACHABLE, 10);
                        }
                        case 5: {
                            return new JLabel(GuiUtil.getString("CONFIG_COMMON_AGENT_STATUS_UPGRADE_NEEDED"), ServiceConfigTab.ICON_UPGRADE_NEEDED, 10);
                        }
                    }
                }
                case 3: {
                    return GUIEntityUtil.getDisplayText(gComputer.gcManufacturer);
                }
                case 5: {
                    return GUIEntityUtil.getDisplayText(MessageLog.getMessageNoID(Constants.OSTYPES[gComputer.gcOsType]));
                }
                case 4: {
                    return GUIEntityUtil.getDisplayText(ComputersAdjuster.getCPUArchString(gComputer.gcCPUArchitecture));
                }
            }
            return "";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    public void refreshAgent(NameList nameList) {
        Integer n = (Integer)this.agentsHash.get(new Integer(nameList.nlID));
        if (n != null) {
            this.agents.set(n, nameList);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void refreshAgents(short s, Response response, boolean bl, AgentListDDI agentListDDI) {
        NameList nameList = null;
        ArrayList<GComputer> arrayList = new ArrayList<GComputer>();
        ArrayList<NameList> arrayList2 = new ArrayList<NameList>();
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        if (s <= 4) {
            int n2 = this.agents.size();
            boolean[] blArray = new boolean[n2];
            nameList = (NameList)response.responseData;
            while (nameList != null) {
                NameList nameList2 = nameList.nlNext;
                nameList.nlNext = null;
                Integer n3 = (Integer)this.agentsHash.get(new Integer(nameList.nlID));
                if (n3 != null) {
                    n = n3;
                    blArray[n] = true;
                    this.agents.set(n, nameList);
                    this.computers.set(n, GuiUtil.getComputer(nameList.nlID));
                } else {
                    arrayList2.add(nameList);
                    arrayList.add(GuiUtil.getComputer(nameList.nlID));
                }
                nameList = nameList2;
            }
            n = 0;
            while (n < blArray.length) {
                if (!blArray[n]) {
                    arrayList3.add(this.agents.get(n));
                }
                ++n;
            }
            if (arrayList3.size() > 0 || arrayList2.size() > 0) {
                UtilsTableModel.removeAndAddAgents(arrayList3, arrayList2, arrayList, false, this);
            }
            if (bl) {
                this.fireTableDataChanged();
            }
            if (agentListDDI != null) {
                agentListDDI.setLastRefreshTime(true);
            }
        } else if (agentListDDI != null) {
            agentListDDI.setLastRefreshTime(false);
        }
    }

    public int getNumRows() {
        return this.agents.size();
    }

    public int getRowCount() {
        return this.agents.size();
    }

    public Object elementAt(int n) {
        return this.agents.get(n);
    }

    public Integer getPosForAgent(Object object) {
        if (object == null) {
            return null;
        }
        Integer n = new Integer(((NameList)object).nlID);
        return (Integer)this.agentsHash.get(n);
    }

    public Object getAgentInfoAt(int n) {
        return this.computers.get(n);
    }

    public void removeAgentAt(int n) {
        NameList nameList = (NameList)this.agents.get(n);
        this.agents.remove(n);
        this.computers.remove(n);
        this.agentsHash.remove(new Integer(nameList.nlID));
    }

    public void addAgents(int n, Collection collection, Collection collection2) {
        if (collection == null) {
            return;
        }
        this.agents.addAll(n, collection);
        this.computers.addAll(n, collection2);
    }

    public void rehashAgent(Object object, Integer n) {
        if (object == null || n == null) {
            return;
        }
        Integer n2 = new Integer(((NameList)object).nlID);
        this.agentsHash.put(n2, n);
    }

    public void clear(boolean bl) {
        this.agents.clear();
        this.computers.clear();
        if (!bl) {
            this.agentsHash.clear();
        }
    }

    public void fireTableRowsInserted(int n, int n2) {
        super.fireTableRowsInserted(n, n2);
    }

    public void fireTableRowsDeleted(int n, int n2) {
        super.fireTableRowsDeleted(n, n2);
    }
}

