/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.common.HashMapDetailsPanel;

public class EditElementManagerConfigDialog
extends JDialog
implements ActionListener,
DirtyListenerInterface {
    HashMapDetailsPanel hashMapPanel;
    private static final String CANCEL_ACTION = Util.getString("LABEL_CANCEL");
    private static final String SAVE_ACTION = Util.getString("LABEL_SAVE");
    private static final String RESET_ACTION = Util.getString("LABEL_RESET");
    private JButton saveButton;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public EditElementManagerConfigDialog(Frame frame) throws HeadlessException {
        super(frame, Util.getString("ELEMENT_MANAGER_CONFIG_DIALOG_TITLE"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.buildPanel(this.getContentPane());
        this.enableHelp();
        this.pack();
        GuiUtil.centerDialog(this);
        this.setVisible(true);
    }

    private void enableHelp() {
        Help.setHelpID(this.getRootPane(), "adm_dlg_cfg_configureelementlauncher");
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    private void buildPanel(Container container) {
        this.hashMapPanel = new HashMapDetailsPanel(ElementManagerManager.getInstance().getConfig());
        this.hashMapPanel.makeAllEditable();
        this.hashMapPanel.addDirtyListener(this);
        container.add((Component)this.hashMapPanel, "North");
        container.add((Component)this.buildButtonPanel(), "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getActionCommand().equals(SAVE_ACTION)) {
            bl = ElementManagerManager.getInstance().setConfig(this.hashMapPanel.getModel());
            if (bl) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (actionEvent.getActionCommand().equals(RESET_ACTION)) {
            bl = ElementManagerManager.getInstance().setConfig(null);
            if (bl) {
                this.setVisible(false);
                this.dispose();
                new EditElementManagerConfigDialog(this.guiMain.getFrame());
            }
        } else if (actionEvent.getActionCommand().equals(CANCEL_ACTION)) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.saveButton = this.buildButton(SAVE_ACTION);
        this.saveButton.setEnabled(false);
        jPanel.add(this.saveButton);
        jPanel.add(this.buildButton(CANCEL_ACTION));
        jPanel.add(this.buildButton(RESET_ACTION));
        return jPanel;
    }

    private JButton buildButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        jButton.setEnabled(true);
        GuiUtil.setAccessible(jButton, jButton.getText(), jButton.getText());
        return jButton;
    }

    public void dirtyTalk(JComponent jComponent, String string) {
        this.saveButton.setEnabled(true);
    }
}

