/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;

public class HashMapDetailsPanel
extends JPanel
implements ActionListener,
DocumentListener {
    HashMap model = new HashMap();
    private static final String FIELD = "MAP_FIELD";
    private DirtyListenerInterface dirtyListener = null;

    public HashMapDetailsPanel(HashMap hashMap) {
        this.buildPanel(hashMap);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.talkDirty(actionEvent.getActionCommand());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.talkDirty((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.talkDirty((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.talkDirty((String)documentEvent.getDocument().getProperty(FIELD));
    }

    private void makeNonEditable(JTextField jTextField) {
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        jTextField.setFont(this.getFont().deriveFont(1));
        jTextField.setForeground(Color.black);
    }

    private void makeEditable(JTextField jTextField) {
        jTextField.setEditable(true);
        jTextField.setBorder(BorderFactory.createBevelBorder(1));
        jTextField.setFont(this.getFont().deriveFont(0));
        jTextField.setForeground(Color.black);
    }

    private JTextField getTextFieldFromRow(String string) {
        return (JTextField)this.model.get(string);
    }

    protected void makeAllEditable() {
        for (Object k : this.model.keySet()) {
            this.makeEditable(this.getTextFieldFromRow((String)k));
        }
    }

    public void makeEditable(String string) {
        this.makeEditable(this.getTextFieldFromRow(string));
    }

    public void makeNonEditable(String string) {
        this.makeNonEditable(this.getTextFieldFromRow(string));
    }

    private void buildRow(GridBagPanel gridBagPanel, String string, String string2) {
        JTextField jTextField = new JTextField(string2);
        jTextField.setColumns(30);
        if (string2 == null || string2.length() == 0) {
            jTextField.setColumns(20);
        }
        this.buildRowWithTextField(gridBagPanel, string, jTextField);
    }

    private void buildPasswordRow(GridBagPanel gridBagPanel, String string, String string2) {
        JPasswordField jPasswordField = new JPasswordField(string2);
        jPasswordField.setColumns(30);
        if (string2 == null || string2.length() == 0) {
            jPasswordField.setColumns(20);
        }
        this.buildRowWithTextField(gridBagPanel, string, jPasswordField);
    }

    private void buildRowWithTextField(GridBagPanel gridBagPanel, String string, JTextField jTextField) {
        gridBagPanel.add(new BoldLabel(string));
        this.makeNonEditable(jTextField);
        this.addEditListeners(string, jTextField);
        gridBagPanel.add(jTextField);
        this.model.put(string, jTextField);
        gridBagPanel.newRow();
    }

    private void addEditListeners(String string, JTextField jTextField) {
        jTextField.setActionCommand(string);
        jTextField.addActionListener(this);
        jTextField.getDocument().addDocumentListener(this);
        jTextField.getDocument().putProperty(FIELD, string);
    }

    private void buildPanel(HashMap hashMap) {
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.buildGridBag(hashMap), "Before");
    }

    private GridBagPanel buildGridBag(HashMap hashMap) {
        GridBagPanel gridBagPanel = new GridBagPanel();
        for (Object k : hashMap.keySet()) {
            this.buildRow(gridBagPanel, (String)k, (String)hashMap.get(k));
        }
        gridBagPanel.createStretchBox();
        return gridBagPanel;
    }

    private String getFieldText(String string) {
        return this.getTextFieldFromRow(string).getText();
    }

    public HashMap getModel() {
        HashMap hashMap = new HashMap();
        for (Object k : this.model.keySet()) {
            hashMap.put(k, this.getTextFieldFromRow((String)k).getText());
        }
        return hashMap;
    }

    protected void talkDirty(String string) {
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, string);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        this.dirtyListener = dirtyListenerInterface;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }
}

