/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.fabric;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelSwitchL0;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequestImpl;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.request.handler.LegacyViewerRequestDispatcher;
import org.eclipse.aperi.server.guireq.topology.request.handler.ViewerGuiSendRequest;
import org.eclipse.aperi.topology.gui.TopologyViewerTreeLabel;
import org.eclipse.aperi.xmsg.MessageLog;

public class SwitchesSection
extends ConfigSection
implements ActionListener,
TJCTableMouseInterface {
    private MegaTable table = null;
    private SwitchData[] switchTableData;
    private SwitchTableModel tableModel;
    private JButton link2sysreports = null;
    private JButton link2topo = null;
    private JLabel noData = null;
    private ArrayList reportsNodePath = null;
    private ArrayList topoNodePath = null;
    protected static HashMap[] switches = null;
    private int countTotal = 0;
    private int countOk = 0;
    private int countWarning = 0;
    private int countCritical = 0;
    private int countMissing = 0;
    private int countNoStatus = 0;

    public SwitchesSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.reportsNodePath = new ArrayList();
        this.reportsNodePath.add(TreeLabel.class);
        this.reportsNodePath.add(MessageLog.getMessageNoID("STG4150L"));
        this.reportsNodePath.add(GuiUtil.getString("SYSTEM_REPORTS"));
        this.reportsNodePath.add(GuiUtil.getString("LABEL_FABRIC"));
        this.reportsNodePath.add(MessageLog.getMessageNoID("STG3914L"));
        this.topoNodePath = new ArrayList();
        this.topoNodePath.add(TreeLabel.class);
        this.topoNodePath.add(TopologyViewerTreeLabel.class);
        this.topoNodePath.add(GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCHES"));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_SWITCHES_SECTION");
        if (!this.isExpanded()) {
            string = GuiUtil.getString("CONFIG_SWITCHES_SECTION_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countOk), String.valueOf(this.countWarning), String.valueOf(this.countCritical), String.valueOf(this.countMissing)});
        }
        return string;
    }

    private void getSwitches() {
        ViewerRequestImpl viewerRequestImpl = new ViewerRequestImpl();
        viewerRequestImpl.addRequest(new GraphModelSwitchL0.ID(), null);
        viewerRequestImpl.setRequestType(0);
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.TopologyViewerHndlr";
        request.requestData = viewerRequestImpl;
        request.flags = (byte)4;
        request.userName = GuiUtil.getUserName();
        ViewerGuiSendRequest viewerGuiSendRequest = new ViewerGuiSendRequest(request, new LegacyViewerRequestDispatcher(){

            /*
             * Unable to fully structure code
             */
            public void handleResponse(short var1_1, Request var2_2, Response var3_3) {
                block13: {
                    SwitchesSection.switches = null;
                    try {
                        if (var3_3 == null) ** break block14
                        if (var3_3.responseData == null) break block15;
                        if (var1_1 > 4) break block16;
                        var4_4 = (ViewerResponse)var3_3.responseData;
                        var5_5 = var4_4.getResponse();
                        if (var4_4.getResponseType() == 0) {
                            if (var5_5 instanceof GraphModel) {
                                try {
                                    var6_6 = (GraphModel)var5_5;
                                    var7_7 = var6_6.enumerate(GraphSwitch.TYPE);
                                    var8_8 = new ArrayList<HashMap<K, V>>();
                                    SwitchesSection.switches = null;
                                    while (var7_7.hasMoreElements()) {
                                        var10_10 = (GraphSwitch)var7_7.nextElement();
                                        var9_9 = new HashMap<String, Object>();
                                        var9_9.put("Label", var10_10.getDisplayName());
                                        var9_9.put("WWN", var10_10.getWWN());
                                        var9_9.put("Health", var10_10.getHealthStatus());
                                        var9_9.put("OpStatus", var10_10.getOperationalStatus());
                                        var9_9.put("IP", var10_10.getIPAddress());
                                        var9_9.put("Domain", var10_10.getDomain());
                                        var9_9.put("Vendor", var10_10.getVendor());
                                        var9_9.put("Model", var10_10.getModel());
                                        var8_8.add(var9_9);
                                    }
                                    if (!var8_8.isEmpty()) {
                                        SwitchesSection.switches = var8_8.toArray(new HashMap[var8_8.size()]);
                                    } else if (SwitchesSection.access$3(SwitchesSection.this) != null) {
                                        SwitchesSection.this.remove(SwitchesSection.access$3(SwitchesSection.this));
                                    }
                                    if (var8_8.isEmpty()) {
                                        SwitchesSection.access$4(SwitchesSection.this, new JLabel(GuiUtil.getString("CONFIG_NO_SWITCHES_DATA")));
                                        SwitchesSection.this.add((Component)SwitchesSection.access$5(SwitchesSection.this), "Center");
                                    }
                                }
                                catch (Exception v0) {}
                            }
                            var5_5 instanceof Throwable;
                        }
                        break block17;
                    }
                    finally {
                        SwitchesSection.access$1(SwitchesSection.this);
                        if (SwitchesSection.switches == null) break block13;
                        var12_13 = 0;
                        if (true) ** GOTO lbl68
                    }
                    {
                        block17: {
                            block16: {
                                block15: {
                                }
                            }
                        }
                    }
                    do {
                        var13_15 = SwitchesSection.switches[var12_13];
                        SwitchesSection.access$2(SwitchesSection.this, (Integer)var13_15.get("Health"));
                        ++var12_13;
lbl68:
                        // 2 sources

                    } while (var12_13 < SwitchesSection.switches.length);
                    SwitchesSection.this.buildTable();
                }
            }
        });
        Thread thread = new Thread((Runnable)viewerGuiSendRequest, "Server Request");
        thread.setPriority(thread.getPriority() + 1);
        thread.start();
        try {
            thread.join(10000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void buildTable() {
        this.populateSwitchData(switches);
        this.tableModel = new SwitchTableModel(switches);
        if (switches.length != 0 && this.tableModel != null) {
            if (this.table != null) {
                this.remove(this.table);
            }
            if (this.noData != null) {
                this.remove(this.noData);
            }
            this.table = new MegaTable();
            this.table.setVisibleRows(10);
            this.table.setMouseListener(this);
            this.table.setBaseTableModel(this.tableModel);
            this.table.setCellRenderer(Number.class, new NumberRenderer());
            this.table.setCellRenderer(JLabel.class, new LabelRenderer());
            this.table.setSelectionPolicy(0);
            this.table.sortByColumn(2, 1);
            this.selectionChanged(true);
            this.table.updateUI();
            this.add((Component)this.table, "First");
        }
        if (this.getContainer() != null) {
            this.getContainer().updateSectionTitle();
        }
        this.selectionChanged(false);
        this.revalidate();
        this.repaint();
    }

    private void resetStateCount() {
        this.countOk = 0;
        this.countWarning = 0;
        this.countCritical = 0;
        this.countMissing = 0;
        this.countTotal = 0;
        this.countNoStatus = 0;
    }

    private void setStateCount(Integer n) {
        if (n != null) {
            if (n.equals(GraphModelConstant.STATUS_NORMAL)) {
                ++this.countOk;
            } else if (n.equals(GraphModelConstant.STATUS_WARNING)) {
                ++this.countWarning;
            } else if (n.equals(GraphModelConstant.STATUS_CRITICAL)) {
                ++this.countCritical;
            } else if (n.equals(GraphModelConstant.STATUS_MISSING)) {
                ++this.countMissing;
            }
        } else {
            ++this.countNoStatus;
        }
        ++this.countTotal;
    }

    public void refresh(boolean bl) {
        if (this.link2topo == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2sysreports = new JButton(GuiUtil.getString("CONFIG_SAN_ASSETS_SW_BTN"));
            this.link2sysreports.addActionListener(this);
            GuiUtil.setAccessible(this.link2sysreports, this.link2sysreports.getText(), this.link2sysreports.getText());
            if (!this.capabilities.isFabricOp()) {
                this.link2sysreports.setEnabled(false);
            }
            jPanel2.add(this.link2sysreports);
            this.link2topo = new JButton(GuiUtil.getString("CONFIG_SWTOPO_BTN"));
            this.link2topo.addActionListener(this);
            GuiUtil.setAccessible(this.link2topo, this.link2topo.getText(), this.link2topo.getText());
            if (!this.capabilities.isFabricOp()) {
                this.link2topo.setEnabled(false);
            }
            jPanel2.add(this.link2topo);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add((Component)jPanel2, "Center");
            this.getSwitches();
        }
        if (bl) {
            this.getSwitches();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2sysreports || actionEvent.getSource() == this.link2topo) {
            ArrayList arrayList = null;
            if (actionEvent.getSource() == this.link2sysreports) {
                arrayList = new ArrayList(this.reportsNodePath);
            } else if (actionEvent.getSource() == this.link2topo) {
                arrayList = new ArrayList(this.topoNodePath);
            }
            new ConfigUtil().selectNode(arrayList);
        }
    }

    private void populateSwitchData(HashMap[] hashMapArray) {
        if (hashMapArray != null && hashMapArray.length > 0) {
            this.switchTableData = new SwitchData[hashMapArray.length];
            int n = 0;
            while (n < hashMapArray.length) {
                HashMap hashMap = hashMapArray[n];
                this.switchTableData[n] = new SwitchData((String)hashMap.get("Label"), (String)hashMap.get("WWN"), (Integer)hashMap.get("Health"), (Integer)hashMap.get("OpStatus"), (String)hashMap.get("IP"), (String)hashMap.get("Domain"), (String)hashMap.get("Vendor"), (String)hashMap.get("Model"), (String)hashMap.get("pmEnabled"));
                ++n;
            }
        }
    }

    public void selectionChanged(boolean bl) {
        if (!this.capabilities.isFabricOp()) {
            this.link2sysreports.setEnabled(false);
            this.link2topo.setEnabled(false);
        } else {
            this.link2sysreports.setEnabled(true);
            this.link2topo.setEnabled(true);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    static /* synthetic */ void access$1(SwitchesSection switchesSection) {
        switchesSection.resetStateCount();
    }

    static /* synthetic */ void access$2(SwitchesSection switchesSection, Integer n) {
        switchesSection.setStateCount(n);
    }

    static /* synthetic */ MegaTable access$3(SwitchesSection switchesSection) {
        return switchesSection.table;
    }

    static /* synthetic */ void access$4(SwitchesSection switchesSection, JLabel jLabel) {
        switchesSection.noData = jLabel;
    }

    static /* synthetic */ JLabel access$5(SwitchesSection switchesSection) {
        return switchesSection.noData;
    }

    private class SwitchData {
        String wwn = "";
        String label = "";
        Integer health = new Integer(0);
        Integer opstatus = new Integer(0);
        String ip = "";
        String domain = "";
        String vendor = "";
        String model = "";
        String pmEnabled = GuiUtil.getString("CONFIG_COMMON_STATUS_UNKNOWN");

        public SwitchData(String string, String string2, Integer n, Integer n2, String string3, String string4, String string5, String string6, String string7) {
            this.label = string;
            this.wwn = string2;
            this.health = n;
            this.opstatus = n2;
            this.ip = string3;
            this.domain = string4;
            this.vendor = string5;
            this.model = string6;
            this.pmEnabled = string7;
        }

        public String getLabel() {
            return this.label;
        }

        public String getWWN() {
            return this.wwn;
        }

        public Integer getHealth() {
            return this.health;
        }

        public Integer getOpStatus() {
            return this.opstatus;
        }

        public String getIP() {
            return this.ip;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getModel() {
            return this.model;
        }

        public String getEnabled() {
            return this.pmEnabled;
        }
    }

    public class SwitchTableModel
    extends BaseTableModel {
        public final String[] COL_NAMES = new String[]{GuiUtil.getString("CONFIG_SWITCH"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_WWN"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_OPERATIONALSTATUS"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_IP"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_DOMAIN"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_VENDOR"), GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_MODEL")};
        private static final int S_LABEL = 0;
        private static final int S_PHYS = 1;
        private static final int S_HEALTH = 2;
        private static final int S_OPSTATUS = 3;
        private static final int S_IP = 4;
        private static final int S_DOMAIN = 5;
        private static final int S_VENDOR = 6;
        private static final int S_MODEL = 7;
        private static final int S_PM_ENABLED = 8;
        private HashMap[] switches = null;

        SwitchTableModel(HashMap[] hashMapArray) {
            this.columnNames = this.COL_NAMES;
            this.rowCount = hashMapArray != null ? hashMapArray.length : 0;
            this.switches = (HashMap[])hashMapArray.clone();
        }

        public Object getTableDataItem(int n, int n2) {
            HashMap cfr_ignored_0 = this.switches[n];
            try {
                switch (n2) {
                    case 0: {
                        return SwitchesSection.this.switchTableData[n].getLabel();
                    }
                    case 1: {
                        return SwitchesSection.this.switchTableData[n].getWWN();
                    }
                    case 2: {
                        JLabel jLabel = this.getHealthLabel(SwitchesSection.this.switchTableData[n].getHealth());
                        return jLabel;
                    }
                    case 3: {
                        return GraphModelUtilities.getOperationalStatus(SwitchesSection.this.switchTableData[n].getOpStatus());
                    }
                    case 4: {
                        return SwitchesSection.this.switchTableData[n].getIP();
                    }
                    case 5: {
                        return SwitchesSection.this.switchTableData[n].getDomain();
                    }
                    case 6: {
                        return SwitchesSection.this.switchTableData[n].getVendor();
                    }
                    case 7: {
                        return SwitchesSection.this.switchTableData[n].getModel();
                    }
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }

        private JLabel getHealthLabel(Integer n) {
            TopoResource.init();
            return new JLabel(GraphModelUtilities.getStatusAlias(n), TopoResource.getIconHealth(n), 10);
        }
    }
}

