/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.tape;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.common.model.DataAccessor;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.library.LibraryDDI;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.topology.gui.TopologyViewerTreeLabel;

public class TapeLibrarySection
extends ConfigSection
implements GuiRequestor,
ActionListener,
TJCTableMouseInterface {
    private int countTotal = 0;
    private int countNormal = 0;
    private int countCritical = 0;
    private int countWarning = 0;
    private int countUnreachable = 0;
    private MegaTable table = null;
    private TapeLibraryTableModel tableModel = null;
    private JButton link2detail = null;
    private JButton link2topo = null;
    private JLabel noData = null;
    private ArrayList topoNodePath = null;
    private Vector libraries = new Vector();
    private Vector changedDetailsPanels = new Vector();
    private GUILibrary lib = null;
    private int libInternalId = -1;

    public TapeLibrarySection(boolean bl) {
        super(bl);
        this.topoNodePath = new ArrayList();
        this.topoNodePath.add(TreeLabel.class);
        this.topoNodePath.add(TopologyViewerTreeLabel.class);
        this.topoNodePath.add(GuiUtil.getString("TOPO_LABEL_ENTITY_STORAGE"));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_TAPE_LIBRARIES_SECTION");
        if (!this.isExpanded()) {
            string = GuiUtil.getString("CONFIG_TL_SECTION_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countNormal), String.valueOf(this.countCritical), String.valueOf(this.countWarning), String.valueOf(this.countUnreachable)});
        }
        return string;
    }

    public void refresh(boolean bl) {
        if (this.link2detail == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_SHOW_TL_DETAILS"));
            this.link2detail.addActionListener(this);
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            jPanel2.add(this.link2detail);
            this.link2detail.setEnabled(false);
            this.link2topo = new JButton(GuiUtil.getString("CONFIG_STTOPO_BTN"));
            this.link2topo.addActionListener(this);
            GuiUtil.setAccessible(this.link2topo, this.link2topo.getText(), this.link2topo.getText());
            if (!this.capabilities.isDiskOp()) {
                this.link2topo.setEnabled(false);
            }
            jPanel2.add(this.link2topo);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_TL_NOTE1"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
            ConfigNote configNote2 = new ConfigNote(GuiUtil.getString("CONFIG_CIMOM_DESC"), jPanel);
            configNote2.setAlignmentX(0.0f);
            jPanel.add(configNote2);
            this.getTapeLibraries();
        }
        if (bl) {
            this.getTapeLibraries();
        }
    }

    public void getTapeLibraries() {
        GUIRequestData gUIRequestData = new GUIRequestData(1);
        DataAccessor.sendGuiRequest(this, "org.eclipse.aperi.server.handler.gui.tape.LibraryInfoHandler", gUIRequestData);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (s <= 4) {
            HashMap hashMap = (HashMap)response.responseData;
            this.libraries = new Vector(hashMap.values());
            ArrayList<GUILibrary> arrayList = new ArrayList<GUILibrary>();
            Iterator iterator = this.libraries.iterator();
            this.resetStateCount();
            while (iterator.hasNext()) {
                GUILibrary gUILibrary = (GUILibrary)iterator.next();
                arrayList.add(gUILibrary);
                this.setStateCount(gUILibrary);
            }
            this.tableModel = new TapeLibraryTableModel(arrayList);
            if (arrayList.size() != 0 && this.tableModel != null) {
                if (this.table != null) {
                    this.remove(this.table);
                }
                if (this.noData != null) {
                    this.remove(this.noData);
                }
                this.table = new MegaTable();
                this.table.setVisibleRows(10);
                this.table.setMouseListener(this);
                this.table.setBaseTableModel(this.tableModel);
                this.table.setCellRenderer(Number.class, new NumberRenderer());
                this.table.setCellRenderer(JLabel.class, new LabelRenderer());
                this.table.setSelectionPolicy(0);
                this.table.sortByColumn(2, 1);
                this.selectionChanged(true);
                this.table.updateUI();
                this.add((Component)this.table, "Center");
            } else {
                if (this.table != null) {
                    this.remove(this.table);
                }
                this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_TAPE_DATA"));
                this.add((Component)this.noData, "Center");
            }
            if (this.getContainer() != null) {
                this.getContainer().updateSectionTitle();
            }
            this.selectionChanged(false);
            this.revalidate();
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.link2detail) {
            int[] nArray;
            if (this.tableModel != null && this.tableModel.getNumRows() != 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
                int n = nArray[0];
                GUILibrary gUILibrary = (GUILibrary)this.tableModel.libraries.get(n);
                this.libInternalId = gUILibrary.getInternalId();
                LibraryDDI libraryDDI = new LibraryDDI(this.libInternalId);
                ((DataDisplayInfo)libraryDDI).reDisplay();
            }
        } else if (actionEvent.getSource() == this.link2topo) {
            ArrayList arrayList = new ArrayList(this.topoNodePath);
            new ConfigUtil().selectNode(arrayList);
        }
    }

    private void resetStateCount() {
        this.countNormal = 0;
        this.countCritical = 0;
        this.countWarning = 0;
        this.countUnreachable = 0;
        this.countTotal = 0;
    }

    private void setStateCount(GUILibrary gUILibrary) {
        if (!gUILibrary.isDetectable()) {
            ++this.countUnreachable;
        } else {
            switch (gUILibrary.getState()) {
                case 0: {
                    ++this.countNormal;
                    break;
                }
                case 1: {
                    ++this.countWarning;
                    break;
                }
                case 2: {
                    ++this.countCritical;
                    break;
                }
                default: {
                    ++this.countUnreachable;
                }
            }
        }
        ++this.countTotal;
    }

    public void selectionChanged(boolean bl) {
        if (this.tableModel != null && this.tableModel.getNumRows() != 0) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                int n = nArray[0];
                GUILibrary cfr_ignored_0 = (GUILibrary)this.tableModel.libraries.get(n);
                this.link2detail.setEnabled(true);
            }
        } else {
            this.link2detail.setEnabled(false);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    public class TapeLibraryTableModel
    extends BaseTableModel {
        public final String[] COL_NAMES = new String[]{GuiUtil.getString("TAPE_LIBRARY_LABEL"), GuiUtil.getString("TAPE_NAME_LABEL"), GuiUtil.getString("TAPE_STATE_LABEL")};
        private static final int TAPE_LBID = 0;
        private static final int TAPE_NAME = 1;
        private static final int TAPE_STATUS = 2;
        private ServerStatusResp status;
        public ArrayList libraries;

        TapeLibraryTableModel(ArrayList arrayList) {
            this.libraries = arrayList;
            this.columnNames = this.COL_NAMES;
            this.rowCount = arrayList != null ? arrayList.size() : 0;
        }

        public Object getTableDataItem(int n, int n2) {
            try {
                GUILibrary gUILibrary = (GUILibrary)this.libraries.get(n);
                switch (n2) {
                    case 0: {
                        return gUILibrary.getDisplayName();
                    }
                    case 1: {
                        return gUILibrary.getUserProvidedName();
                    }
                    case 2: {
                        JLabel jLabel = GUIEntityUtil.getEntityStateLabel(gUILibrary);
                        return jLabel;
                    }
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return "";
            }
        }
    }
}

