/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIFabric;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.request.Response;

public abstract class BaseSelectHostPortsStep
extends WizardPage
implements ActionListener {
    protected JLabel titleLabel = null;
    protected JLabel descLabel = null;
    protected JLabel filterLabel = null;
    protected JLabel filterByLabel = null;
    protected JLabel searchLabel = null;
    protected TUpDownListSelector portList = null;
    protected JButton helpButton = null;
    private JButton nextButton = null;
    private JButton filterGoButton = null;
    private JButton searchGoButton = null;
    private JDialog wizardDialog = null;
    protected JComboBox filterComboBox = null;
    protected JComboBox filterByComboBox = null;
    protected JTextField searchTextField = null;
    protected JList sourceList = null;
    protected JList selectedList = null;
    protected DefaultListModel srcModel = new DefaultListModel();
    protected DefaultListModel originalsrcModel = new DefaultListModel();
    protected DefaultListModel selModel = new DefaultListModel();
    protected DefaultComboBoxModel filterModel = new DefaultComboBoxModel();
    protected DefaultComboBoxModel hostTypeModel = new DefaultComboBoxModel();
    protected boolean skipSubsystemStep = false;
    protected boolean isHelpSet = false;
    private boolean isHostPortDataRetrieved = false;
    private boolean isSSPortDataRetrieved = false;
    private boolean isfabricDataRetrieved = false;
    protected boolean getData = false;
    protected boolean addSSData = false;
    protected boolean skipToReviewStep = false;
    protected boolean portAssignFlag = false;
    protected int hostTypeFlag = -1;
    protected int ihostType = 0;
    protected String hostTypeName = new String();
    protected String hostTypeDesc = new String();
    protected HashMap portWWPN = new HashMap();
    protected HashMap portData = null;
    protected HashMap hostTypeMap = new HashMap();
    protected HashMap hostDescMap = new HashMap();
    protected Vector ssportData = null;
    protected String subSystemID = null;
    protected GUIStorageSubsystem subSystem = null;
    private HashMap hmapPortsOfSS;
    private HashMap hmapPortsOfHP;
    private HashMap hmapFabrics = null;
    private HostType[] hosttype;
    protected DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    protected HashMap assignedhostports = new HashMap();
    protected Vector originalList = new Vector();
    protected ArrayList originalListRHS = new ArrayList();
    protected ArrayList originalListLHS = new ArrayList();
    protected Vector unAssignedPorts = new Vector();
    protected Vector unAssignedPortsWithHosts = new Vector();
    private Vector hostnameData = new Vector();
    private Vector fabricData = new Vector();
    public static String HOSTPORTS_DATA = "Host Ports";
    public static String HOSTPORTS_ASSIGNED_DATA = "Assigned Host Ports";
    public static String HOSTPORTS_UNASSIGNED_DATA = "Unassigned Host Ports";
    public static String HOSTPORTS_UNASSIGNED_HOSTS_DATA = "Unassigned Host Ports with hosts";
    public static String HOSTPORTS_TYPE_DATA = "Host Ports type";
    public static String HOSTPORTS_TYPE_NAME_DATA = "Host Ports type name";
    public static String HOSTPORTS_TYPE_DESC_DATA = "Host Ports type desc";
    public static String STORAGE_CLIENT_SETTING_DATA = "StorageClientSettingData for ";
    private ArrayList selectedPorts;
    private ArrayList srcPorts;
    protected ArrayList currentSrcList;

    public BaseSelectHostPortsStep(int n, GUIStorageSubsystem gUIStorageSubsystem) {
        super(n);
        this.subSystemID = gUIStorageSubsystem.getId();
        this.subSystem = gUIStorageSubsystem;
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container container = this.getContentPane();
        container.add(this.create());
    }

    public JPanel create() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        String string = new String();
        String string2 = new String();
        GridBagPanel gridBagPanel = new GridBagPanel();
        string = this.subSystem.getType() == 4 ? Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS")) : Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
        this.titleLabel = new JLabel(string);
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.titleLabel);
        jPanel2.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.descLabel = new JLabel(string2);
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(this.descLabel);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        this.getPortsFromSystem();
        this.getSSPortsFromSystem();
        this.getFabricsFromsystem();
        this.getHostTypes();
        int n = -1;
        int n2 = -1;
        Vector<String> vector = new Vector<String>();
        vector.add(GuiUtil.getString("DISK_VOLUME_HOSTPORT_NO_FILTER"));
        vector.add(GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER_BY_HOSTNAME"));
        vector.add(GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER_BY_FABRIC"));
        vector.add(GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER_BY_TYPE"));
        this.filterByComboBox = new JComboBox(vector);
        this.filterByLabel = new JLabel(GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER"));
        this.filterByComboBox.addActionListener(this);
        n = GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER_BY_HOSTNAME").length() * this.filterByComboBox.getFontMetrics(this.getFont()).charWidth(0) + 2;
        n2 = this.filterByComboBox.getFontMetrics(this.getFont()).getHeight() + 10;
        this.filterByComboBox.setPreferredSize(new Dimension(n, n2));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)this.filterByLabel, 1, 1, 2);
        gridBagPanel.add((JComponent)this.filterByComboBox, 1, 1, 2);
        GuiUtil.setAccessibleLabel(this.filterByLabel, this.filterByComboBox, "", this.filterByLabel.getText(), this.filterByLabel.getText());
        this.searchTextField = new JTextField(GuiUtil.getString("DISK_VOLUME_HOSTPORT_SEARCH"));
        this.searchLabel = new JLabel(GuiUtil.getString("DISK_VOLUME_HOSTPORT_SEARCH"));
        this.searchLabel.setAlignmentX(1.0f);
        gridBagPanel.add((JComponent)this.searchLabel, 1, 1, 2);
        gridBagPanel.add((JComponent)this.searchTextField, 1, 1, 2);
        n = GuiUtil.getString("DISK_VOLUME_HOSTPORT_SEARCH").length() * this.searchTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        n2 = this.searchTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.searchTextField.setPreferredSize(new Dimension(n, n2));
        this.searchGoButton = new JButton(GuiUtil.getString("DISK_GO_BUTTON"));
        gridBagPanel.add((JComponent)this.searchGoButton, 1, 1, 2);
        this.searchGoButton.addActionListener(this);
        GuiUtil.setAccessibleLabel(this.searchLabel, this.searchTextField, "", this.searchLabel.getText(), this.searchLabel.getText());
        this.filterComboBox = new JComboBox(new Vector());
        this.filterComboBox.setAutoscrolls(true);
        this.filterLabel = new JLabel(GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER_CRITERIA"));
        this.filterComboBox.addActionListener(this);
        n = GuiUtil.getString("DISK_VOLUME_HOSTPORT_FILTER_BY_HOSTNAME").length() * this.filterComboBox.getFontMetrics(this.getFont()).charWidth(0) + 20;
        n2 = this.filterComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.filterComboBox.setPreferredSize(new Dimension(n, n2));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)this.filterLabel, 1, 1, 2);
        gridBagPanel.add((JComponent)this.filterComboBox, 1, 1, 2);
        this.filterGoButton = new JButton(GuiUtil.getString("DISK_GO_BUTTON"));
        gridBagPanel.add((JComponent)this.filterGoButton, 1, 1, 2);
        this.filterGoButton.addActionListener(this);
        GuiUtil.setAccessibleLabel(this.filterLabel, this.filterComboBox, "", this.filterLabel.getText(), this.filterLabel.getText());
        this.sourceList = new JList(this.srcModel);
        this.selectedList = new JList(this.selModel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.portList = new HostPortSelector(this.sourceList, this.selectedList, GuiUtil.getString("DISK_VOLUME_HOST_PORT_SRC_LABEL"), GuiUtil.getString("DISK_VOLUME_HOST_PORT_SEL_LABEL"), true);
        jPanel4.add(this.portList);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.add(gridBagPanel);
        jPanel.add(jPanel4);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = null;
        String string = new String();
        int n = 0;
        if (actionEvent == null) {
            return;
        }
        object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object.equals(this.filterByComboBox)) {
            n = this.filterByComboBox.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.filterModel = new DefaultComboBoxModel();
                    break;
                }
                case 1: {
                    this.filterModel = new DefaultComboBoxModel(this.hostnameData);
                    break;
                }
                case 2: {
                    this.filterModel = new DefaultComboBoxModel(this.fabricData);
                    break;
                }
                case 3: {
                    this.filterModel = this.hostTypeModel;
                    break;
                }
                default: {
                    this.filterModel = new DefaultComboBoxModel();
                }
            }
            this.filterComboBox.setModel(this.filterModel);
        } else if (object.equals(this.filterComboBox)) {
            n = this.filterByComboBox.getSelectedIndex();
            if (n == 3) {
                this.hostTypeName = this.filterComboBox.getSelectedItem().toString();
                this.ihostType = !this.hostTypeName.equals(GuiUtil.getString("DISK_COMMON_NO_SELECTION")) ? (Integer)this.hostTypeMap.get(this.hostTypeName) : 0;
            }
        } else if (object.equals(this.filterGoButton)) {
            n = this.filterByComboBox.getSelectedIndex();
            String string2 = new String();
            this.srcModel = new DefaultListModel();
            GUIPort gUIPort = null;
            Vector vector = new Vector();
            if (n >= 0) {
                string2 = (String)this.filterComboBox.getSelectedItem();
                switch (n) {
                    case 0: {
                        this.srcModel = this.originalsrcModel;
                        break;
                    }
                    case 1: 
                    case 3: {
                        int n2 = -1;
                        String string3 = new String();
                        int n3 = -1;
                        int n4 = 0;
                        while (n4 < this.originalsrcModel.getSize()) {
                            string = (String)this.originalsrcModel.get(n4);
                            n2 = string.indexOf(string2);
                            if (n2 != -1) {
                                if (n == 1) {
                                    n3 = string.indexOf(44);
                                    if (n3 == -1) {
                                        n3 = string.indexOf(41);
                                    }
                                } else if (n == 3) {
                                    n3 = string.lastIndexOf(41);
                                }
                                string3 = string.substring(n2, n3);
                                if (string2.equals(string3 = string3.trim())) {
                                    this.srcModel.addElement(string);
                                }
                            } else if (n == 3 && ((n3 = string.indexOf(44)) == -1 || this.ihostType == 0)) {
                                this.srcModel.addElement(string);
                            }
                            ++n4;
                        }
                        break;
                    }
                    case 2: {
                        int n5 = 0;
                        while (n5 < this.originalsrcModel.getSize()) {
                            string = (String)this.originalsrcModel.get(n5);
                            gUIPort = (GUIPort)this.portData.get(string);
                            if (gUIPort != null && (vector = gUIPort.getFabrics()).contains(string2)) {
                                this.srcModel.addElement(string);
                            }
                            ++n5;
                        }
                        break;
                    }
                }
                this.sourceList.setModel(this.srcModel);
            }
        } else if (object.equals(this.searchGoButton)) {
            String string4 = this.searchTextField.getText();
            if (string4 != null && string4.length() > 0) {
                Vector<Integer> vector = new Vector<Integer>();
                int n6 = 0;
                while (n6 < this.srcModel.getSize()) {
                    string = (String)this.srcModel.get(n6);
                    if (string.indexOf(string4) != -1) {
                        vector.add(new Integer(n6));
                    }
                    ++n6;
                }
                int[] nArray = new int[vector.size()];
                int n7 = 0;
                while (n7 < vector.size()) {
                    nArray[n7] = (Integer)vector.get(n7);
                    ++n7;
                }
                this.sourceList.setSelectedIndices(nArray);
            } else {
                int[] nArray = new int[]{};
                this.sourceList.setSelectedIndices(nArray);
            }
        }
    }

    public void getHostTypes() {
        this.diskAccessor.getHostTypes(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    BaseSelectHostPortsStep.this.hosttype = (HostType[])response.responseData;
                    BaseSelectHostPortsStep.this.hostTypeMap = new HashMap();
                    BaseSelectHostPortsStep.this.hostDescMap = new HashMap();
                    BaseSelectHostPortsStep.this.hostTypeModel = new DefaultComboBoxModel();
                    Vector<String> vector = new Vector<String>();
                    String string = new String();
                    String string2 = new String();
                    String string3 = new String();
                    int n = 0;
                    while (BaseSelectHostPortsStep.this.hosttype != null && n < BaseSelectHostPortsStep.this.hosttype.length) {
                        String[] stringArray;
                        string = BaseSelectHostPortsStep.this.hosttype[n].getElementName();
                        if (string.startsWith(STORAGE_CLIENT_SETTING_DATA)) {
                            string = string3 = string.substring(STORAGE_CLIENT_SETTING_DATA.length(), string.length());
                        }
                        if ((stringArray = BaseSelectHostPortsStep.this.hosttype[n].getClientDescriptions()) != null) {
                            string2 = stringArray[0];
                        }
                        int[] nArray = BaseSelectHostPortsStep.this.hosttype[n].getClientTypes();
                        Integer n2 = new Integer(nArray[0]);
                        BaseSelectHostPortsStep.this.hostTypeMap.put(string, n2);
                        BaseSelectHostPortsStep.this.hostDescMap.put(string, string2);
                        ++n;
                    }
                    vector = new Vector(BaseSelectHostPortsStep.this.hostTypeMap.keySet());
                    Collections.sort(vector);
                    vector.add(0, GuiUtil.getString("DISK_COMMON_NO_SELECTION"));
                    n = 0;
                    while (n < vector.size()) {
                        BaseSelectHostPortsStep.this.hostTypeModel.addElement(vector.get(n));
                        ++n;
                    }
                }
            }
        }, this.subSystemID);
    }

    public void getPortsFromSystem() {
        this.enableControls(false);
        this.diskAccessor.getHostPortsBySubsystem(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                GUIPort gUIPort2 = null;
                BaseSelectHostPortsStep.this.portData = new HashMap();
                String string = new String();
                Vector<String> vector = new Vector<String>();
                BaseSelectHostPortsStep.this.hostnameData = new Vector();
                String string2 = new String();
                String string3 = new String();
                if (s <= 4 && response != null) {
                    BaseSelectHostPortsStep.this.hmapPortsOfHP = (HashMap)response.responseData;
                    if (BaseSelectHostPortsStep.this.hmapPortsOfHP != null) {
                        for (GUIPort gUIPort2 : BaseSelectHostPortsStep.this.hmapPortsOfHP.values()) {
                            string = gUIPort2.getWwpn();
                            string2 = gUIPort2.getHostName();
                            string3 = gUIPort2.getTypeName();
                            if (string2 != null && string2.trim().length() > 0) {
                                string = String.valueOf(string) + "( " + string2;
                                if (string3 != null && string3.trim().length() > 0 && gUIPort2.getType() != 0) {
                                    string = String.valueOf(string) + ", " + string3;
                                }
                                string = String.valueOf(string) + " )";
                                if (!BaseSelectHostPortsStep.this.hostnameData.contains(string2)) {
                                    BaseSelectHostPortsStep.this.hostnameData.add(string2);
                                }
                            }
                            vector.add(string);
                            BaseSelectHostPortsStep.this.portData.put(string, gUIPort2);
                            BaseSelectHostPortsStep.this.portWWPN.put(gUIPort2.getWwpn(), string);
                        }
                        BaseSelectHostPortsStep.this.getAssignedPorts();
                        Collections.sort(vector);
                        int n = 0;
                        while (n < vector.size()) {
                            BaseSelectHostPortsStep.this.srcModel.addElement(vector.get(n));
                            ++n;
                        }
                        BaseSelectHostPortsStep.this.originalsrcModel = BaseSelectHostPortsStep.this.srcModel;
                        BaseSelectHostPortsStep.this.sourceList.setModel(BaseSelectHostPortsStep.this.srcModel);
                        BaseSelectHostPortsStep.this.selectedList.setModel(BaseSelectHostPortsStep.this.selModel);
                        BaseSelectHostPortsStep.this.originalListRHS = BaseSelectHostPortsStep.this.portList.getSelList();
                        BaseSelectHostPortsStep.this.originalListLHS = BaseSelectHostPortsStep.this.portList.getSrcList();
                        if (BaseSelectHostPortsStep.this.originalListRHS == null) {
                            BaseSelectHostPortsStep.this.originalListRHS = new ArrayList();
                        }
                        if (BaseSelectHostPortsStep.this.originalListLHS == null) {
                            BaseSelectHostPortsStep.this.originalListLHS = new ArrayList();
                        }
                        BaseSelectHostPortsStep.this.currentSrcList = BaseSelectHostPortsStep.this.portList.getSrcList();
                        Collections.sort(BaseSelectHostPortsStep.this.hostnameData);
                    }
                }
                BaseSelectHostPortsStep.this.isHostPortDataRetrieved = true;
                BaseSelectHostPortsStep.this.enableControls(true);
            }
        }, this.subSystemID);
    }

    public void getAssignedPorts() {
    }

    public void addData(Vector vector) {
    }

    public void addData(Vector vector, Vector vector2) {
    }

    public JDialog getWizardDialog() {
        return null;
    }

    public boolean skipSubsystemStep() {
        return this.skipSubsystemStep;
    }

    public boolean skipToReviewStep() {
        return this.skipToReviewStep;
    }

    public void getSSPortsFromSystem() {
        this.enableControls(false);
        this.diskAccessor.getSubsystemPorts(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                GUIPort gUIPort2 = null;
                BaseSelectHostPortsStep.this.ssportData = new Vector();
                if (s <= 4 && response != null) {
                    BaseSelectHostPortsStep.this.hmapPortsOfSS = (HashMap)response.responseData;
                    if (!BaseSelectHostPortsStep.this.hmapPortsOfSS.isEmpty()) {
                        for (GUIPort gUIPort2 : BaseSelectHostPortsStep.this.hmapPortsOfSS.values()) {
                            BaseSelectHostPortsStep.this.ssportData.add(gUIPort2);
                        }
                        BaseSelectHostPortsStep.this.getData = true;
                    }
                }
                BaseSelectHostPortsStep.this.isSSPortDataRetrieved = true;
                BaseSelectHostPortsStep.this.enableControls(true);
            }
        }, this.subSystemID);
    }

    public void getFabricsFromsystem() {
        this.enableControls(false);
        this.diskAccessor.getFabrics(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                GUIFabric gUIFabric2 = null;
                BaseSelectHostPortsStep.this.fabricData = new Vector();
                if (s <= 4) {
                    if (response != null) {
                        BaseSelectHostPortsStep.this.hmapFabrics = (HashMap)response.responseData;
                    } else {
                        BaseSelectHostPortsStep.this.hmapFabrics = null;
                    }
                }
                if (BaseSelectHostPortsStep.this.hmapFabrics != null && !BaseSelectHostPortsStep.this.hmapFabrics.isEmpty()) {
                    for (GUIFabric gUIFabric2 : BaseSelectHostPortsStep.this.hmapFabrics.values()) {
                        BaseSelectHostPortsStep.this.fabricData.add(gUIFabric2.getId());
                    }
                }
                BaseSelectHostPortsStep.this.isfabricDataRetrieved = true;
                BaseSelectHostPortsStep.this.enableControls(true);
            }
        });
    }

    public HashMap getSSPorts() {
        return this.hmapPortsOfSS;
    }

    public HashMap getFabrics() {
        return this.hmapFabrics;
    }

    private void enableControls(boolean bl) {
        if (bl && this.isSSPortDataRetrieved && this.isHostPortDataRetrieved && this.isfabricDataRetrieved) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
    }

    public boolean nextBegin() {
        Object object;
        Object object2;
        boolean bl = true;
        String string = null;
        GUIPort gUIPort = null;
        Vector<GUIPort> vector = new Vector<GUIPort>();
        this.skipSubsystemStep = false;
        this.skipToReviewStep = false;
        this.selectedPorts = this.portList.getSelList();
        this.srcPorts = this.currentSrcList;
        if (this.selectedPorts == null) {
            this.selectedPorts = new ArrayList();
        }
        if (this.srcPorts == null) {
            this.srcPorts = new ArrayList();
        }
        if (this.srcPorts.containsAll(this.originalListLHS) && this.originalListLHS.containsAll(this.srcPorts)) {
            object2 = null;
            object = null;
            if (this.subSystem.getType() == 4) {
                object2 = Util.getString("DISK_VOLUME_HOST_PORT_CONFIRMATION", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
                object = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
            } else {
                object2 = Util.getString("DISK_VOLUME_HOST_PORT_CONFIRMATION", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
                object = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
            }
            int n = JOptionPane.showConfirmDialog(this, object2, (String)object, 2);
            switch (n) {
                case 0: {
                    bl = true;
                    this.portAssignFlag = true;
                    this.skipToReviewStep = true;
                    this.addSSData = false;
                    break;
                }
                case 2: {
                    this.portAssignFlag = false;
                    this.skipToReviewStep = false;
                    bl = false;
                }
            }
        } else {
            object2 = this.selectedPorts.listIterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object == null) continue;
                string = object.toString();
                if (this.portData != null) {
                    gUIPort = (GUIPort)this.portData.get(string);
                }
                if (gUIPort == null || this.originalList.contains(string)) continue;
                vector.add(gUIPort);
            }
        }
        if (vector.size() > 0) {
            this.hostTypeFlag = -1;
            object2 = null;
            int n = 0;
            while (n < vector.size()) {
                object2 = (GUIPort)vector.get(n);
                if (this.ihostType > 0 && ((GUIPort)object2).getType() != this.ihostType) {
                    if (((GUIPort)object2).getTypeFrom() == GUIPort.TYPE_FROM_HOST) {
                        this.hostTypeFlag = 0;
                    } else if (((GUIPort)object2).getTypeFrom() == GUIPort.TYPE_FROM_CLIENT) {
                        this.hostTypeFlag = 1;
                    }
                }
                ++n;
            }
            if (this.hostTypeFlag == 1) {
                String string2 = null;
                String string3 = null;
                if (this.subSystem.getType() == 4) {
                    string2 = Util.getString("DMSG_HOSTPORT_INCORRECT_HOST_TYPE", GuiUtil.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
                    string3 = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", GuiUtil.getString("DISK_PORT_ASSIGNMENT_VDISKS"));
                } else {
                    string2 = Util.getString("DMSG_HOSTPORT_INCORRECT_HOST_TYPE", GuiUtil.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
                    string3 = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", GuiUtil.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
                }
                JOptionPane.showMessageDialog(this, string2, string3, 0);
                bl = false;
            } else if (this.hostTypeFlag == 0) {
                this.warningMessage(Util.getString("DISK_VOLUME_HOST_PORT_HOST_TYPE_WARNING", this.subSystem.getDeviceId()));
            }
            if (this.ihostType <= 0) {
                this.ihostType = -1;
            }
            this.hostTypeDesc = (String)this.hostDescMap.get(this.hostTypeName);
            if (this.hostTypeFlag != 1 && this.subSystem.getType() == 1 || this.subSystem.getType() == 5) {
                this.warningMessage(GuiUtil.getString("DISK_VOLUME_HOST_PORT_DS4000_WARNING"));
            }
        } else {
            this.skipToReviewStep = true;
        }
        if (this.subSystem.getCapabilityData().getPortsPerView() == 4 || this.subSystem.getType() == 4) {
            this.skipSubsystemStep = true;
            this.addSSData = true;
        }
        this.addData(vector);
        return bl;
    }

    protected void warningMessage(String string) {
        Object object;
        JOptionPane jOptionPane = new JOptionPane();
        Object object2 = null;
        Font font = this.descLabel.getFont();
        if (string.length() > 75) {
            object2 = new JTextArea(string, 5, 60);
            ((JTextArea)object2).setFont(font);
            ((JTextArea)object2).setLineWrap(true);
            ((JTextArea)object2).setWrapStyleWord(true);
            ((JTextArea)object2).setEditable(false);
            object = jOptionPane.getBackground();
            ((JTextArea)object2).setBackground((Color)object);
        } else {
            object2 = string;
        }
        object = Util.getString("DISK_VOLUME_HOST_PORT_LABEL", Util.getString("DISK_PORT_ASSIGNMENT_VOLUMES"));
        jOptionPane.setMessage(object2);
        jOptionPane.setMessageType(2);
        JDialog jDialog = jOptionPane.createDialog(this, (String)object);
        GuiUtil.centerDialog(jDialog);
        jDialog.pack();
        jDialog.show();
    }

    public boolean previousBegin() {
        return true;
    }

    private class HostPortSelector
    extends TUpDownListSelector {
        public HostPortSelector(JList jList, JList jList2, String string, String string2, boolean bl) {
            super(jList, jList2, string, string2, bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block2: {
                JButton jButton;
                block3: {
                    super.actionPerformed(actionEvent);
                    if (!(actionEvent.getSource() instanceof JButton)) break block2;
                    jButton = (JButton)actionEvent.getSource();
                    if (jButton != this.addButton) break block3;
                    for (Object e : BaseSelectHostPortsStep.this.portList.getSelList()) {
                        if (BaseSelectHostPortsStep.this.currentSrcList == null || !BaseSelectHostPortsStep.this.currentSrcList.contains(e)) continue;
                        BaseSelectHostPortsStep.this.currentSrcList.remove(e);
                    }
                    break block2;
                }
                if (jButton != this.delButton) break block2;
                for (Object e : BaseSelectHostPortsStep.this.portList.getSrcList()) {
                    if (BaseSelectHostPortsStep.this.currentSrcList == null || BaseSelectHostPortsStep.this.currentSrcList.contains(e)) continue;
                    BaseSelectHostPortsStep.this.currentSrcList.add(e);
                }
            }
        }
    }
}

