/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardListener;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.volume.BaseZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeReviewStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSetCharacteristicsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVolumeWizard
extends Wizard
implements WizardListener {
    private CreateVolumeSelectHostPortsStep hostStep = null;
    private CreateVolumeZoneActionStep zoneStep = null;
    private CreateVolumeReviewStep reviewStep = null;
    private CreateVolumeSetCharacteristicsStep charStep = null;
    private CreateVolumeSelectSubsystemPortsStep portStep = null;
    private String SS_ID = null;
    private String deviceID = null;
    private Vector volumeVector = new Vector();
    private Vector hostports = new Vector();
    private Vector ssports = new Vector();
    private String[] hostportWWPNs = null;
    private String[] hostNames = null;
    private Integer hostType = new Integer(-1);
    private String hostTypeDesc = null;
    private String[] ssportWWPNs = null;
    private String[] volumeIDs = null;
    private DiskDataController diskController = null;
    private GUIStorageSubsystem subSystem = null;
    private JDialog wizardDialog = null;
    private HashMap volumeData = null;
    private HashMap unitsMap = new HashMap();
    private int WIZARD_FLAGS = 31;

    public CreateVolumeWizard(GUIStorageSubsystem gUIStorageSubsystem) {
        this.subSystem = gUIStorageSubsystem;
        this.SS_ID = this.subSystem.getId();
        this.deviceID = this.subSystem.getDeviceId();
        this.addWizardListener(this);
        this.volumeData = new HashMap();
        this.charStep = new CreateVolumeSetCharacteristicsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.charStep);
        this.hostStep = new CreateVolumeSelectHostPortsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.hostStep);
        if (this.subSystem.isTargetPortRestrictionSupported() && 4 != this.subSystem.getCapabilityData().getPortsPerView()) {
            this.portStep = new CreateVolumeSelectSubsystemPortsStep(this.WIZARD_FLAGS, this.subSystem);
            this.add(this.portStep);
        }
        this.zoneStep = new CreateVolumeZoneActionStep(this.WIZARD_FLAGS, this.SS_ID);
        this.add(this.zoneStep);
        this.reviewStep = new CreateVolumeReviewStep(this.WIZARD_FLAGS, this.SS_ID);
        this.add(this.reviewStep);
        this.unitsMap.put(Util.getString("DISK_BYTES"), "0");
        this.unitsMap.put(Util.getString("DISK_KB"), "1");
        this.unitsMap.put(Util.getString("DISK_MB"), "2");
        this.unitsMap.put(Util.getString("DISK_GB"), "3");
        this.unitsMap.put(Util.getString("DISK_TB"), "4");
        this.unitsMap.put(Util.getString("DISK_PB"), "5");
    }

    public CreateVolumeSelectSubsystemPortsStep getSubsystemPortsStep() {
        return this.portStep;
    }

    public CreateVolumeSelectHostPortsStep getHostPortsStep() {
        return this.hostStep;
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void addVolumeData(String string, Object object) {
        this.volumeData.put(string, object);
    }

    public HashMap getData() {
        return this.volumeData;
    }

    public void nextBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.hostStep) {
            if (this.hostStep.skipSubsystemStep()) {
                wizardEvent.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                wizardEvent.setNewPage(this.reviewStep);
            }
        }
    }

    public void nextComplete(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).nextComplete());
        if ((WizardPage)wizardEvent.getNewPage() == this.hostStep) {
            this.hostStep.getSSPortsFromSystem();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.portStep) {
            this.portStep.fillData();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.zoneStep) {
            this.zoneStep.fillData();
        }
        if ((WizardPage)wizardEvent.getNewPage() == this.reviewStep) {
            this.reviewStep.fillData();
        }
    }

    public void previousBegin(WizardEvent wizardEvent) {
        wizardEvent.setAllowChange(((WizardPage)wizardEvent.getCurrentPage()).previousBegin());
        if ((WizardPage)wizardEvent.getCurrentPage() == this.reviewStep) {
            if (this.hostStep.skipSubsystemStep()) {
                wizardEvent.setNewPage(this.zoneStep);
            }
            if (this.hostStep.skipToReviewStep()) {
                wizardEvent.setNewPage(this.hostStep);
            }
        }
    }

    public void finished(WizardEvent wizardEvent) {
        super.finished(wizardEvent);
        if (((WizardPage)wizardEvent.getCurrentPage()).equals(this.reviewStep)) {
            String string = Util.getString("DISK_VOLUMES_WIZARD_FINISHED");
            JOptionPane.showMessageDialog(this, string, Util.getString("DISK_VOLUME_WIZARD_TITLE", this.deviceID), 1);
            this.closeWizard();
            new VolumeThread(this).start();
        }
    }

    public void canceled(WizardEvent wizardEvent) {
        int n = JOptionPane.showConfirmDialog(this, Util.getString("DISK_VOLUMES_WIZARD_CANCELED"), Util.getString("DISK_VOLUME_WIZARD_TITLE", this.deviceID), 0);
        switch (n) {
            case 0: {
                super.canceled(wizardEvent);
                this.closeWizard();
                break;
            }
        }
    }

    private void closeWizard() {
        JDialog jDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        jDialog.dispose();
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected String fabricID = null;

        public JobResultThread(int n) {
            this.jobID = n;
        }

        public JobResultThread(int n, String string) {
            this.jobID = n;
            this.fabricID = string;
        }

        public void run() {
            AsyncResult[] asyncResultArray;
            Response response = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (this.fabricID != null) {
                GuiUtil.triggerJobChange((short)108);
                boolean bl = false;
                if (response != null && (asyncResultArray = (AsyncResult[])response.responseData) != null && (asyncResultArray.getReturnException() != null || asyncResultArray.getRc() > 0)) {
                    bl = true;
                }
                if (bl) {
                    CreateVolumeWizard.this.diskController.rollbackFabricTransaction(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                        }
                    }, this.fabricID);
                } else {
                    CreateVolumeWizard.this.diskController.releaseFabric(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                        }
                    }, this.fabricID);
                }
            } else {
                GuiUtil.triggerJobChange((short)107);
            }
            if (response != null) {
                AsyncResult asyncResult = (AsyncResult)response.responseData;
                asyncResultArray = asyncResult.getSubJobResults();
                int n = 0;
                while (asyncResultArray != null && n < asyncResultArray.length) {
                    Exception exception = asyncResultArray[n].getReturnException();
                    if (exception != null) {
                        String string = exception.getMessage();
                        if (exception instanceof SRMRuntimeException) {
                            string = ((SRMRuntimeException)exception).getLocalizedMessage();
                        }
                    }
                    if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                        asyncResultArray[n].getResults();
                    }
                    ++n;
                }
            }
        }
    }

    public class VolumeJobResultThread
    extends JobResultThread {
        public VolumeJobResultThread(int n) {
            super(n);
        }

        public void run() {
            Response response = GuiDeviceJob.getJobStatus(this.jobID, true);
            GuiUtil.triggerJobChange((short)107);
            if (response != null) {
                AsyncResult asyncResult = (AsyncResult)response.responseData;
                AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
                int n = 0;
                while (asyncResultArray != null && n < asyncResultArray.length) {
                    VolumeID[] volumeIDArray;
                    Exception exception = asyncResultArray[n].getReturnException();
                    if (exception != null) {
                        volumeIDArray = exception.getMessage();
                        if (exception instanceof SRMRuntimeException) {
                            volumeIDArray = ((SRMRuntimeException)exception).getLocalizedMessage();
                        }
                    }
                    if (asyncResultArray[n] != null && asyncResultArray[n].getResults() != null && asyncResultArray[n].getRc() <= 0) {
                        volumeIDArray = (VolumeID[])asyncResultArray[n].getResults();
                        CreateVolumeWizard.this.volumeVector.add(volumeIDArray[0].getStorageVolumeID());
                    }
                    ++n;
                }
                CreateVolumeWizard.this.hostportWWPNs = new String[CreateVolumeWizard.this.hostports.size()];
                n = 0;
                while (n < CreateVolumeWizard.this.hostports.size()) {
                    ((CreateVolumeWizard)CreateVolumeWizard.this).hostportWWPNs[n] = ((GUIPort)CreateVolumeWizard.this.hostports.get(n)).getWwpn();
                    ++n;
                }
                if (!CreateVolumeWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVolumeWizard.this.subSystem.getCapabilityData().getPortsPerView()) {
                    CreateVolumeWizard.this.ssportWWPNs = new String[CreateVolumeWizard.this.ssports.size()];
                    n = 0;
                    while (n < CreateVolumeWizard.this.ssports.size()) {
                        ((CreateVolumeWizard)CreateVolumeWizard.this).ssportWWPNs[n] = ((GUIPort)CreateVolumeWizard.this.ssports.get(n)).getWwpn();
                        ++n;
                    }
                } else {
                    CreateVolumeWizard.this.ssportWWPNs = null;
                }
                CreateVolumeWizard.this.volumeIDs = CreateVolumeWizard.this.volumeVector.toArray(new String[0]);
                if (CreateVolumeWizard.this.hostportWWPNs.length > 0 && CreateVolumeWizard.this.volumeIDs.length > 0) {
                    CreateVolumeWizard.this.diskController.assignPorts(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                            if (s <= 4) {
                                int n = (Integer)response.responseData;
                                new JobResultThread(n).start();
                            }
                        }
                    }, CreateVolumeWizard.this.volumeIDs, CreateVolumeWizard.this.ssportWWPNs, CreateVolumeWizard.this.hostportWWPNs);
                }
            }
        }
    }

    public class VolumeThread
    extends Thread {
        private CreateVolumeWizard wizard;

        public VolumeThread(CreateVolumeWizard createVolumeWizard2) {
            this.wizard = createVolumeWizard2;
        }

        public void run() {
            this.createVolumes();
        }

        private void createVolumes() {
            int n = 0;
            long l = 0L;
            new String();
            String string = new String();
            CreateVolumeWizard.this.wizardDialog = (JDialog)this.wizard.getParent().getParent().getParent().getParent();
            CreateVolumeWizard.this.diskController = DiskDataController.getInstance();
            n = Integer.valueOf(CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUME_QUANTITY_LABEL")).toString());
            l = Long.valueOf(CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUME_SIZE_LABEL")).toString());
            string = CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_UNITS_LABEL")).toString();
            string = (String)CreateVolumeWizard.this.unitsMap.get(string);
            l = GUIEntityUtil.convertStorageCapacity(l, Integer.valueOf(string), 0);
            Vector vector = (Vector)CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUMES_LABEL"));
            String[] stringArray = vector != null ? vector.toArray(new String[0]) : (String[])null;
            GUIStoragePool gUIStoragePool = (GUIStoragePool)CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"));
            CreateVolumeWizard.this.hostports = (Vector)CreateVolumeWizard.this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_DATA);
            CreateVolumeWizard.this.ssports = (Vector)CreateVolumeWizard.this.volumeData.get(CreateVolumeSelectSubsystemPortsStep.SUBSYSTEM_DATA);
            CreateVolumeWizard.this.hostType = (Integer)CreateVolumeWizard.this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_TYPE_DATA);
            CreateVolumeWizard.this.hostTypeDesc = (String)CreateVolumeWizard.this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_TYPE_DESC_DATA);
            if (CreateVolumeWizard.this.hostTypeDesc != null && CreateVolumeWizard.this.hostTypeDesc.length() == 0) {
                CreateVolumeWizard.this.hostTypeDesc = null;
            }
            CreateVolumeWizard.this.hostportWWPNs = new String[CreateVolumeWizard.this.hostports.size()];
            CreateVolumeWizard.this.hostNames = new String[CreateVolumeWizard.this.hostports.size()];
            int n2 = 0;
            while (n2 < CreateVolumeWizard.this.hostports.size()) {
                ((CreateVolumeWizard)CreateVolumeWizard.this).hostportWWPNs[n2] = ((GUIPort)CreateVolumeWizard.this.hostports.get(n2)).getWwpn();
                ((CreateVolumeWizard)CreateVolumeWizard.this).hostNames[n2] = ((GUIPort)CreateVolumeWizard.this.hostports.get(n2)).getHostName();
                ++n2;
            }
            if (CreateVolumeWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVolumeWizard.this.subSystem.getCapabilityData().getPortsPerView() && CreateVolumeWizard.this.ssports != null) {
                CreateVolumeWizard.this.ssportWWPNs = new String[CreateVolumeWizard.this.ssports.size()];
                n2 = 0;
                while (n2 < CreateVolumeWizard.this.ssports.size()) {
                    ((CreateVolumeWizard)CreateVolumeWizard.this).ssportWWPNs[n2] = ((GUIPort)CreateVolumeWizard.this.ssports.get(n2)).getWwpn();
                    ++n2;
                }
            } else {
                CreateVolumeWizard.this.ssportWWPNs = null;
            }
            HashMap hashMap = (HashMap)CreateVolumeWizard.this.volumeData.get(CreateVolumeZoneActionStep.ZONE_ACTION_DATA);
            if (hashMap != null) {
                Iterator iterator = hashMap.values().iterator();
                new Vector(hashMap.values());
                while (iterator.hasNext()) {
                    int n3;
                    String[] stringArray2;
                    Vector vector2;
                    BaseZoneActionStep.ZoneAction zoneAction = (BaseZoneActionStep.ZoneAction)iterator.next();
                    if (zoneAction.action == 0) {
                        zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                        vector2 = zoneAction.hostPorts;
                        stringArray2 = new String[vector2.size()];
                        n3 = 0;
                        while (n3 < vector2.size()) {
                            stringArray2[n3] = ((GUIPort)vector2.get(n3)).getWwpn();
                            ++n3;
                        }
                        CreateVolumeWizard.this.diskController.createZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, stringArray2);
                        continue;
                    }
                    if (zoneAction.action != 1) continue;
                    zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                    vector2 = zoneAction.hostPorts;
                    stringArray2 = new String[vector2.size()];
                    n3 = 0;
                    while (n3 < vector2.size()) {
                        stringArray2[n3] = ((GUIPort)vector2.get(n3)).getWwpn();
                        ++n3;
                    }
                    CreateVolumeWizard.this.diskController.updateZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, stringArray2);
                }
            }
            if (CreateVolumeWizard.this.hostportWWPNs == null || CreateVolumeWizard.this.hostportWWPNs.length == 0) {
                CreateVolumeWizard.this.diskController.createVolumes(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        GuiUtil.triggerJobChange((short)107);
                    }
                }, l, gUIStoragePool.getId(), n, stringArray, false);
            } else {
                CreateVolumeWizard.this.diskController.createVolumesAndAssignPorts(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        GuiUtil.triggerJobChange((short)107);
                    }
                }, l, gUIStoragePool.getId(), n, stringArray, CreateVolumeWizard.this.ssportWWPNs, CreateVolumeWizard.this.hostportWWPNs, CreateVolumeWizard.this.hostType, CreateVolumeWizard.this.hostTypeDesc, CreateVolumeWizard.this.hostNames);
            }
        }
    }

    public class ZoneRequestor
    implements GuiRequestor {
        String fabricID = null;

        public ZoneRequestor(String string) {
            this.fabricID = string;
        }

        public void handleResponse(short s, Response response) {
            GuiUtil.triggerJobChange((short)108);
            if (s <= 4) {
                int n = (Integer)response.responseData;
                new JobResultThread(n, this.fabricID).start();
            }
        }
    }
}

