/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneConfigurationTree;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneConfigurationPanel
extends JPanel
implements ActionListener {
    protected ZoneCNS zoneCNS = null;
    protected JButton refreshButton;
    protected JButton editButton;
    protected JLabel leftTitle;
    protected JLabel rightTitle;
    protected ZoneConfigurationTree zoneTree;
    protected ZoneConfigurationTree activeZoneTree;
    protected JPanel returnPanel;
    protected JPanel activePanel;
    protected JPanel definitionPanel;
    private JLabel statusLabel = new JLabel("");
    private JLabel zsActiveLabel = new JLabel("");
    private String sanWWN = null;
    private String sanLabel = null;

    public ZoneConfigurationPanel(ZoneCNS zoneCNS) {
        this.zoneCNS = zoneCNS;
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createButtonPanel(), "North");
        this.refreshButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.enableEditButton(false);
        this.add((Component)this.createZonePanels(), "Center");
    }

    private JPanel createZonePanels() {
        this.returnPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.activePanel = this.createActiveZonePanel();
        this.definitionPanel = this.createZoneDefinitionPanel();
        this.leftTitle = new JLabel(FabricGuiUtil.getString("FabricZone_ActiveConfig"));
        this.rightTitle = new JLabel(FabricGuiUtil.getString("FabricZoneSetPage_title"));
        this.leftTitle.setLabelFor(this.activePanel);
        this.rightTitle.setLabelFor(this.definitionPanel);
        JPanel jPanel = this.getPane(this.activePanel, this.leftTitle);
        JPanel jPanel2 = this.getPane(this.definitionPanel, this.rightTitle);
        GuiUtil.setAccessible(this.leftTitle, FabricGuiUtil.getString("FabricZone_ActiveConfig"), FabricGuiUtil.getString("FabricZone_Active_Tree_Description"));
        GuiUtil.setAccessible(this.rightTitle, FabricGuiUtil.getString("FabricZone_ConfigDef"), FabricGuiUtil.getString("FabricZone_Def_Tree_Description"));
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.returnPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.returnPanel.add((Component)jPanel2, gridBagConstraints);
        return this.returnPanel;
    }

    public ZoneCNS getZoneCNS() {
        return this.zoneCNS;
    }

    private JPanel createZoneDefinitionPanel() {
        JPanel jPanel = GuiUtil.getPanel();
        jPanel.setLayout(new BorderLayout());
        this.zoneTree = new ZoneConfigurationTree(this.zoneCNS, false);
        new JScrollPane(this.zoneTree);
        jPanel.add(this.zoneTree);
        return jPanel;
    }

    private JPanel createActiveZonePanel() {
        JPanel jPanel = GuiUtil.getPanel();
        jPanel.setLayout(new BorderLayout());
        this.activeZoneTree = new ZoneConfigurationTree(this.zoneCNS, true);
        jPanel.add((Component)this.activeZoneTree, "Center");
        return jPanel;
    }

    public void refreshZoneConfigTab() {
        this.sanWWN = this.zoneCNS.getSanWWN();
        this.sanLabel = this.zoneCNS.getSanLabel();
        this.setActiveText();
        this.zoneTree.populateTree();
        this.activeZoneTree.populateTree();
        this.remove(this.returnPanel);
        this.add((Component)this.createZonePanels(), "Center");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = GuiUtil.getBorderedPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(Util.getString("FabricZone_DisplayZones")));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.refreshButton = new JButton(FabricGuiUtil.getString("FabricZone_Refresh"));
        GuiUtil.setAccessible(this.refreshButton, FabricGuiUtil.getString("FabricZone_Refresh"), FabricGuiUtil.getString("FabricZone_Refresh"));
        this.refreshButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_Refresh_M")));
        this.editButton = new JButton(FabricGuiUtil.getString("FabricZone_EditConfig"));
        GuiUtil.setAccessible(this.editButton, FabricGuiUtil.getString("FabricZone_EditConfig"), FabricGuiUtil.getString("FabricZone_EditConfig"));
        this.editButton.setMnemonic(GuiUtil.getMnemonic(FabricGuiUtil.getString("FabricZone_EditConfig_M")));
        jPanel2.add(this.refreshButton);
        jPanel2.add(this.editButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.zsActiveLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.statusLabel, gridBagConstraints);
        return jPanel;
    }

    public void setStatusText(String string) {
        this.statusLabel.setText(string);
        GuiUtil.setAccessibleLabel(this.statusLabel, this, "", string, string);
    }

    public void setActiveText() {
        String string = this.zoneCNS.getActiveZoneSetLabel();
        if (string != null && !string.equals("")) {
            String string2 = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZone_CurrentAct"), new Object[]{string});
            this.zsActiveLabel.setText(string2);
            GuiUtil.setAccessibleLabel(this.zsActiveLabel, this, "", string2, string2);
        } else {
            this.zsActiveLabel.setText("");
        }
    }

    private JPanel getPane(JComponent jComponent, JLabel jLabel) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jComponent);
        jScrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public void enableEditButton(boolean bl) {
        this.editButton.setEnabled(bl);
    }

    public void enableRefreshButton(boolean bl) {
        this.refreshButton.setEnabled(bl);
    }

    public String getSanWWN() {
        return this.sanWWN;
    }

    public String getSanLabel() {
        return this.sanLabel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.zoneCNS.reDisplay();
        } else if (object == this.editButton) {
            if (!this.zoneCNS.isDefinitionPanelOpened()) {
                this.zoneCNS.reserveTokenAndCheckDefinition(this);
            } else {
                this.zoneCNS.bringDefinitionPanelToFront();
            }
        }
    }
}

