/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;

public class ZoneMemberPanel
extends JPanel
implements ActionListener {
    private Zone zone = new Zone("temp");
    private boolean newZone = false;
    private ZoneCNS zoneCNS;
    private Vector zoneAssets = new Vector();
    private ZoneMember[] origZoneMems = null;
    protected JButton addButton;
    protected JButton delButton;
    protected JPanel leftPane;
    protected JPanel rightPane;
    protected JPanel middlePane;
    protected JLabel leftTitle;
    protected JLabel rightTitle;
    private JList assetList;
    private JTree assetTree;
    private short N_PORT = (short)11;
    private short SWITCHPORT = (short)12;
    private short FCID = (short)13;
    private short DEVICE_PORT = (short)10;
    private short NODE_PORT = (short)14;
    private DefaultMutableTreeNode topNode = new DefaultMutableTreeNode();
    private HashMap switchNodes = new HashMap();
    private HashMap domainPorts = new HashMap();
    private HashMap fcidPorts = new HashMap();
    private HashMap wwnPorts = new HashMap();
    private DefaultMutableTreeNode switchNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Switches")));
    private DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Devices")));
    private DefaultMutableTreeNode aliasNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_ZoneAliases")));
    HashMap assetMap = new HashMap();

    public ZoneMemberPanel(boolean bl, Zone zone, ZoneCNS zoneCNS, ZoneMember[] zoneMemberArray) {
        this.newZone = bl;
        this.zoneCNS = zoneCNS;
        this.zone = zone;
        this.origZoneMems = zoneMemberArray;
        this.init();
    }

    public void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.addButton = new JButton(">>");
        Font font = this.addButton.getFont().deriveFont(1);
        this.addButton.setFont(font);
        this.delButton = new JButton("<<");
        this.delButton.setFont(font);
        this.assetTree = new JTree(this.topNode);
        this.assetTree.setRootVisible(false);
        this.assetTree.setShowsRootHandles(true);
        this.assetTree.getSelectionModel().setSelectionMode(4);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.assetTree.setCellRenderer(defaultTreeCellRenderer);
        this.assetTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ZoneMemberPanel.this.assetTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    ZoneMemberPanel.this.addButton.setEnabled(false);
                    return;
                }
                AssetNode assetNode = (AssetNode)defaultMutableTreeNode.getUserObject();
                if (ZoneMemberPanel.this.isAsset(assetNode) || assetNode.isSwitch() && ZoneMemberPanel.this.zoneCNS.getZoneCapabilities().isSupportsDomainPort() || assetNode.isDevice()) {
                    ZoneMemberPanel.this.addButton.setEnabled(true);
                    ZoneMemberPanel.this.delButton.setEnabled(false);
                    ZoneMemberPanel.this.assetList.clearSelection();
                } else {
                    ZoneMemberPanel.this.addButton.setEnabled(false);
                }
            }
        });
        this.populateAssetTree();
        JScrollPane jScrollPane = new JScrollPane(this.assetTree);
        jScrollPane.setName(Util.getString("FabricZonePanel_AssetTreeTitle"));
        this.zoneAssets = this.populateMemberList();
        this.assetList = new JList(this.zoneAssets);
        this.assetList.setSelectionMode(2);
        this.assetList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AssetNode assetNode = (AssetNode)ZoneMemberPanel.this.assetList.getSelectedValue();
                if (assetNode == null) {
                    ZoneMemberPanel.this.delButton.setEnabled(false);
                    return;
                }
                ZoneMemberPanel.this.assetTree.clearSelection();
                ZoneMemberPanel.this.addButton.setEnabled(false);
                ZoneMemberPanel.this.delButton.setEnabled(true);
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.assetList);
        this.leftTitle = new JLabel(Util.getString("FabricZonePanel_AssetTreeTitle"));
        this.leftTitle.setFont(font);
        this.rightTitle = new JLabel(Util.getString("FabricZonePanel_AssetListTitle"));
        this.rightTitle.setFont(font);
        this.leftTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_AVAILABLE"));
        this.leftTitle.setLabelFor(jScrollPane);
        this.rightTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_PROBE_TREE_SELECTED"));
        this.rightTitle.setLabelFor(jScrollPane2);
        this.leftPane = this.getPane(jScrollPane, this.leftTitle);
        this.rightPane = this.getPane(jScrollPane2, this.rightTitle);
        this.middlePane = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets.bottom = 10;
        this.middlePane.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        this.middlePane.add((Component)this.delButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.leftPane, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.middlePane, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.rightPane, gridBagConstraints);
        this.addButton.setEnabled(false);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.delButton.addActionListener(this);
    }

    private JPanel getPane(JComponent jComponent, JLabel jLabel) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jComponent);
        jScrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private Vector populateMemberList() {
        Vector<AssetNode> vector = new Vector<AssetNode>();
        if (!this.newZone) {
            ZoneMember[] zoneMemberArray = this.origZoneMems;
            int n = 0;
            while (n < zoneMemberArray.length) {
                AssetNode assetNode;
                if (zoneMemberArray[n].getType() == this.SWITCHPORT) {
                    assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_Port")) + " " + zoneMemberArray[n].getName(), zoneMemberArray[n]);
                    vector.add(assetNode);
                    this.assetMap.put(String.valueOf(Util.getString("FabricZonePanel_Port")) + " " + zoneMemberArray[n].getName(), assetNode);
                } else if (zoneMemberArray[n].getType() == this.N_PORT) {
                    assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_PortWWN")) + " " + zoneMemberArray[n].getName(), zoneMemberArray[n]);
                    vector.add(assetNode);
                    this.assetMap.put(String.valueOf(Util.getString("FabricZonePanel_PortWWN")) + " " + zoneMemberArray[n].getName(), assetNode);
                } else if (zoneMemberArray[n].getType() == this.FCID) {
                    assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_FCID")) + " " + zoneMemberArray[n].getName(), zoneMemberArray[n]);
                    vector.add(assetNode);
                    this.assetMap.put(String.valueOf(Util.getString("FabricZonePanel_FCID")) + " " + zoneMemberArray[n].getName(), assetNode);
                } else if (zoneMemberArray[n].getType() == this.DEVICE_PORT) {
                    assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_DevicePort")) + " " + zoneMemberArray[n].getName(), zoneMemberArray[n]);
                    vector.add(assetNode);
                    this.assetMap.put(String.valueOf(Util.getString("FabricZonePanel_DevicePort")) + " " + zoneMemberArray[n].getName(), assetNode);
                } else if (zoneMemberArray[n].getType() == this.NODE_PORT) {
                    assetNode = new AssetNode(String.valueOf(Util.getString("FabricDetails_Node")) + " " + zoneMemberArray[n].getName(), zoneMemberArray[n]);
                    vector.add(assetNode);
                    this.assetMap.put(String.valueOf(Util.getString("FabricDetails_Node")) + " " + zoneMemberArray[n].getName(), assetNode);
                } else if (!zoneMemberArray[n].getName().equals("0000000000000000")) {
                    assetNode = new AssetNode(zoneMemberArray[n].getName(), zoneMemberArray[n]);
                    vector.add(assetNode);
                    this.assetMap.put(zoneMemberArray[n].getName(), assetNode);
                }
                ++n;
            }
            ZoneAlias[] zoneAliasArray = this.zoneCNS.getZoneAliases(this.zone);
            int n2 = 0;
            while (n2 < zoneAliasArray.length) {
                AssetNode assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_Alias")) + " " + zoneAliasArray[n2].getName(), zoneAliasArray[n2]);
                vector.add(assetNode);
                this.assetMap.put(String.valueOf(Util.getString("FabricZonePanel_Alias")) + " " + zoneAliasArray[n2].getName(), assetNode);
                ++n2;
            }
        }
        return vector;
    }

    public void populateAssetTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Switches")));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_Devices")));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new AssetNode(Util.getString("FabricZonePanel_ZoneAliases")));
        if (ZoneCNS.DEBUG) {
            DefaultMutableTreeNode defaultMutableTreeNode4;
            Object object;
            int n = 5;
            short s = 1;
            int n2 = 0;
            while (n2 < n) {
                object = new AssetNode("Domain " + n2 + " (Switch " + n2 + ")");
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                int n3 = 0;
                while (n3 < 5) {
                    AssetNode assetNode = new AssetNode("Port " + n3, new ZoneMember(s, "Port " + n3));
                    DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(assetNode);
                    DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new AssetNode("FCID " + n3, new ZoneMember(s, "FCID " + n3)));
                    DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new AssetNode("Port WWN " + n3, new ZoneMember(s, "Port WWN " + n3)));
                    defaultMutableTreeNode6.add(defaultMutableTreeNode7);
                    defaultMutableTreeNode5.add(defaultMutableTreeNode6);
                    defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                    ++n3;
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode4);
                ++n2;
            }
            n2 = 0;
            while (n2 < 25) {
                object = new DefaultMutableTreeNode(new AssetNode("Device " + n2));
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new AssetNode("Device " + n2, new ZoneMember(s, "Device " + n2)));
                ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode4);
                defaultMutableTreeNode2.add((MutableTreeNode)object);
                ++n2;
            }
            n2 = 0;
            while (n2 < 15) {
                object = new DefaultMutableTreeNode(new AssetNode("Alias " + n2, new ZoneAlias("Alias" + n2)));
                defaultMutableTreeNode3.add((MutableTreeNode)object);
                ++n2;
            }
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode8;
            String string;
            Object object;
            Object object2;
            String string2;
            Cloneable cloneable;
            Object object3;
            Object object4;
            String string3 = null;
            DefaultMutableTreeNode defaultMutableTreeNode9 = null;
            HashMap[] hashMapArray = this.zoneCNS.getSwitchZMHash();
            String string4 = this.zoneCNS.getSanWWN();
            HashMap hashMap = new HashMap();
            if (hashMapArray != null) {
                int n = 0;
                while (n < hashMapArray.length) {
                    hashMap = hashMapArray[n];
                    object4 = (String)hashMap.get(new String("SWITCHWWN"));
                    defaultMutableTreeNode9 = this.getAssetSwitchNode(string3, (String)object4, hashMap);
                    defaultMutableTreeNode.add(defaultMutableTreeNode9);
                    object3 = (String)hashMap.get(new String("EPPORTWWN"));
                    cloneable = null;
                    if (object3 != null && !FabricGuiUtil.isSwitchPort((Integer)hashMap.get("EPPORTTYPE"))) {
                        cloneable = this.getPortWWNNode((String)object3);
                    }
                    Integer n4 = (Integer)hashMap.get("EPFCID");
                    string2 = this.getFCIDHex(n4);
                    object2 = null;
                    if (this.zoneCNS.getZoneCapabilities().isSupportsFCID() && string2 != null) {
                        object2 = this.getFcidPortNode(string2);
                    }
                    object = (String)hashMap.get("SWITCHPORTWWN");
                    string = String.valueOf((String)hashMap.get("DOMAIN")) + "," + (String)hashMap.get("PORTPHY");
                    defaultMutableTreeNode8 = null;
                    if (this.isDomainPortZoneable((String)object, (String)object4, string4, hashMap)) {
                        defaultMutableTreeNode8 = this.getDomainPortNode(string);
                    }
                    if (defaultMutableTreeNode8 != null) {
                        if (object2 != null) {
                            if (cloneable != null) {
                                ((DefaultMutableTreeNode)object2).add((MutableTreeNode)((Object)cloneable));
                            }
                            defaultMutableTreeNode8.add((MutableTreeNode)object2);
                        } else if (cloneable != null) {
                            defaultMutableTreeNode8.add((MutableTreeNode)((Object)cloneable));
                        }
                        defaultMutableTreeNode9.add(defaultMutableTreeNode8);
                    } else if (object2 != null) {
                        if (cloneable != null) {
                            ((DefaultMutableTreeNode)object2).add((MutableTreeNode)((Object)cloneable));
                        }
                        defaultMutableTreeNode9.add((MutableTreeNode)object2);
                    } else if (cloneable != null) {
                        defaultMutableTreeNode9.add((MutableTreeNode)((Object)cloneable));
                    }
                    ++n;
                }
            }
            HashMap<String, DefaultMutableTreeNode> hashMap2 = new HashMap<String, DefaultMutableTreeNode>();
            object4 = new HashMap();
            object3 = new HashMap();
            cloneable = new HashMap();
            int n = 0;
            while (n < 4) {
                string2 = String.valueOf(Util.getString("FabricZonePanel_Device")) + " ";
                object2 = String.valueOf(Util.getString("FabricZonePanel_DevicePort")) + " ";
                object = null;
                switch (n) {
                    case 0: {
                        object = this.zoneCNS.getDeviceSPZMHash();
                        break;
                    }
                    case 1: {
                        object = this.zoneCNS.getDeviceZMHash();
                        break;
                    }
                    case 2: {
                        object = this.zoneCNS.getNodeZMHash();
                        break;
                    }
                    case 3: {
                        object = this.zoneCNS.getPortZMHash();
                    }
                }
                string = null;
                defaultMutableTreeNode8 = null;
                if (object != null) {
                    int n5 = 0;
                    while (n5 < ((HashMap[])object).length) {
                        Object object5;
                        DefaultMutableTreeNode defaultMutableTreeNode10;
                        Object object6;
                        if (string == null || (String)object[n5].get("Label") != string) {
                            string = (String)object[n5].get("Label");
                            object6 = new AssetNode(String.valueOf(string2) + (String)object[n5].get("Label"));
                            ((AssetNode)object6).setTypeToDevice();
                            if (hashMap2.containsKey(string)) {
                                defaultMutableTreeNode8 = (DefaultMutableTreeNode)hashMap2.get(string);
                            } else {
                                defaultMutableTreeNode8 = new DefaultMutableTreeNode(object6);
                                hashMap2.put(string, defaultMutableTreeNode8);
                                defaultMutableTreeNode2.add(defaultMutableTreeNode8);
                            }
                        }
                        if ((object6 = (String)object[n5].get("NODEWWN")) != null && this.zoneCNS.isNodeZoneAsset() && !((String)object6).equals("")) {
                            defaultMutableTreeNode10 = new DefaultMutableTreeNode(new AssetNode(String.valueOf(Util.getString("FabricDetails_Node")) + " " + (String)object6, new ZoneMember(this.NODE_PORT, (String)object6)));
                            if (((HashMap)object4).containsKey(object6)) {
                                defaultMutableTreeNode10 = (DefaultMutableTreeNode)((HashMap)object4).get(object6);
                            } else {
                                defaultMutableTreeNode8.add(defaultMutableTreeNode10);
                                ((HashMap)object4).put(object6, defaultMutableTreeNode10);
                            }
                            String string5 = (String)object[n5].get("PORTWWN");
                            object5 = new DefaultMutableTreeNode(new AssetNode(String.valueOf(object2) + string5, new ZoneMember(this.N_PORT, string5)));
                            if (!((HashMap)object3).containsKey(string5)) {
                                defaultMutableTreeNode10.add((MutableTreeNode)object5);
                                ((HashMap)object3).put(string5, object5);
                            }
                        } else {
                            object5 = (String)object[n5].get("PORTWWN");
                            defaultMutableTreeNode10 = new DefaultMutableTreeNode(new AssetNode(String.valueOf(object2) + (String)object5, new ZoneMember(this.N_PORT, (String)object5)));
                            if (!((HashMap)cloneable).containsKey(object5)) {
                                defaultMutableTreeNode8.add(defaultMutableTreeNode10);
                                ((HashMap)cloneable).put(object5, defaultMutableTreeNode10);
                            }
                        }
                        ++n5;
                    }
                }
                ++n;
            }
            if (this.zoneCNS.getZoneCapabilities().isSupportsAliases()) {
                ZoneAlias[] zoneAliasArray = this.zoneCNS.getAllZoneAliases();
                int n6 = 0;
                while (n6 < zoneAliasArray.length) {
                    object2 = new DefaultMutableTreeNode(new AssetNode(String.valueOf(Util.getString("FabricZonePanel_Alias")) + " " + zoneAliasArray[n6].getName(), zoneAliasArray[n6]));
                    defaultMutableTreeNode3.add((MutableTreeNode)object2);
                    ++n6;
                }
            }
        }
        this.topNode.add(defaultMutableTreeNode);
        this.topNode.add(defaultMutableTreeNode2);
        if (!ZoneCNS.DEBUG && this.zoneCNS.getZoneCapabilities().isSupportsAliases()) {
            this.topNode.add(defaultMutableTreeNode3);
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.topNode);
        this.assetTree.setModel(defaultTreeModel);
    }

    protected Vector getZoneMembers() {
        Vector<Comparable> vector = new Vector<Comparable>();
        Enumeration enumeration = this.zoneAssets.elements();
        while (enumeration.hasMoreElements()) {
            AssetNode assetNode = (AssetNode)enumeration.nextElement();
            if (assetNode.isZoneMember()) {
                vector.add(assetNode.getZoneMember());
                continue;
            }
            vector.add(assetNode.getZoneAlias());
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            if (!ZoneCNS.DEBUG && this.zoneCNS.getZoneCapabilities().getMaxMembersInZone() == this.assetList.getModel().getSize()) {
                JOptionPane.showMessageDialog(this, Util.getString("FabricZonePanel_MaxZoneMembers"));
            } else {
                TreePath[] treePathArray = this.assetTree.getSelectionPaths();
                int n = 0;
                while (n < treePathArray.length) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                    AssetNode assetNode = (AssetNode)defaultMutableTreeNode.getUserObject();
                    if (this.isAsset(assetNode) && !this.assetMap.containsKey(assetNode.name) && assetNode.name != null) {
                        this.zoneAssets.add(assetNode);
                        this.assetList.setListData(this.zoneAssets);
                        this.assetMap.put(assetNode.name, assetNode);
                    } else if (assetNode.isSwitch() && this.zoneCNS.getZoneCapabilities().isSupportsDomainPort() || assetNode.isDevice()) {
                        AssetNode assetNode2 = null;
                        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                        while (enumeration.hasMoreElements()) {
                            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                            assetNode2 = (AssetNode)defaultMutableTreeNode2.getUserObject();
                            if (this.assetMap.containsKey(assetNode2.name) || assetNode2.name == null) continue;
                            this.zoneAssets.add(assetNode2);
                            this.assetMap.put(assetNode2.name, assetNode2);
                        }
                        this.assetList.setListData(this.zoneAssets);
                    }
                    ++n;
                }
            }
        } else if (object == this.delButton && (objectArray = this.assetList.getSelectedValues()) != null) {
            int n = 0;
            while (n < objectArray.length) {
                AssetNode assetNode = (AssetNode)objectArray[n];
                this.zoneAssets.remove(assetNode);
                if (this.assetMap.containsKey(assetNode.name)) {
                    this.assetMap.remove(assetNode.name);
                }
                ++n;
            }
            this.assetList.setListData(this.zoneAssets);
        }
    }

    private boolean isAsset(AssetNode assetNode) {
        return assetNode.getZoneMember() != null || assetNode.isAlias();
    }

    public String getPortMode(int n) {
        String string = new String();
        switch (n) {
            case 1: {
                string = Util.getString("FabricAvantiMode_Initiator");
                break;
            }
            case 2: {
                string = Util.getString("FabricAvantiMode_Target");
                break;
            }
            case 3: {
                string = Util.getString("FabricAvantiMode_Both");
            }
        }
        return string;
    }

    private DefaultMutableTreeNode getAssetSwitchNode(String string, String string2, HashMap hashMap) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (string == null || string2 != string) {
            string = string2;
            if (!this.switchNodes.containsKey(string)) {
                String string3 = string;
                String string4 = new String();
                try {
                    string4 = (String)hashMap.get("DOMAIN");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                AssetNode assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_Domain")) + " " + string4 + " (" + Util.getString("FabricZonePanel_Switch") + string3 + ")");
                assetNode.setTypeToSwitch();
                defaultMutableTreeNode = new DefaultMutableTreeNode(assetNode);
                this.switchNode.add(defaultMutableTreeNode);
                this.switchNodes.put(string, defaultMutableTreeNode);
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.switchNodes.get(string);
            }
            return defaultMutableTreeNode;
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getDomainPortNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (!this.domainPorts.containsKey(string)) {
            AssetNode assetNode = new AssetNode(String.valueOf(Util.getString("FabricZonePanel_Port")) + " " + string, new ZoneMember(this.SWITCHPORT, string));
            defaultMutableTreeNode = new DefaultMutableTreeNode(assetNode);
            this.domainPorts.put(string, defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.domainPorts.get(string);
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getFcidPortNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (!this.fcidPorts.containsKey(string)) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(new AssetNode(String.valueOf(Util.getString("FabricZonePanel_FCID")) + " " + string, new ZoneMember(this.FCID, string)));
            this.fcidPorts.put(string, defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.fcidPorts.get(string);
        }
        return defaultMutableTreeNode;
    }

    private String getFCIDHex(Integer n) {
        String string = null;
        if (n != null) {
            string = Integer.toHexString(n);
            switch (string.length()) {
                case 0: {
                    string = "000000" + string;
                    break;
                }
                case 1: {
                    string = "00000" + string;
                    break;
                }
                case 2: {
                    string = "0000" + string;
                    break;
                }
                case 3: {
                    string = "000" + string;
                    break;
                }
                case 4: {
                    string = "00" + string;
                    break;
                }
                case 5: {
                    string = "0" + string;
                }
            }
        }
        return string;
    }

    private DefaultMutableTreeNode getPortWWNNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (!this.wwnPorts.containsKey(string)) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(new AssetNode(String.valueOf(Util.getString("FabricZonePanel_PortWWN")) + " " + string, new ZoneMember(this.N_PORT, string)));
            this.wwnPorts.put(string, defaultMutableTreeNode);
        } else {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.wwnPorts.get(string);
        }
        return defaultMutableTreeNode;
    }

    private boolean isDomainPortZoneable(String string, String string2, String string3, HashMap hashMap) {
        boolean bl = this.getDetectable((Integer)hashMap.get("PORTSTATE"));
        boolean bl2 = this.getDetectable((Integer)hashMap.get("SWITCH2PORTSTATE"));
        boolean bl3 = this.getDetectable((Integer)hashMap.get("FABRIC2SWITCHSTATE"));
        if (bl) {
            return bl2 && bl3;
        }
        return true;
    }

    private boolean getDetectable(Integer n) {
        return n != null && n.equals(new Integer(1));
    }

    class AssetListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AssetListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((ZoneMember)object).getName();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }

    class AssetNode {
        protected String name;
        protected int type = 0;
        protected ZoneMember zoneMember = null;
        protected ZoneAlias aliasMember = null;

        public AssetNode(String string) {
            this.name = string;
        }

        public AssetNode(String string, ZoneMember zoneMember) {
            this.zoneMember = zoneMember;
            this.name = string;
        }

        public AssetNode(String string, ZoneAlias zoneAlias) {
            this.aliasMember = zoneAlias;
            this.setTypeToAlias();
            this.name = string;
        }

        public boolean isDevice() {
            return this.type == 3;
        }

        public boolean isSwitch() {
            return this.type == 2;
        }

        public boolean isAlias() {
            return this.type == 1;
        }

        public boolean isZoneMember() {
            return this.type == 0;
        }

        public void setTypeToDevice() {
            this.type = 3;
        }

        public void setTypeToSwitch() {
            this.type = 2;
        }

        public void setTypeToAlias() {
            this.type = 1;
        }

        public void setTypeToZoneMember() {
            this.type = 0;
        }

        public String toString() {
            return this.name;
        }

        public ZoneMember getZoneMember() {
            return this.zoneMember;
        }

        public ZoneAlias getZoneAlias() {
            return this.aliasMember;
        }
    }

    class AssetTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon treeIcon;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(this.treeIcon);
            return this;
        }
    }
}

