/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelPinList;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Computer;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Other;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2TapeLibrary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphTapeLibrary;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBox;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxComputerSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxFabricSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxOtherSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxStorageSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoBoxSwitchSummary;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.PinList;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.WidgetPool;

public class JTopoCanvasOverview
extends AbstractJTopoCanvas {
    protected static final String WIDGET_FABRICSUMMARY = "WIDGET_FABRICSUMMARY";
    protected static final String WIDGET_COMPUTERSUMMARY = "WIDGET_COMPUTERSUMMARY";
    protected static final String WIDGET_SWITCHSUMMARY = "WIDGET_SWITCHSUMMARY";
    protected static final String WIDGET_STORAGESUMMARY = "WIDGET_STORAGESUMMARY";
    protected static final String WIDGET_OTHERSUMMARY = "WIDGET_OTHERSUMMARY";

    public JTopoCanvasOverview() {
        this.widgetH.put(WIDGET_FABRICSUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_COMPUTERSUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_SWITCHSUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_STORAGESUMMARY, new Hashtable());
        this.widgetH.put(WIDGET_OTHERSUMMARY, new Hashtable());
    }

    public String getViewName() {
        return GuiUtil.getString("TOPO_LABEL_VIEW_OVERVIEW");
    }

    protected void reattach() {
        AbstractJTopoBox abstractJTopoBox;
        Hashtable hashtable;
        GraphEntity.ID iD;
        GraphEntity graphEntity;
        if (GraphDebug.isInfoVisible()) {
            GraphDebug.info("---------------JTopoCanvasOverview, reattach()---------------");
        }
        WidgetPool widgetPool = WidgetPool.getInstance();
        Integer n = null;
        Object object = this.dataModel.enumerate(GraphFabricSummary.TYPE);
        if (object.hasMoreElements()) {
            graphEntity = (GraphFabricSummary)object.nextElement();
            iD = (GraphFabricSummary.ID)graphEntity.getEntityID();
            hashtable = (Hashtable)this.widgetH.get(WIDGET_FABRICSUMMARY);
            abstractJTopoBox = (JTopoBoxFabricSummary)hashtable.get(iD);
            if (abstractJTopoBox == null) {
                abstractJTopoBox = (JTopoBoxFabricSummary)widgetPool.getWidget(JTopoBoxFabricSummary.class);
                abstractJTopoBox.setSessionModel(this, "Focus");
                hashtable.put(iD, abstractJTopoBox);
                this.canvasPanel.add(abstractJTopoBox);
            }
            abstractJTopoBox.setDataModel(graphEntity);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getHealthStatus());
        }
        if ((object = this.dataModel.enumerate(GraphComputerSummary.TYPE)).hasMoreElements()) {
            graphEntity = (GraphComputerSummary)object.nextElement();
            iD = (GraphComputerSummary.ID)graphEntity.getEntityID();
            hashtable = (Hashtable)this.widgetH.get(WIDGET_COMPUTERSUMMARY);
            abstractJTopoBox = (JTopoBoxComputerSummary)hashtable.get(iD);
            if (abstractJTopoBox == null) {
                abstractJTopoBox = (JTopoBoxComputerSummary)widgetPool.getWidget(JTopoBoxComputerSummary.class);
                abstractJTopoBox.setSessionModel(this, "Focus");
                hashtable.put(iD, abstractJTopoBox);
                this.canvasPanel.add(abstractJTopoBox);
            }
            abstractJTopoBox.setDataModel(graphEntity);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getHealthStatus());
        }
        if ((object = this.dataModel.enumerate(GraphSwitchSummary.TYPE)).hasMoreElements()) {
            graphEntity = (GraphSwitchSummary)object.nextElement();
            iD = (GraphSwitchSummary.ID)graphEntity.getEntityID();
            hashtable = (Hashtable)this.widgetH.get(WIDGET_FABRICSUMMARY);
            abstractJTopoBox = (JTopoBoxSwitchSummary)hashtable.get(iD);
            if (abstractJTopoBox == null) {
                abstractJTopoBox = (JTopoBoxSwitchSummary)widgetPool.getWidget(JTopoBoxSwitchSummary.class);
                abstractJTopoBox.setSessionModel(this, "Focus");
                hashtable.put(iD, abstractJTopoBox);
                this.canvasPanel.add(abstractJTopoBox);
            }
            abstractJTopoBox.setDataModel(graphEntity);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getHealthStatus());
        }
        if ((object = this.dataModel.enumerate(GraphStorageSummary.TYPE)).hasMoreElements()) {
            graphEntity = (GraphStorageSummary)object.nextElement();
            iD = (GraphStorageSummary.ID)graphEntity.getEntityID();
            hashtable = (Hashtable)this.widgetH.get(WIDGET_STORAGESUMMARY);
            abstractJTopoBox = (JTopoBoxStorageSummary)hashtable.get(iD);
            if (abstractJTopoBox == null) {
                abstractJTopoBox = (JTopoBoxStorageSummary)widgetPool.getWidget(JTopoBoxStorageSummary.class);
                abstractJTopoBox.setSessionModel(this, "Focus");
                hashtable.put(iD, abstractJTopoBox);
                this.canvasPanel.add(abstractJTopoBox);
            }
            abstractJTopoBox.setDataModel(graphEntity);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getHealthStatus());
        }
        if ((object = this.dataModel.enumerate(GraphOtherSummary.TYPE)).hasMoreElements()) {
            graphEntity = (GraphOtherSummary)object.nextElement();
            iD = (GraphOtherSummary.ID)graphEntity.getEntityID();
            hashtable = (Hashtable)this.widgetH.get(WIDGET_OTHERSUMMARY);
            abstractJTopoBox = (JTopoBoxOtherSummary)hashtable.get(iD);
            if (abstractJTopoBox == null) {
                abstractJTopoBox = (JTopoBoxOtherSummary)widgetPool.getWidget(JTopoBoxOtherSummary.class);
                abstractJTopoBox.setSessionModel(this, "Focus");
                hashtable.put(iD, abstractJTopoBox);
                this.canvasPanel.add(abstractJTopoBox);
            }
            abstractJTopoBox.setDataModel(graphEntity);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getHealthStatus());
        }
        object = this.controllerView.getTopoView();
        ((JTopoView)object).setStatus(n);
    }

    public Vector getPinContainers(GraphEntity.ID iD) {
        PinList pinList = this.controllerView.getControllerApp().getPinList();
        GraphModelPinList graphModelPinList = (GraphModelPinList)pinList.getModel();
        Vector<ITopoPinContainerWidget> vector = new Vector<ITopoPinContainerWidget>();
        Enumeration enumeration = this.widgetH.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                ITopoPinContainerWidget iTopoPinContainerWidget = (ITopoPinContainerWidget)enumeration2.nextElement();
                boolean bl = false;
                if (iTopoPinContainerWidget instanceof JTopoBoxFabricSummary) {
                    Enumeration enumeration3 = null;
                    if (iD instanceof GraphComputer.ID) {
                        enumeration3 = graphModelPinList.associatorID(GraphFabric2Computer.TYPE, iD);
                    } else if (iD instanceof GraphSwitch.ID) {
                        enumeration3 = graphModelPinList.associatorID(GraphFabric2Switch.TYPE, iD);
                    } else if (iD instanceof GraphSubsystem.ID) {
                        enumeration3 = graphModelPinList.associatorID(GraphFabric2Subsystem.TYPE, iD);
                    } else if (iD instanceof GraphTapeLibrary.ID) {
                        enumeration3 = graphModelPinList.associatorID(GraphFabric2TapeLibrary.TYPE, iD);
                    } else if (iD instanceof GraphOther.ID) {
                        enumeration3 = graphModelPinList.associatorID(GraphFabric2Other.TYPE, iD);
                    }
                    if (enumeration3 != null && enumeration3.hasMoreElements()) {
                        bl = true;
                    }
                } else if (iTopoPinContainerWidget instanceof JTopoBoxComputerSummary && iD instanceof GraphComputer.ID) {
                    bl = true;
                } else if (iTopoPinContainerWidget instanceof JTopoBoxSwitchSummary && iD instanceof GraphSwitch.ID) {
                    bl = true;
                } else if (iTopoPinContainerWidget instanceof JTopoBoxStorageSummary && (iD instanceof GraphSubsystem.ID || iD instanceof GraphTapeLibrary.ID)) {
                    bl = true;
                } else if (iTopoPinContainerWidget instanceof JTopoBoxOtherSummary && iD instanceof GraphOther.ID) {
                    bl = true;
                }
                if (!bl) continue;
                vector.add(iTopoPinContainerWidget);
            }
        }
        return vector;
    }

    protected Vector getFirstLevelGroup() {
        Vector vector = new Vector();
        return vector;
    }

    protected void clearAllLines() {
    }

    protected HashSet addLine(AbstractJTopoEntity abstractJTopoEntity, boolean bl) {
        return new HashSet();
    }

    protected void removeLine(AbstractJTopoEntity abstractJTopoEntity) {
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.HorizontalLayout {
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DefaultLayout)DefaultLayout.this).JTopoCanvasOverview.this.controllerView.canvasLayoutChanged();
                }
            });
        }
    }
}

