/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public class JTopoMiniMap
extends AbstractJTopoBase {
    private AbstractJTopoCanvas canvas;
    private float ratio;
    private JPanel auxPanel;
    private JPanel miniCanvas;
    private JPanel miniFocusPanel;
    private ML_Click ml_click;
    private ML_Drag ml_drag;
    private Hashtable unitH;
    private InvalidPanel invalidPanel;

    public JTopoMiniMap() {
        this.setBorder(LineBorder.createGrayLineBorder());
        this.setBackground(TopoResource.COLOR_BACKGROUND);
        this.setLayout(this.createDefaultLayout());
        this.auxPanel = new JPanel();
        this.auxPanel.setBackground(TopoResource.COLOR_BACKGROUND);
        this.auxPanel.setBorder(LineBorder.createGrayLineBorder());
        this.auxPanel.setLayout(new BorderLayout());
        this.add(this.auxPanel);
        this.miniCanvas = new JPanel();
        this.miniCanvas.setBackground(TopoResource.COLOR_BACKGROUND);
        this.miniCanvas.setLayout(null);
        this.ml_click = new ML_Click();
        this.miniCanvas.addMouseListener(this.ml_click);
        this.auxPanel.add(this.miniCanvas);
        this.miniFocusPanel = new JPanel();
        this.miniFocusPanel.setBackground(TopoResource.COLOR_TRANSPARENTBOX);
        this.miniFocusPanel.setBorder(LineBorder.createGrayLineBorder());
        this.miniFocusPanel.addMouseListener(this.ml_click);
        this.ml_drag = new ML_Drag();
        this.miniFocusPanel.addMouseListener(this.ml_drag);
        this.miniFocusPanel.addMouseMotionListener(this.ml_drag);
        this.unitH = new Hashtable();
        this.invalidPanel = new InvalidPanel();
        this.initState();
    }

    private void initState() {
        this.canvas = null;
        this.ratio = 0.0f;
        this.unitH.clear();
        this.miniFocusPanel.setLocation(0, 0);
        this.setEnabled(true);
    }

    public void resetState() {
        this.initState();
    }

    protected void reattach() {
        if (this.canvas == null) {
            return;
        }
        this.miniCanvas.removeAll();
        this.unitH.clear();
        this.miniCanvas.add(this.miniFocusPanel);
        this.addUnit(this.canvas.getCanvasPanel(), 0);
        this.validate();
    }

    public AbstractJTopoCanvas getDataModel() {
        return this.canvas;
    }

    public void setDataModel(AbstractJTopoCanvas abstractJTopoCanvas) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoMiniMap, setModel()");
        }
        if (abstractJTopoCanvas == null) {
            if (GraphDebug.isErrorVisible()) {
                GraphDebug.error("JTopoMiniMap.setModel(), canvas=null");
            }
            return;
        }
        this.canvas = abstractJTopoCanvas;
        this.updateContainer();
    }

    public void canvasLayoutChanged() {
        this.updateContainer();
    }

    public void viewportPositionChanged() {
        this.layoutFocusPanel();
    }

    protected void addUnit(Container container, int n) {
        int n2 = 0;
        while (n2 < container.getComponentCount()) {
            AbstractJTopoGroup abstractJTopoGroup;
            Component component = container.getComponent(n2);
            Unit unit = null;
            if (component instanceof AbstractJTopoGroup) {
                unit = new Unit(component);
            }
            if (unit != null) {
                this.miniCanvas.add((Component)unit, 1);
                this.unitH.put(component, unit);
            }
            if (component.isVisible() && (!(component instanceof AbstractJTopoGroup) || (abstractJTopoGroup = (AbstractJTopoGroup)component).isExpanded()) && component instanceof Container) {
                this.addUnit((Container)component, n + 1);
            }
            ++n2;
        }
    }

    protected void layoutFocusPanel() {
        if (this.ratio == 0.0f) {
            return;
        }
        JViewport jViewport = this.canvas.getViewport();
        Dimension dimension = jViewport.getExtentSize();
        Rectangle rectangle = new Rectangle();
        rectangle.width = (int)((float)dimension.width / this.ratio);
        rectangle.height = (int)((float)dimension.height / this.ratio);
        rectangle.x = (int)((float)jViewport.getViewPosition().x / this.ratio);
        rectangle.y = (int)((float)jViewport.getViewPosition().y / this.ratio);
        this.miniFocusPanel.setBounds(rectangle);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    public void setEnabled(boolean bl) {
        this.remove(this.invalidPanel);
        if (!bl) {
            this.add((Component)this.invalidPanel, 0);
        }
        super.setEnabled(bl);
    }

    protected class DefaultLayout
    implements LayoutManager {
        protected int gap = 5;

        protected DefaultLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Cloneable cloneable;
            if (!container.isEnabled()) {
                cloneable = container.getInsets();
                int n = cloneable.left;
                int n2 = cloneable.top;
                int n3 = container.getWidth() - cloneable.left - cloneable.right;
                int n4 = container.getHeight() - cloneable.top - cloneable.bottom;
                JTopoMiniMap.this.invalidPanel.setBounds(n, n2, n3, n4);
            }
            cloneable = JTopoMiniMap.this.getSize();
            Dimension dimension = new Dimension(((Dimension)cloneable).width - 2 * this.gap, ((Dimension)cloneable).height - 2 * this.gap);
            Dimension dimension2 = JTopoMiniMap.this.canvas.getCanvasPanel().getSize();
            if ((float)dimension2.width / (float)dimension2.height > (float)dimension.width / (float)dimension.height) {
                JTopoMiniMap.this.ratio = (float)dimension2.width / (float)dimension.width;
            } else {
                JTopoMiniMap.this.ratio = (float)dimension2.height / (float)dimension.height;
            }
            if (JTopoMiniMap.this.ratio == 0.0f) {
                return;
            }
            Rectangle rectangle = new Rectangle();
            rectangle.width = (int)((float)dimension2.width / JTopoMiniMap.this.ratio);
            rectangle.height = (int)((float)dimension2.height / JTopoMiniMap.this.ratio);
            rectangle.x = (((Dimension)cloneable).width - rectangle.width) / 2;
            rectangle.y = (((Dimension)cloneable).height - rectangle.height) / 2;
            JTopoMiniMap.this.miniCanvas.setBounds(rectangle);
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = rectangle.x - 1;
            rectangle2.y = rectangle.y - 1;
            rectangle2.width = rectangle.width + 2;
            rectangle2.height = rectangle.height + 2;
            JTopoMiniMap.this.auxPanel.setBounds(rectangle2);
            JTopoMiniMap.this.layoutFocusPanel();
            Enumeration enumeration = JTopoMiniMap.this.unitH.elements();
            while (enumeration.hasMoreElements()) {
                Unit unit = (Unit)enumeration.nextElement();
                Component component = unit.getRefComp();
                Rectangle rectangle3 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), JTopoMiniMap.this.canvas.getCanvasPanel());
                rectangle3.x = (int)((float)rectangle3.x / JTopoMiniMap.this.ratio);
                rectangle3.y = (int)((float)rectangle3.y / JTopoMiniMap.this.ratio);
                rectangle3.width = (int)((float)rectangle3.width / JTopoMiniMap.this.ratio);
                rectangle3.height = (int)((float)rectangle3.height / JTopoMiniMap.this.ratio);
                unit.setBounds(rectangle3);
            }
        }
    }

    protected class InvalidPanel
    extends JPanel {
        public InvalidPanel() {
            this.setBackground(new Color(255, 255, 255, 200));
            this.addMouseListener(new DummyMouseAdapter());
        }

        protected class DummyMouseAdapter
        extends MouseAdapter {
            protected DummyMouseAdapter() {
            }
        }
    }

    protected class ML_Click
    extends MouseAdapter {
        protected ML_Click() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = null;
            point = mouseEvent.getSource() == JTopoMiniMap.this.miniFocusPanel ? new Point(mouseEvent.getX() + JTopoMiniMap.this.miniFocusPanel.getX(), mouseEvent.getY() + JTopoMiniMap.this.miniFocusPanel.getY()) : mouseEvent.getPoint();
            Dimension dimension = JTopoMiniMap.this.miniFocusPanel.getSize();
            Point point2 = new Point(point.x - dimension.width / 2, point.y - dimension.height / 2);
            JViewport jViewport = JTopoMiniMap.this.canvas.getViewport();
            jViewport.getViewPosition();
            Point point3 = new Point((int)((float)point2.x * JTopoMiniMap.this.ratio), (int)((float)point2.y * JTopoMiniMap.this.ratio));
            JTopoMiniMap.this.canvas.setViewPosition(point3);
        }
    }

    protected class ML_Drag
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point last;
        protected boolean isCursorSet;

        protected ML_Drag() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.last = mouseEvent.getPoint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.isCursorSet) {
                JTopoMiniMap.this.setCursor(Cursor.getPredefinedCursor(13));
                this.isCursorSet = true;
            }
            Point point = mouseEvent.getPoint();
            Point point2 = JTopoMiniMap.this.miniFocusPanel.getLocation();
            Point point3 = new Point(point2.x + point.x, point2.y + point.y);
            Dimension dimension = new Dimension(point.x - this.last.x, point.y - this.last.y);
            Rectangle rectangle = new Rectangle(0, 0, JTopoMiniMap.this.miniCanvas.getWidth(), JTopoMiniMap.this.miniCanvas.getHeight());
            if (rectangle.contains(point3)) {
                JViewport jViewport = JTopoMiniMap.this.canvas.getViewport();
                Point point4 = jViewport.getViewPosition();
                Point point5 = new Point((int)((float)point4.x + (float)dimension.width * JTopoMiniMap.this.ratio), (int)((float)point4.y + (float)dimension.height * JTopoMiniMap.this.ratio));
                JTopoMiniMap.this.canvas.setViewPosition(point5);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.last = null;
            if (this.isCursorSet) {
                JTopoMiniMap.this.setCursor(Cursor.getPredefinedCursor(0));
                this.isCursorSet = false;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class Unit
    extends JPanel {
        protected Component comp;

        public Unit(Component component) {
            this.comp = component;
            if (component == null) {
                return;
            }
            if (component instanceof AbstractJTopoEntity) {
                AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)component;
                this.setBorder(LineBorder.createGrayLineBorder());
                ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)abstractJTopoEntity.getWidgetModel();
                Integer n = iTopoEntityModel.getHealth();
                if (n == null) {
                    this.setBackground(TopoResource.COLOR_NA);
                } else if (n.equals(GraphModelConstant.STATUS_UNKNOWN)) {
                    this.setBackground(TopoResource.COLOR_UNKNOWN);
                } else if (n.equals(GraphModelConstant.STATUS_NORMAL)) {
                    this.setBackground(TopoResource.COLOR_NORMAL);
                } else if (n.equals(GraphModelConstant.STATUS_WARNING)) {
                    this.setBackground(TopoResource.COLOR_WARNING);
                } else if (n.equals(GraphModelConstant.STATUS_CRITICAL)) {
                    this.setBackground(TopoResource.COLOR_CRITICAL);
                } else if (n.equals(GraphModelConstant.STATUS_MISSING)) {
                    this.setBackground(TopoResource.COLOR_MISSING);
                } else {
                    this.setBackground(TopoResource.COLOR_NA);
                }
            }
        }

        public Component getRefComp() {
            return this.comp;
        }
    }
}

