/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;

public class CurrentTime {
    private static boolean initialized = false;
    private static long delta = 0L;

    public static void initialize(DBConnection dBConnection) throws SQLException {
        if (!initialized || dBConnection != null) {
            DBConnection dBConnection2 = null;
            DBPreparedStatement dBPreparedStatement = null;
            try {
                dBConnection2 = dBConnection == null ? (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection() : dBConnection;
                Connection connection = dBConnection2.getConnection();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                Timestamp timestamp = null;
                long l = 0L;
                if (string.startsWith("DB2") || string.startsWith("Apache Derby")) {
                    dBPreparedStatement = dBConnection2.prepareStatement("SELECT current timestamp FROM sysibm.sysdummy1");
                    DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
                    l = System.currentTimeMillis();
                    if (dBResultSet.next()) {
                        timestamp = dBResultSet.getTimestamp(1);
                    }
                } else if (string.startsWith("Oracle")) {
                    dBPreparedStatement = dBConnection2.prepareStatement("SELECT SYSTIMESTAMP FROM DUAL");
                    DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
                    l = System.currentTimeMillis();
                    if (dBResultSet.next()) {
                        String string2 = dBResultSet.getString(1);
                        String[] stringArray = string2.split(" ");
                        stringArray[1] = stringArray[1].replaceFirst("\\.", ":");
                        stringArray[1] = stringArray[1].replaceFirst("\\.", ":");
                        string2 = String.valueOf(stringArray[0]) + " " + stringArray[1];
                        timestamp = Timestamp.valueOf(string2);
                    }
                } else if (string.startsWith("Microsoft SQL Server")) {
                    dBPreparedStatement = dBConnection2.prepareStatement("SELECT GETDATE()");
                    DBResultSet dBResultSet = dBPreparedStatement.executeQuery();
                    l = System.currentTimeMillis();
                    if (dBResultSet.next()) {
                        timestamp = dBResultSet.getTimestamp(1);
                    }
                } else {
                    throw new SQLException("Database vendor " + string + " is not supported");
                }
                if (timestamp == null) {
                    throw new SQLException("Unable to retrieve timestamp from db server");
                }
                delta = l - timestamp.getTime();
                initialized = true;
            }
            catch (Throwable throwable) {
                if (dBPreparedStatement != null) {
                    try {
                        dBPreparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                if (dBConnection2 != null && dBConnection == null) {
                    try {
                        dBConnection2.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dBPreparedStatement != null) {
                try {
                    dBPreparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (dBConnection2 != null && dBConnection == null) {
                try {
                    dBConnection2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Timestamp getTimestamp(DBConnection dBConnection) throws SQLException {
        return CurrentTime.getTimestamp();
    }

    public static synchronized Timestamp getTimestamp() throws SQLException {
        CurrentTime.initialize(null);
        return new Timestamp(System.currentTimeMillis() - delta);
    }
}

