/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;

public class CimkeyVolume
extends TResCimkeyVolumeTable {
    private String m_SystemNamesId_str;
    private String m_CreationClassNameId_str;
    private String m_SystemCreationClassNameId_str;

    public void setSystemNames(String string) {
        this.m_SystemNamesId_str = string;
    }

    public String getSystemNames() {
        return this.m_SystemNamesId_str;
    }

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public void setSystemCreationClassName(String string) {
        this.m_SystemCreationClassNameId_str = string;
    }

    public String getSystemCreationClassName() {
        return this.m_SystemCreationClassNameId_str;
    }

    public static CimkeyVolumeCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new CimkeyVolumeCursor(dBConnection, hashtable, vector);
    }

    public CimkeyVolume() {
        this.clear();
    }

    public CimkeyVolume(int n, int n2, short s, short s2, short s3, String string, short s4, Timestamp timestamp) {
        this.clear();
        this.m_VolumeId = n;
        this.m_CimNamespaceId = n2;
        this.m_SystemNamesId = s;
        this.m_CreationClassNameId = s2;
        this.m_SystemCreationClassNameId = s3;
        this.m_DeviceId = string;
        this.m_Active = s4;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SystemNamesId != Short.MIN_VALUE) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(this.m_SystemNamesId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_SystemCreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(this.m_SystemCreationClassNameId));
        }
        if (this.m_DeviceId != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(CimkeyVolume.getColumnInfo("DEVICE_ID"), this.m_DeviceId);
        }
        if (this.m_Active != Short.MIN_VALUE) {
            hashtable.put(CimkeyVolume.getColumnInfo("ACTIVE"), String.valueOf(this.m_Active));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(CimkeyVolume.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htColsAndValues.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htColsAndValues.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_VOLUME", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CIMKEY_VOLUME", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_VOLUME", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")));
        if (hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_VOLUME", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_VOLUME", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")));
        if (hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_VOLUME", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SystemNamesId_str != null) {
            this.m_SystemNamesId = Normalizer.SystemNamesGetID(dBConnection, this.m_SystemNamesId_str);
        }
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_SystemCreationClassNameId_str != null) {
            this.m_SystemCreationClassNameId = Normalizer.SystemCreationClassNameGetID(dBConnection, this.m_SystemCreationClassNameId_str);
        }
        if (this.m_VolumeId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key VOLUME_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), String.valueOf(this.m_VolumeId));
        if (this.m_CimNamespaceId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key CIM_NAMESPACE_ID not found");
        }
        this.htWhereClause.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), String.valueOf(this.m_CimNamespaceId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_VOLUME", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static CimkeyVolume retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        CimkeyVolume cimkeyVolume = null;
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")) == null) {
            throw new SQLException(" ERROR: key VOLUME_ID not found");
        }
        hashtable2.put(CimkeyVolume.getColumnInfo("VOLUME_ID"), hashtable.get(CimkeyVolume.getColumnInfo("VOLUME_ID")));
        if (hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")) == null) {
            throw new SQLException(" ERROR: key CIM_NAMESPACE_ID not found");
        }
        hashtable2.put(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID"), hashtable.get(CimkeyVolume.getColumnInfo("CIM_NAMESPACE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CIMKEY_VOLUME", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                cimkeyVolume = new CimkeyVolume();
                cimkeyVolume.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return cimkeyVolume;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable2.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable2.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable2.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable2.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CIMKEY_VOLUME", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CIMKEY_VOLUME", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setVolumeId(dBResultSet.getInt("VOLUME_ID"));
        this.setCimNamespaceId(dBResultSet.getInt("CIM_NAMESPACE_ID"));
        this.setSystemNamesId(dBResultSet.getShort("SYSTEM_NAMES_ID"));
        this.setSystemNames(Normalizer.SystemNamesGetName(dBConnection, this.m_SystemNamesId));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setSystemCreationClassNameId(dBResultSet.getShort("SYSTEM_CREATION_CLASS_NAME_ID"));
        this.setSystemCreationClassName(Normalizer.SystemCreationClassNameGetName(dBConnection, this.m_SystemCreationClassNameId));
        this.setDeviceId(dBResultSet.getString("DEVICE_ID"));
        this.setActive(dBResultSet.getShort("ACTIVE"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class CimkeyVolumeCursor
    extends DBCursor {
        private CimkeyVolume element = new CimkeyVolume();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")) != null) {
                hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID"), String.valueOf(Normalizer.SystemNamesGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_NAMES_ID")))));
            }
            if (hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            if (hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.SystemCreationClassNameGetID(dBConnection, (String)hashtable.get(CimkeyVolume.getColumnInfo("SYSTEM_CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public CimkeyVolumeCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_CIMKEY_VOLUME", dBConnection, CimkeyVolumeCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public CimkeyVolume getObject() throws SQLException {
            CimkeyVolume cimkeyVolume = null;
            if (this.DBrs != null) {
                cimkeyVolume = new CimkeyVolume();
                cimkeyVolume.setFields(this.con, this.DBrs);
            }
            return cimkeyVolume;
        }

        public CimkeyVolume getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

